/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.microsoft.azure.arm.dag.DAGNode;
import com.microsoft.azure.arm.dag.DAGraph;
import com.microsoft.azure.arm.dag.ItemHolder;
import com.microsoft.azure.arm.dag.Node;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class DAGraphTest {
    @Test
    public void testDAGraphGetNext() {
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add("A");
        expectedOrder.add("I");
        expectedOrder.add("B");
        expectedOrder.add("C");
        expectedOrder.add("H");
        expectedOrder.add("D");
        expectedOrder.add("G");
        expectedOrder.add("E");
        expectedOrder.add("F");
        ItemHolder nodeA = new ItemHolder("A", "dataA");
        ItemHolder nodeI = new ItemHolder("I", "dataI");
        ItemHolder nodeB = new ItemHolder("B", "dataB");
        nodeB.addDependency(nodeA.key());
        ItemHolder nodeC = new ItemHolder("C", "dataC");
        nodeC.addDependency(nodeA.key());
        ItemHolder nodeH = new ItemHolder("H", "dataH");
        nodeH.addDependency(nodeI.key());
        ItemHolder nodeG = new ItemHolder("G", "dataG");
        nodeG.addDependency(nodeC.key());
        ItemHolder nodeE = new ItemHolder("E", "dataE");
        nodeE.addDependency(nodeB.key());
        nodeE.addDependency(nodeG.key());
        ItemHolder nodeD = new ItemHolder("D", "dataD");
        nodeD.addDependency(nodeB.key());
        ItemHolder nodeF = new ItemHolder("F", "dataF");
        nodeF.addDependency(nodeD.key());
        nodeF.addDependency(nodeE.key());
        nodeF.addDependency(nodeH.key());
        DAGraph dag = new DAGraph((DAGNode)nodeF);
        dag.addNode((Node)nodeA);
        dag.addNode((Node)nodeB);
        dag.addNode((Node)nodeC);
        dag.addNode((Node)nodeD);
        dag.addNode((Node)nodeE);
        dag.addNode((Node)nodeG);
        dag.addNode((Node)nodeH);
        dag.addNode((Node)nodeI);
        dag.prepareForEnumeration();
        ItemHolder nextNode = (ItemHolder)dag.getNext();
        int i = 0;
        while (nextNode != null) {
            Assert.assertEquals((Object)nextNode.key(), expectedOrder.get(i));
            dag.reportCompletion((DAGNode)nextNode);
            nextNode = (ItemHolder)dag.getNext();
            ++i;
        }
        System.out.println("done");
    }

    @Test
    public void testGraphMerge() {
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add("A");
        expectedOrder.add("I");
        expectedOrder.add("B");
        expectedOrder.add("C");
        expectedOrder.add("H");
        expectedOrder.add("D");
        expectedOrder.add("G");
        expectedOrder.add("E");
        expectedOrder.add("F");
        DAGraph<String, ItemHolder> graphA = this.createGraph("A");
        DAGraph<String, ItemHolder> graphI = this.createGraph("I");
        DAGraph<String, ItemHolder> graphB = this.createGraph("B");
        graphA.addDependentGraph(graphB);
        DAGraph<String, ItemHolder> graphC = this.createGraph("C");
        graphA.addDependentGraph(graphC);
        DAGraph<String, ItemHolder> graphH = this.createGraph("H");
        graphI.addDependentGraph(graphH);
        DAGraph<String, ItemHolder> graphG = this.createGraph("G");
        graphC.addDependentGraph(graphG);
        DAGraph<String, ItemHolder> graphE = this.createGraph("E");
        graphB.addDependentGraph(graphE);
        graphG.addDependentGraph(graphE);
        DAGraph<String, ItemHolder> graphD = this.createGraph("D");
        graphB.addDependentGraph(graphD);
        DAGraph<String, ItemHolder> graphF = this.createGraph("F");
        graphD.addDependentGraph(graphF);
        graphE.addDependentGraph(graphF);
        graphH.addDependentGraph(graphF);
        DAGraph<String, ItemHolder> dag = graphF;
        dag.prepareForEnumeration();
        ItemHolder nextNode = (ItemHolder)dag.getNext();
        int i = 0;
        while (nextNode != null) {
            Assert.assertEquals(expectedOrder.get(i), (Object)nextNode.key());
            dag.reportCompletion((DAGNode)nextNode);
            nextNode = (ItemHolder)dag.getNext();
            ++i;
        }
    }

    private DAGraph<String, ItemHolder> createGraph(String resourceName) {
        ItemHolder node = new ItemHolder(resourceName, "data" + resourceName);
        DAGraph graph = new DAGraph((DAGNode)node);
        return graph;
    }
}

