/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.microsoft.azure.arm.dag.DAGNode;
import com.microsoft.azure.arm.dag.DAGraph;
import com.microsoft.azure.arm.dag.ItemHolder;
import com.microsoft.azure.arm.dag.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class DAGraphTests {
    @Test
    public void testDAGraphGetNext() {
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add("A");
        expectedOrder.add("I");
        expectedOrder.add("B");
        expectedOrder.add("C");
        expectedOrder.add("H");
        expectedOrder.add("D");
        expectedOrder.add("G");
        expectedOrder.add("E");
        expectedOrder.add("F");
        ItemHolder nodeA = new ItemHolder("A", "dataA");
        ItemHolder nodeI = new ItemHolder("I", "dataI");
        ItemHolder nodeB = new ItemHolder("B", "dataB");
        nodeB.addDependency(nodeA.key());
        ItemHolder nodeC = new ItemHolder("C", "dataC");
        nodeC.addDependency(nodeA.key());
        ItemHolder nodeH = new ItemHolder("H", "dataH");
        nodeH.addDependency(nodeI.key());
        ItemHolder nodeG = new ItemHolder("G", "dataG");
        nodeG.addDependency(nodeC.key());
        ItemHolder nodeE = new ItemHolder("E", "dataE");
        nodeE.addDependency(nodeB.key());
        nodeE.addDependency(nodeG.key());
        ItemHolder nodeD = new ItemHolder("D", "dataD");
        nodeD.addDependency(nodeB.key());
        ItemHolder nodeF = new ItemHolder("F", "dataF");
        nodeF.addDependency(nodeD.key());
        nodeF.addDependency(nodeE.key());
        nodeF.addDependency(nodeH.key());
        DAGraph dag = new DAGraph((DAGNode)nodeF);
        dag.addNode((Node)nodeA);
        dag.addNode((Node)nodeB);
        dag.addNode((Node)nodeC);
        dag.addNode((Node)nodeD);
        dag.addNode((Node)nodeE);
        dag.addNode((Node)nodeG);
        dag.addNode((Node)nodeH);
        dag.addNode((Node)nodeI);
        dag.prepareForEnumeration();
        ItemHolder nextNode = (ItemHolder)dag.getNext();
        int i = 0;
        while (nextNode != null) {
            Assert.assertEquals((Object)nextNode.key(), expectedOrder.get(i));
            dag.reportCompletion((DAGNode)nextNode);
            nextNode = (ItemHolder)dag.getNext();
            ++i;
        }
        System.out.println("done");
    }

    @Test
    public void testGraphDependency() {
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add("A");
        expectedOrder.add("I");
        expectedOrder.add("B");
        expectedOrder.add("C");
        expectedOrder.add("H");
        expectedOrder.add("D");
        expectedOrder.add("G");
        expectedOrder.add("E");
        expectedOrder.add("F");
        DAGraph<String, ItemHolder> graphA = this.createGraph("A");
        DAGraph<String, ItemHolder> graphI = this.createGraph("I");
        DAGraph<String, ItemHolder> graphB = this.createGraph("B");
        graphB.addDependencyGraph(graphA);
        DAGraph<String, ItemHolder> graphC = this.createGraph("C");
        graphC.addDependencyGraph(graphA);
        DAGraph<String, ItemHolder> graphH = this.createGraph("H");
        graphH.addDependencyGraph(graphI);
        DAGraph<String, ItemHolder> graphG = this.createGraph("G");
        graphG.addDependencyGraph(graphC);
        DAGraph<String, ItemHolder> graphE = this.createGraph("E");
        graphE.addDependencyGraph(graphB);
        graphE.addDependencyGraph(graphG);
        DAGraph<String, ItemHolder> graphD = this.createGraph("D");
        graphD.addDependencyGraph(graphB);
        DAGraph<String, ItemHolder> graphF = this.createGraph("F");
        graphF.addDependencyGraph(graphD);
        graphF.addDependencyGraph(graphE);
        graphF.addDependencyGraph(graphH);
        DAGraph<String, ItemHolder> dag = graphF;
        dag.prepareForEnumeration();
        ItemHolder nextNode = (ItemHolder)dag.getNext();
        int i = 0;
        while (nextNode != null) {
            Assert.assertEquals(expectedOrder.get(i), (Object)nextNode.key());
            dag.reportCompletion((DAGNode)nextNode);
            nextNode = (ItemHolder)dag.getNext();
            ++i;
        }
    }

    @Test
    public void testGraphDeadLockDetection() {
        boolean dlDetected = false;
        DAGraph<String, ItemHolder> graphX = this.createGraph("X");
        try {
            graphX.addDependencyGraph(graphX);
        }
        catch (IllegalStateException exception) {
            dlDetected = exception.getMessage().contains("X -> ") && exception.getMessage().contains(" -> X");
        }
        Assert.assertTrue((String)"Expected exception is not thrown", (boolean)dlDetected);
        dlDetected = false;
        DAGraph<String, ItemHolder> graphA = this.createGraph("A");
        DAGraph<String, ItemHolder> graphB = this.createGraph("B");
        DAGraph<String, ItemHolder> graphC = this.createGraph("C");
        graphA.addDependencyGraph(graphB);
        graphC.addDependencyGraph(graphA);
        try {
            graphB.addDependencyGraph(graphC);
        }
        catch (IllegalStateException exception) {
            dlDetected = exception.getMessage().contains("B -> ") && exception.getMessage().contains(" -> B");
        }
        Assert.assertTrue((String)"Expected exception is not thrown", (boolean)dlDetected);
        dlDetected = false;
        DAGraph<String, ItemHolder> graph1 = this.createGraph("1");
        DAGraph<String, ItemHolder> graph2 = this.createGraph("2");
        DAGraph<String, ItemHolder> graph3 = this.createGraph("3");
        graph2.addDependencyGraph(graph1);
        graph1.addDependencyGraph(graph3);
        try {
            graph3.addDependencyGraph(graph1);
        }
        catch (IllegalStateException exception) {
            dlDetected = exception.getMessage().contains("3 -> ") && exception.getMessage().contains(" -> 3");
        }
        Assert.assertTrue((String)"Expected exception is not thrown", (boolean)dlDetected);
    }

    @Test
    public void testGraphNodeTableBubblingUp() {
        DAGraph<String, ItemHolder> graphA = this.createGraph("A");
        DAGraph<String, ItemHolder> graphB = this.createGraph("B");
        DAGraph<String, ItemHolder> graphC = this.createGraph("C");
        graphB.addDependencyGraph(graphA);
        graphC.addDependencyGraph(graphA);
        graphC.addDependencyGraph(graphB);
        DAGraph<String, ItemHolder> graph1Root = graphC;
        DAGraph<String, ItemHolder> graphD = this.createGraph("D");
        DAGraph<String, ItemHolder> graphE = this.createGraph("E");
        DAGraph<String, ItemHolder> graphF = this.createGraph("F");
        DAGraph<String, ItemHolder> graphG = this.createGraph("G");
        graphE.addDependencyGraph(graphD);
        graphD.addDependencyGraph(graphG);
        graphF.addDependencyGraph(graphE);
        DAGraph<String, ItemHolder> graph2Root = graphF;
        DAGraph<String, ItemHolder> graphJ = this.createGraph("J");
        DAGraph<String, ItemHolder> graphH = this.createGraph("H");
        DAGraph<String, ItemHolder> graphI = this.createGraph("I");
        graphJ.addDependencyGraph(graphH);
        graphH.addDependencyGraph(graphI);
        DAGraph<String, ItemHolder> graph3Root = graphJ;
        graph1Root.addDependentGraph(graph3Root);
        graph1Root.addDependentGraph(graph2Root);
        DAGraph<String, ItemHolder> graph4Root1 = graph2Root;
        DAGraph<String, ItemHolder> graph4Root2 = graph3Root;
        ItemHolder nodeA_G1 = (ItemHolder)graph1Root.getNode("A");
        Assert.assertEquals((long)1L, (long)nodeA_G1.owner().nodeTable.size());
        this.assertExactMatch(nodeA_G1.owner().nodeTable.keySet(), new String[]{"A"});
        ItemHolder nodeB_G1 = (ItemHolder)graph1Root.getNode("B");
        Assert.assertEquals((long)2L, (long)nodeB_G1.owner().nodeTable.size());
        this.assertExactMatch(nodeB_G1.owner().nodeTable.keySet(), new String[]{"A", "B"});
        ItemHolder nodeC_G1 = (ItemHolder)graph1Root.getNode("C");
        Assert.assertEquals((long)3L, (long)nodeC_G1.owner().nodeTable.size());
        this.assertExactMatch(nodeC_G1.owner().nodeTable.keySet(), new String[]{"A", "B", "C"});
        ItemHolder nodeA_G41 = (ItemHolder)graph4Root1.getNode("A");
        Assert.assertEquals((long)1L, (long)nodeA_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeA_G41.owner().nodeTable.keySet(), new String[]{"A"});
        ItemHolder nodeB_G41 = (ItemHolder)graph4Root1.getNode("B");
        Assert.assertEquals((long)2L, (long)nodeB_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeB_G41.owner().nodeTable.keySet(), new String[]{"A", "B"});
        ItemHolder nodeC_G41 = (ItemHolder)graph4Root1.getNode("C");
        Assert.assertEquals((long)3L, (long)nodeC_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeC_G41.owner().nodeTable.keySet(), new String[]{"A", "B", "C"});
        ItemHolder nodeG_G41 = (ItemHolder)graph4Root1.getNode("G");
        Assert.assertEquals((long)1L, (long)nodeG_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeG_G41.owner().nodeTable.keySet(), new String[]{"G"});
        ItemHolder nodeD_G41 = (ItemHolder)graph4Root1.getNode("D");
        Assert.assertEquals((long)2L, (long)nodeD_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeD_G41.owner().nodeTable.keySet(), new String[]{"D", "G"});
        ItemHolder nodeE_G41 = (ItemHolder)graph4Root1.getNode("E");
        Assert.assertEquals((long)3L, (long)nodeE_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeE_G41.owner().nodeTable.keySet(), new String[]{"E", "D", "G"});
        ItemHolder nodeF_G41 = (ItemHolder)graph4Root1.getNode("F");
        Assert.assertEquals((long)7L, (long)nodeF_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeF_G41.owner().nodeTable.keySet(), new String[]{"E", "F", "D", "G", "A", "B", "C"});
        ItemHolder nodeA_G42 = (ItemHolder)graph4Root2.getNode("A");
        Assert.assertEquals((long)1L, (long)nodeA_G42.owner().nodeTable.size());
        this.assertExactMatch(nodeA_G42.owner().nodeTable.keySet(), new String[]{"A"});
        ItemHolder nodeB_G42 = (ItemHolder)graph4Root2.getNode("B");
        Assert.assertEquals((long)2L, (long)nodeB_G42.owner().nodeTable.size());
        this.assertExactMatch(nodeB_G42.owner().nodeTable.keySet(), new String[]{"A", "B"});
        ItemHolder nodeC_G42 = (ItemHolder)graph4Root2.getNode("C");
        Assert.assertEquals((long)3L, (long)nodeC_G42.owner().nodeTable.size());
        this.assertExactMatch(nodeC_G42.owner().nodeTable.keySet(), new String[]{"A", "B", "C"});
        ItemHolder nodeI_G42 = (ItemHolder)graph4Root2.getNode("I");
        Assert.assertEquals((long)1L, (long)nodeI_G42.owner().nodeTable.size());
        this.assertExactMatch(nodeI_G42.owner().nodeTable.keySet(), new String[]{"I"});
        ItemHolder nodeH_G42 = (ItemHolder)graph4Root2.getNode("H");
        Assert.assertEquals((long)2L, (long)nodeH_G42.owner().nodeTable.size());
        this.assertExactMatch(nodeH_G42.owner().nodeTable.keySet(), new String[]{"I", "H"});
        ItemHolder nodeJ_G42 = (ItemHolder)graph4Root2.getNode("J");
        Assert.assertEquals((long)6L, (long)nodeJ_G42.owner().nodeTable.size());
        this.assertExactMatch(nodeJ_G42.owner().nodeTable.keySet(), new String[]{"I", "H", "J", "A", "B", "C"});
        DAGraph<String, ItemHolder> graphK = this.createGraph("K");
        DAGraph<String, ItemHolder> graphL = this.createGraph("L");
        DAGraph<String, ItemHolder> graphM = this.createGraph("M");
        graphL.addDependencyGraph(graphK);
        graphM.addDependencyGraph(graphL);
        graphM.addDependencyGraph(graphK);
        graphA.addDependencyGraph(graphL);
        ItemHolder nodeK_G41 = (ItemHolder)graph4Root1.getNode("K");
        Assert.assertEquals((long)1L, (long)nodeK_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeK_G41.owner().nodeTable.keySet(), new String[]{"K"});
        ItemHolder nodeL_G41 = (ItemHolder)graph4Root1.getNode("L");
        Assert.assertEquals((long)2L, (long)nodeL_G41.owner().nodeTable.size());
        this.assertExactMatch(nodeL_G41.owner().nodeTable.keySet(), new String[]{"K", "L"});
        ItemHolder nodeA_G41_updated = (ItemHolder)graph4Root1.getNode("A");
        Assert.assertEquals((long)3L, (long)nodeA_G41_updated.owner().nodeTable.size());
        this.assertExactMatch(nodeA_G41_updated.owner().nodeTable.keySet(), new String[]{"K", "L", "A"});
        ItemHolder nodeB_G41_updated = (ItemHolder)graph4Root1.getNode("B");
        Assert.assertEquals((long)4L, (long)nodeB_G41_updated.owner().nodeTable.size());
        this.assertExactMatch(nodeB_G41_updated.owner().nodeTable.keySet(), new String[]{"K", "L", "A", "B"});
        ItemHolder nodeC_G41_updated = (ItemHolder)graph4Root1.getNode("C");
        Assert.assertEquals((long)5L, (long)nodeC_G41_updated.owner().nodeTable.size());
        this.assertExactMatch(nodeC_G41_updated.owner().nodeTable.keySet(), new String[]{"K", "L", "A", "B", "C"});
        ItemHolder nodeF_G41_updated = (ItemHolder)graph4Root1.getNode("F");
        Assert.assertEquals((long)9L, (long)nodeF_G41_updated.owner().nodeTable.size());
        this.assertExactMatch(nodeF_G41_updated.owner().nodeTable.keySet(), new String[]{"K", "L", "A", "B", "C", "F", "E", "D", "G"});
        ItemHolder nodeG_G41_noUpdate = (ItemHolder)graph4Root1.getNode("G");
        Assert.assertEquals((long)1L, (long)nodeG_G41_noUpdate.owner().nodeTable.size());
        this.assertExactMatch(nodeG_G41_noUpdate.owner().nodeTable.keySet(), new String[]{"G"});
        ItemHolder nodeD_G41_noUpdate = (ItemHolder)graph4Root1.getNode("D");
        Assert.assertEquals((long)2L, (long)nodeD_G41_noUpdate.owner().nodeTable.size());
        this.assertExactMatch(nodeD_G41_noUpdate.owner().nodeTable.keySet(), new String[]{"D", "G"});
        ItemHolder nodeE_G41_noUpdate = (ItemHolder)graph4Root1.getNode("E");
        Assert.assertEquals((long)3L, (long)nodeE_G41_noUpdate.owner().nodeTable.size());
        this.assertExactMatch(nodeE_G41_noUpdate.owner().nodeTable.keySet(), new String[]{"E", "D", "G"});
    }

    private DAGraph<String, ItemHolder> createGraph(String resourceName) {
        ItemHolder node = new ItemHolder(resourceName, "data" + resourceName);
        DAGraph graph = new DAGraph((DAGNode)node);
        return graph;
    }

    private void assertExactMatch(Set<String> set, String[] values) {
        HashSet<String> s = new HashSet<String>();
        s.addAll(set);
        s.removeAll(Arrays.asList(values));
        if (s.size() != 0) {
            Assert.assertTrue((String)("Content of set " + set + " does not match with provided array " + Arrays.asList(values)), (boolean)false);
        }
    }
}

