/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.microsoft.azure.arm.dag.IndexableTaskItem;
import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.model.Indexable;
import com.microsoft.azure.arm.resources.models.HasName;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import rx.Observable;
import rx.functions.Func1;

public class InvokeRootTests {
    @Test
    public void testIgnoreCachedResultOnRootWithNoProxy() {
        TestTaskItem taskItem1 = new TestTaskItem("A");
        TestTaskItem taskItem2 = new TestTaskItem("B");
        taskItem1.addDependency((TaskGroup.HasTaskGroup)taskItem2);
        final HashMap seen = new HashMap();
        taskItem1.taskGroup().invokeAsync(taskItem1.taskGroup().newInvocationContext()).map((Func1)new Func1<Indexable, Indexable>(){

            public Indexable call(Indexable item) {
                SupportCountingAndHasName c = (SupportCountingAndHasName)item;
                if (seen.containsKey(c.name())) {
                    Integer a = (Integer)seen.get(c.name()) + 1;
                    seen.put(c.name(), a);
                } else {
                    seen.put(c.name(), 1);
                }
                return item;
            }
        }).toBlocking().last();
        Assert.assertEquals((long)2L, (long)seen.size());
        Assert.assertTrue((boolean)seen.containsKey("A"));
        Assert.assertTrue((boolean)seen.containsKey("B"));
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("A")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("B")).intValue());
        Assert.assertEquals((long)1L, (long)taskItem1.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem2.getCallCount());
        seen.clear();
        taskItem1.taskGroup().invokeAsync(taskItem1.taskGroup().newInvocationContext()).map((Func1)new Func1<Indexable, Indexable>(){

            public Indexable call(Indexable item) {
                SupportCountingAndHasName c = (SupportCountingAndHasName)item;
                if (seen.containsKey(c.name())) {
                    Integer a = (Integer)seen.get(c.name()) + 1;
                    seen.put(c.name(), a);
                } else {
                    seen.put(c.name(), 1);
                }
                return item;
            }
        }).toBlocking().last();
        Assert.assertEquals((long)2L, (long)seen.size());
        Assert.assertTrue((boolean)seen.containsKey("A"));
        Assert.assertTrue((boolean)seen.containsKey("B"));
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("A")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("B")).intValue());
        Assert.assertEquals((long)2L, (long)taskItem1.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem2.getCallCount());
    }

    @Test
    public void testIgnoreCachedResultOnRootWithProxy() {
        TestTaskItem taskItem1 = new TestTaskItem("X");
        TestTaskItem taskItem2 = new TestTaskItem("Y");
        TestTaskItem taskItem3 = new TestTaskItem("Z");
        taskItem1.addDependency((TaskGroup.HasTaskGroup)taskItem2);
        taskItem1.addPostRunDependent((TaskGroup.HasTaskGroup)taskItem3);
        final HashMap seen = new HashMap();
        taskItem1.taskGroup().invokeAsync(taskItem1.taskGroup().newInvocationContext()).map((Func1)new Func1<Indexable, Indexable>(){

            public Indexable call(Indexable item) {
                SupportCountingAndHasName c = (SupportCountingAndHasName)item;
                if (seen.containsKey(c.name())) {
                    Integer a = (Integer)seen.get(c.name()) + 1;
                    seen.put(c.name(), a);
                } else {
                    seen.put(c.name(), 1);
                }
                return item;
            }
        }).toBlocking().last();
        Assert.assertEquals((long)3L, (long)seen.size());
        Assert.assertTrue((boolean)seen.containsKey("X"));
        Assert.assertTrue((boolean)seen.containsKey("Y"));
        Assert.assertTrue((boolean)seen.containsKey("Z"));
        Assert.assertEquals((long)2L, (long)((Integer)seen.get("X")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("Y")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("Z")).intValue());
        Assert.assertEquals((long)1L, (long)taskItem1.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem2.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem3.getCallCount());
        seen.clear();
        taskItem1.taskGroup().invokeAsync(taskItem1.taskGroup().newInvocationContext()).map((Func1)new Func1<Indexable, Indexable>(){

            public Indexable call(Indexable item) {
                SupportCountingAndHasName c = (SupportCountingAndHasName)item;
                if (seen.containsKey(c.name())) {
                    Integer a = (Integer)seen.get(c.name()) + 1;
                    seen.put(c.name(), a);
                } else {
                    seen.put(c.name(), 1);
                }
                return item;
            }
        }).toBlocking().last();
        Assert.assertEquals((long)3L, (long)seen.size());
        Assert.assertTrue((boolean)seen.containsKey("X"));
        Assert.assertTrue((boolean)seen.containsKey("Y"));
        Assert.assertTrue((boolean)seen.containsKey("Z"));
        Assert.assertEquals((long)2L, (long)((Integer)seen.get("X")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("Y")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("Z")).intValue());
        Assert.assertEquals((long)2L, (long)taskItem1.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem2.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem3.getCallCount());
    }

    @Test
    public void testIgnoreCachedResultOnRootWithProxyWithDescendantProxy() {
        TestTaskItem taskItem1 = new TestTaskItem("1");
        TestTaskItem taskItem2 = new TestTaskItem("2");
        TestTaskItem taskItem3 = new TestTaskItem("3");
        TestTaskItem taskItem4 = new TestTaskItem("4");
        TestTaskItem taskItem5 = new TestTaskItem("5");
        taskItem1.addDependency((TaskGroup.HasTaskGroup)taskItem2);
        taskItem1.addPostRunDependent((TaskGroup.HasTaskGroup)taskItem3);
        taskItem4.addDependency((TaskGroup.HasTaskGroup)taskItem1);
        taskItem4.addPostRunDependent((TaskGroup.HasTaskGroup)taskItem5);
        final HashMap seen = new HashMap();
        taskItem4.taskGroup().invokeAsync(taskItem1.taskGroup().newInvocationContext()).map((Func1)new Func1<Indexable, Indexable>(){

            public Indexable call(Indexable item) {
                SupportCountingAndHasName c = (SupportCountingAndHasName)item;
                if (seen.containsKey(c.name())) {
                    Integer a = (Integer)seen.get(c.name()) + 1;
                    seen.put(c.name(), a);
                } else {
                    seen.put(c.name(), 1);
                }
                return item;
            }
        }).toBlocking().last();
        Assert.assertEquals((long)5L, (long)seen.size());
        Assert.assertTrue((boolean)seen.containsKey("1"));
        Assert.assertTrue((boolean)seen.containsKey("2"));
        Assert.assertTrue((boolean)seen.containsKey("3"));
        Assert.assertTrue((boolean)seen.containsKey("4"));
        Assert.assertTrue((boolean)seen.containsKey("5"));
        Assert.assertEquals((long)2L, (long)((Integer)seen.get("1")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("2")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("3")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)seen.get("4")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("5")).intValue());
        Assert.assertEquals((long)1L, (long)taskItem1.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem2.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem3.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem4.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem5.getCallCount());
        seen.clear();
        taskItem4.taskGroup().invokeAsync(taskItem1.taskGroup().newInvocationContext()).map((Func1)new Func1<Indexable, Indexable>(){

            public Indexable call(Indexable item) {
                SupportCountingAndHasName c = (SupportCountingAndHasName)item;
                if (seen.containsKey(c.name())) {
                    Integer a = (Integer)seen.get(c.name()) + 1;
                    seen.put(c.name(), a);
                } else {
                    seen.put(c.name(), 1);
                }
                return item;
            }
        }).toBlocking().last();
        Assert.assertEquals((long)5L, (long)seen.size());
        Assert.assertTrue((boolean)seen.containsKey("1"));
        Assert.assertTrue((boolean)seen.containsKey("2"));
        Assert.assertTrue((boolean)seen.containsKey("3"));
        Assert.assertTrue((boolean)seen.containsKey("4"));
        Assert.assertTrue((boolean)seen.containsKey("5"));
        Assert.assertEquals((long)2L, (long)((Integer)seen.get("1")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("2")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("3")).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)seen.get("4")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)seen.get("5")).intValue());
        Assert.assertEquals((long)1L, (long)taskItem1.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem2.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem3.getCallCount());
        Assert.assertEquals((long)2L, (long)taskItem4.getCallCount());
        Assert.assertEquals((long)1L, (long)taskItem5.getCallCount());
    }

    static interface SupportCountingAndHasName
    extends HasName {
        public int getCallCount();
    }

    class TestTaskItem
    extends IndexableTaskItem
    implements SupportCountingAndHasName {
        private final String name;
        private int callCount;

        TestTaskItem(String name) {
            super(name);
            this.callCount = 0;
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        @Override
        public int getCallCount() {
            return this.callCount;
        }

        protected Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
            return Observable.just((Object)this).map((Func1)new Func1<IndexableTaskItem, Indexable>(){

                public Indexable call(IndexableTaskItem r) {
                    TestTaskItem.this.callCount++;
                    return r;
                }
            });
        }
    }
}

