/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.microsoft.azure.arm.dag.IPancake;
import com.microsoft.azure.arm.dag.PancakeInner;
import com.microsoft.azure.arm.dag.TaskGroupEntry;
import com.microsoft.azure.arm.model.Creatable;
import com.microsoft.azure.arm.model.implementation.CreatableUpdatableImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import rx.Observable;
import rx.functions.Func1;

class PancakeImpl
extends CreatableUpdatableImpl<IPancake, PancakeInner, PancakeImpl>
implements IPancake {
    final List<Creatable<IPancake>> delayedPancakes;
    final long eventDelayInMilliseconds;
    final Throwable errorToThrow;
    boolean prepareCalled = false;

    public PancakeImpl(String name, long eventDelayInMilliseconds) {
        this(name, eventDelayInMilliseconds, false);
    }

    public PancakeImpl(String name, long eventDelayInMilliseconds, boolean fault) {
        super(name, name, (Object)new PancakeInner());
        this.eventDelayInMilliseconds = eventDelayInMilliseconds;
        this.errorToThrow = fault ? new RuntimeException(name) : null;
        this.delayedPancakes = new ArrayList<Creatable<IPancake>>();
    }

    @Override
    public PancakeImpl withInstantPancake(Creatable<IPancake> pancake) {
        this.addDependency(pancake);
        return this;
    }

    @Override
    public PancakeImpl withDelayedPancake(Creatable<IPancake> pancake) {
        this.delayedPancakes.add(pancake);
        return this;
    }

    public void beforeGroupCreateOrUpdate() {
        Assert.assertFalse((String)"PancakeImpl::beforeGroupCreateOrUpdate() should not be called multiple times", (boolean)this.prepareCalled);
        this.prepareCalled = true;
        int oldCount = ((TaskGroupEntry)this.taskGroup().getNode(this.key())).dependencyKeys().size();
        for (Creatable<IPancake> pancake : this.delayedPancakes) {
            this.addDependency(pancake);
        }
        int newCount = ((TaskGroupEntry)this.taskGroup().getNode(this.key())).dependencyKeys().size();
        System.out.println("Pancake(" + this.name() + ")::beforeGroupCreateOrUpdate() 'delayedSize':" + this.delayedPancakes.size() + " 'dependency count [old, new]': [" + oldCount + "," + newCount + "]");
    }

    public Observable<IPancake> createResourceAsync() {
        if (this.errorToThrow == null) {
            System.out.println("Pancake(" + this.name() + ")::createResourceAsync() 'onNext()'");
            return Observable.just((Object)this).delay(this.eventDelayInMilliseconds, TimeUnit.MILLISECONDS).map((Func1)new Func1<PancakeImpl, IPancake>(){

                public IPancake call(PancakeImpl pancake) {
                    return pancake;
                }
            });
        }
        System.out.println("Pancake(" + this.name() + ")::createResourceAsync() 'onError()'");
        return Observable.just((Object)this).delay(this.eventDelayInMilliseconds, TimeUnit.MILLISECONDS).flatMap((Func1)new Func1<PancakeImpl, Observable<IPancake>>(){

            public Observable<IPancake> call(PancakeImpl pancake) {
                return PancakeImpl.this.toErrorObservable(PancakeImpl.this.errorToThrow);
            }
        });
    }

    public boolean isInCreateMode() {
        return true;
    }

    protected Observable<PancakeInner> getInnerAsync() {
        return null;
    }

    private Observable<IPancake> toErrorObservable(Throwable throwable) {
        return Observable.error((Throwable)throwable);
    }
}

