/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.microsoft.azure.arm.dag.IPasta;
import com.microsoft.azure.arm.dag.PastaInner;
import com.microsoft.azure.arm.dag.TaskGroupEntry;
import com.microsoft.azure.arm.model.Creatable;
import com.microsoft.azure.arm.model.implementation.CreatableUpdatableImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import rx.Observable;
import rx.functions.Func1;

class PastaImpl
extends CreatableUpdatableImpl<IPasta, PastaInner, PastaImpl>
implements IPasta {
    final List<Creatable<IPasta>> delayedPastas;
    final long eventDelayInMilliseconds;
    final Throwable errorToThrow;
    boolean prepareCalled = false;

    public PastaImpl(String name, long eventDelayInMilliseconds) {
        this(name, eventDelayInMilliseconds, false);
    }

    public PastaImpl(String name, long eventDelayInMilliseconds, boolean fault) {
        super(name, name, (Object)new PastaInner());
        this.eventDelayInMilliseconds = eventDelayInMilliseconds;
        this.errorToThrow = fault ? new RuntimeException(name) : null;
        this.delayedPastas = new ArrayList<Creatable<IPasta>>();
    }

    @Override
    public PastaImpl withInstantPasta(Creatable<IPasta> pasta) {
        this.addDependency(pasta);
        return this;
    }

    @Override
    public PastaImpl withDelayedPasta(Creatable<IPasta> pasta) {
        this.delayedPastas.add(pasta);
        return this;
    }

    public void beforeGroupCreateOrUpdate() {
        Assert.assertFalse((String)"PastaImpl::beforeGroupCreateOrUpdate() should not be called multiple times", (boolean)this.prepareCalled);
        this.prepareCalled = true;
        int oldCount = ((TaskGroupEntry)this.taskGroup().getNode(this.key())).dependencyKeys().size();
        for (Creatable<IPasta> pancake : this.delayedPastas) {
            this.addDependency(pancake);
        }
        int newCount = ((TaskGroupEntry)this.taskGroup().getNode(this.key())).dependencyKeys().size();
        System.out.println("Pasta(" + this.name() + ")::beforeGroupCreateOrUpdate() 'delayedSize':" + this.delayedPastas.size() + " 'dependency count [old, new]': [" + oldCount + "," + newCount + "]");
    }

    public Observable<IPasta> createResourceAsync() {
        if (this.errorToThrow == null) {
            System.out.println("Pasta(" + this.name() + ")::createResourceAsync() 'onNext()'");
            return Observable.just((Object)this).delay(this.eventDelayInMilliseconds, TimeUnit.MILLISECONDS).map((Func1)new Func1<PastaImpl, IPasta>(){

                public IPasta call(PastaImpl pasta) {
                    return pasta;
                }
            });
        }
        System.out.println("Pasta(" + this.name() + ")::createResourceAsync() 'onError()'");
        return Observable.just((Object)this).delay(this.eventDelayInMilliseconds, TimeUnit.MILLISECONDS).flatMap((Func1)new Func1<PastaImpl, Observable<IPasta>>(){

            public Observable<IPasta> call(PastaImpl pasta) {
                return PastaImpl.this.toErrorObservable(PastaImpl.this.errorToThrow);
            }
        });
    }

    public boolean isInCreateMode() {
        return true;
    }

    protected Observable<PastaInner> getInnerAsync() {
        return Observable.just((Object)this.inner());
    }

    private Observable<IPasta> toErrorObservable(Throwable throwable) {
        return Observable.error((Throwable)throwable);
    }
}

