/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.microsoft.azure.arm.dag.IPizza;
import com.microsoft.azure.arm.dag.PizzaInner;
import com.microsoft.azure.arm.dag.TaskGroupEntry;
import com.microsoft.azure.arm.model.Creatable;
import com.microsoft.azure.arm.model.implementation.CreatableUpdatableImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import rx.Observable;
import rx.functions.Func1;

class PizzaImpl
extends CreatableUpdatableImpl<IPizza, PizzaInner, PizzaImpl>
implements IPizza {
    final List<Creatable<IPizza>> delayedPizzas = new ArrayList<Creatable<IPizza>>();
    boolean prepareCalled = false;

    public PizzaImpl(String name) {
        super(name, name, (Object)new PizzaInner());
    }

    @Override
    public PizzaImpl withInstantPizza(Creatable<IPizza> pizza) {
        this.addDependency(pizza);
        return this;
    }

    @Override
    public PizzaImpl withDelayedPizza(Creatable<IPizza> pizza) {
        this.delayedPizzas.add(pizza);
        return this;
    }

    public void beforeGroupCreateOrUpdate() {
        Assert.assertFalse((String)"PizzaImpl::beforeGroupCreateOrUpdate() should not be called multiple times", (boolean)this.prepareCalled);
        this.prepareCalled = true;
        int oldCount = ((TaskGroupEntry)this.taskGroup().getNode(this.key())).dependencyKeys().size();
        for (Creatable<IPizza> pizza : this.delayedPizzas) {
            this.addDependency(pizza);
        }
        int newCount = ((TaskGroupEntry)this.taskGroup().getNode(this.key())).dependencyKeys().size();
        System.out.println("Pizza(" + this.name() + ")::beforeGroupCreateOrUpdate() 'delayedSize':" + this.delayedPizzas.size() + " 'dependency count [old, new]': [" + oldCount + "," + newCount + "]");
    }

    public Observable<IPizza> createResourceAsync() {
        System.out.println("Pizza(" + this.name() + ")::createResourceAsync()");
        return Observable.just((Object)this).delay(250L, TimeUnit.MILLISECONDS).map((Func1)new Func1<PizzaImpl, IPizza>(){

            public IPizza call(PizzaImpl pizza) {
                return pizza;
            }
        });
    }

    public boolean isInCreateMode() {
        return true;
    }

    protected Observable<PizzaInner> getInnerAsync() {
        return Observable.just((Object)this.inner());
    }
}

