/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.dag;

import com.google.common.collect.Sets;
import com.microsoft.azure.arm.dag.DAGNode;
import com.microsoft.azure.arm.dag.IndexableTaskItem;
import com.microsoft.azure.arm.dag.TaskGroup;
import com.microsoft.azure.arm.dag.TaskGroupEntry;
import com.microsoft.azure.arm.dag.TaskItem;
import com.microsoft.azure.arm.model.Indexable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import rx.Completable;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class ProxyTaskGroupTests {
    @Test
    public void testSampleTaskGroupSanity() {
        final ArrayList<String> groupItems = new ArrayList<String>();
        TaskGroup group = this.createSampleTaskGroup("A", "B", "C", "D", "E", "F", groupItems);
        group.invokeAsync(group.newInvocationContext()).subscribe((Action1)new Action1<Indexable>(){

            public void call(Indexable value) {
                StringIndexable stringIndexable = ProxyTaskGroupTests.this.toStringIndexable(value);
                Assert.assertTrue((boolean)groupItems.contains(stringIndexable.str()));
                groupItems.remove(stringIndexable.str());
            }
        });
        Assert.assertEquals((long)0L, (long)groupItems.size());
        HashMap shouldNotSee = new HashMap();
        shouldNotSee.put("A", new HashSet());
        ((Set)shouldNotSee.get("A")).addAll(Arrays.asList("B", "C", "D", "E", "F"));
        shouldNotSee.put("B", new HashSet());
        ((Set)shouldNotSee.get("B")).addAll(Arrays.asList("F"));
        shouldNotSee.put("C", new HashSet());
        ((Set)shouldNotSee.get("C")).addAll(Arrays.asList("E", "F"));
        shouldNotSee.put("D", new HashSet());
        ((Set)shouldNotSee.get("D")).addAll(Arrays.asList("E", "F"));
        shouldNotSee.put("E", new HashSet());
        ((Set)shouldNotSee.get("E")).addAll(Arrays.asList("F"));
        shouldNotSee.put("F", new HashSet());
        ((Set)shouldNotSee.get("F")).addAll(Arrays.asList(new String[0]));
        HashSet<String> seen = new HashSet<String>();
        group.prepareForEnumeration();
        TaskGroupEntry entry = (TaskGroupEntry)group.getNext();
        while (entry != null) {
            Sets.SetView common = Sets.intersection((Set)((Set)shouldNotSee.get(entry.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry.key()), (boolean)false);
            }
            seen.add(entry.key());
            group.reportCompletion((DAGNode)entry);
            entry = (TaskGroupEntry)group.getNext();
        }
        Assert.assertEquals((long)6L, (long)seen.size());
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F"));
        Sets.SetView diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
    }

    @Test
    public void testTaskGroupInvocationShouldNotInvokeDependentTaskGroup() {
        final ArrayList<String> group1Items = new ArrayList<String>();
        TaskGroup group1 = this.createSampleTaskGroup("A", "B", "C", "D", "E", "F", group1Items);
        ArrayList<String> group2Items = new ArrayList<String>();
        TaskGroup group2 = this.createSampleTaskGroup("G", "H", "I", "J", "K", "L", group2Items);
        group2.addDependencyTaskGroup(group1);
        group1.invokeAsync(group1.newInvocationContext()).subscribe((Action1)new Action1<Indexable>(){

            public void call(Indexable value) {
                StringIndexable stringIndexable = ProxyTaskGroupTests.this.toStringIndexable(value);
                Assert.assertTrue((boolean)group1Items.contains(stringIndexable.str()));
                group1Items.remove(stringIndexable.str());
            }
        });
        Assert.assertEquals((long)0L, (long)group1Items.size());
        HashMap shouldNotSee = new HashMap();
        shouldNotSee.put("A", new HashSet());
        ((Set)shouldNotSee.get("A")).addAll(Arrays.asList("B", "C", "D", "E", "F"));
        shouldNotSee.put("B", new HashSet());
        ((Set)shouldNotSee.get("B")).addAll(Arrays.asList("F"));
        shouldNotSee.put("C", new HashSet());
        ((Set)shouldNotSee.get("C")).addAll(Arrays.asList("E", "F"));
        shouldNotSee.put("D", new HashSet());
        ((Set)shouldNotSee.get("D")).addAll(Arrays.asList("E", "F"));
        shouldNotSee.put("E", new HashSet());
        ((Set)shouldNotSee.get("E")).addAll(Arrays.asList("F"));
        shouldNotSee.put("F", new HashSet());
        ((Set)shouldNotSee.get("F")).addAll(Arrays.asList(new String[0]));
        HashSet<String> seen = new HashSet<String>();
        group1.prepareForEnumeration();
        TaskGroupEntry entry = (TaskGroupEntry)group1.getNext();
        while (entry != null) {
            Sets.SetView common = Sets.intersection((Set)((Set)shouldNotSee.get(entry.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry.key()), (boolean)false);
            }
            seen.add(entry.key());
            group1.reportCompletion((DAGNode)entry);
            entry = (TaskGroupEntry)group1.getNext();
        }
        Assert.assertEquals((long)6L, (long)seen.size());
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F"));
        Sets.SetView diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
    }

    @Test
    public void testTaskGroupInvocationShouldInvokeDependencyTaskGroup() {
        ArrayList<String> group1Items = new ArrayList<String>();
        TaskGroup group1 = this.createSampleTaskGroup("A", "B", "C", "D", "E", "F", group1Items);
        final ArrayList<String> group2Items = new ArrayList<String>();
        TaskGroup group2 = this.createSampleTaskGroup("G", "H", "I", "J", "K", "L", group2Items);
        group2.addDependencyTaskGroup(group1);
        group2Items.addAll(group1Items);
        group2.invokeAsync(group2.newInvocationContext()).subscribe((Action1)new Action1<Indexable>(){

            public void call(Indexable value) {
                StringIndexable stringIndexable = ProxyTaskGroupTests.this.toStringIndexable(value);
                Assert.assertTrue((boolean)group2Items.contains(stringIndexable.str()));
                group2Items.remove(stringIndexable.str());
            }
        });
        Assert.assertEquals((long)0L, (long)group2Items.size());
        HashMap shouldNotSee = new HashMap();
        shouldNotSee.put("A", new HashSet());
        ((Set)shouldNotSee.get("A")).addAll(Arrays.asList("B", "C", "D", "E", "F"));
        shouldNotSee.put("B", new HashSet());
        ((Set)shouldNotSee.get("B")).addAll(Arrays.asList("F"));
        shouldNotSee.put("C", new HashSet());
        ((Set)shouldNotSee.get("C")).addAll(Arrays.asList("E", "F"));
        shouldNotSee.put("D", new HashSet());
        ((Set)shouldNotSee.get("D")).addAll(Arrays.asList("E", "F"));
        shouldNotSee.put("E", new HashSet());
        ((Set)shouldNotSee.get("E")).addAll(Arrays.asList("F"));
        shouldNotSee.put("F", new HashSet());
        ((Set)shouldNotSee.get("F")).addAll(Arrays.asList(new String[0]));
        shouldNotSee.put("G", new HashSet());
        ((Set)shouldNotSee.get("G")).addAll(Arrays.asList("H", "I", "J", "K", "L"));
        shouldNotSee.put("H", new HashSet());
        ((Set)shouldNotSee.get("H")).addAll(Arrays.asList("L"));
        shouldNotSee.put("I", new HashSet());
        ((Set)shouldNotSee.get("I")).addAll(Arrays.asList("K", "L"));
        shouldNotSee.put("J", new HashSet());
        ((Set)shouldNotSee.get("J")).addAll(Arrays.asList("K", "L"));
        shouldNotSee.put("K", new HashSet());
        ((Set)shouldNotSee.get("K")).addAll(Arrays.asList("L"));
        shouldNotSee.put("L", new HashSet());
        ((Set)shouldNotSee.get("L")).addAll(Arrays.asList(new String[0]));
        HashSet<String> seen = new HashSet<String>();
        group2.prepareForEnumeration();
        TaskGroupEntry entry = (TaskGroupEntry)group2.getNext();
        while (entry != null) {
            Assert.assertTrue((boolean)shouldNotSee.containsKey(entry.key()));
            Assert.assertFalse((boolean)seen.contains(entry.key()));
            Sets.SetView common = Sets.intersection((Set)((Set)shouldNotSee.get(entry.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry.key()), (boolean)false);
            }
            seen.add(entry.key());
            group2.reportCompletion((DAGNode)entry);
            entry = (TaskGroupEntry)group2.getNext();
        }
        Assert.assertEquals((long)12L, (long)seen.size());
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L"));
        Sets.SetView diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
    }

    @Test
    public void testTaskGroupInvocationShouldInvokePostRunDependentTaskGroup() {
        final LinkedList<String> group1Items = new LinkedList<String>();
        TaskGroup group1 = this.createSampleTaskGroup("A", "B", "C", "D", "E", "F", group1Items);
        LinkedList<String> group2Items = new LinkedList<String>();
        TaskGroup group2 = this.createSampleTaskGroup("G", "H", "I", "J", "K", "L", group2Items);
        group1.addPostRunDependentTaskGroup(group2);
        group1Items.addAll(group2Items);
        group1.invokeAsync(group1.newInvocationContext()).subscribe((Action1)new Action1<Indexable>(){

            public void call(Indexable value) {
                StringIndexable stringIndexable = ProxyTaskGroupTests.this.toStringIndexable(value);
                Assert.assertTrue((boolean)group1Items.contains(stringIndexable.str()));
                group1Items.remove(stringIndexable.str());
            }
        });
        Assert.assertEquals((long)0L, (long)group1Items.size());
        HashMap shouldNotSee = new HashMap();
        shouldNotSee.put("A", new HashSet());
        ((Set)shouldNotSee.get("A")).addAll(Arrays.asList("B", "C", "D", "E", "F", "proxy-F"));
        shouldNotSee.put("B", new HashSet());
        ((Set)shouldNotSee.get("B")).addAll(Arrays.asList("F", "proxy-F"));
        shouldNotSee.put("C", new HashSet());
        ((Set)shouldNotSee.get("C")).addAll(Arrays.asList("E", "F", "proxy-F"));
        shouldNotSee.put("D", new HashSet());
        ((Set)shouldNotSee.get("D")).addAll(Arrays.asList("E", "F", "proxy-F"));
        shouldNotSee.put("E", new HashSet());
        ((Set)shouldNotSee.get("E")).addAll(Arrays.asList("F", "proxy-F"));
        shouldNotSee.put("F", new HashSet());
        ((Set)shouldNotSee.get("F")).addAll(Arrays.asList("proxy-F"));
        shouldNotSee.put("G", new HashSet());
        ((Set)shouldNotSee.get("G")).addAll(Arrays.asList("H", "I", "J", "K", "L", "proxy-F"));
        shouldNotSee.put("H", new HashSet());
        ((Set)shouldNotSee.get("H")).addAll(Arrays.asList("L", "proxy-F"));
        shouldNotSee.put("I", new HashSet());
        ((Set)shouldNotSee.get("I")).addAll(Arrays.asList("K", "L", "proxy-F"));
        shouldNotSee.put("J", new HashSet());
        ((Set)shouldNotSee.get("J")).addAll(Arrays.asList("K", "L", "proxy-F"));
        shouldNotSee.put("K", new HashSet());
        ((Set)shouldNotSee.get("K")).addAll(Arrays.asList("L", "proxy-F"));
        shouldNotSee.put("L", new HashSet());
        ((Set)shouldNotSee.get("L")).addAll(Arrays.asList("proxy-F"));
        shouldNotSee.put("proxy-F", new HashSet());
        ((Set)shouldNotSee.get("proxy-F")).addAll(Arrays.asList(new String[0]));
        HashSet<String> seen = new HashSet<String>();
        group1.proxyTaskGroupWrapper.taskGroup().prepareForEnumeration();
        TaskGroupEntry entry = (TaskGroupEntry)group1.proxyTaskGroupWrapper.taskGroup().getNext();
        while (entry != null) {
            Assert.assertTrue((boolean)shouldNotSee.containsKey(entry.key()));
            Assert.assertFalse((boolean)seen.contains(entry.key()));
            Sets.SetView common = Sets.intersection((Set)((Set)shouldNotSee.get(entry.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry.key()), (boolean)false);
            }
            seen.add(entry.key());
            group1.proxyTaskGroupWrapper.taskGroup().reportCompletion((DAGNode)entry);
            entry = (TaskGroupEntry)group1.proxyTaskGroupWrapper.taskGroup().getNext();
        }
        Assert.assertEquals((long)13L, (long)seen.size());
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "proxy-F"));
        Sets.SetView diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
        group1.invokeAsync(group1.newInvocationContext()).subscribe((Action1)new Action1<Indexable>(){

            public void call(Indexable indexable) {
                System.out.println(indexable.key());
            }
        });
    }

    @Test
    public void testPostRunTaskGroupInvocationShouldInvokeDependencyTaskGroup() {
        LinkedList<String> group1Items = new LinkedList<String>();
        TaskGroup group1 = this.createSampleTaskGroup("A", "B", "C", "D", "E", "F", group1Items);
        final ArrayList<String> group2Items = new ArrayList<String>();
        TaskGroup group2 = this.createSampleTaskGroup("G", "H", "I", "J", "K", "L", group2Items);
        group1.addPostRunDependentTaskGroup(group2);
        group2Items.addAll(group1Items);
        group2.invokeAsync(group2.newInvocationContext()).subscribe((Action1)new Action1<Indexable>(){

            public void call(Indexable value) {
                StringIndexable stringIndexable = ProxyTaskGroupTests.this.toStringIndexable(value);
                Assert.assertTrue((boolean)group2Items.contains(stringIndexable.str()));
                group2Items.remove(stringIndexable.str());
            }
        });
        Assert.assertEquals((long)0L, (long)group2Items.size());
        HashMap shouldNotSee = new HashMap();
        shouldNotSee.put("A", new HashSet());
        ((Set)shouldNotSee.get("A")).addAll(Arrays.asList("B", "C", "D", "E", "F", "proxy-F"));
        shouldNotSee.put("B", new HashSet());
        ((Set)shouldNotSee.get("B")).addAll(Arrays.asList("F", "proxy-F"));
        shouldNotSee.put("C", new HashSet());
        ((Set)shouldNotSee.get("C")).addAll(Arrays.asList("E", "F", "proxy-F"));
        shouldNotSee.put("D", new HashSet());
        ((Set)shouldNotSee.get("D")).addAll(Arrays.asList("E", "F", "proxy-F"));
        shouldNotSee.put("E", new HashSet());
        ((Set)shouldNotSee.get("E")).addAll(Arrays.asList("F", "proxy-F"));
        shouldNotSee.put("F", new HashSet());
        ((Set)shouldNotSee.get("F")).addAll(Arrays.asList("proxy-F"));
        shouldNotSee.put("G", new HashSet());
        ((Set)shouldNotSee.get("G")).addAll(Arrays.asList("H", "I", "J", "K", "L", "proxy-F"));
        shouldNotSee.put("H", new HashSet());
        ((Set)shouldNotSee.get("H")).addAll(Arrays.asList("L", "proxy-F"));
        shouldNotSee.put("I", new HashSet());
        ((Set)shouldNotSee.get("I")).addAll(Arrays.asList("K", "L", "proxy-F"));
        shouldNotSee.put("J", new HashSet());
        ((Set)shouldNotSee.get("J")).addAll(Arrays.asList("K", "L", "proxy-F"));
        shouldNotSee.put("K", new HashSet());
        ((Set)shouldNotSee.get("K")).addAll(Arrays.asList("L", "proxy-F"));
        shouldNotSee.put("L", new HashSet());
        ((Set)shouldNotSee.get("L")).addAll(Arrays.asList("proxy-F"));
        shouldNotSee.put("proxy-F", new HashSet());
        ((Set)shouldNotSee.get("proxy-F")).addAll(Arrays.asList(new String[0]));
        HashSet<String> seen = new HashSet<String>();
        group2.prepareForEnumeration();
        TaskGroupEntry entry = (TaskGroupEntry)group2.getNext();
        while (entry != null) {
            Assert.assertTrue((boolean)shouldNotSee.containsKey(entry.key()));
            Assert.assertFalse((boolean)seen.contains(entry.key()));
            Sets.SetView common = Sets.intersection((Set)((Set)shouldNotSee.get(entry.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry.key()), (boolean)false);
            }
            seen.add(entry.key());
            group2.reportCompletion((DAGNode)entry);
            entry = (TaskGroupEntry)group2.getNext();
        }
        Assert.assertEquals((long)12L, (long)seen.size());
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L"));
        Sets.SetView diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
    }

    @Test
    public void testParentReassignmentUponProxyTaskGroupActivation() {
        LinkedList<String> group1Items = new LinkedList<String>();
        TaskGroup group1 = this.createSampleTaskGroup("A", "B", "C", "D", "E", "F", group1Items);
        ArrayList<String> group2Items = new ArrayList<String>();
        TaskGroup group2 = this.createSampleTaskGroup("G", "H", "I", "J", "K", "L", group2Items);
        group2.addDependencyTaskGroup(group1);
        Assert.assertEquals((long)1L, (long)group1.parentDAGs.size());
        Assert.assertTrue((boolean)group1.parentDAGs.contains(group2));
        LinkedList<String> group3Items = new LinkedList<String>();
        TaskGroup group3 = this.createSampleTaskGroup("M", "N", "O", "P", "Q", "R", group3Items);
        group1.addPostRunDependentTaskGroup(group3);
        Assert.assertEquals((long)2L, (long)group1.parentDAGs.size());
        Assert.assertTrue((boolean)group1.parentDAGs.contains(group3));
        Assert.assertTrue((boolean)group1.parentDAGs.contains(group1.proxyTaskGroupWrapper.taskGroup()));
        Assert.assertEquals((long)1L, (long)group1.proxyTaskGroupWrapper.taskGroup().parentDAGs.size());
        Assert.assertTrue((boolean)group1.proxyTaskGroupWrapper.taskGroup().parentDAGs.contains(group2));
        HashMap shouldNotSee = new HashMap();
        shouldNotSee.put("A", new HashSet());
        ((Set)shouldNotSee.get("A")).addAll(Arrays.asList("B", "C", "D", "E", "F", "proxy-F", "L"));
        shouldNotSee.put("B", new HashSet());
        ((Set)shouldNotSee.get("B")).addAll(Arrays.asList("F", "proxy-F", "L"));
        shouldNotSee.put("C", new HashSet());
        ((Set)shouldNotSee.get("C")).addAll(Arrays.asList("E", "F", "proxy-F", "L"));
        shouldNotSee.put("D", new HashSet());
        ((Set)shouldNotSee.get("D")).addAll(Arrays.asList("E", "F", "proxy-F", "L"));
        shouldNotSee.put("E", new HashSet());
        ((Set)shouldNotSee.get("E")).addAll(Arrays.asList("F", "proxy-F", "L"));
        shouldNotSee.put("F", new HashSet());
        ((Set)shouldNotSee.get("F")).addAll(Arrays.asList("proxy-F", "L"));
        shouldNotSee.put("M", new HashSet());
        ((Set)shouldNotSee.get("M")).addAll(Arrays.asList("N", "O", "P", "Q", "R", "proxy-F", "L"));
        shouldNotSee.put("N", new HashSet());
        ((Set)shouldNotSee.get("N")).addAll(Arrays.asList("R", "proxy-F", "L"));
        shouldNotSee.put("O", new HashSet());
        ((Set)shouldNotSee.get("O")).addAll(Arrays.asList("Q", "R", "L"));
        shouldNotSee.put("P", new HashSet());
        ((Set)shouldNotSee.get("P")).addAll(Arrays.asList("Q", "R", "proxy-F", "L"));
        shouldNotSee.put("Q", new HashSet());
        ((Set)shouldNotSee.get("Q")).addAll(Arrays.asList("R", "proxy-F", "L"));
        shouldNotSee.put("R", new HashSet());
        ((Set)shouldNotSee.get("R")).addAll(Arrays.asList("proxy-F", "L"));
        shouldNotSee.put("G", new HashSet());
        ((Set)shouldNotSee.get("G")).addAll(Arrays.asList("H", "I", "J", "K", "L"));
        shouldNotSee.put("H", new HashSet());
        ((Set)shouldNotSee.get("H")).addAll(Arrays.asList("L"));
        shouldNotSee.put("I", new HashSet());
        ((Set)shouldNotSee.get("I")).addAll(Arrays.asList("K", "L"));
        shouldNotSee.put("J", new HashSet());
        ((Set)shouldNotSee.get("J")).addAll(Arrays.asList("K", "L"));
        shouldNotSee.put("K", new HashSet());
        ((Set)shouldNotSee.get("K")).addAll(Arrays.asList("L"));
        shouldNotSee.put("L", new HashSet());
        ((Set)shouldNotSee.get("L")).addAll(Arrays.asList(new String[0]));
        shouldNotSee.put("proxy-F", new HashSet());
        ((Set)shouldNotSee.get("proxy-F")).addAll(Arrays.asList("L"));
        HashSet<String> seen = new HashSet<String>();
        group2.prepareForEnumeration();
        TaskGroupEntry entry = (TaskGroupEntry)group2.getNext();
        while (entry != null) {
            Assert.assertTrue((boolean)shouldNotSee.containsKey(entry.key()));
            Assert.assertFalse((boolean)seen.contains(entry.key()));
            Sets.SetView common = Sets.intersection((Set)((Set)shouldNotSee.get(entry.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry.key()), (boolean)false);
            }
            seen.add(entry.key());
            group2.reportCompletion((DAGNode)entry);
            entry = (TaskGroupEntry)group2.getNext();
        }
        Assert.assertEquals((long)19L, (long)seen.size());
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "proxy-F", "R"));
        Sets.SetView diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
        seen.clear();
        TaskGroup group1Proxy = group1.proxyTaskGroupWrapper.taskGroup();
        group1Proxy.prepareForEnumeration();
        TaskGroupEntry entry2 = (TaskGroupEntry)group1Proxy.getNext();
        while (entry2 != null) {
            Assert.assertTrue((boolean)shouldNotSee.containsKey(entry2.key()));
            Assert.assertFalse((boolean)seen.contains(entry2.key()));
            Sets.SetView common = Sets.intersection((Set)((Set)shouldNotSee.get(entry2.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry2.key()), (boolean)false);
            }
            seen.add(entry2.key());
            group1Proxy.reportCompletion((DAGNode)entry2);
            entry2 = (TaskGroupEntry)group1Proxy.getNext();
        }
        Assert.assertEquals((long)13L, (long)seen.size());
        expectedToSee.clear();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F", "M", "N", "O", "P", "Q", "proxy-F", "R"));
    }

    @Test
    public void testParentProxyReassignmentUponProxyTaskGroupActivation() {
        Sets.SetView common;
        LinkedList<String> group1Items = new LinkedList<String>();
        TaskGroup group1 = this.createSampleTaskGroup("A", "B", "C", "D", "E", "F", group1Items);
        ArrayList<String> group2Items = new ArrayList<String>();
        TaskGroup group2 = this.createSampleTaskGroup("G", "H", "I", "J", "K", "L", group2Items);
        group2.addDependencyTaskGroup(group1);
        Assert.assertEquals((long)1L, (long)group1.parentDAGs.size());
        Assert.assertTrue((boolean)group1.parentDAGs.contains(group2));
        LinkedList<String> group3Items = new LinkedList<String>();
        TaskGroup group3 = this.createSampleTaskGroup("M", "N", "O", "P", "Q", "R", group3Items);
        group1.addPostRunDependentTaskGroup(group3);
        Assert.assertEquals((long)2L, (long)group1.parentDAGs.size());
        Assert.assertTrue((boolean)group1.parentDAGs.contains(group3));
        Assert.assertTrue((boolean)group1.parentDAGs.contains(group1.proxyTaskGroupWrapper.taskGroup()));
        Assert.assertEquals((long)1L, (long)group1.proxyTaskGroupWrapper.taskGroup().parentDAGs.size());
        Assert.assertTrue((boolean)group1.proxyTaskGroupWrapper.taskGroup().parentDAGs.contains(group2));
        LinkedList<String> group4Items = new LinkedList<String>();
        TaskGroup group4 = this.createSampleTaskGroup("S", "T", "U", "V", "W", "X", group4Items);
        LinkedList<String> group5Items = new LinkedList<String>();
        TaskGroup group5 = this.createSampleTaskGroup("1", "2", "3", "4", "5", "6", group5Items);
        group4.addPostRunDependentTaskGroup(group5);
        group1.addPostRunDependentTaskGroup(group4);
        HashMap shouldNotSee = new HashMap();
        shouldNotSee.put("A", new HashSet());
        ((Set)shouldNotSee.get("A")).addAll(Arrays.asList("B", "C", "D", "E", "F", "proxy-F", "L"));
        shouldNotSee.put("B", new HashSet());
        ((Set)shouldNotSee.get("B")).addAll(Arrays.asList("F", "proxy-F", "L"));
        shouldNotSee.put("C", new HashSet());
        ((Set)shouldNotSee.get("C")).addAll(Arrays.asList("E", "F", "proxy-F", "L"));
        shouldNotSee.put("D", new HashSet());
        ((Set)shouldNotSee.get("D")).addAll(Arrays.asList("E", "F", "proxy-F", "L"));
        shouldNotSee.put("E", new HashSet());
        ((Set)shouldNotSee.get("E")).addAll(Arrays.asList("F", "proxy-F", "L"));
        shouldNotSee.put("F", new HashSet());
        ((Set)shouldNotSee.get("F")).addAll(Arrays.asList("proxy-F", "L"));
        shouldNotSee.put("M", new HashSet());
        ((Set)shouldNotSee.get("M")).addAll(Arrays.asList("N", "O", "P", "Q", "R", "proxy-F", "L"));
        shouldNotSee.put("N", new HashSet());
        ((Set)shouldNotSee.get("N")).addAll(Arrays.asList("R", "proxy-F", "L"));
        shouldNotSee.put("O", new HashSet());
        ((Set)shouldNotSee.get("O")).addAll(Arrays.asList("Q", "R", "L"));
        shouldNotSee.put("P", new HashSet());
        ((Set)shouldNotSee.get("P")).addAll(Arrays.asList("Q", "R", "proxy-F", "L"));
        shouldNotSee.put("Q", new HashSet());
        ((Set)shouldNotSee.get("Q")).addAll(Arrays.asList("R", "proxy-F", "L"));
        shouldNotSee.put("R", new HashSet());
        ((Set)shouldNotSee.get("R")).addAll(Arrays.asList("proxy-F", "L"));
        shouldNotSee.put("S", new HashSet());
        ((Set)shouldNotSee.get("S")).addAll(Arrays.asList("T", "U", "V", "W", "X", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("T", new HashSet());
        ((Set)shouldNotSee.get("T")).addAll(Arrays.asList("X", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("U", new HashSet());
        ((Set)shouldNotSee.get("U")).addAll(Arrays.asList("W", "X", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("V", new HashSet());
        ((Set)shouldNotSee.get("V")).addAll(Arrays.asList("W", "X", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("W", new HashSet());
        ((Set)shouldNotSee.get("W")).addAll(Arrays.asList("X", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("X", new HashSet());
        ((Set)shouldNotSee.get("X")).addAll(Arrays.asList("proxy-X", "proxy-F", "L"));
        shouldNotSee.put("1", new HashSet());
        ((Set)shouldNotSee.get("1")).addAll(Arrays.asList("2", "3", "4", "5", "6", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("2", new HashSet());
        ((Set)shouldNotSee.get("2")).addAll(Arrays.asList("6", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("3", new HashSet());
        ((Set)shouldNotSee.get("3")).addAll(Arrays.asList("5", "6", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("4", new HashSet());
        ((Set)shouldNotSee.get("4")).addAll(Arrays.asList("5", "6", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("5", new HashSet());
        ((Set)shouldNotSee.get("5")).addAll(Arrays.asList("6", "proxy-X", "proxy-F", "L"));
        shouldNotSee.put("6", new HashSet());
        ((Set)shouldNotSee.get("6")).addAll(Arrays.asList("proxy-X", "proxy-F", "L"));
        shouldNotSee.put("G", new HashSet());
        ((Set)shouldNotSee.get("G")).addAll(Arrays.asList("H", "I", "J", "K", "L"));
        shouldNotSee.put("H", new HashSet());
        ((Set)shouldNotSee.get("H")).addAll(Arrays.asList("L"));
        shouldNotSee.put("I", new HashSet());
        ((Set)shouldNotSee.get("I")).addAll(Arrays.asList("K", "L"));
        shouldNotSee.put("J", new HashSet());
        ((Set)shouldNotSee.get("J")).addAll(Arrays.asList("K", "L"));
        shouldNotSee.put("K", new HashSet());
        ((Set)shouldNotSee.get("K")).addAll(Arrays.asList("L"));
        shouldNotSee.put("L", new HashSet());
        ((Set)shouldNotSee.get("L")).addAll(Arrays.asList(new String[0]));
        shouldNotSee.put("proxy-F", new HashSet());
        ((Set)shouldNotSee.get("proxy-F")).addAll(Arrays.asList("L"));
        shouldNotSee.put("proxy-X", new HashSet());
        ((Set)shouldNotSee.get("proxy-X")).addAll(Arrays.asList("proxy-F", "L"));
        HashSet<String> seen = new HashSet<String>();
        TaskGroup group1Proxy = group1.proxyTaskGroupWrapper.taskGroup();
        group1Proxy.prepareForEnumeration();
        TaskGroupEntry entry = (TaskGroupEntry)group1Proxy.getNext();
        while (entry != null) {
            Assert.assertTrue((boolean)shouldNotSee.containsKey(entry.key()));
            Assert.assertFalse((boolean)seen.contains(entry.key()));
            Sets.SetView common2 = Sets.intersection((Set)((Set)shouldNotSee.get(entry.key())), seen);
            if (common2.size() > 0) {
                Assert.assertTrue((String)("The entries " + common2 + " must be emitted before " + entry.key()), (boolean)false);
            }
            seen.add(entry.key());
            group1Proxy.reportCompletion((DAGNode)entry);
            entry = (TaskGroupEntry)group1Proxy.getNext();
        }
        Assert.assertEquals((long)26L, (long)seen.size());
        HashSet<String> expectedToSee = new HashSet<String>();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "proxy-X", "1", "proxy-F", "2", "3", "4", "5", "6"));
        Sets.SetView diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
        seen.clear();
        TaskGroup group4Proxy = group4.proxyTaskGroupWrapper.taskGroup();
        group4Proxy.prepareForEnumeration();
        TaskGroupEntry entry2 = (TaskGroupEntry)group4Proxy.getNext();
        while (entry2 != null) {
            Assert.assertTrue((boolean)shouldNotSee.containsKey(entry2.key()));
            Assert.assertFalse((boolean)seen.contains(entry2.key()));
            common = Sets.intersection((Set)((Set)shouldNotSee.get(entry2.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry2.key()), (boolean)false);
            }
            seen.add(entry2.key());
            group4Proxy.reportCompletion((DAGNode)entry2);
            entry2 = (TaskGroupEntry)group4Proxy.getNext();
        }
        Assert.assertEquals((long)19L, (long)seen.size());
        expectedToSee.clear();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F", "S", "T", "U", "V", "W", "X", "proxy-X", "1", "2", "3", "4", "5", "6"));
        diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
        seen.clear();
        group2.prepareForEnumeration();
        entry2 = (TaskGroupEntry)group2.getNext();
        while (entry2 != null) {
            Assert.assertTrue((boolean)shouldNotSee.containsKey(entry2.key()));
            Assert.assertFalse((boolean)seen.contains(entry2.key()));
            common = Sets.intersection((Set)((Set)shouldNotSee.get(entry2.key())), seen);
            if (common.size() > 0) {
                Assert.assertTrue((String)("The entries " + common + " must be emitted before " + entry2.key()), (boolean)false);
            }
            seen.add(entry2.key());
            group2.reportCompletion((DAGNode)entry2);
            entry2 = (TaskGroupEntry)group2.getNext();
        }
        expectedToSee.clear();
        expectedToSee.addAll(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "proxy-X", "1", "proxy-F", "2", "3", "4", "5", "6"));
        diff = Sets.difference(seen, expectedToSee);
        Assert.assertEquals((long)0L, (long)diff.size());
    }

    @Test
    public void canHandleDependenciesAndPostRunDependentsInBeforeGroupInvoke() {
        final IndexableTaskItem itiA = new IndexableTaskItem("A"){

            protected Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                return this.voidObservable();
            }
        };
        final int[] beforeGroupInvokeCntB = new int[1];
        final IndexableTaskItem itiB = new IndexableTaskItem("B"){

            public void beforeGroupInvoke() {
                beforeGroupInvokeCntB[0] = beforeGroupInvokeCntB[0] + 1;
                this.addDependency((TaskGroup.HasTaskGroup)itiA);
            }

            protected Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                return this.voidObservable();
            }
        };
        final int[] beforeGroupInvokeCntC = new int[1];
        IndexableTaskItem itiC = new IndexableTaskItem("C"){

            public void beforeGroupInvoke() {
                beforeGroupInvokeCntC[0] = beforeGroupInvokeCntC[0] + 1;
                this.addPostRunDependent((TaskGroup.HasTaskGroup)itiB);
            }

            protected Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                return this.voidObservable();
            }
        };
        final ArrayList seen = new ArrayList();
        itiC.taskGroup().invokeAsync(itiC.taskGroup().newInvocationContext()).toBlocking().subscribe((Action1)new Action1<Indexable>(){

            public void call(Indexable indexable) {
                seen.add(indexable.key());
            }
        });
        boolean b1 = seen.equals(new ArrayList<String>(Arrays.asList("A", "C", "B", "C")));
        boolean b2 = seen.equals(new ArrayList<String>(Arrays.asList("C", "A", "B", "C")));
        if (!b1 && !b2) {
            Assert.assertTrue((String)("Emission order should be either [A, C, B, C] or [C, A, B, C] but got " + seen), (boolean)false);
        }
        Assert.assertEquals((long)beforeGroupInvokeCntB[0], (long)1L);
        Assert.assertEquals((long)beforeGroupInvokeCntC[0], (long)1L);
        final IndexableTaskItem itiD = new IndexableTaskItem("D"){

            protected Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                return this.voidObservable();
            }
        };
        final int[] beforeGroupInvokeCntE = new int[1];
        final IndexableTaskItem itiE = new IndexableTaskItem("E"){

            public void beforeGroupInvoke() {
                beforeGroupInvokeCntE[0] = beforeGroupInvokeCntE[0] + 1;
                this.addPostRunDependent((TaskGroup.HasTaskGroup)itiD);
            }

            protected Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                return this.voidObservable();
            }
        };
        final int[] beforeGroupInvokeCntF = new int[1];
        IndexableTaskItem itiF = new IndexableTaskItem("F"){

            public void beforeGroupInvoke() {
                beforeGroupInvokeCntF[0] = beforeGroupInvokeCntF[0] + 1;
                this.addDependency((TaskGroup.HasTaskGroup)itiE);
            }

            protected Observable<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                return this.voidObservable();
            }
        };
        seen.clear();
        itiF.taskGroup().invokeAsync(itiC.taskGroup().newInvocationContext()).toBlocking().subscribe((Action1)new Action1<Indexable>(){

            public void call(Indexable indexable) {
                seen.add(indexable.key());
            }
        });
        b1 = seen.equals(new ArrayList<String>(Arrays.asList("E", "D", "E", "F")));
        Assert.assertTrue((String)("Emission order should be [E, D, E, F] but got " + seen), (boolean)b1);
        Assert.assertEquals((long)beforeGroupInvokeCntE[0], (long)1L);
        Assert.assertEquals((long)beforeGroupInvokeCntF[0], (long)1L);
    }

    private TaskGroup createSampleTaskGroup(String vertex1, String vertex2, String vertex3, String vertex4, String vertex5, String vertex6, List<String> verticesNames) {
        verticesNames.add(vertex6);
        verticesNames.add(vertex5);
        verticesNames.add(vertex4);
        verticesNames.add(vertex3);
        verticesNames.add(vertex2);
        verticesNames.add(vertex1);
        TaskGroup group1 = new TaskGroup(vertex1, (TaskItem)new StringTaskItem(vertex1));
        TaskGroup group2 = new TaskGroup(vertex2, (TaskItem)new StringTaskItem(vertex2));
        TaskGroup group3 = new TaskGroup(vertex3, (TaskItem)new StringTaskItem(vertex3));
        TaskGroup group4 = new TaskGroup(vertex4, (TaskItem)new StringTaskItem(vertex4));
        TaskGroup group5 = new TaskGroup(vertex5, (TaskItem)new StringTaskItem(vertex5));
        TaskGroup group6 = new TaskGroup(vertex6, (TaskItem)new StringTaskItem(vertex6));
        group2.addDependencyTaskGroup(group1);
        group3.addDependencyTaskGroup(group1);
        group4.addDependencyTaskGroup(group1);
        group5.addDependencyTaskGroup(group3);
        group5.addDependencyTaskGroup(group4);
        group6.addDependencyTaskGroup(group2);
        group6.addDependencyTaskGroup(group5);
        return group6;
    }

    private StringIndexable toStringIndexable(Indexable indexable) {
        return (StringIndexable)indexable;
    }

    private static class StringIndexable
    implements Indexable {
        private final String str;

        StringIndexable(String str) {
            this.str = str;
        }

        public String str() {
            return this.str;
        }

        public String key() {
            return this.str;
        }
    }

    private static class StringTaskItem
    implements TaskItem {
        private final String name;
        private StringIndexable producedValue = null;

        StringTaskItem(String name) {
            this.name = name;
        }

        public Indexable result() {
            return this.producedValue;
        }

        public void beforeGroupInvoke() {
        }

        public boolean isHot() {
            return false;
        }

        public Observable<Indexable> invokeAsync(TaskGroup.InvocationContext context) {
            this.producedValue = new StringIndexable(this.name);
            return Observable.just((Object)this.producedValue).map((Func1)new Func1<StringIndexable, Indexable>(){

                public Indexable call(StringIndexable stringIndexable) {
                    return stringIndexable;
                }
            });
        }

        public Completable invokeAfterPostRunAsync(boolean isGroupFaulted) {
            return Completable.complete();
        }
    }
}

