/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.resources.collection.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.arm.model.HasInner;
import com.microsoft.azure.arm.resources.ResourceId;
import com.microsoft.azure.arm.resources.ResourceUtilsCore;
import com.microsoft.azure.arm.resources.collection.SupportsDeletingByResourceGroup;
import com.microsoft.azure.arm.resources.collection.SupportsGettingById;
import com.microsoft.azure.arm.resources.collection.SupportsGettingByResourceGroup;
import com.microsoft.azure.arm.resources.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.arm.resources.implementation.ManagerBaseCore;
import com.microsoft.azure.arm.resources.models.GroupableResourceCore;
import com.microsoft.azure.arm.resources.models.HasManager;
import com.microsoft.azure.arm.utils.SdkContext;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public abstract class GroupableResourcesCoreImpl<T extends GroupableResourceCore<ManagerT, InnerT>, ImplT extends T, InnerT extends Resource, InnerCollectionT, ManagerT extends ManagerBaseCore>
extends CreatableResourcesImpl<T, ImplT, InnerT>
implements SupportsGettingById<T>,
SupportsGettingByResourceGroup<T>,
SupportsDeletingByResourceGroup,
HasManager<ManagerT>,
HasInner<InnerCollectionT> {
    private final InnerCollectionT innerCollection;
    private final ManagerT myManager;

    protected GroupableResourcesCoreImpl(InnerCollectionT innerCollection, ManagerT manager) {
        this.innerCollection = innerCollection;
        this.myManager = manager;
    }

    @Override
    public InnerCollectionT inner() {
        return this.innerCollection;
    }

    @Override
    public ManagerT manager() {
        return this.myManager;
    }

    @Override
    public T getById(String id) {
        return (T)((GroupableResourceCore)this.getByIdAsync(id).toBlocking().last());
    }

    @Override
    public final Observable<T> getByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString(id);
        if (resourceId == null) {
            return null;
        }
        return this.getByResourceGroupAsync(resourceId.resourceGroupName(), resourceId.name());
    }

    @Override
    public final ServiceFuture<T> getByIdAsync(String id, ServiceCallback<T> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    @Override
    public final void deleteByResourceGroup(String groupName, String name) {
        this.deleteByResourceGroupAsync(groupName, name).await();
    }

    @Override
    public final ServiceFuture<Void> deleteByResourceGroupAsync(String groupName, String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.deleteByResourceGroupAsync(groupName, name).andThen(Observable.just(null)), callback);
    }

    @Override
    public Completable deleteByResourceGroupAsync(String groupName, String name) {
        return this.deleteInnerAsync(groupName, name).subscribeOn(SdkContext.getRxScheduler());
    }

    @Override
    public Completable deleteByIdAsync(String id) {
        return this.deleteByResourceGroupAsync(ResourceUtilsCore.groupFromResourceId(id), ResourceUtilsCore.nameFromResourceId(id));
    }

    @Override
    public T getByResourceGroup(String resourceGroupName, String name) {
        return (T)((GroupableResourceCore)this.getByResourceGroupAsync(resourceGroupName, name).toBlocking().last());
    }

    @Override
    public Observable<T> getByResourceGroupAsync(String resourceGroupName, String name) {
        return this.getInnerAsync(resourceGroupName, name).map(new Func1<InnerT, T>(){

            public T call(InnerT innerT) {
                return (GroupableResourceCore)GroupableResourcesCoreImpl.this.wrapModel(innerT);
            }
        });
    }

    @Override
    public ServiceFuture<T> getByResourceGroupAsync(String resourceGroupName, String name, ServiceCallback<T> callback) {
        return ServiceFuture.fromBody(this.getByResourceGroupAsync(resourceGroupName, name), callback);
    }

    protected abstract Observable<InnerT> getInnerAsync(String var1, String var2);

    protected abstract Completable deleteInnerAsync(String var1, String var2);
}

