/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.resources.models.implementation;

import com.microsoft.azure.arm.model.HasInner;
import com.microsoft.azure.arm.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.arm.resources.Region;
import com.microsoft.azure.arm.resources.models.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class ResourceImpl<FluentModelT extends Resource, InnerModelT extends com.microsoft.azure.Resource, FluentModelImplT extends ResourceImpl<FluentModelT, InnerModelT, FluentModelImplT>>
extends CreatableUpdatableImpl<FluentModelT, InnerModelT, FluentModelImplT>
implements Resource {
    protected ResourceImpl(String name, InnerModelT innerObject) {
        super(name, innerObject);
        if (innerObject.getTags() == null) {
            innerObject.withTags(new TreeMap());
        }
    }

    @Override
    public String regionName() {
        return ((com.microsoft.azure.Resource)this.inner()).location();
    }

    @Override
    public Region region() {
        return Region.fromName(this.regionName());
    }

    @Override
    public Map<String, String> tags() {
        TreeMap tags = ((com.microsoft.azure.Resource)this.inner()).getTags();
        if (tags == null) {
            tags = new TreeMap();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public String id() {
        return ((com.microsoft.azure.Resource)this.inner()).id();
    }

    @Override
    public String type() {
        return ((com.microsoft.azure.Resource)this.inner()).type();
    }

    @Override
    public String name() {
        if (((com.microsoft.azure.Resource)this.inner()).name() == null) {
            return super.name();
        }
        return ((com.microsoft.azure.Resource)this.inner()).name();
    }

    public final FluentModelImplT withTags(Map<String, String> tags) {
        ((com.microsoft.azure.Resource)this.inner()).withTags(new HashMap<String, String>(tags));
        return (FluentModelImplT)this;
    }

    public final FluentModelImplT withTag(String key, String value) {
        if (((com.microsoft.azure.Resource)this.inner()).getTags() == null) {
            ((com.microsoft.azure.Resource)this.inner()).withTags(new HashMap());
        }
        ((com.microsoft.azure.Resource)this.inner()).getTags().put(key, value);
        return (FluentModelImplT)this;
    }

    public final FluentModelImplT withoutTag(String key) {
        if (((com.microsoft.azure.Resource)this.inner()).getTags() != null) {
            ((com.microsoft.azure.Resource)this.inner()).getTags().remove(key);
        }
        return (FluentModelImplT)this;
    }

    public final FluentModelImplT withRegion(String regionName) {
        ((com.microsoft.azure.Resource)this.inner()).withLocation(regionName);
        return (FluentModelImplT)this;
    }

    public final FluentModelImplT withRegion(Region region) {
        return this.withRegion(region.toString());
    }

    @Override
    public boolean isInCreateMode() {
        return ((com.microsoft.azure.Resource)this.inner()).id() == null;
    }

    protected <InnerT> List<InnerT> innersFromWrappers(Collection<? extends HasInner<InnerT>> wrappers) {
        return this.innersFromWrappers(wrappers, null);
    }

    protected <InnerT> List<InnerT> innersFromWrappers(Collection<? extends HasInner<InnerT>> wrappers, List<InnerT> inners) {
        if (wrappers == null || wrappers.size() == 0) {
            return inners;
        }
        if (inners == null) {
            inners = new ArrayList<InnerT>();
        }
        for (HasInner<InnerT> wrapper : wrappers) {
            inners.add(wrapper.inner());
        }
        return inners;
    }
}

