/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.arm.resources.collection.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.arm.resources.collection.implementation.PageImpl;
import com.microsoft.azure.arm.utils.PagedListConverter;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

public abstract class ReadableWrappersImpl<T, ImplT extends T, InnerT> {
    private final PagedListConverter<InnerT, T> converter = new PagedListConverter<InnerT, T>(){

        @Override
        public Observable<T> typeConvertAsync(InnerT inner) {
            return Observable.just(ReadableWrappersImpl.this.wrapModel(inner));
        }
    };

    protected ReadableWrappersImpl() {
    }

    protected abstract ImplT wrapModel(InnerT var1);

    protected PagedList<T> wrapList(PagedList<InnerT> pagedList) {
        return this.converter.convert(pagedList);
    }

    protected PagedList<T> wrapList(List<InnerT> list) {
        return this.wrapList(ReadableWrappersImpl.convertToPagedList(list));
    }

    public static <InnerT> PagedList<InnerT> convertToPagedList(List<InnerT> list) {
        PageImpl<InnerT> page = new PageImpl<InnerT>();
        page.setItems(list);
        page.setNextPageLink(null);
        return new PagedList<InnerT>(page){

            public Page<InnerT> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    protected Observable<T> wrapPageAsync(Observable<Page<InnerT>> innerPage) {
        return this.wrapModelAsync(ReadableWrappersImpl.convertPageToInnerAsync(innerPage));
    }

    protected Observable<T> wrapListAsync(Observable<List<InnerT>> innerList) {
        return this.wrapModelAsync(ReadableWrappersImpl.convertListToInnerAsync(innerList));
    }

    public static <InnerT> Observable<InnerT> convertListToInnerAsync(Observable<List<InnerT>> innerList) {
        return innerList.flatMap(new Func1<List<InnerT>, Observable<InnerT>>(){

            public Observable<InnerT> call(List<InnerT> inners) {
                return Observable.from(inners);
            }
        });
    }

    public static <InnerT> Observable<InnerT> convertPageToInnerAsync(Observable<Page<InnerT>> innerPage) {
        return innerPage.flatMap(new Func1<Page<InnerT>, Observable<InnerT>>(){

            public Observable<InnerT> call(Page<InnerT> pageInner) {
                return Observable.from((Iterable)pageInner.items());
            }
        });
    }

    private Observable<T> wrapModelAsync(Observable<InnerT> inner) {
        return inner.map(new Func1<InnerT, T>(){

            public T call(InnerT inner) {
                return ReadableWrappersImpl.this.wrapModel(inner);
            }
        });
    }
}

