/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.auth.configuration.AuthMethod;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.ArrayUtils;

public class AzureTokenWrapper
extends AzureTokenCredentials {
    private static final String TEMPLATE = "Auth Type : %s";
    private static final String TEMPLATE_WITH_FILE = "Auth Type : %s, Auth Files : [%s]";
    private AuthMethod authMethod;
    private File[] authFileLocation;
    private AzureTokenCredentials azureTokenCredentials;

    public AzureTokenWrapper(AuthMethod authMethod, AzureTokenCredentials credentials) {
        super(credentials.environment(), credentials.domain());
        this.authMethod = authMethod;
        this.azureTokenCredentials = credentials;
    }

    public AzureTokenWrapper(AuthMethod authMethod, AzureTokenCredentials credentials, File ... authFileLocation) {
        this(authMethod, credentials);
        this.authFileLocation = authFileLocation;
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public AzureTokenCredentials getAzureTokenCredentials() {
        return this.azureTokenCredentials;
    }

    public File[] getAuthFileLocation() {
        return this.authFileLocation;
    }

    public String getCredentialDescription() {
        if (ArrayUtils.isEmpty((Object[])this.authFileLocation)) {
            return String.format(TEMPLATE, new Object[]{this.authMethod.getAuthType()});
        }
        String authFiles = Arrays.stream(this.authFileLocation).map(file -> file.getAbsolutePath()).collect(Collectors.joining(", "));
        return String.format(TEMPLATE_WITH_FILE, new Object[]{this.authMethod.getAuthType(), authFiles});
    }

    public String getToken(String s) throws IOException {
        return this.azureTokenCredentials.getToken(s);
    }

    public String domain() {
        return this.azureTokenCredentials.domain();
    }

    public AzureEnvironment environment() {
        return this.azureTokenCredentials.environment();
    }

    public String defaultSubscriptionId() {
        return this.azureTokenCredentials.defaultSubscriptionId();
    }

    public AzureTokenCredentials withDefaultSubscriptionId(String subscriptionId) {
        return this.azureTokenCredentials.withDefaultSubscriptionId(subscriptionId);
    }

    public Proxy proxy() {
        return this.azureTokenCredentials.proxy();
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.azureTokenCredentials.sslSocketFactory();
    }

    public AzureTokenCredentials withProxy(Proxy proxy) {
        return this.azureTokenCredentials.withProxy(proxy);
    }

    public AzureTokenCredentials withSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        return this.azureTokenCredentials.withSslSocketFactory(sslSocketFactory);
    }

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        this.azureTokenCredentials.applyCredentialsFilter(clientBuilder);
    }
}

