/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.microsoft.azure.auth.configuration.AuthConfiguration;
import com.microsoft.azure.auth.exception.MavenDecryptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenSettingHelper {
    public static AuthConfiguration getAuthConfigurationFromServer(MavenSession session, SettingsDecrypter settingsDecrypter, String serverId) throws MavenDecryptException {
        if (StringUtils.isBlank((CharSequence)serverId)) {
            throw new IllegalArgumentException("Parameter 'serverId' cannot be null or empty.");
        }
        Server server = session.getSettings().getServer(serverId);
        if (server == null) {
            return null;
        }
        AuthConfiguration configurationFromServer = new AuthConfiguration();
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        if (configuration == null) {
            return configurationFromServer;
        }
        configurationFromServer.setTenant(MavenSettingHelper.getConfiguration(configuration, "tenant"));
        configurationFromServer.setClient(MavenSettingHelper.getConfiguration(configuration, "client"));
        String rawKey = MavenSettingHelper.getConfiguration(configuration, "key");
        configurationFromServer.setKey(MavenSettingHelper.isValueEncrypted(rawKey) ? MavenSettingHelper.decryptMavenProtectedValue(settingsDecrypter, "key", rawKey) : rawKey);
        configurationFromServer.setCertificate(MavenSettingHelper.getConfiguration(configuration, "certificate"));
        String rawCertificatePassword = MavenSettingHelper.getConfiguration(configuration, "certificatePassword");
        configurationFromServer.setCertificatePassword(MavenSettingHelper.isValueEncrypted(rawCertificatePassword) ? MavenSettingHelper.decryptMavenProtectedValue(settingsDecrypter, "certificatePassword", rawCertificatePassword) : rawCertificatePassword);
        configurationFromServer.setEnvironment(MavenSettingHelper.getConfiguration(configuration, "environment"));
        configurationFromServer.setHttpProxyHost(MavenSettingHelper.getConfiguration(configuration, "httpProxyHost"));
        configurationFromServer.setHttpProxyPort(MavenSettingHelper.getConfiguration(configuration, "httpProxyPort"));
        configurationFromServer.setServerId(serverId);
        return configurationFromServer;
    }

    private static String getConfiguration(Xpp3Dom configuration, String property) {
        Xpp3Dom node = configuration.getChild(property);
        return node == null ? null : node.getValue();
    }

    private static boolean isValueEncrypted(String value) {
        return value != null && value.startsWith("{") && value.endsWith("}");
    }

    private static String decryptMavenProtectedValue(SettingsDecrypter settingsDecrypter, String propertyName, String value) throws MavenDecryptException {
        Server server = new Server();
        server.setPassword(value);
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
        for (SettingsProblem problem : result.getProblems()) {
            if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
            throw new MavenDecryptException(propertyName, value, "Unable to decrypt value(" + value + ") from settings.xml: " + problem);
        }
        return result.getServer().getPassword();
    }

    private MavenSettingHelper() {
    }
}

