/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.auth.AzureCredential;
import com.microsoft.azure.auth.AzureLoginHelper;
import com.microsoft.azure.auth.AzureServicePrincipleAuthHelper;
import com.microsoft.azure.auth.AzureTokenWrapper;
import com.microsoft.azure.auth.configuration.AuthConfiguration;
import com.microsoft.azure.auth.configuration.AuthMethod;
import com.microsoft.azure.auth.configuration.AuthType;
import com.microsoft.azure.auth.exception.AzureLoginFailureException;
import com.microsoft.azure.common.utils.JsonUtils;
import com.microsoft.azure.credentials.AzureCliCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.MSICredentials;
import com.microsoft.azure.tools.exception.DesktopNotSupportedException;
import com.microsoft.azure.tools.exception.InvalidConfigurationException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.Jwts;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class AzureAuthHelper {
    private static final String UNKNOWN = "UNKNOWN";
    private static final AuthType[] AUTH_ORDER = new AuthType[]{AuthType.SERVICE_PRINCIPAL, AuthType.AZURE_SECRET_FILE, AuthType.AZURE_CLI, AuthType.AZURE_AUTH_MAVEN_PLUGIN};
    private static final Map<AzureEnvironment, String> AZURE_ENVIRONMENT_DISPLAY_NAME_MAP = new HashMap<AzureEnvironment, String>();

    public static AzureCredential oAuthLogin(AzureEnvironment env) throws AzureLoginFailureException, DesktopNotSupportedException, InterruptedException, ExecutionException {
        return AzureLoginHelper.oAuthLogin(env);
    }

    public static AzureCredential deviceLogin(AzureEnvironment env) throws AzureLoginFailureException, MalformedURLException, InterruptedException, ExecutionException {
        return AzureLoginHelper.deviceLogin(env);
    }

    public static AzureCredential refreshToken(AzureEnvironment env, String refreshToken) throws MalformedURLException, InterruptedException, ExecutionException {
        return AzureLoginHelper.refreshToken(env, refreshToken);
    }

    public static AzureEnvironment getAzureEnvironment(String environment) {
        if (StringUtils.isEmpty((CharSequence)environment)) {
            return AzureEnvironment.AZURE;
        }
        switch (environment.toUpperCase(Locale.ENGLISH)) {
            case "AZURE_CHINA": 
            case "AZURECHINACLOUD": {
                return AzureEnvironment.AZURE_CHINA;
            }
            case "AZURE_GERMANY": 
            case "AZUREGERMANCLOUD": {
                return AzureEnvironment.AZURE_GERMANY;
            }
            case "AZURE_US_GOVERNMENT": 
            case "AZUREUSGOVERNMENT": {
                return AzureEnvironment.AZURE_US_GOVERNMENT;
            }
        }
        return AzureEnvironment.AZURE;
    }

    public static String getAzureEnvironmentDisplayName(AzureEnvironment azureEnvironment) {
        return AZURE_ENVIRONMENT_DISPLAY_NAME_MAP.containsKey(azureEnvironment) ? AZURE_ENVIRONMENT_DISPLAY_NAME_MAP.get(azureEnvironment) : UNKNOWN;
    }

    public static boolean validateEnvironment(String environment) {
        if (StringUtils.isBlank((CharSequence)environment)) {
            return true;
        }
        switch (environment.toUpperCase(Locale.ENGLISH)) {
            case "AZURE_CHINA": 
            case "AZURECHINACLOUD": 
            case "AZURE_GERMANY": 
            case "AZUREGERMANCLOUD": 
            case "AZURE_US_GOVERNMENT": 
            case "AZUREUSGOVERNMENT": 
            case "AZURE": 
            case "AZURE_CLOUD": {
                return true;
            }
        }
        return false;
    }

    public static File getAzureSecretFile() {
        return new File(AzureAuthHelper.getAzureConfigFolder(), "azure-secret.json");
    }

    public static File getAzureConfigFolder() {
        return StringUtils.isNotBlank((CharSequence)System.getenv("AZURE_CONFIG_DIR")) ? new File(System.getenv("AZURE_CONFIG_DIR")) : Paths.get(System.getProperty("user.home"), ".azure").toFile();
    }

    public static boolean existsAzureSecretFile() {
        File azureSecretFile = AzureAuthHelper.getAzureSecretFile();
        return azureSecretFile.exists() && azureSecretFile.isFile() && azureSecretFile.length() > 0L;
    }

    public static boolean deleteAzureSecretFile() {
        if (AzureAuthHelper.existsAzureSecretFile()) {
            return FileUtils.deleteQuietly((File)AzureAuthHelper.getAzureSecretFile());
        }
        return false;
    }

    public static void writeAzureCredentials(AzureCredential cred, File file) throws IOException {
        if (cred == null) {
            throw new IllegalArgumentException("Parameter 'cred' cannot be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' cannot be null.");
        }
        FileUtils.writeStringToFile((File)file, (String)JsonUtils.toJson((Object)cred), (String)"utf8");
    }

    public static AzureCredential readAzureCredentials() throws IOException {
        return AzureAuthHelper.readAzureCredentials(AzureAuthHelper.getAzureSecretFile());
    }

    public static AzureCredential readAzureCredentials(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' cannot be null.");
        }
        String jsonStr = FileUtils.readFileToString((File)file, (String)"utf8");
        return (AzureCredential)JsonUtils.fromJson((String)jsonStr, AzureCredential.class);
    }

    public static AzureTokenCredentials getMavenAzureLoginCredentials() throws IOException {
        AzureCredential credentials = AzureAuthHelper.readAzureCredentials(AzureAuthHelper.getAzureSecretFile());
        AzureEnvironment env = AzureAuthHelper.getAzureEnvironment(credentials.getEnvironment());
        return AzureAuthHelper.getMavenAzureLoginCredentials(credentials, env);
    }

    public static AzureTokenCredentials getMavenAzureLoginCredentials(final AzureCredential credentials, final AzureEnvironment env) {
        AzureTokenCredentials azureTokenCredentials = new AzureTokenCredentials(env, null){

            public String getToken(String resource) throws IOException {
                String accessToken = credentials.getAccessToken();
                String accessTokenWithoutSignature = accessToken.substring(0, accessToken.lastIndexOf(46) + 1);
                try {
                    Jwt jwtToken = Jwts.parser().parseClaimsJwt(accessTokenWithoutSignature);
                    if (((Claims)jwtToken.getBody()).getExpiration().after(DateUtils.addMinutes((Date)new Date(), (int)1))) {
                        return accessToken;
                    }
                }
                catch (ExpiredJwtException jwtToken) {
                    // empty catch block
                }
                try {
                    AzureCredential newCredentials = AzureAuthHelper.refreshToken(env, credentials.getRefreshToken());
                    credentials.setAccessToken(newCredentials.getAccessToken());
                    AzureAuthHelper.writeAzureCredentials(credentials, AzureAuthHelper.getAzureSecretFile());
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e.getCause() instanceof AuthenticationException) {
                        throw (AuthenticationException)e.getCause();
                    }
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new IOException(String.format("Error happened during refreshing access token, due to error: %s.", e.getMessage()));
                }
                return credentials.getAccessToken();
            }
        };
        if (StringUtils.isNotBlank((CharSequence)credentials.getDefaultSubscription())) {
            azureTokenCredentials.withDefaultSubscriptionId(credentials.getDefaultSubscription());
        }
        return azureTokenCredentials;
    }

    public static AzureTokenWrapper getAzureCLICredential(AzureEnvironment environment) throws IOException {
        if (AzureAuthHelper.isInCloudShell()) {
            return new AzureTokenWrapper(AuthMethod.CLOUD_SHELL, (AzureTokenCredentials)new MSICredentials(environment));
        }
        File credentialParent = AzureAuthHelper.getAzureConfigFolder();
        if (credentialParent.exists() && credentialParent.isDirectory()) {
            File azureProfile = new File(credentialParent, "azureProfile.json");
            File accessTokens = new File(credentialParent, "accessTokens.json");
            if (azureProfile.exists() && accessTokens.exists()) {
                List tokens = (List)JsonUtils.fromJson((String)FileUtils.readFileToString((File)accessTokens, (String)"utf8"), List.class);
                if (tokens.isEmpty()) {
                    return null;
                }
                Wrapper wrapper = (Wrapper)JsonUtils.fromJson((String)FileUtils.readFileToString((File)azureProfile, (String)"utf8"), Wrapper.class);
                if (wrapper.subscriptions == null || wrapper.subscriptions.isEmpty()) {
                    return null;
                }
                return new AzureTokenWrapper(AuthMethod.AZURE_CLI, (AzureTokenCredentials)AzureCliCredentials.create((File)azureProfile, (File)accessTokens), azureProfile, accessTokens);
            }
        }
        return null;
    }

    public static AzureTokenWrapper getServicePrincipalCredential(AuthConfiguration configuration) throws InvalidConfigurationException, IOException {
        return configuration == null ? null : new AzureTokenWrapper(AuthMethod.SERVICE_PRINCIPAL, AzureServicePrincipleAuthHelper.getAzureServicePrincipleCredentials(configuration));
    }

    public static AzureTokenWrapper getAzureMavenPluginCredential(AzureEnvironment environment) throws IOException, InterruptedException, ExecutionException, AzureLoginFailureException {
        if (AzureAuthHelper.existsAzureSecretFile()) {
            return new AzureTokenWrapper(AuthMethod.AZURE_SECRET_FILE, AzureAuthHelper.getMavenAzureLoginCredentials(), AzureAuthHelper.getAzureSecretFile());
        }
        AuthMethod authMethod = null;
        AzureCredential credential = null;
        try {
            authMethod = AuthMethod.OAUTH;
            credential = AzureAuthHelper.oAuthLogin(environment);
        }
        catch (AzureLoginFailureException | DesktopNotSupportedException | InterruptedException | ExecutionException e) {
            authMethod = AuthMethod.DEVICE_LOGIN;
            credential = AzureAuthHelper.deviceLogin(environment);
        }
        AzureAuthHelper.writeAzureCredentials(credential, AzureAuthHelper.getAzureSecretFile());
        return new AzureTokenWrapper(authMethod, AzureAuthHelper.getMavenAzureLoginCredentials(credential, environment));
    }

    public static AzureTokenWrapper getAzureSecretFileCredential() throws IOException {
        return AzureAuthHelper.existsAzureSecretFile() ? new AzureTokenWrapper(AuthMethod.AZURE_SECRET_FILE, AzureAuthHelper.getMavenAzureLoginCredentials(), AzureAuthHelper.getAzureSecretFile()) : null;
    }

    public static AzureTokenWrapper getAzureTokenCredentials(AuthConfiguration configuration) throws InvalidConfigurationException, IOException {
        if (configuration != null) {
            return new AzureTokenWrapper(AuthMethod.SERVICE_PRINCIPAL, AzureServicePrincipleAuthHelper.getAzureServicePrincipleCredentials(configuration));
        }
        if (AzureAuthHelper.existsAzureSecretFile()) {
            try {
                return new AzureTokenWrapper(AuthMethod.AZURE_SECRET_FILE, AzureAuthHelper.getMavenAzureLoginCredentials(), AzureAuthHelper.getAzureSecretFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (AzureAuthHelper.isInCloudShell()) {
            return new AzureTokenWrapper(AuthMethod.CLOUD_SHELL, (AzureTokenCredentials)new MSICredentials());
        }
        return AzureAuthHelper.getAzureCLICredential(AzureEnvironment.AZURE);
    }

    public static AzureTokenWrapper getAzureCredentialByOrder(AuthConfiguration authConfiguration, AzureEnvironment azureEnvironment) {
        AzureTokenWrapper result = null;
        for (AuthType authType : AUTH_ORDER) {
            try {
                result = authType.getAzureToken(authConfiguration, azureEnvironment);
                if (result == null) continue;
                break;
            }
            catch (AzureLoginFailureException e) {
                // empty catch block
            }
        }
        return result;
    }

    static boolean isInCloudShell() {
        return System.getenv("ACC_CLOUD") != null;
    }

    private AzureAuthHelper() {
    }

    static {
        AZURE_ENVIRONMENT_DISPLAY_NAME_MAP.put(AzureEnvironment.AZURE, "AZURE");
        AZURE_ENVIRONMENT_DISPLAY_NAME_MAP.put(AzureEnvironment.AZURE_CHINA, "AZURE_CHINA");
        AZURE_ENVIRONMENT_DISPLAY_NAME_MAP.put(AzureEnvironment.AZURE_GERMANY, "AZURE_GERMANY");
        AZURE_ENVIRONMENT_DISPLAY_NAME_MAP.put(AzureEnvironment.AZURE_US_GOVERNMENT, "AZURE_US_GOVERNMENT");
    }

    static class Wrapper {
        List<Map> subscriptions;

        Wrapper() {
        }
    }
}

