/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.BatchClient;
import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.BehaviorManager;
import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.IInheritedBehaviors;
import com.microsoft.azure.batch.InternalHelper;
import com.microsoft.azure.batch.protocol.models.ApplicationPackageReference;
import com.microsoft.azure.batch.protocol.models.AutoScaleRun;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.CertificateReference;
import com.microsoft.azure.batch.protocol.models.CloudPool;
import com.microsoft.azure.batch.protocol.models.CloudServiceConfiguration;
import com.microsoft.azure.batch.protocol.models.ComputeNode;
import com.microsoft.azure.batch.protocol.models.ComputeNodeDeallocationOption;
import com.microsoft.azure.batch.protocol.models.MetadataItem;
import com.microsoft.azure.batch.protocol.models.NodeRemoveParameter;
import com.microsoft.azure.batch.protocol.models.PoolAddOptions;
import com.microsoft.azure.batch.protocol.models.PoolAddParameter;
import com.microsoft.azure.batch.protocol.models.PoolDeleteOptions;
import com.microsoft.azure.batch.protocol.models.PoolDisableAutoScaleOptions;
import com.microsoft.azure.batch.protocol.models.PoolEnableAutoScaleOptions;
import com.microsoft.azure.batch.protocol.models.PoolEnableAutoScaleParameter;
import com.microsoft.azure.batch.protocol.models.PoolEvaluateAutoScaleOptions;
import com.microsoft.azure.batch.protocol.models.PoolExistsOptions;
import com.microsoft.azure.batch.protocol.models.PoolGetAllLifetimeStatisticsOptions;
import com.microsoft.azure.batch.protocol.models.PoolGetOptions;
import com.microsoft.azure.batch.protocol.models.PoolListOptions;
import com.microsoft.azure.batch.protocol.models.PoolListUsageMetricsOptions;
import com.microsoft.azure.batch.protocol.models.PoolPatchOptions;
import com.microsoft.azure.batch.protocol.models.PoolPatchParameter;
import com.microsoft.azure.batch.protocol.models.PoolRemoveNodesOptions;
import com.microsoft.azure.batch.protocol.models.PoolResizeOptions;
import com.microsoft.azure.batch.protocol.models.PoolResizeParameter;
import com.microsoft.azure.batch.protocol.models.PoolStatistics;
import com.microsoft.azure.batch.protocol.models.PoolStopResizeOptions;
import com.microsoft.azure.batch.protocol.models.PoolUpdatePropertiesOptions;
import com.microsoft.azure.batch.protocol.models.PoolUpdatePropertiesParameter;
import com.microsoft.azure.batch.protocol.models.PoolUsageMetrics;
import com.microsoft.azure.batch.protocol.models.StartTask;
import com.microsoft.azure.batch.protocol.models.VirtualMachineConfiguration;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class PoolOperations
implements IInheritedBehaviors {
    private Collection<BatchClientBehavior> customBehaviors;
    private final BatchClient parentBatchClient;

    PoolOperations(BatchClient batchClient, Collection<BatchClientBehavior> customBehaviors) {
        this.parentBatchClient = batchClient;
        InternalHelper.inheritClientBehaviorsAndSetPublicProperty(this, customBehaviors);
    }

    @Override
    public Collection<BatchClientBehavior> customBehaviors() {
        return this.customBehaviors;
    }

    @Override
    public IInheritedBehaviors withCustomBehaviors(Collection<BatchClientBehavior> behaviors) {
        this.customBehaviors = behaviors;
        return this;
    }

    public PagedList<CloudPool> listPools() throws BatchErrorException, IOException {
        return this.listPools(null, null);
    }

    public PagedList<CloudPool> listPools(DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listPools(detailLevel, null);
    }

    public PagedList<CloudPool> listPools(DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolListOptions options = new PoolListOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().pools().list(options);
    }

    public CloudPool getPool(String poolId) throws BatchErrorException, IOException {
        return this.getPool(poolId, null, null);
    }

    public CloudPool getPool(String poolId, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.getPool(poolId, detailLevel, null);
    }

    public CloudPool getPool(String poolId, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolGetOptions options = new PoolGetOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().pools().get(poolId, options);
    }

    public void deletePool(String poolId) throws BatchErrorException, IOException {
        this.deletePool(poolId, null);
    }

    public void deletePool(String poolId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolDeleteOptions options = new PoolDeleteOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().pools().delete(poolId, options);
    }

    public void createPool(String poolId, String virtualMachineSize, CloudServiceConfiguration cloudServiceConfiguration, int targetDedicatedNodes) throws BatchErrorException, IOException {
        this.createPool(poolId, virtualMachineSize, cloudServiceConfiguration, targetDedicatedNodes, 0, null);
    }

    public void createPool(String poolId, String virtualMachineSize, CloudServiceConfiguration cloudServiceConfiguration, int targetDedicatedNodes, int targetLowPriorityNodes) throws BatchErrorException, IOException {
        this.createPool(poolId, virtualMachineSize, cloudServiceConfiguration, targetDedicatedNodes, targetLowPriorityNodes, null);
    }

    public void createPool(String poolId, String virtualMachineSize, CloudServiceConfiguration cloudServiceConfiguration, int targetDedicatedNodes, int targetLowPriorityNodes, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolAddParameter parameter = new PoolAddParameter().withId(poolId).withCloudServiceConfiguration(cloudServiceConfiguration).withTargetDedicatedNodes(targetDedicatedNodes).withTargetLowPriorityNodes(targetLowPriorityNodes).withVmSize(virtualMachineSize);
        this.createPool(parameter, additionalBehaviors);
    }

    public void createPool(String poolId, String virtualMachineSize, VirtualMachineConfiguration virtualMachineConfiguration, int targetDedicatedNodes) throws BatchErrorException, IOException {
        this.createPool(poolId, virtualMachineSize, virtualMachineConfiguration, targetDedicatedNodes, 0, null);
    }

    public void createPool(String poolId, String virtualMachineSize, VirtualMachineConfiguration virtualMachineConfiguration, int targetDedicatedNodes, int targetLowPriorityNodes) throws BatchErrorException, IOException {
        this.createPool(poolId, virtualMachineSize, virtualMachineConfiguration, targetDedicatedNodes, targetLowPriorityNodes, null);
    }

    public void createPool(String poolId, String virtualMachineSize, VirtualMachineConfiguration virtualMachineConfiguration, int targetDedicatedNodes, int targetLowPriorityNodes, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolAddParameter parameter = new PoolAddParameter().withId(poolId).withVirtualMachineConfiguration(virtualMachineConfiguration).withTargetDedicatedNodes(targetDedicatedNodes).withTargetLowPriorityNodes(targetLowPriorityNodes).withVmSize(virtualMachineSize);
        this.createPool(parameter, additionalBehaviors);
    }

    public void createPool(PoolAddParameter pool) throws BatchErrorException, IOException {
        this.createPool(pool, null);
    }

    public void createPool(PoolAddParameter pool, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolAddOptions options = new PoolAddOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().pools().add(pool, options);
    }

    public void resizePool(String poolId, Integer targetDedicatedNodes, Integer targetLowPriorityNodes) throws BatchErrorException, IOException {
        this.resizePool(poolId, targetDedicatedNodes, targetLowPriorityNodes, null, null, null);
    }

    public void resizePool(String poolId, Integer targetDedicatedNodes, Integer targetLowPriorityNodes, Period resizeTimeout) throws BatchErrorException, IOException {
        this.resizePool(poolId, targetDedicatedNodes, targetLowPriorityNodes, resizeTimeout, null, null);
    }

    public void resizePool(String poolId, Integer targetDedicatedNodes, Integer targetLowPriorityNodes, Period resizeTimeout, ComputeNodeDeallocationOption deallocationOption) throws BatchErrorException, IOException {
        this.resizePool(poolId, targetDedicatedNodes, targetLowPriorityNodes, resizeTimeout, deallocationOption, null);
    }

    public void resizePool(String poolId, Integer targetDedicatedNodes, Integer targetLowPriorityNodes, Period resizeTimeout, ComputeNodeDeallocationOption deallocationOption, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolResizeOptions options = new PoolResizeOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        PoolResizeParameter param = new PoolResizeParameter().withResizeTimeout(resizeTimeout).withNodeDeallocationOption(deallocationOption).withTargetDedicatedNodes(targetDedicatedNodes).withTargetLowPriorityNodes(targetLowPriorityNodes);
        this.parentBatchClient.protocolLayer().pools().resize(poolId, param, options);
    }

    public void stopResizePool(String poolId) throws BatchErrorException, IOException {
        this.stopResizePool(poolId, null);
    }

    public void stopResizePool(String poolId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolStopResizeOptions options = new PoolStopResizeOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().pools().stopResize(poolId, options);
    }

    public void enableAutoScale(String poolId) throws BatchErrorException, IOException {
        this.enableAutoScale(poolId, null, null, null);
    }

    public void enableAutoScale(String poolId, String autoScaleFormula) throws BatchErrorException, IOException {
        this.enableAutoScale(poolId, autoScaleFormula, null, null);
    }

    public void enableAutoScale(String poolId, String autoScaleFormula, Period autoScaleEvaluationInterval) throws BatchErrorException, IOException {
        this.enableAutoScale(poolId, autoScaleFormula, autoScaleEvaluationInterval, null);
    }

    public void enableAutoScale(String poolId, String autoScaleFormula, Period autoScaleEvaluationInterval, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolEnableAutoScaleOptions options = new PoolEnableAutoScaleOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        PoolEnableAutoScaleParameter param = new PoolEnableAutoScaleParameter().withAutoScaleFormula(autoScaleFormula).withAutoScaleEvaluationInterval(autoScaleEvaluationInterval);
        this.parentBatchClient.protocolLayer().pools().enableAutoScale(poolId, param, options);
    }

    public void disableAutoScale(String poolId) throws BatchErrorException, IOException {
        this.disableAutoScale(poolId, null);
    }

    public void disableAutoScale(String poolId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolDisableAutoScaleOptions options = new PoolDisableAutoScaleOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().pools().disableAutoScale(poolId, options);
    }

    public AutoScaleRun evaluateAutoScale(String poolId, String autoScaleFormula) throws BatchErrorException, IOException {
        return this.evaluateAutoScale(poolId, autoScaleFormula, null);
    }

    public AutoScaleRun evaluateAutoScale(String poolId, String autoScaleFormula, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolEvaluateAutoScaleOptions options = new PoolEvaluateAutoScaleOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().pools().evaluateAutoScale(poolId, autoScaleFormula, options);
    }

    public void removeNodeFromPool(String poolId, String computeNodeId) throws BatchErrorException, IOException {
        this.removeNodeFromPool(poolId, computeNodeId, null, null, null);
    }

    public void removeNodeFromPool(String poolId, String computeNodeId, ComputeNodeDeallocationOption deallocationOption) throws BatchErrorException, IOException {
        this.removeNodeFromPool(poolId, computeNodeId, deallocationOption, null, null);
    }

    public void removeNodeFromPool(String poolId, String computeNodeId, ComputeNodeDeallocationOption deallocationOption, Period resizeTimeout, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        LinkedList<String> nodeIds = new LinkedList<String>();
        nodeIds.add(computeNodeId);
        this.removeNodesFromPool(poolId, (List<String>)nodeIds, deallocationOption, resizeTimeout, additionalBehaviors);
    }

    public void removeNodesFromPool(String poolId, Collection<ComputeNode> computeNodes) throws BatchErrorException, IOException {
        this.removeNodesFromPool(poolId, computeNodes, null, null, null);
    }

    public void removeNodesFromPool(String poolId, Collection<ComputeNode> computeNodes, ComputeNodeDeallocationOption deallocationOption) throws BatchErrorException, IOException {
        this.removeNodesFromPool(poolId, computeNodes, deallocationOption, null, null);
    }

    public void removeNodesFromPool(String poolId, Collection<ComputeNode> computeNodes, ComputeNodeDeallocationOption deallocationOption, Period resizeTimeout, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        LinkedList<String> nodeIds = new LinkedList<String>();
        for (ComputeNode node : computeNodes) {
            nodeIds.add(node.id());
        }
        this.removeNodesFromPool(poolId, (List<String>)nodeIds, deallocationOption, resizeTimeout, additionalBehaviors);
    }

    public void removeNodesFromPool(String poolId, List<String> computeNodeIds, ComputeNodeDeallocationOption deallocationOption, Period resizeTimeout, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolRemoveNodesOptions options = new PoolRemoveNodesOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        NodeRemoveParameter param = new NodeRemoveParameter().withNodeList(computeNodeIds).withNodeDeallocationOption(deallocationOption).withResizeTimeout(resizeTimeout);
        this.parentBatchClient.protocolLayer().pools().removeNodes(poolId, param, options);
    }

    public boolean existsPool(String poolId) throws BatchErrorException, IOException {
        return this.existsPool(poolId, null);
    }

    public boolean existsPool(String poolId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolExistsOptions options = new PoolExistsOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().pools().exists(poolId, options);
    }

    public void updatePoolProperties(String poolId, StartTask startTask, Collection<CertificateReference> certificateReferences, Collection<ApplicationPackageReference> applicationPackageReferences, Collection<MetadataItem> metadata) throws BatchErrorException, IOException {
        this.updatePoolProperties(poolId, startTask, certificateReferences, applicationPackageReferences, metadata, null);
    }

    public void updatePoolProperties(String poolId, StartTask startTask, Collection<CertificateReference> certificateReferences, Collection<ApplicationPackageReference> applicationPackageReferences, Collection<MetadataItem> metadata, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolUpdatePropertiesOptions options = new PoolUpdatePropertiesOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        PoolUpdatePropertiesParameter param = new PoolUpdatePropertiesParameter().withMetadata(metadata == null ? new LinkedList<MetadataItem>() : new LinkedList<MetadataItem>(metadata)).withApplicationPackageReferences(applicationPackageReferences == null ? new LinkedList<ApplicationPackageReference>() : new LinkedList<ApplicationPackageReference>(applicationPackageReferences)).withCertificateReferences(certificateReferences == null ? new LinkedList<CertificateReference>() : new LinkedList<CertificateReference>(certificateReferences)).withStartTask(startTask);
        this.parentBatchClient.protocolLayer().pools().updateProperties(poolId, param, options);
    }

    public void patchPool(String poolId, StartTask startTask, Collection<CertificateReference> certificateReferences, Collection<ApplicationPackageReference> applicationPackageReferences, Collection<MetadataItem> metadata) throws BatchErrorException, IOException {
        this.patchPool(poolId, startTask, certificateReferences, applicationPackageReferences, metadata, null);
    }

    public void patchPool(String poolId, StartTask startTask, Collection<CertificateReference> certificateReferences, Collection<ApplicationPackageReference> applicationPackageReferences, Collection<MetadataItem> metadata, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolPatchOptions options = new PoolPatchOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        PoolPatchParameter param = new PoolPatchParameter().withStartTask(startTask);
        if (metadata != null) {
            param.withMetadata(new LinkedList<MetadataItem>(metadata));
        }
        if (applicationPackageReferences != null) {
            param.withApplicationPackageReferences(new LinkedList<ApplicationPackageReference>(applicationPackageReferences));
        }
        if (certificateReferences != null) {
            param.withCertificateReferences(new LinkedList<CertificateReference>(certificateReferences));
        }
        this.parentBatchClient.protocolLayer().pools().patch(poolId, param, options);
    }

    public PagedList<PoolUsageMetrics> listPoolUsageMetrics(DateTime startTime, DateTime endTime) throws BatchErrorException, IOException {
        return this.listPoolUsageMetrics(startTime, endTime, null, null);
    }

    public PagedList<PoolUsageMetrics> listPoolUsageMetrics(DateTime startTime, DateTime endTime, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listPoolUsageMetrics(startTime, endTime, detailLevel, null);
    }

    public PagedList<PoolUsageMetrics> listPoolUsageMetrics(DateTime startTime, DateTime endTime, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolListUsageMetricsOptions options = new PoolListUsageMetricsOptions().withStartTime(startTime).withEndTime(endTime);
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().pools().listUsageMetrics(options);
    }

    public PoolStatistics getAllPoolsLifetimeStatistics() throws BatchErrorException, IOException {
        return this.getAllPoolsLifetimeStatistics(null);
    }

    public PoolStatistics getAllPoolsLifetimeStatistics(Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        PoolGetAllLifetimeStatisticsOptions options = new PoolGetAllLifetimeStatisticsOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().pools().getAllLifetimeStatistics(options);
    }
}

