/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.BatchClient;
import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.BehaviorManager;
import com.microsoft.azure.batch.CreateTasksErrorException;
import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.IInheritedBehaviors;
import com.microsoft.azure.batch.InternalHelper;
import com.microsoft.azure.batch.interceptor.BatchClientParallelOptions;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.CloudTask;
import com.microsoft.azure.batch.protocol.models.CloudTaskListSubtasksResult;
import com.microsoft.azure.batch.protocol.models.SubtaskInformation;
import com.microsoft.azure.batch.protocol.models.TaskAddCollectionOptions;
import com.microsoft.azure.batch.protocol.models.TaskAddCollectionResult;
import com.microsoft.azure.batch.protocol.models.TaskAddOptions;
import com.microsoft.azure.batch.protocol.models.TaskAddParameter;
import com.microsoft.azure.batch.protocol.models.TaskAddResult;
import com.microsoft.azure.batch.protocol.models.TaskAddStatus;
import com.microsoft.azure.batch.protocol.models.TaskConstraints;
import com.microsoft.azure.batch.protocol.models.TaskDeleteOptions;
import com.microsoft.azure.batch.protocol.models.TaskGetOptions;
import com.microsoft.azure.batch.protocol.models.TaskListOptions;
import com.microsoft.azure.batch.protocol.models.TaskListSubtasksOptions;
import com.microsoft.azure.batch.protocol.models.TaskReactivateOptions;
import com.microsoft.azure.batch.protocol.models.TaskTerminateOptions;
import com.microsoft.azure.batch.protocol.models.TaskUpdateOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskOperations
implements IInheritedBehaviors {
    private Collection<BatchClientBehavior> customBehaviors;
    private final BatchClient parentBatchClient;

    TaskOperations(BatchClient batchClient, Collection<BatchClientBehavior> customBehaviors) {
        this.parentBatchClient = batchClient;
        InternalHelper.inheritClientBehaviorsAndSetPublicProperty(this, customBehaviors);
    }

    @Override
    public Collection<BatchClientBehavior> customBehaviors() {
        return this.customBehaviors;
    }

    @Override
    public IInheritedBehaviors withCustomBehaviors(Collection<BatchClientBehavior> behaviors) {
        this.customBehaviors = behaviors;
        return this;
    }

    public void createTask(String jobId, TaskAddParameter taskToAdd) throws BatchErrorException, IOException {
        this.createTask(jobId, taskToAdd, null);
    }

    public void createTask(String jobId, TaskAddParameter taskToAdd, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        TaskAddOptions options = new TaskAddOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().tasks().add(jobId, taskToAdd, options);
    }

    public void createTasks(String jobId, List<TaskAddParameter> taskList) throws RuntimeException, InterruptedException {
        this.createTasks(jobId, taskList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTasks(String jobId, List<TaskAddParameter> taskList, Iterable<BatchClientBehavior> additionalBehaviors) throws RuntimeException, InterruptedException {
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        int threadNumber = 1;
        for (BatchClientBehavior op : bhMgr.getMasterListOfBehaviors()) {
            if (!(op instanceof BatchClientParallelOptions)) continue;
            threadNumber = ((BatchClientParallelOptions)op).maxDegreeOfParallelism();
        }
        Iterator lock = new Iterator();
        ConcurrentLinkedQueue<TaskAddParameter> pendingList = new ConcurrentLinkedQueue<TaskAddParameter>(taskList);
        CopyOnWriteArrayList<TaskAddResult> failures = new CopyOnWriteArrayList<TaskAddResult>();
        HashMap<Object, WorkingThread> threads = new HashMap<Object, WorkingThread>();
        Exception innerException = null;
        Iterator<Object> iterator = lock;
        synchronized (iterator) {
            while (!pendingList.isEmpty()) {
                if (threads.size() < threadNumber) {
                    WorkingThread worker = new WorkingThread(this.parentBatchClient, bhMgr, jobId, pendingList, failures, lock);
                    Thread thread = new Thread(worker);
                    thread.start();
                    threads.put(thread, worker);
                    continue;
                }
                lock.wait();
                ArrayList finishedThreads = new ArrayList();
                for (Map.Entry entry : threads.entrySet()) {
                    if (((Thread)entry.getKey()).getState() != Thread.State.TERMINATED) continue;
                    finishedThreads.add(entry.getKey());
                    innerException = ((WorkingThread)entry.getValue()).getException();
                    if (innerException == null) continue;
                    break;
                }
                threads.keySet().removeAll(finishedThreads);
                if (innerException == null && failures.isEmpty()) continue;
                break;
            }
        }
        for (Thread t : threads.keySet()) {
            t.join();
        }
        if (innerException == null) {
            Map.Entry entry;
            iterator = threads.entrySet().iterator();
            while (iterator.hasNext() && (innerException = ((WorkingThread)(entry = (Map.Entry)iterator.next()).getValue()).getException()) == null) {
            }
        }
        if (innerException != null) {
            if (innerException instanceof BatchErrorException) {
                throw (BatchErrorException)((Object)innerException);
            }
            if (innerException instanceof RuntimeException) {
                throw (RuntimeException)innerException;
            }
        }
        if (!failures.isEmpty()) {
            ArrayList<TaskAddParameter> notFinished = new ArrayList<TaskAddParameter>();
            for (TaskAddParameter param : pendingList) {
                notFinished.add(param);
            }
            throw new CreateTasksErrorException("At least one task failed to be added.", failures, notFinished);
        }
    }

    public PagedList<CloudTask> listTasks(String jobId) throws BatchErrorException, IOException {
        return this.listTasks(jobId, null, null);
    }

    public PagedList<CloudTask> listTasks(String jobId, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listTasks(jobId, detailLevel, null);
    }

    public PagedList<CloudTask> listTasks(String jobId, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        TaskListOptions options = new TaskListOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().tasks().list(jobId, options);
    }

    public List<SubtaskInformation> listSubtasks(String jobId, String taskId) throws BatchErrorException, IOException {
        return this.listSubtasks(jobId, taskId, null, null);
    }

    public List<SubtaskInformation> listSubtasks(String jobId, String taskId, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listSubtasks(jobId, taskId, detailLevel, null);
    }

    public List<SubtaskInformation> listSubtasks(String jobId, String taskId, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        TaskListSubtasksOptions options = new TaskListSubtasksOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        CloudTaskListSubtasksResult response = this.parentBatchClient.protocolLayer().tasks().listSubtasks(jobId, taskId, options);
        if (response != null) {
            return response.value();
        }
        return null;
    }

    public void deleteTask(String jobId, String taskId) throws BatchErrorException, IOException {
        this.deleteTask(jobId, taskId, null);
    }

    public void deleteTask(String jobId, String taskId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        TaskDeleteOptions options = new TaskDeleteOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().tasks().delete(jobId, taskId, options);
    }

    public CloudTask getTask(String jobId, String taskId) throws BatchErrorException, IOException {
        return this.getTask(jobId, taskId, null, null);
    }

    public CloudTask getTask(String jobId, String taskId, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.getTask(jobId, taskId, detailLevel, null);
    }

    public CloudTask getTask(String jobId, String taskId, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        TaskGetOptions options = new TaskGetOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().tasks().get(jobId, taskId, options);
    }

    public void updateTask(String jobId, String taskId, TaskConstraints constraints) throws BatchErrorException, IOException {
        this.updateTask(jobId, taskId, constraints, null);
    }

    public void updateTask(String jobId, String taskId, TaskConstraints constraints, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        TaskUpdateOptions options = new TaskUpdateOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().tasks().update(jobId, taskId, constraints, options);
    }

    public void terminateTask(String jobId, String taskId) throws BatchErrorException, IOException {
        this.terminateTask(jobId, taskId, null);
    }

    public void terminateTask(String jobId, String taskId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        TaskTerminateOptions options = new TaskTerminateOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().tasks().terminate(jobId, taskId, options);
    }

    public void reactivateTask(String jobId, String taskId) throws BatchErrorException, IOException {
        this.reactivateTask(jobId, taskId, null);
    }

    public void reactivateTask(String jobId, String taskId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        TaskReactivateOptions options = new TaskReactivateOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().tasks().reactivate(jobId, taskId, options);
    }

    private static class WorkingThread
    implements Runnable {
        static final int MAX_TASKS_PER_REQUEST = 100;
        private static final AtomicInteger CURRENT_MAX_TASKS = new AtomicInteger(100);
        BatchClient client;
        BehaviorManager bhMgr;
        String jobId;
        Queue<TaskAddParameter> pendingList;
        List<TaskAddResult> failures;
        volatile Exception exception;
        final Object lock;

        WorkingThread(BatchClient client, BehaviorManager bhMgr, String jobId, Queue<TaskAddParameter> pendingList, List<TaskAddResult> failures, Object lock) {
            this.client = client;
            this.bhMgr = bhMgr;
            this.jobId = jobId;
            this.pendingList = pendingList;
            this.failures = failures;
            this.exception = null;
            this.lock = lock;
        }

        public Exception getException() {
            return this.exception;
        }

        private void submitChunk(List<TaskAddParameter> taskList) {
            block9: {
                TaskAddCollectionOptions options = new TaskAddCollectionOptions();
                this.bhMgr.applyRequestBehaviors(options);
                try {
                    TaskAddCollectionResult response = this.client.protocolLayer().tasks().addCollection(this.jobId, taskList, options);
                    if (response == null || response.value() == null) break block9;
                    block3: for (TaskAddResult result : response.value()) {
                        if (result.error() == null) continue;
                        if (result.status() == TaskAddStatus.SERVER_ERROR) {
                            for (TaskAddParameter addParameter : taskList) {
                                if (!addParameter.id().equals(result.taskId())) continue;
                                this.pendingList.add(addParameter);
                                continue block3;
                            }
                            continue;
                        }
                        if (result.status() != TaskAddStatus.CLIENT_ERROR || result.error().code().equals("TaskExists")) continue;
                        this.failures.add(result);
                    }
                }
                catch (BatchErrorException e) {
                    if (e.body().code().equals("RequestBodyTooLarge") && taskList.size() > 1) {
                        int midpoint = taskList.size() / 2;
                        int max = CURRENT_MAX_TASKS.get();
                        while (midpoint < max) {
                            CURRENT_MAX_TASKS.compareAndSet(max, midpoint);
                            max = CURRENT_MAX_TASKS.get();
                        }
                        this.pendingList.addAll(taskList.subList(midpoint, taskList.size()));
                        this.submitChunk(taskList.subList(0, midpoint));
                    } else {
                        this.exception = e;
                        this.pendingList.addAll(taskList);
                    }
                }
                catch (RuntimeException e) {
                    this.exception = e;
                    this.pendingList.addAll(taskList);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TaskAddParameter param;
                LinkedList<TaskAddParameter> taskList = new LinkedList<TaskAddParameter>();
                int maxAmount = CURRENT_MAX_TASKS.get();
                for (int count = 0; count < maxAmount && (param = this.pendingList.poll()) != null; ++count) {
                    taskList.add(param);
                }
                if (taskList.size() > 0) {
                    this.submitChunk(taskList);
                }
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
        }
    }
}

