/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.auth;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.batch.auth.BatchCredentials;
import com.microsoft.rest.credentials.TokenCredentials;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Request;

public class BatchApplicationTokenCredentials
extends TokenCredentials
implements BatchCredentials {
    private final String clientId;
    private final String domain;
    private final String secret;
    private final String baseUrl;
    private final String batchEndpoint;
    private final String authenticationEndpoint;
    private AuthenticationResult authenticationResult;

    public BatchApplicationTokenCredentials(String baseUrl, String clientId, String secret, String domain, String batchEndpoint, String authenticationEndpoint) {
        super(null, null);
        if (baseUrl == null) {
            throw new IllegalArgumentException("Parameter baseUrl is required and cannot be null.");
        }
        if (clientId == null) {
            throw new IllegalArgumentException("Parameter clientId is required and cannot be null.");
        }
        if (secret == null) {
            throw new IllegalArgumentException("Parameter secret is required and cannot be null.");
        }
        if (domain == null) {
            throw new IllegalArgumentException("Parameter domain is required and cannot be null.");
        }
        if (batchEndpoint == null) {
            batchEndpoint = "https://batch.core.windows.net/";
        }
        if (authenticationEndpoint == null) {
            authenticationEndpoint = "https://login.microsoftonline.com/";
        }
        this.clientId = clientId;
        this.baseUrl = baseUrl;
        this.secret = secret;
        this.domain = domain;
        this.batchEndpoint = batchEndpoint;
        this.authenticationEndpoint = authenticationEndpoint;
        this.authenticationResult = null;
    }

    public String clientId() {
        return this.clientId;
    }

    public String domain() {
        return this.domain;
    }

    public String authenticationEndpoint() {
        return this.authenticationEndpoint;
    }

    public String batchEndpoint() {
        return this.batchEndpoint;
    }

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    public String getToken(Request request) throws IOException {
        if (this.authenticationResult == null || this.authenticationResult.getExpiresOnDate().before(new Date())) {
            this.authenticationResult = this.acquireAccessToken();
        }
        return this.authenticationResult.getAccessToken();
    }

    private AuthenticationResult acquireAccessToken() throws IOException {
        String authorityUrl = this.authenticationEndpoint() + this.domain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, false, executor);
        try {
            AuthenticationResult authenticationResult = this.authenticationResult = (AuthenticationResult)context.acquireToken(this.batchEndpoint(), new ClientCredential(this.clientId(), this.secret), null).get();
            return authenticationResult;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            executor.shutdown();
        }
    }
}

