/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.interceptor;

import com.microsoft.azure.batch.interceptor.BatchRequestInterceptHandler;
import com.microsoft.azure.batch.interceptor.RequestInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;

public class ClientRequestIdInterceptor
extends RequestInterceptor {
    public ClientRequestIdInterceptor() {
        this.withHandler(new RequestInterceptorHandler());
    }

    private static class RequestInterceptorHandler
    implements BatchRequestInterceptHandler {
        private RequestInterceptorHandler() {
        }

        @Override
        public void modify(Object request) {
            Class<?> c = request.getClass();
            try {
                Method clientRequestIdMethod = c.getMethod("withClientRequestId", UUID.class);
                UUID clientRequestId = UUID.randomUUID();
                clientRequestIdMethod.invoke(request, clientRequestId);
                Method returnClientRequestIdMethod = c.getMethod("withReturnClientRequestId", Boolean.class);
                returnClientRequestIdMethod.invoke(request, true);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }
}

