/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.ComputeNodes;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.ComputeNode;
import com.microsoft.azure.batch.protocol.models.ComputeNodeAddUserHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeAddUserOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeDeleteUserHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeDeleteUserOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeDisableSchedulingHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeDisableSchedulingOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeEnableSchedulingHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeEnableSchedulingOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeGetHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeGetOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeGetRemoteDesktopHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeGetRemoteDesktopOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeGetRemoteLoginSettingsHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeGetRemoteLoginSettingsOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeGetRemoteLoginSettingsResult;
import com.microsoft.azure.batch.protocol.models.ComputeNodeListHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeListNextOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeListOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeRebootHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeRebootOption;
import com.microsoft.azure.batch.protocol.models.ComputeNodeRebootOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeReimageHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeReimageOption;
import com.microsoft.azure.batch.protocol.models.ComputeNodeReimageOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeUpdateUserHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeUpdateUserOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeUploadBatchServiceLogsHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeUploadBatchServiceLogsOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeUser;
import com.microsoft.azure.batch.protocol.models.DisableComputeNodeSchedulingOption;
import com.microsoft.azure.batch.protocol.models.NodeDisableSchedulingParameter;
import com.microsoft.azure.batch.protocol.models.NodeRebootParameter;
import com.microsoft.azure.batch.protocol.models.NodeReimageParameter;
import com.microsoft.azure.batch.protocol.models.NodeUpdateUserParameter;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.azure.batch.protocol.models.UploadBatchServiceLogsConfiguration;
import com.microsoft.azure.batch.protocol.models.UploadBatchServiceLogsResult;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Streaming;
import retrofit2.http.Url;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;

public class ComputeNodesImpl
implements ComputeNodes {
    private ComputeNodesService service;
    private BatchServiceClientImpl client;

    public ComputeNodesImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (ComputeNodesService)retrofit.create(ComputeNodesService.class);
        this.client = client;
    }

    @Override
    public void getRemoteDesktop(String poolId, String nodeId, final OutputStream outputStream) {
        this.getRemoteDesktopAsync(poolId, nodeId).doOnNext((Action1)new Action1<InputStream>(){

            public void call(InputStream input) {
                byte[] data = new byte[4096];
                try {
                    int nRead;
                    while ((nRead = input.read(data, 0, data.length)) != -1) {
                        outputStream.write(data, 0, nRead);
                    }
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }).toBlocking().single();
    }

    @Override
    public void getRemoteDesktop(String poolId, String nodeId, ComputeNodeGetRemoteDesktopOptions computeNodeGetRemoteDesktopOptions, final OutputStream outputStream) {
        this.getRemoteDesktopAsync(poolId, nodeId, computeNodeGetRemoteDesktopOptions).doOnNext((Action1)new Action1<InputStream>(){

            public void call(InputStream input) {
                byte[] data = new byte[4096];
                try {
                    int nRead;
                    while ((nRead = input.read(data, 0, data.length)) != -1) {
                        outputStream.write(data, 0, nRead);
                    }
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }).toBlocking().single();
    }

    @Override
    public void addUser(String poolId, String nodeId, ComputeNodeUser user) {
        ((ServiceResponseWithHeaders)this.addUserWithServiceResponseAsync(poolId, nodeId, user).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addUserAsync(String poolId, String nodeId, ComputeNodeUser user, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addUserWithServiceResponseAsync(poolId, nodeId, user), serviceCallback);
    }

    @Override
    public Observable<Void> addUserAsync(String poolId, String nodeId, ComputeNodeUser user) {
        return this.addUserWithServiceResponseAsync(poolId, nodeId, user).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders>> addUserWithServiceResponseAsync(String poolId, String nodeId, ComputeNodeUser user) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (user == null) {
            throw new IllegalArgumentException("Parameter user is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)user);
        Object computeNodeAddUserOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.addUser(poolId, nodeId, user, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.addUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void addUser(String poolId, String nodeId, ComputeNodeUser user, ComputeNodeAddUserOptions computeNodeAddUserOptions) {
        ((ServiceResponseWithHeaders)this.addUserWithServiceResponseAsync(poolId, nodeId, user, computeNodeAddUserOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addUserAsync(String poolId, String nodeId, ComputeNodeUser user, ComputeNodeAddUserOptions computeNodeAddUserOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addUserWithServiceResponseAsync(poolId, nodeId, user, computeNodeAddUserOptions), serviceCallback);
    }

    @Override
    public Observable<Void> addUserAsync(String poolId, String nodeId, ComputeNodeUser user, ComputeNodeAddUserOptions computeNodeAddUserOptions) {
        return this.addUserWithServiceResponseAsync(poolId, nodeId, user, computeNodeAddUserOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders>> addUserWithServiceResponseAsync(String poolId, String nodeId, ComputeNodeUser user, ComputeNodeAddUserOptions computeNodeAddUserOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (user == null) {
            throw new IllegalArgumentException("Parameter user is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)user);
        Validator.validate((Object)computeNodeAddUserOptions);
        Integer timeout = null;
        if (computeNodeAddUserOptions != null) {
            timeout = computeNodeAddUserOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeAddUserOptions != null) {
            clientRequestId = computeNodeAddUserOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeAddUserOptions != null) {
            returnClientRequestId = computeNodeAddUserOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeAddUserOptions != null) {
            ocpDate = computeNodeAddUserOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.addUser(poolId, nodeId, user, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.addUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, ComputeNodeAddUserHeaders> addUserDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeAddUserHeaders.class);
    }

    @Override
    public void deleteUser(String poolId, String nodeId, String userName) {
        ((ServiceResponseWithHeaders)this.deleteUserWithServiceResponseAsync(poolId, nodeId, userName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteUserAsync(String poolId, String nodeId, String userName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteUserWithServiceResponseAsync(poolId, nodeId, userName), serviceCallback);
    }

    @Override
    public Observable<Void> deleteUserAsync(String poolId, String nodeId, String userName) {
        return this.deleteUserWithServiceResponseAsync(poolId, nodeId, userName).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders>> deleteUserWithServiceResponseAsync(String poolId, String nodeId, String userName) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Parameter userName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object computeNodeDeleteUserOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.deleteUser(poolId, nodeId, userName, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.deleteUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void deleteUser(String poolId, String nodeId, String userName, ComputeNodeDeleteUserOptions computeNodeDeleteUserOptions) {
        ((ServiceResponseWithHeaders)this.deleteUserWithServiceResponseAsync(poolId, nodeId, userName, computeNodeDeleteUserOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteUserAsync(String poolId, String nodeId, String userName, ComputeNodeDeleteUserOptions computeNodeDeleteUserOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteUserWithServiceResponseAsync(poolId, nodeId, userName, computeNodeDeleteUserOptions), serviceCallback);
    }

    @Override
    public Observable<Void> deleteUserAsync(String poolId, String nodeId, String userName, ComputeNodeDeleteUserOptions computeNodeDeleteUserOptions) {
        return this.deleteUserWithServiceResponseAsync(poolId, nodeId, userName, computeNodeDeleteUserOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders>> deleteUserWithServiceResponseAsync(String poolId, String nodeId, String userName, ComputeNodeDeleteUserOptions computeNodeDeleteUserOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Parameter userName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeDeleteUserOptions);
        Integer timeout = null;
        if (computeNodeDeleteUserOptions != null) {
            timeout = computeNodeDeleteUserOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeDeleteUserOptions != null) {
            clientRequestId = computeNodeDeleteUserOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeDeleteUserOptions != null) {
            returnClientRequestId = computeNodeDeleteUserOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeDeleteUserOptions != null) {
            ocpDate = computeNodeDeleteUserOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.deleteUser(poolId, nodeId, userName, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.deleteUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, ComputeNodeDeleteUserHeaders> deleteUserDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeDeleteUserHeaders.class);
    }

    @Override
    public void updateUser(String poolId, String nodeId, String userName, NodeUpdateUserParameter nodeUpdateUserParameter) {
        ((ServiceResponseWithHeaders)this.updateUserWithServiceResponseAsync(poolId, nodeId, userName, nodeUpdateUserParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateUserAsync(String poolId, String nodeId, String userName, NodeUpdateUserParameter nodeUpdateUserParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateUserWithServiceResponseAsync(poolId, nodeId, userName, nodeUpdateUserParameter), serviceCallback);
    }

    @Override
    public Observable<Void> updateUserAsync(String poolId, String nodeId, String userName, NodeUpdateUserParameter nodeUpdateUserParameter) {
        return this.updateUserWithServiceResponseAsync(poolId, nodeId, userName, nodeUpdateUserParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders>> updateUserWithServiceResponseAsync(String poolId, String nodeId, String userName, NodeUpdateUserParameter nodeUpdateUserParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Parameter userName is required and cannot be null.");
        }
        if (nodeUpdateUserParameter == null) {
            throw new IllegalArgumentException("Parameter nodeUpdateUserParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)nodeUpdateUserParameter);
        Object computeNodeUpdateUserOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.updateUser(poolId, nodeId, userName, nodeUpdateUserParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.updateUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void updateUser(String poolId, String nodeId, String userName, NodeUpdateUserParameter nodeUpdateUserParameter, ComputeNodeUpdateUserOptions computeNodeUpdateUserOptions) {
        ((ServiceResponseWithHeaders)this.updateUserWithServiceResponseAsync(poolId, nodeId, userName, nodeUpdateUserParameter, computeNodeUpdateUserOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateUserAsync(String poolId, String nodeId, String userName, NodeUpdateUserParameter nodeUpdateUserParameter, ComputeNodeUpdateUserOptions computeNodeUpdateUserOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateUserWithServiceResponseAsync(poolId, nodeId, userName, nodeUpdateUserParameter, computeNodeUpdateUserOptions), serviceCallback);
    }

    @Override
    public Observable<Void> updateUserAsync(String poolId, String nodeId, String userName, NodeUpdateUserParameter nodeUpdateUserParameter, ComputeNodeUpdateUserOptions computeNodeUpdateUserOptions) {
        return this.updateUserWithServiceResponseAsync(poolId, nodeId, userName, nodeUpdateUserParameter, computeNodeUpdateUserOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders>> updateUserWithServiceResponseAsync(String poolId, String nodeId, String userName, NodeUpdateUserParameter nodeUpdateUserParameter, ComputeNodeUpdateUserOptions computeNodeUpdateUserOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Parameter userName is required and cannot be null.");
        }
        if (nodeUpdateUserParameter == null) {
            throw new IllegalArgumentException("Parameter nodeUpdateUserParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)nodeUpdateUserParameter);
        Validator.validate((Object)computeNodeUpdateUserOptions);
        Integer timeout = null;
        if (computeNodeUpdateUserOptions != null) {
            timeout = computeNodeUpdateUserOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeUpdateUserOptions != null) {
            clientRequestId = computeNodeUpdateUserOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeUpdateUserOptions != null) {
            returnClientRequestId = computeNodeUpdateUserOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeUpdateUserOptions != null) {
            ocpDate = computeNodeUpdateUserOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.updateUser(poolId, nodeId, userName, nodeUpdateUserParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.updateUserDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, ComputeNodeUpdateUserHeaders> updateUserDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeUpdateUserHeaders.class);
    }

    @Override
    public ComputeNode get(String poolId, String nodeId) {
        return (ComputeNode)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(poolId, nodeId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ComputeNode> getAsync(String poolId, String nodeId, ServiceCallback<ComputeNode> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(poolId, nodeId), serviceCallback);
    }

    @Override
    public Observable<ComputeNode> getAsync(String poolId, String nodeId) {
        return this.getWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders>, ComputeNode>(){

            public ComputeNode call(ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders> response) {
                return (ComputeNode)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders>> getWithServiceResponseAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object computeNodeGetOptions = null;
        String select = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.get(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), select, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public ComputeNode get(String poolId, String nodeId, ComputeNodeGetOptions computeNodeGetOptions) {
        return (ComputeNode)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(poolId, nodeId, computeNodeGetOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ComputeNode> getAsync(String poolId, String nodeId, ComputeNodeGetOptions computeNodeGetOptions, ServiceCallback<ComputeNode> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(poolId, nodeId, computeNodeGetOptions), serviceCallback);
    }

    @Override
    public Observable<ComputeNode> getAsync(String poolId, String nodeId, ComputeNodeGetOptions computeNodeGetOptions) {
        return this.getWithServiceResponseAsync(poolId, nodeId, computeNodeGetOptions).map((Func1)new Func1<ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders>, ComputeNode>(){

            public ComputeNode call(ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders> response) {
                return (ComputeNode)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders>> getWithServiceResponseAsync(String poolId, String nodeId, ComputeNodeGetOptions computeNodeGetOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeGetOptions);
        String select = null;
        if (computeNodeGetOptions != null) {
            select = computeNodeGetOptions.select();
        }
        Integer timeout = null;
        if (computeNodeGetOptions != null) {
            timeout = computeNodeGetOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeGetOptions != null) {
            clientRequestId = computeNodeGetOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeGetOptions != null) {
            returnClientRequestId = computeNodeGetOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeGetOptions != null) {
            ocpDate = computeNodeGetOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.get(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), select, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<ComputeNode, ComputeNodeGetHeaders> getDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ComputeNode>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeGetHeaders.class);
    }

    @Override
    public void reboot(String poolId, String nodeId) {
        ((ServiceResponseWithHeaders)this.rebootWithServiceResponseAsync(poolId, nodeId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> rebootAsync(String poolId, String nodeId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.rebootWithServiceResponseAsync(poolId, nodeId), serviceCallback);
    }

    @Override
    public Observable<Void> rebootAsync(String poolId, String nodeId) {
        return this.rebootWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders>> rebootWithServiceResponseAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object nodeRebootOption = null;
        Object computeNodeRebootOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        NodeRebootParameter nodeRebootParameter = new NodeRebootParameter();
        nodeRebootParameter.withNodeRebootOption(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.reboot(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, nodeRebootParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.rebootDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void reboot(String poolId, String nodeId, ComputeNodeRebootOption nodeRebootOption, ComputeNodeRebootOptions computeNodeRebootOptions) {
        ((ServiceResponseWithHeaders)this.rebootWithServiceResponseAsync(poolId, nodeId, nodeRebootOption, computeNodeRebootOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> rebootAsync(String poolId, String nodeId, ComputeNodeRebootOption nodeRebootOption, ComputeNodeRebootOptions computeNodeRebootOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.rebootWithServiceResponseAsync(poolId, nodeId, nodeRebootOption, computeNodeRebootOptions), serviceCallback);
    }

    @Override
    public Observable<Void> rebootAsync(String poolId, String nodeId, ComputeNodeRebootOption nodeRebootOption, ComputeNodeRebootOptions computeNodeRebootOptions) {
        return this.rebootWithServiceResponseAsync(poolId, nodeId, nodeRebootOption, computeNodeRebootOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders>> rebootWithServiceResponseAsync(String poolId, String nodeId, ComputeNodeRebootOption nodeRebootOption, ComputeNodeRebootOptions computeNodeRebootOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeRebootOptions);
        Integer timeout = null;
        if (computeNodeRebootOptions != null) {
            timeout = computeNodeRebootOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeRebootOptions != null) {
            clientRequestId = computeNodeRebootOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeRebootOptions != null) {
            returnClientRequestId = computeNodeRebootOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeRebootOptions != null) {
            ocpDate = computeNodeRebootOptions.ocpDate();
        }
        NodeRebootParameter nodeRebootParameter = null;
        if (nodeRebootOption != null) {
            nodeRebootParameter = new NodeRebootParameter();
            nodeRebootParameter.withNodeRebootOption(nodeRebootOption);
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.reboot(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, nodeRebootParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.rebootDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, ComputeNodeRebootHeaders> rebootDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeRebootHeaders.class);
    }

    @Override
    public void reimage(String poolId, String nodeId) {
        ((ServiceResponseWithHeaders)this.reimageWithServiceResponseAsync(poolId, nodeId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> reimageAsync(String poolId, String nodeId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.reimageWithServiceResponseAsync(poolId, nodeId), serviceCallback);
    }

    @Override
    public Observable<Void> reimageAsync(String poolId, String nodeId) {
        return this.reimageWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders>> reimageWithServiceResponseAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object nodeReimageOption = null;
        Object computeNodeReimageOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        NodeReimageParameter nodeReimageParameter = new NodeReimageParameter();
        nodeReimageParameter.withNodeReimageOption(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.reimage(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, nodeReimageParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.reimageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void reimage(String poolId, String nodeId, ComputeNodeReimageOption nodeReimageOption, ComputeNodeReimageOptions computeNodeReimageOptions) {
        ((ServiceResponseWithHeaders)this.reimageWithServiceResponseAsync(poolId, nodeId, nodeReimageOption, computeNodeReimageOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> reimageAsync(String poolId, String nodeId, ComputeNodeReimageOption nodeReimageOption, ComputeNodeReimageOptions computeNodeReimageOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.reimageWithServiceResponseAsync(poolId, nodeId, nodeReimageOption, computeNodeReimageOptions), serviceCallback);
    }

    @Override
    public Observable<Void> reimageAsync(String poolId, String nodeId, ComputeNodeReimageOption nodeReimageOption, ComputeNodeReimageOptions computeNodeReimageOptions) {
        return this.reimageWithServiceResponseAsync(poolId, nodeId, nodeReimageOption, computeNodeReimageOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders>> reimageWithServiceResponseAsync(String poolId, String nodeId, ComputeNodeReimageOption nodeReimageOption, ComputeNodeReimageOptions computeNodeReimageOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeReimageOptions);
        Integer timeout = null;
        if (computeNodeReimageOptions != null) {
            timeout = computeNodeReimageOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeReimageOptions != null) {
            clientRequestId = computeNodeReimageOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeReimageOptions != null) {
            returnClientRequestId = computeNodeReimageOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeReimageOptions != null) {
            ocpDate = computeNodeReimageOptions.ocpDate();
        }
        NodeReimageParameter nodeReimageParameter = null;
        if (nodeReimageOption != null) {
            nodeReimageParameter = new NodeReimageParameter();
            nodeReimageParameter.withNodeReimageOption(nodeReimageOption);
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.reimage(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, nodeReimageParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.reimageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, ComputeNodeReimageHeaders> reimageDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeReimageHeaders.class);
    }

    @Override
    public void disableScheduling(String poolId, String nodeId) {
        ((ServiceResponseWithHeaders)this.disableSchedulingWithServiceResponseAsync(poolId, nodeId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> disableSchedulingAsync(String poolId, String nodeId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableSchedulingWithServiceResponseAsync(poolId, nodeId), serviceCallback);
    }

    @Override
    public Observable<Void> disableSchedulingAsync(String poolId, String nodeId) {
        return this.disableSchedulingWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders>> disableSchedulingWithServiceResponseAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object nodeDisableSchedulingOption = null;
        Object computeNodeDisableSchedulingOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        NodeDisableSchedulingParameter nodeDisableSchedulingParameter = new NodeDisableSchedulingParameter();
        nodeDisableSchedulingParameter.withNodeDisableSchedulingOption(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.disableScheduling(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, nodeDisableSchedulingParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.disableSchedulingDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void disableScheduling(String poolId, String nodeId, DisableComputeNodeSchedulingOption nodeDisableSchedulingOption, ComputeNodeDisableSchedulingOptions computeNodeDisableSchedulingOptions) {
        ((ServiceResponseWithHeaders)this.disableSchedulingWithServiceResponseAsync(poolId, nodeId, nodeDisableSchedulingOption, computeNodeDisableSchedulingOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> disableSchedulingAsync(String poolId, String nodeId, DisableComputeNodeSchedulingOption nodeDisableSchedulingOption, ComputeNodeDisableSchedulingOptions computeNodeDisableSchedulingOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableSchedulingWithServiceResponseAsync(poolId, nodeId, nodeDisableSchedulingOption, computeNodeDisableSchedulingOptions), serviceCallback);
    }

    @Override
    public Observable<Void> disableSchedulingAsync(String poolId, String nodeId, DisableComputeNodeSchedulingOption nodeDisableSchedulingOption, ComputeNodeDisableSchedulingOptions computeNodeDisableSchedulingOptions) {
        return this.disableSchedulingWithServiceResponseAsync(poolId, nodeId, nodeDisableSchedulingOption, computeNodeDisableSchedulingOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders>> disableSchedulingWithServiceResponseAsync(String poolId, String nodeId, DisableComputeNodeSchedulingOption nodeDisableSchedulingOption, ComputeNodeDisableSchedulingOptions computeNodeDisableSchedulingOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeDisableSchedulingOptions);
        Integer timeout = null;
        if (computeNodeDisableSchedulingOptions != null) {
            timeout = computeNodeDisableSchedulingOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeDisableSchedulingOptions != null) {
            clientRequestId = computeNodeDisableSchedulingOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeDisableSchedulingOptions != null) {
            returnClientRequestId = computeNodeDisableSchedulingOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeDisableSchedulingOptions != null) {
            ocpDate = computeNodeDisableSchedulingOptions.ocpDate();
        }
        NodeDisableSchedulingParameter nodeDisableSchedulingParameter = null;
        if (nodeDisableSchedulingOption != null) {
            nodeDisableSchedulingParameter = new NodeDisableSchedulingParameter();
            nodeDisableSchedulingParameter.withNodeDisableSchedulingOption(nodeDisableSchedulingOption);
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.disableScheduling(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, nodeDisableSchedulingParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.disableSchedulingDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, ComputeNodeDisableSchedulingHeaders> disableSchedulingDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeDisableSchedulingHeaders.class);
    }

    @Override
    public void enableScheduling(String poolId, String nodeId) {
        ((ServiceResponseWithHeaders)this.enableSchedulingWithServiceResponseAsync(poolId, nodeId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> enableSchedulingAsync(String poolId, String nodeId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.enableSchedulingWithServiceResponseAsync(poolId, nodeId), serviceCallback);
    }

    @Override
    public Observable<Void> enableSchedulingAsync(String poolId, String nodeId) {
        return this.enableSchedulingWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders>> enableSchedulingWithServiceResponseAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object computeNodeEnableSchedulingOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.enableScheduling(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.enableSchedulingDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void enableScheduling(String poolId, String nodeId, ComputeNodeEnableSchedulingOptions computeNodeEnableSchedulingOptions) {
        ((ServiceResponseWithHeaders)this.enableSchedulingWithServiceResponseAsync(poolId, nodeId, computeNodeEnableSchedulingOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> enableSchedulingAsync(String poolId, String nodeId, ComputeNodeEnableSchedulingOptions computeNodeEnableSchedulingOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.enableSchedulingWithServiceResponseAsync(poolId, nodeId, computeNodeEnableSchedulingOptions), serviceCallback);
    }

    @Override
    public Observable<Void> enableSchedulingAsync(String poolId, String nodeId, ComputeNodeEnableSchedulingOptions computeNodeEnableSchedulingOptions) {
        return this.enableSchedulingWithServiceResponseAsync(poolId, nodeId, computeNodeEnableSchedulingOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders>> enableSchedulingWithServiceResponseAsync(String poolId, String nodeId, ComputeNodeEnableSchedulingOptions computeNodeEnableSchedulingOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeEnableSchedulingOptions);
        Integer timeout = null;
        if (computeNodeEnableSchedulingOptions != null) {
            timeout = computeNodeEnableSchedulingOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeEnableSchedulingOptions != null) {
            clientRequestId = computeNodeEnableSchedulingOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeEnableSchedulingOptions != null) {
            returnClientRequestId = computeNodeEnableSchedulingOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeEnableSchedulingOptions != null) {
            ocpDate = computeNodeEnableSchedulingOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.enableScheduling(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.enableSchedulingDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, ComputeNodeEnableSchedulingHeaders> enableSchedulingDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeEnableSchedulingHeaders.class);
    }

    @Override
    public ComputeNodeGetRemoteLoginSettingsResult getRemoteLoginSettings(String poolId, String nodeId) {
        return (ComputeNodeGetRemoteLoginSettingsResult)((ServiceResponseWithHeaders)this.getRemoteLoginSettingsWithServiceResponseAsync(poolId, nodeId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ComputeNodeGetRemoteLoginSettingsResult> getRemoteLoginSettingsAsync(String poolId, String nodeId, ServiceCallback<ComputeNodeGetRemoteLoginSettingsResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getRemoteLoginSettingsWithServiceResponseAsync(poolId, nodeId), serviceCallback);
    }

    @Override
    public Observable<ComputeNodeGetRemoteLoginSettingsResult> getRemoteLoginSettingsAsync(String poolId, String nodeId) {
        return this.getRemoteLoginSettingsWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders>, ComputeNodeGetRemoteLoginSettingsResult>(){

            public ComputeNodeGetRemoteLoginSettingsResult call(ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders> response) {
                return (ComputeNodeGetRemoteLoginSettingsResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders>> getRemoteLoginSettingsWithServiceResponseAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object computeNodeGetRemoteLoginSettingsOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.getRemoteLoginSettings(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.getRemoteLoginSettingsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public ComputeNodeGetRemoteLoginSettingsResult getRemoteLoginSettings(String poolId, String nodeId, ComputeNodeGetRemoteLoginSettingsOptions computeNodeGetRemoteLoginSettingsOptions) {
        return (ComputeNodeGetRemoteLoginSettingsResult)((ServiceResponseWithHeaders)this.getRemoteLoginSettingsWithServiceResponseAsync(poolId, nodeId, computeNodeGetRemoteLoginSettingsOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ComputeNodeGetRemoteLoginSettingsResult> getRemoteLoginSettingsAsync(String poolId, String nodeId, ComputeNodeGetRemoteLoginSettingsOptions computeNodeGetRemoteLoginSettingsOptions, ServiceCallback<ComputeNodeGetRemoteLoginSettingsResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getRemoteLoginSettingsWithServiceResponseAsync(poolId, nodeId, computeNodeGetRemoteLoginSettingsOptions), serviceCallback);
    }

    @Override
    public Observable<ComputeNodeGetRemoteLoginSettingsResult> getRemoteLoginSettingsAsync(String poolId, String nodeId, ComputeNodeGetRemoteLoginSettingsOptions computeNodeGetRemoteLoginSettingsOptions) {
        return this.getRemoteLoginSettingsWithServiceResponseAsync(poolId, nodeId, computeNodeGetRemoteLoginSettingsOptions).map((Func1)new Func1<ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders>, ComputeNodeGetRemoteLoginSettingsResult>(){

            public ComputeNodeGetRemoteLoginSettingsResult call(ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders> response) {
                return (ComputeNodeGetRemoteLoginSettingsResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders>> getRemoteLoginSettingsWithServiceResponseAsync(String poolId, String nodeId, ComputeNodeGetRemoteLoginSettingsOptions computeNodeGetRemoteLoginSettingsOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeGetRemoteLoginSettingsOptions);
        Integer timeout = null;
        if (computeNodeGetRemoteLoginSettingsOptions != null) {
            timeout = computeNodeGetRemoteLoginSettingsOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeGetRemoteLoginSettingsOptions != null) {
            clientRequestId = computeNodeGetRemoteLoginSettingsOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeGetRemoteLoginSettingsOptions != null) {
            returnClientRequestId = computeNodeGetRemoteLoginSettingsOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeGetRemoteLoginSettingsOptions != null) {
            ocpDate = computeNodeGetRemoteLoginSettingsOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.getRemoteLoginSettings(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.getRemoteLoginSettingsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<ComputeNodeGetRemoteLoginSettingsResult, ComputeNodeGetRemoteLoginSettingsHeaders> getRemoteLoginSettingsDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ComputeNodeGetRemoteLoginSettingsResult>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeGetRemoteLoginSettingsHeaders.class);
    }

    @Override
    public InputStream getRemoteDesktop(String poolId, String nodeId) {
        return (InputStream)((ServiceResponseWithHeaders)this.getRemoteDesktopWithServiceResponseAsync(poolId, nodeId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<InputStream> getRemoteDesktopAsync(String poolId, String nodeId, ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getRemoteDesktopWithServiceResponseAsync(poolId, nodeId), serviceCallback);
    }

    @Override
    public Observable<InputStream> getRemoteDesktopAsync(String poolId, String nodeId) {
        return this.getRemoteDesktopWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders>, InputStream>(){

            public InputStream call(ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders> response) {
                return (InputStream)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders>> getRemoteDesktopWithServiceResponseAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object computeNodeGetRemoteDesktopOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.getRemoteDesktop(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.getRemoteDesktopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public InputStream getRemoteDesktop(String poolId, String nodeId, ComputeNodeGetRemoteDesktopOptions computeNodeGetRemoteDesktopOptions) {
        return (InputStream)((ServiceResponseWithHeaders)this.getRemoteDesktopWithServiceResponseAsync(poolId, nodeId, computeNodeGetRemoteDesktopOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<InputStream> getRemoteDesktopAsync(String poolId, String nodeId, ComputeNodeGetRemoteDesktopOptions computeNodeGetRemoteDesktopOptions, ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getRemoteDesktopWithServiceResponseAsync(poolId, nodeId, computeNodeGetRemoteDesktopOptions), serviceCallback);
    }

    @Override
    public Observable<InputStream> getRemoteDesktopAsync(String poolId, String nodeId, ComputeNodeGetRemoteDesktopOptions computeNodeGetRemoteDesktopOptions) {
        return this.getRemoteDesktopWithServiceResponseAsync(poolId, nodeId, computeNodeGetRemoteDesktopOptions).map((Func1)new Func1<ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders>, InputStream>(){

            public InputStream call(ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders> response) {
                return (InputStream)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders>> getRemoteDesktopWithServiceResponseAsync(String poolId, String nodeId, ComputeNodeGetRemoteDesktopOptions computeNodeGetRemoteDesktopOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeGetRemoteDesktopOptions);
        Integer timeout = null;
        if (computeNodeGetRemoteDesktopOptions != null) {
            timeout = computeNodeGetRemoteDesktopOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeGetRemoteDesktopOptions != null) {
            clientRequestId = computeNodeGetRemoteDesktopOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeGetRemoteDesktopOptions != null) {
            returnClientRequestId = computeNodeGetRemoteDesktopOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeGetRemoteDesktopOptions != null) {
            ocpDate = computeNodeGetRemoteDesktopOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.getRemoteDesktop(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.getRemoteDesktopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<InputStream, ComputeNodeGetRemoteDesktopHeaders> getRemoteDesktopDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InputStream>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeGetRemoteDesktopHeaders.class);
    }

    @Override
    public UploadBatchServiceLogsResult uploadBatchServiceLogs(String poolId, String nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration) {
        return (UploadBatchServiceLogsResult)((ServiceResponseWithHeaders)this.uploadBatchServiceLogsWithServiceResponseAsync(poolId, nodeId, uploadBatchServiceLogsConfiguration).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<UploadBatchServiceLogsResult> uploadBatchServiceLogsAsync(String poolId, String nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration, ServiceCallback<UploadBatchServiceLogsResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.uploadBatchServiceLogsWithServiceResponseAsync(poolId, nodeId, uploadBatchServiceLogsConfiguration), serviceCallback);
    }

    @Override
    public Observable<UploadBatchServiceLogsResult> uploadBatchServiceLogsAsync(String poolId, String nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration) {
        return this.uploadBatchServiceLogsWithServiceResponseAsync(poolId, nodeId, uploadBatchServiceLogsConfiguration).map((Func1)new Func1<ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders>, UploadBatchServiceLogsResult>(){

            public UploadBatchServiceLogsResult call(ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders> response) {
                return (UploadBatchServiceLogsResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders>> uploadBatchServiceLogsWithServiceResponseAsync(String poolId, String nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (uploadBatchServiceLogsConfiguration == null) {
            throw new IllegalArgumentException("Parameter uploadBatchServiceLogsConfiguration is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)uploadBatchServiceLogsConfiguration);
        Object computeNodeUploadBatchServiceLogsOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.uploadBatchServiceLogs(poolId, nodeId, uploadBatchServiceLogsConfiguration, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.uploadBatchServiceLogsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public UploadBatchServiceLogsResult uploadBatchServiceLogs(String poolId, String nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration, ComputeNodeUploadBatchServiceLogsOptions computeNodeUploadBatchServiceLogsOptions) {
        return (UploadBatchServiceLogsResult)((ServiceResponseWithHeaders)this.uploadBatchServiceLogsWithServiceResponseAsync(poolId, nodeId, uploadBatchServiceLogsConfiguration, computeNodeUploadBatchServiceLogsOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<UploadBatchServiceLogsResult> uploadBatchServiceLogsAsync(String poolId, String nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration, ComputeNodeUploadBatchServiceLogsOptions computeNodeUploadBatchServiceLogsOptions, ServiceCallback<UploadBatchServiceLogsResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.uploadBatchServiceLogsWithServiceResponseAsync(poolId, nodeId, uploadBatchServiceLogsConfiguration, computeNodeUploadBatchServiceLogsOptions), serviceCallback);
    }

    @Override
    public Observable<UploadBatchServiceLogsResult> uploadBatchServiceLogsAsync(String poolId, String nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration, ComputeNodeUploadBatchServiceLogsOptions computeNodeUploadBatchServiceLogsOptions) {
        return this.uploadBatchServiceLogsWithServiceResponseAsync(poolId, nodeId, uploadBatchServiceLogsConfiguration, computeNodeUploadBatchServiceLogsOptions).map((Func1)new Func1<ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders>, UploadBatchServiceLogsResult>(){

            public UploadBatchServiceLogsResult call(ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders> response) {
                return (UploadBatchServiceLogsResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders>> uploadBatchServiceLogsWithServiceResponseAsync(String poolId, String nodeId, UploadBatchServiceLogsConfiguration uploadBatchServiceLogsConfiguration, ComputeNodeUploadBatchServiceLogsOptions computeNodeUploadBatchServiceLogsOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (uploadBatchServiceLogsConfiguration == null) {
            throw new IllegalArgumentException("Parameter uploadBatchServiceLogsConfiguration is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)uploadBatchServiceLogsConfiguration);
        Validator.validate((Object)computeNodeUploadBatchServiceLogsOptions);
        Integer timeout = null;
        if (computeNodeUploadBatchServiceLogsOptions != null) {
            timeout = computeNodeUploadBatchServiceLogsOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeUploadBatchServiceLogsOptions != null) {
            clientRequestId = computeNodeUploadBatchServiceLogsOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeUploadBatchServiceLogsOptions != null) {
            returnClientRequestId = computeNodeUploadBatchServiceLogsOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeUploadBatchServiceLogsOptions != null) {
            ocpDate = computeNodeUploadBatchServiceLogsOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.uploadBatchServiceLogs(poolId, nodeId, uploadBatchServiceLogsConfiguration, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodesImpl.this.uploadBatchServiceLogsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<UploadBatchServiceLogsResult, ComputeNodeUploadBatchServiceLogsHeaders> uploadBatchServiceLogsDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<UploadBatchServiceLogsResult>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeUploadBatchServiceLogsHeaders.class);
    }

    @Override
    public PagedList<ComputeNode> list(String poolId) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(poolId).toBlocking().single();
        return new PagedList<ComputeNode>((Page)response.body()){

            public Page<ComputeNode> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ComputeNodesImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ComputeNode>> listAsync(String poolId, ListOperationCallback<ComputeNode> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(poolId), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(String nextPageLink) {
                return ComputeNodesImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ComputeNode>> listAsync(String poolId) {
        return this.listWithServiceResponseAsync(poolId).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>, Page<ComputeNode>>(){

            public Page<ComputeNode> call(ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> listWithServiceResponseAsync(String poolId) {
        return this.listSinglePageAsync(poolId).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComputeNodesImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> listSinglePageAsync(String poolId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object computeNodeListOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(poolId, this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ComputeNodesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<ComputeNode> list(String poolId, final ComputeNodeListOptions computeNodeListOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(poolId, computeNodeListOptions).toBlocking().single();
        return new PagedList<ComputeNode>((Page)response.body()){

            public Page<ComputeNode> nextPage(String nextPageLink) {
                ComputeNodeListNextOptions computeNodeListNextOptions = null;
                if (computeNodeListOptions != null) {
                    computeNodeListNextOptions = new ComputeNodeListNextOptions();
                    computeNodeListNextOptions.withClientRequestId(computeNodeListOptions.clientRequestId());
                    computeNodeListNextOptions.withReturnClientRequestId(computeNodeListOptions.returnClientRequestId());
                    computeNodeListNextOptions.withOcpDate(computeNodeListOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)ComputeNodesImpl.this.listNextSinglePageAsync(nextPageLink, computeNodeListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ComputeNode>> listAsync(String poolId, final ComputeNodeListOptions computeNodeListOptions, ListOperationCallback<ComputeNode> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(poolId, computeNodeListOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(String nextPageLink) {
                ComputeNodeListNextOptions computeNodeListNextOptions = null;
                if (computeNodeListOptions != null) {
                    computeNodeListNextOptions = new ComputeNodeListNextOptions();
                    computeNodeListNextOptions.withClientRequestId(computeNodeListOptions.clientRequestId());
                    computeNodeListNextOptions.withReturnClientRequestId(computeNodeListOptions.returnClientRequestId());
                    computeNodeListNextOptions.withOcpDate(computeNodeListOptions.ocpDate());
                }
                return ComputeNodesImpl.this.listNextSinglePageAsync(nextPageLink, computeNodeListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ComputeNode>> listAsync(String poolId, ComputeNodeListOptions computeNodeListOptions) {
        return this.listWithServiceResponseAsync(poolId, computeNodeListOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>, Page<ComputeNode>>(){

            public Page<ComputeNode> call(ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> listWithServiceResponseAsync(String poolId, final ComputeNodeListOptions computeNodeListOptions) {
        return this.listSinglePageAsync(poolId, computeNodeListOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                ComputeNodeListNextOptions computeNodeListNextOptions = null;
                if (computeNodeListOptions != null) {
                    computeNodeListNextOptions = new ComputeNodeListNextOptions();
                    computeNodeListNextOptions.withClientRequestId(computeNodeListOptions.clientRequestId());
                    computeNodeListNextOptions.withReturnClientRequestId(computeNodeListOptions.returnClientRequestId());
                    computeNodeListNextOptions.withOcpDate(computeNodeListOptions.ocpDate());
                }
                return Observable.just(page).concatWith(ComputeNodesImpl.this.listNextWithServiceResponseAsync(nextPageLink, computeNodeListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> listSinglePageAsync(String poolId, ComputeNodeListOptions computeNodeListOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeListOptions);
        String filter = null;
        if (computeNodeListOptions != null) {
            filter = computeNodeListOptions.filter();
        }
        String select = null;
        if (computeNodeListOptions != null) {
            select = computeNodeListOptions.select();
        }
        Integer maxResults = null;
        if (computeNodeListOptions != null) {
            maxResults = computeNodeListOptions.maxResults();
        }
        Integer timeout = null;
        if (computeNodeListOptions != null) {
            timeout = computeNodeListOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeListOptions != null) {
            clientRequestId = computeNodeListOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeListOptions != null) {
            returnClientRequestId = computeNodeListOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeListOptions != null) {
            ocpDate = computeNodeListOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(poolId, this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ComputeNodesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<ComputeNode>, ComputeNodeListHeaders> listDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ComputeNode>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeListHeaders.class);
    }

    @Override
    public PagedList<ComputeNode> listNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ComputeNode>((Page)response.body()){

            public Page<ComputeNode> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ComputeNodesImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ComputeNode>> listNextAsync(String nextPageLink, ServiceFuture<List<ComputeNode>> serviceFuture, ListOperationCallback<ComputeNode> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(String nextPageLink) {
                return ComputeNodesImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ComputeNode>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>, Page<ComputeNode>>(){

            public Page<ComputeNode> call(ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComputeNodesImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object computeNodeListNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ComputeNodesImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<ComputeNode> listNext(String nextPageLink, final ComputeNodeListNextOptions computeNodeListNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink, computeNodeListNextOptions).toBlocking().single();
        return new PagedList<ComputeNode>((Page)response.body()){

            public Page<ComputeNode> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ComputeNodesImpl.this.listNextSinglePageAsync(nextPageLink, computeNodeListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ComputeNode>> listNextAsync(String nextPageLink, final ComputeNodeListNextOptions computeNodeListNextOptions, ServiceFuture<List<ComputeNode>> serviceFuture, ListOperationCallback<ComputeNode> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink, computeNodeListNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(String nextPageLink) {
                return ComputeNodesImpl.this.listNextSinglePageAsync(nextPageLink, computeNodeListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ComputeNode>> listNextAsync(String nextPageLink, ComputeNodeListNextOptions computeNodeListNextOptions) {
        return this.listNextWithServiceResponseAsync(nextPageLink, computeNodeListNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>, Page<ComputeNode>>(){

            public Page<ComputeNode> call(ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> listNextWithServiceResponseAsync(String nextPageLink, final ComputeNodeListNextOptions computeNodeListNextOptions) {
        return this.listNextSinglePageAsync(nextPageLink, computeNodeListNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComputeNodesImpl.this.listNextWithServiceResponseAsync(nextPageLink, computeNodeListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> listNextSinglePageAsync(String nextPageLink, ComputeNodeListNextOptions computeNodeListNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeListNextOptions);
        UUID clientRequestId = null;
        if (computeNodeListNextOptions != null) {
            clientRequestId = computeNodeListNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeListNextOptions != null) {
            returnClientRequestId = computeNodeListNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeListNextOptions != null) {
            ocpDate = computeNodeListNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ComputeNode>, ComputeNodeListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ComputeNodesImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<ComputeNode>, ComputeNodeListHeaders> listNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ComputeNode>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeListHeaders.class);
    }

    static interface ComputeNodesService {
        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes addUser"})
        @POST(value="pools/{poolId}/nodes/{nodeId}/users")
        public Observable<Response<ResponseBody>> addUser(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Body ComputeNodeUser var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes deleteUser"})
        @HTTP(path="pools/{poolId}/nodes/{nodeId}/users/{userName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteUser(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Path(value="userName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes updateUser"})
        @PUT(value="pools/{poolId}/nodes/{nodeId}/users/{userName}")
        public Observable<Response<ResponseBody>> updateUser(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Path(value="userName") String var3, @Body NodeUpdateUserParameter var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes get"})
        @GET(value="pools/{poolId}/nodes/{nodeId}")
        public Observable<Response<ResponseBody>> get(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="$select") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes reboot"})
        @POST(value="pools/{poolId}/nodes/{nodeId}/reboot")
        public Observable<Response<ResponseBody>> reboot(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Body NodeRebootParameter var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes reimage"})
        @POST(value="pools/{poolId}/nodes/{nodeId}/reimage")
        public Observable<Response<ResponseBody>> reimage(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Body NodeReimageParameter var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes disableScheduling"})
        @POST(value="pools/{poolId}/nodes/{nodeId}/disablescheduling")
        public Observable<Response<ResponseBody>> disableScheduling(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Body NodeDisableSchedulingParameter var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes enableScheduling"})
        @POST(value="pools/{poolId}/nodes/{nodeId}/enablescheduling")
        public Observable<Response<ResponseBody>> enableScheduling(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes getRemoteLoginSettings"})
        @GET(value="pools/{poolId}/nodes/{nodeId}/remoteloginsettings")
        public Observable<Response<ResponseBody>> getRemoteLoginSettings(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes getRemoteDesktop"})
        @GET(value="pools/{poolId}/nodes/{nodeId}/rdp")
        @Streaming
        public Observable<Response<ResponseBody>> getRemoteDesktop(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes uploadBatchServiceLogs"})
        @POST(value="pools/{poolId}/nodes/{nodeId}/uploadbatchservicelogs")
        public Observable<Response<ResponseBody>> uploadBatchServiceLogs(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Body UploadBatchServiceLogsConfiguration var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes list"})
        @GET(value="pools/{poolId}/nodes")
        public Observable<Response<ResponseBody>> list(@Path(value="poolId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$filter") String var4, @Query(value="$select") String var5, @Query(value="maxresults") Integer var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodes listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

