/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.Tasks;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.CloudTask;
import com.microsoft.azure.batch.protocol.models.CloudTaskListSubtasksResult;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.azure.batch.protocol.models.TaskAddCollectionHeaders;
import com.microsoft.azure.batch.protocol.models.TaskAddCollectionOptions;
import com.microsoft.azure.batch.protocol.models.TaskAddCollectionParameter;
import com.microsoft.azure.batch.protocol.models.TaskAddCollectionResult;
import com.microsoft.azure.batch.protocol.models.TaskAddHeaders;
import com.microsoft.azure.batch.protocol.models.TaskAddOptions;
import com.microsoft.azure.batch.protocol.models.TaskAddParameter;
import com.microsoft.azure.batch.protocol.models.TaskConstraints;
import com.microsoft.azure.batch.protocol.models.TaskDeleteHeaders;
import com.microsoft.azure.batch.protocol.models.TaskDeleteOptions;
import com.microsoft.azure.batch.protocol.models.TaskGetHeaders;
import com.microsoft.azure.batch.protocol.models.TaskGetOptions;
import com.microsoft.azure.batch.protocol.models.TaskListHeaders;
import com.microsoft.azure.batch.protocol.models.TaskListNextOptions;
import com.microsoft.azure.batch.protocol.models.TaskListOptions;
import com.microsoft.azure.batch.protocol.models.TaskListSubtasksHeaders;
import com.microsoft.azure.batch.protocol.models.TaskListSubtasksOptions;
import com.microsoft.azure.batch.protocol.models.TaskReactivateHeaders;
import com.microsoft.azure.batch.protocol.models.TaskReactivateOptions;
import com.microsoft.azure.batch.protocol.models.TaskTerminateHeaders;
import com.microsoft.azure.batch.protocol.models.TaskTerminateOptions;
import com.microsoft.azure.batch.protocol.models.TaskUpdateHeaders;
import com.microsoft.azure.batch.protocol.models.TaskUpdateOptions;
import com.microsoft.azure.batch.protocol.models.TaskUpdateParameter;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class TasksImpl
implements Tasks {
    private TasksService service;
    private BatchServiceClientImpl client;

    public TasksImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (TasksService)retrofit.create(TasksService.class);
        this.client = client;
    }

    @Override
    public void add(String jobId, TaskAddParameter task) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(jobId, task).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(String jobId, TaskAddParameter task, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(jobId, task), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(String jobId, TaskAddParameter task) {
        return this.addWithServiceResponseAsync(jobId, task).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskAddHeaders>> addWithServiceResponseAsync(String jobId, TaskAddParameter task) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (task == null) {
            throw new IllegalArgumentException("Parameter task is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)task);
        Object taskAddOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(jobId, task, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void add(String jobId, TaskAddParameter task, TaskAddOptions taskAddOptions) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(jobId, task, taskAddOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(String jobId, TaskAddParameter task, TaskAddOptions taskAddOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(jobId, task, taskAddOptions), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(String jobId, TaskAddParameter task, TaskAddOptions taskAddOptions) {
        return this.addWithServiceResponseAsync(jobId, task, taskAddOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskAddHeaders>> addWithServiceResponseAsync(String jobId, TaskAddParameter task, TaskAddOptions taskAddOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (task == null) {
            throw new IllegalArgumentException("Parameter task is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)task);
        Validator.validate((Object)taskAddOptions);
        Integer timeout = null;
        if (taskAddOptions != null) {
            timeout = taskAddOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskAddOptions != null) {
            clientRequestId = taskAddOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskAddOptions != null) {
            returnClientRequestId = taskAddOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskAddOptions != null) {
            ocpDate = taskAddOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(jobId, task, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, TaskAddHeaders> addDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskAddHeaders.class);
    }

    @Override
    public PagedList<CloudTask> list(String jobId) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(jobId).toBlocking().single();
        return new PagedList<CloudTask>((Page)response.body()){

            public Page<CloudTask> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)TasksImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudTask>> listAsync(String jobId, ListOperationCallback<CloudTask> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(jobId), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(String nextPageLink) {
                return TasksImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudTask>> listAsync(String jobId) {
        return this.listWithServiceResponseAsync(jobId).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>, Page<CloudTask>>(){

            public Page<CloudTask> call(ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> listWithServiceResponseAsync(String jobId) {
        return this.listSinglePageAsync(jobId).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TasksImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> listSinglePageAsync(String jobId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object taskListOptions = null;
        String filter = null;
        String select = null;
        String expand = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(jobId, this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = TasksImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudTask> list(String jobId, final TaskListOptions taskListOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(jobId, taskListOptions).toBlocking().single();
        return new PagedList<CloudTask>((Page)response.body()){

            public Page<CloudTask> nextPage(String nextPageLink) {
                TaskListNextOptions taskListNextOptions = null;
                if (taskListOptions != null) {
                    taskListNextOptions = new TaskListNextOptions();
                    taskListNextOptions.withClientRequestId(taskListOptions.clientRequestId());
                    taskListNextOptions.withReturnClientRequestId(taskListOptions.returnClientRequestId());
                    taskListNextOptions.withOcpDate(taskListOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)TasksImpl.this.listNextSinglePageAsync(nextPageLink, taskListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudTask>> listAsync(String jobId, final TaskListOptions taskListOptions, ListOperationCallback<CloudTask> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(jobId, taskListOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(String nextPageLink) {
                TaskListNextOptions taskListNextOptions = null;
                if (taskListOptions != null) {
                    taskListNextOptions = new TaskListNextOptions();
                    taskListNextOptions.withClientRequestId(taskListOptions.clientRequestId());
                    taskListNextOptions.withReturnClientRequestId(taskListOptions.returnClientRequestId());
                    taskListNextOptions.withOcpDate(taskListOptions.ocpDate());
                }
                return TasksImpl.this.listNextSinglePageAsync(nextPageLink, taskListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudTask>> listAsync(String jobId, TaskListOptions taskListOptions) {
        return this.listWithServiceResponseAsync(jobId, taskListOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>, Page<CloudTask>>(){

            public Page<CloudTask> call(ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> listWithServiceResponseAsync(String jobId, final TaskListOptions taskListOptions) {
        return this.listSinglePageAsync(jobId, taskListOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                TaskListNextOptions taskListNextOptions = null;
                if (taskListOptions != null) {
                    taskListNextOptions = new TaskListNextOptions();
                    taskListNextOptions.withClientRequestId(taskListOptions.clientRequestId());
                    taskListNextOptions.withReturnClientRequestId(taskListOptions.returnClientRequestId());
                    taskListNextOptions.withOcpDate(taskListOptions.ocpDate());
                }
                return Observable.just(page).concatWith(TasksImpl.this.listNextWithServiceResponseAsync(nextPageLink, taskListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> listSinglePageAsync(String jobId, TaskListOptions taskListOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)taskListOptions);
        String filter = null;
        if (taskListOptions != null) {
            filter = taskListOptions.filter();
        }
        String select = null;
        if (taskListOptions != null) {
            select = taskListOptions.select();
        }
        String expand = null;
        if (taskListOptions != null) {
            expand = taskListOptions.expand();
        }
        Integer maxResults = null;
        if (taskListOptions != null) {
            maxResults = taskListOptions.maxResults();
        }
        Integer timeout = null;
        if (taskListOptions != null) {
            timeout = taskListOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskListOptions != null) {
            clientRequestId = taskListOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskListOptions != null) {
            returnClientRequestId = taskListOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskListOptions != null) {
            ocpDate = taskListOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(jobId, this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = TasksImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudTask>, TaskListHeaders> listDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudTask>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskListHeaders.class);
    }

    @Override
    public TaskAddCollectionResult addCollection(String jobId, List<TaskAddParameter> value) {
        return (TaskAddCollectionResult)((ServiceResponseWithHeaders)this.addCollectionWithServiceResponseAsync(jobId, value).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<TaskAddCollectionResult> addCollectionAsync(String jobId, List<TaskAddParameter> value, ServiceCallback<TaskAddCollectionResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addCollectionWithServiceResponseAsync(jobId, value), serviceCallback);
    }

    @Override
    public Observable<TaskAddCollectionResult> addCollectionAsync(String jobId, List<TaskAddParameter> value) {
        return this.addCollectionWithServiceResponseAsync(jobId, value).map((Func1)new Func1<ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders>, TaskAddCollectionResult>(){

            public TaskAddCollectionResult call(ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders> response) {
                return (TaskAddCollectionResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders>> addCollectionWithServiceResponseAsync(String jobId, List<TaskAddParameter> value) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        Object taskAddCollectionOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        TaskAddCollectionParameter taskCollection = new TaskAddCollectionParameter();
        taskCollection.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.addCollection(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, taskCollection, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.addCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public TaskAddCollectionResult addCollection(String jobId, List<TaskAddParameter> value, TaskAddCollectionOptions taskAddCollectionOptions) {
        return (TaskAddCollectionResult)((ServiceResponseWithHeaders)this.addCollectionWithServiceResponseAsync(jobId, value, taskAddCollectionOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<TaskAddCollectionResult> addCollectionAsync(String jobId, List<TaskAddParameter> value, TaskAddCollectionOptions taskAddCollectionOptions, ServiceCallback<TaskAddCollectionResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addCollectionWithServiceResponseAsync(jobId, value, taskAddCollectionOptions), serviceCallback);
    }

    @Override
    public Observable<TaskAddCollectionResult> addCollectionAsync(String jobId, List<TaskAddParameter> value, TaskAddCollectionOptions taskAddCollectionOptions) {
        return this.addCollectionWithServiceResponseAsync(jobId, value, taskAddCollectionOptions).map((Func1)new Func1<ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders>, TaskAddCollectionResult>(){

            public TaskAddCollectionResult call(ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders> response) {
                return (TaskAddCollectionResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders>> addCollectionWithServiceResponseAsync(String jobId, List<TaskAddParameter> value, TaskAddCollectionOptions taskAddCollectionOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(value);
        Validator.validate((Object)taskAddCollectionOptions);
        Integer timeout = null;
        if (taskAddCollectionOptions != null) {
            timeout = taskAddCollectionOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskAddCollectionOptions != null) {
            clientRequestId = taskAddCollectionOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskAddCollectionOptions != null) {
            returnClientRequestId = taskAddCollectionOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskAddCollectionOptions != null) {
            ocpDate = taskAddCollectionOptions.ocpDate();
        }
        TaskAddCollectionParameter taskCollection = new TaskAddCollectionParameter();
        taskCollection.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.addCollection(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, taskCollection, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.addCollectionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<TaskAddCollectionResult, TaskAddCollectionHeaders> addCollectionDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TaskAddCollectionResult>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskAddCollectionHeaders.class);
    }

    @Override
    public void delete(String jobId, String taskId) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(jobId, taskId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String jobId, String taskId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(jobId, taskId), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String jobId, String taskId) {
        return this.deleteWithServiceResponseAsync(jobId, taskId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskDeleteHeaders>> deleteWithServiceResponseAsync(String jobId, String taskId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object taskDeleteOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void delete(String jobId, String taskId, TaskDeleteOptions taskDeleteOptions) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(jobId, taskId, taskDeleteOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String jobId, String taskId, TaskDeleteOptions taskDeleteOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(jobId, taskId, taskDeleteOptions), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String jobId, String taskId, TaskDeleteOptions taskDeleteOptions) {
        return this.deleteWithServiceResponseAsync(jobId, taskId, taskDeleteOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskDeleteHeaders>> deleteWithServiceResponseAsync(String jobId, String taskId, TaskDeleteOptions taskDeleteOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)taskDeleteOptions);
        Integer timeout = null;
        if (taskDeleteOptions != null) {
            timeout = taskDeleteOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskDeleteOptions != null) {
            clientRequestId = taskDeleteOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskDeleteOptions != null) {
            returnClientRequestId = taskDeleteOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskDeleteOptions != null) {
            ocpDate = taskDeleteOptions.ocpDate();
        }
        String ifMatch = null;
        if (taskDeleteOptions != null) {
            ifMatch = taskDeleteOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (taskDeleteOptions != null) {
            ifNoneMatch = taskDeleteOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (taskDeleteOptions != null) {
            ifModifiedSince = taskDeleteOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (taskDeleteOptions != null) {
            ifUnmodifiedSince = taskDeleteOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, TaskDeleteHeaders> deleteDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskDeleteHeaders.class);
    }

    @Override
    public CloudTask get(String jobId, String taskId) {
        return (CloudTask)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(jobId, taskId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudTask> getAsync(String jobId, String taskId, ServiceCallback<CloudTask> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(jobId, taskId), serviceCallback);
    }

    @Override
    public Observable<CloudTask> getAsync(String jobId, String taskId) {
        return this.getWithServiceResponseAsync(jobId, taskId).map((Func1)new Func1<ServiceResponseWithHeaders<CloudTask, TaskGetHeaders>, CloudTask>(){

            public CloudTask call(ServiceResponseWithHeaders<CloudTask, TaskGetHeaders> response) {
                return (CloudTask)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudTask, TaskGetHeaders>> getWithServiceResponseAsync(String jobId, String taskId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object taskGetOptions = null;
        String select = null;
        String expand = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.get(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), select, expand, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudTask, TaskGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudTask, TaskGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CloudTask get(String jobId, String taskId, TaskGetOptions taskGetOptions) {
        return (CloudTask)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(jobId, taskId, taskGetOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudTask> getAsync(String jobId, String taskId, TaskGetOptions taskGetOptions, ServiceCallback<CloudTask> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(jobId, taskId, taskGetOptions), serviceCallback);
    }

    @Override
    public Observable<CloudTask> getAsync(String jobId, String taskId, TaskGetOptions taskGetOptions) {
        return this.getWithServiceResponseAsync(jobId, taskId, taskGetOptions).map((Func1)new Func1<ServiceResponseWithHeaders<CloudTask, TaskGetHeaders>, CloudTask>(){

            public CloudTask call(ServiceResponseWithHeaders<CloudTask, TaskGetHeaders> response) {
                return (CloudTask)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudTask, TaskGetHeaders>> getWithServiceResponseAsync(String jobId, String taskId, TaskGetOptions taskGetOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)taskGetOptions);
        String select = null;
        if (taskGetOptions != null) {
            select = taskGetOptions.select();
        }
        String expand = null;
        if (taskGetOptions != null) {
            expand = taskGetOptions.expand();
        }
        Integer timeout = null;
        if (taskGetOptions != null) {
            timeout = taskGetOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskGetOptions != null) {
            clientRequestId = taskGetOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskGetOptions != null) {
            returnClientRequestId = taskGetOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskGetOptions != null) {
            ocpDate = taskGetOptions.ocpDate();
        }
        String ifMatch = null;
        if (taskGetOptions != null) {
            ifMatch = taskGetOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (taskGetOptions != null) {
            ifNoneMatch = taskGetOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (taskGetOptions != null) {
            ifModifiedSince = taskGetOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (taskGetOptions != null) {
            ifUnmodifiedSince = taskGetOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.get(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), select, expand, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudTask, TaskGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudTask, TaskGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CloudTask, TaskGetHeaders> getDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CloudTask>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskGetHeaders.class);
    }

    @Override
    public void update(String jobId, String taskId) {
        ((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(jobId, taskId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateAsync(String jobId, String taskId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(jobId, taskId), serviceCallback);
    }

    @Override
    public Observable<Void> updateAsync(String jobId, String taskId) {
        return this.updateWithServiceResponseAsync(jobId, taskId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskUpdateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskUpdateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskUpdateHeaders>> updateWithServiceResponseAsync(String jobId, String taskId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object constraints = null;
        Object taskUpdateOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        TaskUpdateParameter taskUpdateParameter = new TaskUpdateParameter();
        taskUpdateParameter.withConstraints(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.update(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, taskUpdateParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void update(String jobId, String taskId, TaskConstraints constraints, TaskUpdateOptions taskUpdateOptions) {
        ((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(jobId, taskId, constraints, taskUpdateOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateAsync(String jobId, String taskId, TaskConstraints constraints, TaskUpdateOptions taskUpdateOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(jobId, taskId, constraints, taskUpdateOptions), serviceCallback);
    }

    @Override
    public Observable<Void> updateAsync(String jobId, String taskId, TaskConstraints constraints, TaskUpdateOptions taskUpdateOptions) {
        return this.updateWithServiceResponseAsync(jobId, taskId, constraints, taskUpdateOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskUpdateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskUpdateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskUpdateHeaders>> updateWithServiceResponseAsync(String jobId, String taskId, TaskConstraints constraints, TaskUpdateOptions taskUpdateOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)constraints);
        Validator.validate((Object)taskUpdateOptions);
        Integer timeout = null;
        if (taskUpdateOptions != null) {
            timeout = taskUpdateOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskUpdateOptions != null) {
            clientRequestId = taskUpdateOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskUpdateOptions != null) {
            returnClientRequestId = taskUpdateOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskUpdateOptions != null) {
            ocpDate = taskUpdateOptions.ocpDate();
        }
        String ifMatch = null;
        if (taskUpdateOptions != null) {
            ifMatch = taskUpdateOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (taskUpdateOptions != null) {
            ifNoneMatch = taskUpdateOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (taskUpdateOptions != null) {
            ifModifiedSince = taskUpdateOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (taskUpdateOptions != null) {
            ifUnmodifiedSince = taskUpdateOptions.ifUnmodifiedSince();
        }
        TaskUpdateParameter taskUpdateParameter = new TaskUpdateParameter();
        taskUpdateParameter.withConstraints(constraints);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.update(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, taskUpdateParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, TaskUpdateHeaders> updateDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskUpdateHeaders.class);
    }

    @Override
    public CloudTaskListSubtasksResult listSubtasks(String jobId, String taskId) {
        return (CloudTaskListSubtasksResult)((ServiceResponseWithHeaders)this.listSubtasksWithServiceResponseAsync(jobId, taskId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudTaskListSubtasksResult> listSubtasksAsync(String jobId, String taskId, ServiceCallback<CloudTaskListSubtasksResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.listSubtasksWithServiceResponseAsync(jobId, taskId), serviceCallback);
    }

    @Override
    public Observable<CloudTaskListSubtasksResult> listSubtasksAsync(String jobId, String taskId) {
        return this.listSubtasksWithServiceResponseAsync(jobId, taskId).map((Func1)new Func1<ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders>, CloudTaskListSubtasksResult>(){

            public CloudTaskListSubtasksResult call(ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders> response) {
                return (CloudTaskListSubtasksResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders>> listSubtasksWithServiceResponseAsync(String jobId, String taskId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object taskListSubtasksOptions = null;
        String select = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listSubtasks(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), select, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.listSubtasksDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CloudTaskListSubtasksResult listSubtasks(String jobId, String taskId, TaskListSubtasksOptions taskListSubtasksOptions) {
        return (CloudTaskListSubtasksResult)((ServiceResponseWithHeaders)this.listSubtasksWithServiceResponseAsync(jobId, taskId, taskListSubtasksOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudTaskListSubtasksResult> listSubtasksAsync(String jobId, String taskId, TaskListSubtasksOptions taskListSubtasksOptions, ServiceCallback<CloudTaskListSubtasksResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.listSubtasksWithServiceResponseAsync(jobId, taskId, taskListSubtasksOptions), serviceCallback);
    }

    @Override
    public Observable<CloudTaskListSubtasksResult> listSubtasksAsync(String jobId, String taskId, TaskListSubtasksOptions taskListSubtasksOptions) {
        return this.listSubtasksWithServiceResponseAsync(jobId, taskId, taskListSubtasksOptions).map((Func1)new Func1<ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders>, CloudTaskListSubtasksResult>(){

            public CloudTaskListSubtasksResult call(ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders> response) {
                return (CloudTaskListSubtasksResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders>> listSubtasksWithServiceResponseAsync(String jobId, String taskId, TaskListSubtasksOptions taskListSubtasksOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)taskListSubtasksOptions);
        String select = null;
        if (taskListSubtasksOptions != null) {
            select = taskListSubtasksOptions.select();
        }
        Integer timeout = null;
        if (taskListSubtasksOptions != null) {
            timeout = taskListSubtasksOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskListSubtasksOptions != null) {
            clientRequestId = taskListSubtasksOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskListSubtasksOptions != null) {
            returnClientRequestId = taskListSubtasksOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskListSubtasksOptions != null) {
            ocpDate = taskListSubtasksOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listSubtasks(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), select, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.listSubtasksDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CloudTaskListSubtasksResult, TaskListSubtasksHeaders> listSubtasksDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CloudTaskListSubtasksResult>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskListSubtasksHeaders.class);
    }

    @Override
    public void terminate(String jobId, String taskId) {
        ((ServiceResponseWithHeaders)this.terminateWithServiceResponseAsync(jobId, taskId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> terminateAsync(String jobId, String taskId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.terminateWithServiceResponseAsync(jobId, taskId), serviceCallback);
    }

    @Override
    public Observable<Void> terminateAsync(String jobId, String taskId) {
        return this.terminateWithServiceResponseAsync(jobId, taskId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskTerminateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskTerminateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskTerminateHeaders>> terminateWithServiceResponseAsync(String jobId, String taskId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object taskTerminateOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.terminate(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskTerminateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskTerminateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.terminateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void terminate(String jobId, String taskId, TaskTerminateOptions taskTerminateOptions) {
        ((ServiceResponseWithHeaders)this.terminateWithServiceResponseAsync(jobId, taskId, taskTerminateOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> terminateAsync(String jobId, String taskId, TaskTerminateOptions taskTerminateOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.terminateWithServiceResponseAsync(jobId, taskId, taskTerminateOptions), serviceCallback);
    }

    @Override
    public Observable<Void> terminateAsync(String jobId, String taskId, TaskTerminateOptions taskTerminateOptions) {
        return this.terminateWithServiceResponseAsync(jobId, taskId, taskTerminateOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskTerminateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskTerminateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskTerminateHeaders>> terminateWithServiceResponseAsync(String jobId, String taskId, TaskTerminateOptions taskTerminateOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)taskTerminateOptions);
        Integer timeout = null;
        if (taskTerminateOptions != null) {
            timeout = taskTerminateOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskTerminateOptions != null) {
            clientRequestId = taskTerminateOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskTerminateOptions != null) {
            returnClientRequestId = taskTerminateOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskTerminateOptions != null) {
            ocpDate = taskTerminateOptions.ocpDate();
        }
        String ifMatch = null;
        if (taskTerminateOptions != null) {
            ifMatch = taskTerminateOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (taskTerminateOptions != null) {
            ifNoneMatch = taskTerminateOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (taskTerminateOptions != null) {
            ifModifiedSince = taskTerminateOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (taskTerminateOptions != null) {
            ifUnmodifiedSince = taskTerminateOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.terminate(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskTerminateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskTerminateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.terminateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, TaskTerminateHeaders> terminateDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskTerminateHeaders.class);
    }

    @Override
    public void reactivate(String jobId, String taskId) {
        ((ServiceResponseWithHeaders)this.reactivateWithServiceResponseAsync(jobId, taskId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> reactivateAsync(String jobId, String taskId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.reactivateWithServiceResponseAsync(jobId, taskId), serviceCallback);
    }

    @Override
    public Observable<Void> reactivateAsync(String jobId, String taskId) {
        return this.reactivateWithServiceResponseAsync(jobId, taskId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskReactivateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskReactivateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskReactivateHeaders>> reactivateWithServiceResponseAsync(String jobId, String taskId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object taskReactivateOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.reactivate(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskReactivateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskReactivateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.reactivateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void reactivate(String jobId, String taskId, TaskReactivateOptions taskReactivateOptions) {
        ((ServiceResponseWithHeaders)this.reactivateWithServiceResponseAsync(jobId, taskId, taskReactivateOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> reactivateAsync(String jobId, String taskId, TaskReactivateOptions taskReactivateOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.reactivateWithServiceResponseAsync(jobId, taskId, taskReactivateOptions), serviceCallback);
    }

    @Override
    public Observable<Void> reactivateAsync(String jobId, String taskId, TaskReactivateOptions taskReactivateOptions) {
        return this.reactivateWithServiceResponseAsync(jobId, taskId, taskReactivateOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, TaskReactivateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, TaskReactivateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, TaskReactivateHeaders>> reactivateWithServiceResponseAsync(String jobId, String taskId, TaskReactivateOptions taskReactivateOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)taskReactivateOptions);
        Integer timeout = null;
        if (taskReactivateOptions != null) {
            timeout = taskReactivateOptions.timeout();
        }
        UUID clientRequestId = null;
        if (taskReactivateOptions != null) {
            clientRequestId = taskReactivateOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskReactivateOptions != null) {
            returnClientRequestId = taskReactivateOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskReactivateOptions != null) {
            ocpDate = taskReactivateOptions.ocpDate();
        }
        String ifMatch = null;
        if (taskReactivateOptions != null) {
            ifMatch = taskReactivateOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (taskReactivateOptions != null) {
            ifNoneMatch = taskReactivateOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (taskReactivateOptions != null) {
            ifModifiedSince = taskReactivateOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (taskReactivateOptions != null) {
            ifUnmodifiedSince = taskReactivateOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.reactivate(jobId, taskId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, TaskReactivateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, TaskReactivateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = TasksImpl.this.reactivateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, TaskReactivateHeaders> reactivateDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskReactivateHeaders.class);
    }

    @Override
    public PagedList<CloudTask> listNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CloudTask>((Page)response.body()){

            public Page<CloudTask> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)TasksImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudTask>> listNextAsync(String nextPageLink, ServiceFuture<List<CloudTask>> serviceFuture, ListOperationCallback<CloudTask> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(String nextPageLink) {
                return TasksImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudTask>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>, Page<CloudTask>>(){

            public Page<CloudTask> call(ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TasksImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object taskListNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = TasksImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudTask> listNext(String nextPageLink, final TaskListNextOptions taskListNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink, taskListNextOptions).toBlocking().single();
        return new PagedList<CloudTask>((Page)response.body()){

            public Page<CloudTask> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)TasksImpl.this.listNextSinglePageAsync(nextPageLink, taskListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudTask>> listNextAsync(String nextPageLink, final TaskListNextOptions taskListNextOptions, ServiceFuture<List<CloudTask>> serviceFuture, ListOperationCallback<CloudTask> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink, taskListNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(String nextPageLink) {
                return TasksImpl.this.listNextSinglePageAsync(nextPageLink, taskListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudTask>> listNextAsync(String nextPageLink, TaskListNextOptions taskListNextOptions) {
        return this.listNextWithServiceResponseAsync(nextPageLink, taskListNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>, Page<CloudTask>>(){

            public Page<CloudTask> call(ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> listNextWithServiceResponseAsync(String nextPageLink, final TaskListNextOptions taskListNextOptions) {
        return this.listNextSinglePageAsync(nextPageLink, taskListNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TasksImpl.this.listNextWithServiceResponseAsync(nextPageLink, taskListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> listNextSinglePageAsync(String nextPageLink, TaskListNextOptions taskListNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)taskListNextOptions);
        UUID clientRequestId = null;
        if (taskListNextOptions != null) {
            clientRequestId = taskListNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (taskListNextOptions != null) {
            returnClientRequestId = taskListNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (taskListNextOptions != null) {
            ocpDate = taskListNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudTask>, TaskListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = TasksImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudTask>, TaskListHeaders> listNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudTask>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, TaskListHeaders.class);
    }

    static interface TasksService {
        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks add"})
        @POST(value="jobs/{jobId}/tasks")
        public Observable<Response<ResponseBody>> add(@Path(value="jobId") String var1, @Body TaskAddParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks list"})
        @GET(value="jobs/{jobId}/tasks")
        public Observable<Response<ResponseBody>> list(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$filter") String var4, @Query(value="$select") String var5, @Query(value="$expand") String var6, @Query(value="maxresults") Integer var7, @Query(value="timeout") Integer var8, @Header(value="client-request-id") UUID var9, @Header(value="return-client-request-id") Boolean var10, @Header(value="ocp-date") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks addCollection"})
        @POST(value="jobs/{jobId}/addtaskcollection")
        public Observable<Response<ResponseBody>> addCollection(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Body TaskAddCollectionParameter var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks delete"})
        @HTTP(path="jobs/{jobId}/tasks/{taskId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks get"})
        @GET(value="jobs/{jobId}/tasks/{taskId}")
        public Observable<Response<ResponseBody>> get(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="$select") String var5, @Query(value="$expand") String var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="If-Match") String var11, @Header(value="If-None-Match") String var12, @Header(value="If-Modified-Since") DateTimeRfc1123 var13, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var14, @Header(value="x-ms-parameterized-host") String var15, @Header(value="User-Agent") String var16);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks update"})
        @PUT(value="jobs/{jobId}/tasks/{taskId}")
        public Observable<Response<ResponseBody>> update(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Body TaskUpdateParameter var13, @Header(value="x-ms-parameterized-host") String var14, @Header(value="User-Agent") String var15);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks listSubtasks"})
        @GET(value="jobs/{jobId}/tasks/{taskId}/subtasksinfo")
        public Observable<Response<ResponseBody>> listSubtasks(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="$select") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks terminate"})
        @POST(value="jobs/{jobId}/tasks/{taskId}/terminate")
        public Observable<Response<ResponseBody>> terminate(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks reactivate"})
        @POST(value="jobs/{jobId}/tasks/{taskId}/reactivate")
        public Observable<Response<ResponseBody>> reactivate(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Tasks listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

