/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.interceptor;

import com.microsoft.azure.batch.interceptor.BatchRequestInterceptHandler;
import com.microsoft.azure.batch.interceptor.RequestInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ServerTimeoutInterceptor
extends RequestInterceptor {
    private final int serverTimeout;

    public ServerTimeoutInterceptor(int timeout) {
        this.serverTimeout = timeout;
        this.withHandler(new BatchRequestInterceptHandler(){

            @Override
            public void modify(Object request) {
                Class<?> c = request.getClass();
                try {
                    Method timeoutMethod = c.getMethod("withTimeout", Integer.class);
                    timeoutMethod.invoke(request, ServerTimeoutInterceptor.this.serverTimeout);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
    }

    public int serverTimeout() {
        return this.serverTimeout;
    }
}

