/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.JobSchedules;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.CloudJobSchedule;
import com.microsoft.azure.batch.protocol.models.JobScheduleAddHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleAddOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleAddParameter;
import com.microsoft.azure.batch.protocol.models.JobScheduleDeleteHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleDeleteOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleDisableHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleDisableOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleEnableHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleEnableOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleExistsHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleExistsOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleGetHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleGetOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleListHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleListNextOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleListOptions;
import com.microsoft.azure.batch.protocol.models.JobSchedulePatchHeaders;
import com.microsoft.azure.batch.protocol.models.JobSchedulePatchOptions;
import com.microsoft.azure.batch.protocol.models.JobSchedulePatchParameter;
import com.microsoft.azure.batch.protocol.models.JobScheduleTerminateHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleTerminateOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleUpdateHeaders;
import com.microsoft.azure.batch.protocol.models.JobScheduleUpdateOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleUpdateParameter;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobSchedulesImpl
implements JobSchedules {
    private JobSchedulesService service;
    private BatchServiceClientImpl client;

    public JobSchedulesImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (JobSchedulesService)retrofit.create(JobSchedulesService.class);
        this.client = client;
    }

    @Override
    public boolean exists(String jobScheduleId) {
        return (Boolean)((ServiceResponseWithHeaders)this.existsWithServiceResponseAsync(jobScheduleId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Boolean> existsAsync(String jobScheduleId, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.existsWithServiceResponseAsync(jobScheduleId), serviceCallback);
    }

    @Override
    public Observable<Boolean> existsAsync(String jobScheduleId) {
        return this.existsWithServiceResponseAsync(jobScheduleId).map((Func1)new Func1<ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders>, Boolean>(){

            public Boolean call(ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders> response) {
                return (Boolean)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders>> existsWithServiceResponseAsync(String jobScheduleId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobScheduleExistsOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.exists(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders>> call(Response<Void> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.existsDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public boolean exists(String jobScheduleId, JobScheduleExistsOptions jobScheduleExistsOptions) {
        return (Boolean)((ServiceResponseWithHeaders)this.existsWithServiceResponseAsync(jobScheduleId, jobScheduleExistsOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Boolean> existsAsync(String jobScheduleId, JobScheduleExistsOptions jobScheduleExistsOptions, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.existsWithServiceResponseAsync(jobScheduleId, jobScheduleExistsOptions), serviceCallback);
    }

    @Override
    public Observable<Boolean> existsAsync(String jobScheduleId, JobScheduleExistsOptions jobScheduleExistsOptions) {
        return this.existsWithServiceResponseAsync(jobScheduleId, jobScheduleExistsOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders>, Boolean>(){

            public Boolean call(ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders> response) {
                return (Boolean)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders>> existsWithServiceResponseAsync(String jobScheduleId, JobScheduleExistsOptions jobScheduleExistsOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleExistsOptions);
        Integer timeout = null;
        if (jobScheduleExistsOptions != null) {
            timeout = jobScheduleExistsOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleExistsOptions != null) {
            clientRequestId = jobScheduleExistsOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleExistsOptions != null) {
            returnClientRequestId = jobScheduleExistsOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleExistsOptions != null) {
            ocpDate = jobScheduleExistsOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobScheduleExistsOptions != null) {
            ifMatch = jobScheduleExistsOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobScheduleExistsOptions != null) {
            ifNoneMatch = jobScheduleExistsOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobScheduleExistsOptions != null) {
            ifModifiedSince = jobScheduleExistsOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobScheduleExistsOptions != null) {
            ifUnmodifiedSince = jobScheduleExistsOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.exists(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders>> call(Response<Void> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.existsDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Boolean, JobScheduleExistsHeaders> existsDelegate(Response<Void> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildEmptyWithHeaders(response, JobScheduleExistsHeaders.class);
    }

    @Override
    public void delete(String jobScheduleId) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(jobScheduleId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String jobScheduleId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(jobScheduleId), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String jobScheduleId) {
        return this.deleteWithServiceResponseAsync(jobScheduleId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders>> deleteWithServiceResponseAsync(String jobScheduleId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobScheduleDeleteOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void delete(String jobScheduleId, JobScheduleDeleteOptions jobScheduleDeleteOptions) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(jobScheduleId, jobScheduleDeleteOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String jobScheduleId, JobScheduleDeleteOptions jobScheduleDeleteOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(jobScheduleId, jobScheduleDeleteOptions), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String jobScheduleId, JobScheduleDeleteOptions jobScheduleDeleteOptions) {
        return this.deleteWithServiceResponseAsync(jobScheduleId, jobScheduleDeleteOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders>> deleteWithServiceResponseAsync(String jobScheduleId, JobScheduleDeleteOptions jobScheduleDeleteOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleDeleteOptions);
        Integer timeout = null;
        if (jobScheduleDeleteOptions != null) {
            timeout = jobScheduleDeleteOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleDeleteOptions != null) {
            clientRequestId = jobScheduleDeleteOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleDeleteOptions != null) {
            returnClientRequestId = jobScheduleDeleteOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleDeleteOptions != null) {
            ocpDate = jobScheduleDeleteOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobScheduleDeleteOptions != null) {
            ifMatch = jobScheduleDeleteOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobScheduleDeleteOptions != null) {
            ifNoneMatch = jobScheduleDeleteOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobScheduleDeleteOptions != null) {
            ifModifiedSince = jobScheduleDeleteOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobScheduleDeleteOptions != null) {
            ifUnmodifiedSince = jobScheduleDeleteOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobScheduleDeleteHeaders> deleteDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleDeleteHeaders.class);
    }

    @Override
    public CloudJobSchedule get(String jobScheduleId) {
        return (CloudJobSchedule)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(jobScheduleId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudJobSchedule> getAsync(String jobScheduleId, ServiceCallback<CloudJobSchedule> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(jobScheduleId), serviceCallback);
    }

    @Override
    public Observable<CloudJobSchedule> getAsync(String jobScheduleId) {
        return this.getWithServiceResponseAsync(jobScheduleId).map((Func1)new Func1<ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders>, CloudJobSchedule>(){

            public CloudJobSchedule call(ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders> response) {
                return (CloudJobSchedule)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders>> getWithServiceResponseAsync(String jobScheduleId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobScheduleGetOptions = null;
        String select = null;
        String expand = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.get(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), select, expand, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CloudJobSchedule get(String jobScheduleId, JobScheduleGetOptions jobScheduleGetOptions) {
        return (CloudJobSchedule)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(jobScheduleId, jobScheduleGetOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudJobSchedule> getAsync(String jobScheduleId, JobScheduleGetOptions jobScheduleGetOptions, ServiceCallback<CloudJobSchedule> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(jobScheduleId, jobScheduleGetOptions), serviceCallback);
    }

    @Override
    public Observable<CloudJobSchedule> getAsync(String jobScheduleId, JobScheduleGetOptions jobScheduleGetOptions) {
        return this.getWithServiceResponseAsync(jobScheduleId, jobScheduleGetOptions).map((Func1)new Func1<ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders>, CloudJobSchedule>(){

            public CloudJobSchedule call(ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders> response) {
                return (CloudJobSchedule)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders>> getWithServiceResponseAsync(String jobScheduleId, JobScheduleGetOptions jobScheduleGetOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleGetOptions);
        String select = null;
        if (jobScheduleGetOptions != null) {
            select = jobScheduleGetOptions.select();
        }
        String expand = null;
        if (jobScheduleGetOptions != null) {
            expand = jobScheduleGetOptions.expand();
        }
        Integer timeout = null;
        if (jobScheduleGetOptions != null) {
            timeout = jobScheduleGetOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleGetOptions != null) {
            clientRequestId = jobScheduleGetOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleGetOptions != null) {
            returnClientRequestId = jobScheduleGetOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleGetOptions != null) {
            ocpDate = jobScheduleGetOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobScheduleGetOptions != null) {
            ifMatch = jobScheduleGetOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobScheduleGetOptions != null) {
            ifNoneMatch = jobScheduleGetOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobScheduleGetOptions != null) {
            ifModifiedSince = jobScheduleGetOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobScheduleGetOptions != null) {
            ifUnmodifiedSince = jobScheduleGetOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.get(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), select, expand, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CloudJobSchedule, JobScheduleGetHeaders> getDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CloudJobSchedule>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleGetHeaders.class);
    }

    @Override
    public void patch(String jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter) {
        ((ServiceResponseWithHeaders)this.patchWithServiceResponseAsync(jobScheduleId, jobSchedulePatchParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> patchAsync(String jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.patchWithServiceResponseAsync(jobScheduleId, jobSchedulePatchParameter), serviceCallback);
    }

    @Override
    public Observable<Void> patchAsync(String jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter) {
        return this.patchWithServiceResponseAsync(jobScheduleId, jobSchedulePatchParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders>> patchWithServiceResponseAsync(String jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (jobSchedulePatchParameter == null) {
            throw new IllegalArgumentException("Parameter jobSchedulePatchParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobSchedulePatchParameter);
        Object jobSchedulePatchOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.patch(jobScheduleId, jobSchedulePatchParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void patch(String jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter, JobSchedulePatchOptions jobSchedulePatchOptions) {
        ((ServiceResponseWithHeaders)this.patchWithServiceResponseAsync(jobScheduleId, jobSchedulePatchParameter, jobSchedulePatchOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> patchAsync(String jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter, JobSchedulePatchOptions jobSchedulePatchOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.patchWithServiceResponseAsync(jobScheduleId, jobSchedulePatchParameter, jobSchedulePatchOptions), serviceCallback);
    }

    @Override
    public Observable<Void> patchAsync(String jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter, JobSchedulePatchOptions jobSchedulePatchOptions) {
        return this.patchWithServiceResponseAsync(jobScheduleId, jobSchedulePatchParameter, jobSchedulePatchOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders>> patchWithServiceResponseAsync(String jobScheduleId, JobSchedulePatchParameter jobSchedulePatchParameter, JobSchedulePatchOptions jobSchedulePatchOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (jobSchedulePatchParameter == null) {
            throw new IllegalArgumentException("Parameter jobSchedulePatchParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobSchedulePatchParameter);
        Validator.validate((Object)jobSchedulePatchOptions);
        Integer timeout = null;
        if (jobSchedulePatchOptions != null) {
            timeout = jobSchedulePatchOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobSchedulePatchOptions != null) {
            clientRequestId = jobSchedulePatchOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobSchedulePatchOptions != null) {
            returnClientRequestId = jobSchedulePatchOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobSchedulePatchOptions != null) {
            ocpDate = jobSchedulePatchOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobSchedulePatchOptions != null) {
            ifMatch = jobSchedulePatchOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobSchedulePatchOptions != null) {
            ifNoneMatch = jobSchedulePatchOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobSchedulePatchOptions != null) {
            ifModifiedSince = jobSchedulePatchOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobSchedulePatchOptions != null) {
            ifUnmodifiedSince = jobSchedulePatchOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.patch(jobScheduleId, jobSchedulePatchParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobSchedulePatchHeaders> patchDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobSchedulePatchHeaders.class);
    }

    @Override
    public void update(String jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter) {
        ((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(jobScheduleId, jobScheduleUpdateParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateAsync(String jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(jobScheduleId, jobScheduleUpdateParameter), serviceCallback);
    }

    @Override
    public Observable<Void> updateAsync(String jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter) {
        return this.updateWithServiceResponseAsync(jobScheduleId, jobScheduleUpdateParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders>> updateWithServiceResponseAsync(String jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (jobScheduleUpdateParameter == null) {
            throw new IllegalArgumentException("Parameter jobScheduleUpdateParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleUpdateParameter);
        Object jobScheduleUpdateOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.update(jobScheduleId, jobScheduleUpdateParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void update(String jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter, JobScheduleUpdateOptions jobScheduleUpdateOptions) {
        ((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(jobScheduleId, jobScheduleUpdateParameter, jobScheduleUpdateOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateAsync(String jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter, JobScheduleUpdateOptions jobScheduleUpdateOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(jobScheduleId, jobScheduleUpdateParameter, jobScheduleUpdateOptions), serviceCallback);
    }

    @Override
    public Observable<Void> updateAsync(String jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter, JobScheduleUpdateOptions jobScheduleUpdateOptions) {
        return this.updateWithServiceResponseAsync(jobScheduleId, jobScheduleUpdateParameter, jobScheduleUpdateOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders>> updateWithServiceResponseAsync(String jobScheduleId, JobScheduleUpdateParameter jobScheduleUpdateParameter, JobScheduleUpdateOptions jobScheduleUpdateOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (jobScheduleUpdateParameter == null) {
            throw new IllegalArgumentException("Parameter jobScheduleUpdateParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleUpdateParameter);
        Validator.validate((Object)jobScheduleUpdateOptions);
        Integer timeout = null;
        if (jobScheduleUpdateOptions != null) {
            timeout = jobScheduleUpdateOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleUpdateOptions != null) {
            clientRequestId = jobScheduleUpdateOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleUpdateOptions != null) {
            returnClientRequestId = jobScheduleUpdateOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleUpdateOptions != null) {
            ocpDate = jobScheduleUpdateOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobScheduleUpdateOptions != null) {
            ifMatch = jobScheduleUpdateOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobScheduleUpdateOptions != null) {
            ifNoneMatch = jobScheduleUpdateOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobScheduleUpdateOptions != null) {
            ifModifiedSince = jobScheduleUpdateOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobScheduleUpdateOptions != null) {
            ifUnmodifiedSince = jobScheduleUpdateOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.update(jobScheduleId, jobScheduleUpdateParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobScheduleUpdateHeaders> updateDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleUpdateHeaders.class);
    }

    @Override
    public void disable(String jobScheduleId) {
        ((ServiceResponseWithHeaders)this.disableWithServiceResponseAsync(jobScheduleId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> disableAsync(String jobScheduleId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableWithServiceResponseAsync(jobScheduleId), serviceCallback);
    }

    @Override
    public Observable<Void> disableAsync(String jobScheduleId) {
        return this.disableWithServiceResponseAsync(jobScheduleId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders>> disableWithServiceResponseAsync(String jobScheduleId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobScheduleDisableOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.disable(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.disableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void disable(String jobScheduleId, JobScheduleDisableOptions jobScheduleDisableOptions) {
        ((ServiceResponseWithHeaders)this.disableWithServiceResponseAsync(jobScheduleId, jobScheduleDisableOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> disableAsync(String jobScheduleId, JobScheduleDisableOptions jobScheduleDisableOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableWithServiceResponseAsync(jobScheduleId, jobScheduleDisableOptions), serviceCallback);
    }

    @Override
    public Observable<Void> disableAsync(String jobScheduleId, JobScheduleDisableOptions jobScheduleDisableOptions) {
        return this.disableWithServiceResponseAsync(jobScheduleId, jobScheduleDisableOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders>> disableWithServiceResponseAsync(String jobScheduleId, JobScheduleDisableOptions jobScheduleDisableOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleDisableOptions);
        Integer timeout = null;
        if (jobScheduleDisableOptions != null) {
            timeout = jobScheduleDisableOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleDisableOptions != null) {
            clientRequestId = jobScheduleDisableOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleDisableOptions != null) {
            returnClientRequestId = jobScheduleDisableOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleDisableOptions != null) {
            ocpDate = jobScheduleDisableOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobScheduleDisableOptions != null) {
            ifMatch = jobScheduleDisableOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobScheduleDisableOptions != null) {
            ifNoneMatch = jobScheduleDisableOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobScheduleDisableOptions != null) {
            ifModifiedSince = jobScheduleDisableOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobScheduleDisableOptions != null) {
            ifUnmodifiedSince = jobScheduleDisableOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.disable(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.disableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobScheduleDisableHeaders> disableDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleDisableHeaders.class);
    }

    @Override
    public void enable(String jobScheduleId) {
        ((ServiceResponseWithHeaders)this.enableWithServiceResponseAsync(jobScheduleId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> enableAsync(String jobScheduleId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.enableWithServiceResponseAsync(jobScheduleId), serviceCallback);
    }

    @Override
    public Observable<Void> enableAsync(String jobScheduleId) {
        return this.enableWithServiceResponseAsync(jobScheduleId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders>> enableWithServiceResponseAsync(String jobScheduleId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobScheduleEnableOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.enable(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.enableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void enable(String jobScheduleId, JobScheduleEnableOptions jobScheduleEnableOptions) {
        ((ServiceResponseWithHeaders)this.enableWithServiceResponseAsync(jobScheduleId, jobScheduleEnableOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> enableAsync(String jobScheduleId, JobScheduleEnableOptions jobScheduleEnableOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.enableWithServiceResponseAsync(jobScheduleId, jobScheduleEnableOptions), serviceCallback);
    }

    @Override
    public Observable<Void> enableAsync(String jobScheduleId, JobScheduleEnableOptions jobScheduleEnableOptions) {
        return this.enableWithServiceResponseAsync(jobScheduleId, jobScheduleEnableOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders>> enableWithServiceResponseAsync(String jobScheduleId, JobScheduleEnableOptions jobScheduleEnableOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleEnableOptions);
        Integer timeout = null;
        if (jobScheduleEnableOptions != null) {
            timeout = jobScheduleEnableOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleEnableOptions != null) {
            clientRequestId = jobScheduleEnableOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleEnableOptions != null) {
            returnClientRequestId = jobScheduleEnableOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleEnableOptions != null) {
            ocpDate = jobScheduleEnableOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobScheduleEnableOptions != null) {
            ifMatch = jobScheduleEnableOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobScheduleEnableOptions != null) {
            ifNoneMatch = jobScheduleEnableOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobScheduleEnableOptions != null) {
            ifModifiedSince = jobScheduleEnableOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobScheduleEnableOptions != null) {
            ifUnmodifiedSince = jobScheduleEnableOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.enable(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.enableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobScheduleEnableHeaders> enableDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleEnableHeaders.class);
    }

    @Override
    public void terminate(String jobScheduleId) {
        ((ServiceResponseWithHeaders)this.terminateWithServiceResponseAsync(jobScheduleId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> terminateAsync(String jobScheduleId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.terminateWithServiceResponseAsync(jobScheduleId), serviceCallback);
    }

    @Override
    public Observable<Void> terminateAsync(String jobScheduleId) {
        return this.terminateWithServiceResponseAsync(jobScheduleId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders>> terminateWithServiceResponseAsync(String jobScheduleId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobScheduleTerminateOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.terminate(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.terminateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void terminate(String jobScheduleId, JobScheduleTerminateOptions jobScheduleTerminateOptions) {
        ((ServiceResponseWithHeaders)this.terminateWithServiceResponseAsync(jobScheduleId, jobScheduleTerminateOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> terminateAsync(String jobScheduleId, JobScheduleTerminateOptions jobScheduleTerminateOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.terminateWithServiceResponseAsync(jobScheduleId, jobScheduleTerminateOptions), serviceCallback);
    }

    @Override
    public Observable<Void> terminateAsync(String jobScheduleId, JobScheduleTerminateOptions jobScheduleTerminateOptions) {
        return this.terminateWithServiceResponseAsync(jobScheduleId, jobScheduleTerminateOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders>> terminateWithServiceResponseAsync(String jobScheduleId, JobScheduleTerminateOptions jobScheduleTerminateOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleTerminateOptions);
        Integer timeout = null;
        if (jobScheduleTerminateOptions != null) {
            timeout = jobScheduleTerminateOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleTerminateOptions != null) {
            clientRequestId = jobScheduleTerminateOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleTerminateOptions != null) {
            returnClientRequestId = jobScheduleTerminateOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleTerminateOptions != null) {
            ocpDate = jobScheduleTerminateOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobScheduleTerminateOptions != null) {
            ifMatch = jobScheduleTerminateOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobScheduleTerminateOptions != null) {
            ifNoneMatch = jobScheduleTerminateOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobScheduleTerminateOptions != null) {
            ifModifiedSince = jobScheduleTerminateOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobScheduleTerminateOptions != null) {
            ifUnmodifiedSince = jobScheduleTerminateOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.terminate(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.terminateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobScheduleTerminateHeaders> terminateDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleTerminateHeaders.class);
    }

    @Override
    public void add(JobScheduleAddParameter cloudJobSchedule) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(cloudJobSchedule).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(JobScheduleAddParameter cloudJobSchedule, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(cloudJobSchedule), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(JobScheduleAddParameter cloudJobSchedule) {
        return this.addWithServiceResponseAsync(cloudJobSchedule).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleAddHeaders>> addWithServiceResponseAsync(JobScheduleAddParameter cloudJobSchedule) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (cloudJobSchedule == null) {
            throw new IllegalArgumentException("Parameter cloudJobSchedule is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)cloudJobSchedule);
        Object jobScheduleAddOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(cloudJobSchedule, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void add(JobScheduleAddParameter cloudJobSchedule, JobScheduleAddOptions jobScheduleAddOptions) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(cloudJobSchedule, jobScheduleAddOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(JobScheduleAddParameter cloudJobSchedule, JobScheduleAddOptions jobScheduleAddOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(cloudJobSchedule, jobScheduleAddOptions), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(JobScheduleAddParameter cloudJobSchedule, JobScheduleAddOptions jobScheduleAddOptions) {
        return this.addWithServiceResponseAsync(cloudJobSchedule, jobScheduleAddOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobScheduleAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobScheduleAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobScheduleAddHeaders>> addWithServiceResponseAsync(JobScheduleAddParameter cloudJobSchedule, JobScheduleAddOptions jobScheduleAddOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (cloudJobSchedule == null) {
            throw new IllegalArgumentException("Parameter cloudJobSchedule is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)cloudJobSchedule);
        Validator.validate((Object)jobScheduleAddOptions);
        Integer timeout = null;
        if (jobScheduleAddOptions != null) {
            timeout = jobScheduleAddOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleAddOptions != null) {
            clientRequestId = jobScheduleAddOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleAddOptions != null) {
            returnClientRequestId = jobScheduleAddOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleAddOptions != null) {
            ocpDate = jobScheduleAddOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(cloudJobSchedule, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobScheduleAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobScheduleAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobSchedulesImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobScheduleAddHeaders> addDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleAddHeaders.class);
    }

    @Override
    public PagedList<CloudJobSchedule> list() {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<CloudJobSchedule>((Page)response.body()){

            public Page<CloudJobSchedule> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobSchedulesImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJobSchedule>> listAsync(ListOperationCallback<CloudJobSchedule> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(String nextPageLink) {
                return JobSchedulesImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJobSchedule>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>, Page<CloudJobSchedule>>(){

            public Page<CloudJobSchedule> call(ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobSchedulesImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> listSinglePageAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobScheduleListOptions = null;
        String filter = null;
        String select = null;
        String expand = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobSchedulesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudJobSchedule> list(final JobScheduleListOptions jobScheduleListOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(jobScheduleListOptions).toBlocking().single();
        return new PagedList<CloudJobSchedule>((Page)response.body()){

            public Page<CloudJobSchedule> nextPage(String nextPageLink) {
                JobScheduleListNextOptions jobScheduleListNextOptions = null;
                if (jobScheduleListOptions != null) {
                    jobScheduleListNextOptions = new JobScheduleListNextOptions();
                    jobScheduleListNextOptions.withClientRequestId(jobScheduleListOptions.clientRequestId());
                    jobScheduleListNextOptions.withReturnClientRequestId(jobScheduleListOptions.returnClientRequestId());
                    jobScheduleListNextOptions.withOcpDate(jobScheduleListOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)JobSchedulesImpl.this.listNextSinglePageAsync(nextPageLink, jobScheduleListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJobSchedule>> listAsync(final JobScheduleListOptions jobScheduleListOptions, ListOperationCallback<CloudJobSchedule> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(jobScheduleListOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(String nextPageLink) {
                JobScheduleListNextOptions jobScheduleListNextOptions = null;
                if (jobScheduleListOptions != null) {
                    jobScheduleListNextOptions = new JobScheduleListNextOptions();
                    jobScheduleListNextOptions.withClientRequestId(jobScheduleListOptions.clientRequestId());
                    jobScheduleListNextOptions.withReturnClientRequestId(jobScheduleListOptions.returnClientRequestId());
                    jobScheduleListNextOptions.withOcpDate(jobScheduleListOptions.ocpDate());
                }
                return JobSchedulesImpl.this.listNextSinglePageAsync(nextPageLink, jobScheduleListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJobSchedule>> listAsync(JobScheduleListOptions jobScheduleListOptions) {
        return this.listWithServiceResponseAsync(jobScheduleListOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>, Page<CloudJobSchedule>>(){

            public Page<CloudJobSchedule> call(ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> listWithServiceResponseAsync(final JobScheduleListOptions jobScheduleListOptions) {
        return this.listSinglePageAsync(jobScheduleListOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                JobScheduleListNextOptions jobScheduleListNextOptions = null;
                if (jobScheduleListOptions != null) {
                    jobScheduleListNextOptions = new JobScheduleListNextOptions();
                    jobScheduleListNextOptions.withClientRequestId(jobScheduleListOptions.clientRequestId());
                    jobScheduleListNextOptions.withReturnClientRequestId(jobScheduleListOptions.returnClientRequestId());
                    jobScheduleListNextOptions.withOcpDate(jobScheduleListOptions.ocpDate());
                }
                return Observable.just(page).concatWith(JobSchedulesImpl.this.listNextWithServiceResponseAsync(nextPageLink, jobScheduleListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> listSinglePageAsync(JobScheduleListOptions jobScheduleListOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleListOptions);
        String filter = null;
        if (jobScheduleListOptions != null) {
            filter = jobScheduleListOptions.filter();
        }
        String select = null;
        if (jobScheduleListOptions != null) {
            select = jobScheduleListOptions.select();
        }
        String expand = null;
        if (jobScheduleListOptions != null) {
            expand = jobScheduleListOptions.expand();
        }
        Integer maxResults = null;
        if (jobScheduleListOptions != null) {
            maxResults = jobScheduleListOptions.maxResults();
        }
        Integer timeout = null;
        if (jobScheduleListOptions != null) {
            timeout = jobScheduleListOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobScheduleListOptions != null) {
            clientRequestId = jobScheduleListOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleListOptions != null) {
            returnClientRequestId = jobScheduleListOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleListOptions != null) {
            ocpDate = jobScheduleListOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobSchedulesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudJobSchedule>, JobScheduleListHeaders> listDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudJobSchedule>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleListHeaders.class);
    }

    @Override
    public PagedList<CloudJobSchedule> listNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CloudJobSchedule>((Page)response.body()){

            public Page<CloudJobSchedule> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobSchedulesImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJobSchedule>> listNextAsync(String nextPageLink, ServiceFuture<List<CloudJobSchedule>> serviceFuture, ListOperationCallback<CloudJobSchedule> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(String nextPageLink) {
                return JobSchedulesImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJobSchedule>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>, Page<CloudJobSchedule>>(){

            public Page<CloudJobSchedule> call(ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobSchedulesImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object jobScheduleListNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobSchedulesImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudJobSchedule> listNext(String nextPageLink, final JobScheduleListNextOptions jobScheduleListNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink, jobScheduleListNextOptions).toBlocking().single();
        return new PagedList<CloudJobSchedule>((Page)response.body()){

            public Page<CloudJobSchedule> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobSchedulesImpl.this.listNextSinglePageAsync(nextPageLink, jobScheduleListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJobSchedule>> listNextAsync(String nextPageLink, final JobScheduleListNextOptions jobScheduleListNextOptions, ServiceFuture<List<CloudJobSchedule>> serviceFuture, ListOperationCallback<CloudJobSchedule> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink, jobScheduleListNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(String nextPageLink) {
                return JobSchedulesImpl.this.listNextSinglePageAsync(nextPageLink, jobScheduleListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJobSchedule>> listNextAsync(String nextPageLink, JobScheduleListNextOptions jobScheduleListNextOptions) {
        return this.listNextWithServiceResponseAsync(nextPageLink, jobScheduleListNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>, Page<CloudJobSchedule>>(){

            public Page<CloudJobSchedule> call(ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> listNextWithServiceResponseAsync(String nextPageLink, final JobScheduleListNextOptions jobScheduleListNextOptions) {
        return this.listNextSinglePageAsync(nextPageLink, jobScheduleListNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobSchedulesImpl.this.listNextWithServiceResponseAsync(nextPageLink, jobScheduleListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> listNextSinglePageAsync(String nextPageLink, JobScheduleListNextOptions jobScheduleListNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)jobScheduleListNextOptions);
        UUID clientRequestId = null;
        if (jobScheduleListNextOptions != null) {
            clientRequestId = jobScheduleListNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobScheduleListNextOptions != null) {
            returnClientRequestId = jobScheduleListNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobScheduleListNextOptions != null) {
            ocpDate = jobScheduleListNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJobSchedule>, JobScheduleListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobSchedulesImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudJobSchedule>, JobScheduleListHeaders> listNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudJobSchedule>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobScheduleListHeaders.class);
    }

    static interface JobSchedulesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules exists"})
        @HEAD(value="jobschedules/{jobScheduleId}")
        public Observable<Response<Void>> exists(@Path(value="jobScheduleId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules delete"})
        @HTTP(path="jobschedules/{jobScheduleId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="jobScheduleId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules get"})
        @GET(value="jobschedules/{jobScheduleId}")
        public Observable<Response<ResponseBody>> get(@Path(value="jobScheduleId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$select") String var4, @Query(value="$expand") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="If-Match") String var10, @Header(value="If-None-Match") String var11, @Header(value="If-Modified-Since") DateTimeRfc1123 var12, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var13, @Header(value="x-ms-parameterized-host") String var14, @Header(value="User-Agent") String var15);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules patch"})
        @PATCH(value="jobschedules/{jobScheduleId}")
        public Observable<Response<ResponseBody>> patch(@Path(value="jobScheduleId") String var1, @Body JobSchedulePatchParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules update"})
        @PUT(value="jobschedules/{jobScheduleId}")
        public Observable<Response<ResponseBody>> update(@Path(value="jobScheduleId") String var1, @Body JobScheduleUpdateParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules disable"})
        @POST(value="jobschedules/{jobScheduleId}/disable")
        public Observable<Response<ResponseBody>> disable(@Path(value="jobScheduleId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules enable"})
        @POST(value="jobschedules/{jobScheduleId}/enable")
        public Observable<Response<ResponseBody>> enable(@Path(value="jobScheduleId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules terminate"})
        @POST(value="jobschedules/{jobScheduleId}/terminate")
        public Observable<Response<ResponseBody>> terminate(@Path(value="jobScheduleId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules add"})
        @POST(value="jobschedules")
        public Observable<Response<ResponseBody>> add(@Body JobScheduleAddParameter var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules list"})
        @GET(value="jobschedules")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="$filter") String var3, @Query(value="$select") String var4, @Query(value="$expand") String var5, @Query(value="maxresults") Integer var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.JobSchedules listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

