/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.Jobs;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.CloudJob;
import com.microsoft.azure.batch.protocol.models.DisableJobOption;
import com.microsoft.azure.batch.protocol.models.JobAddHeaders;
import com.microsoft.azure.batch.protocol.models.JobAddOptions;
import com.microsoft.azure.batch.protocol.models.JobAddParameter;
import com.microsoft.azure.batch.protocol.models.JobDeleteHeaders;
import com.microsoft.azure.batch.protocol.models.JobDeleteOptions;
import com.microsoft.azure.batch.protocol.models.JobDisableHeaders;
import com.microsoft.azure.batch.protocol.models.JobDisableOptions;
import com.microsoft.azure.batch.protocol.models.JobDisableParameter;
import com.microsoft.azure.batch.protocol.models.JobEnableHeaders;
import com.microsoft.azure.batch.protocol.models.JobEnableOptions;
import com.microsoft.azure.batch.protocol.models.JobGetAllLifetimeStatisticsHeaders;
import com.microsoft.azure.batch.protocol.models.JobGetAllLifetimeStatisticsOptions;
import com.microsoft.azure.batch.protocol.models.JobGetHeaders;
import com.microsoft.azure.batch.protocol.models.JobGetOptions;
import com.microsoft.azure.batch.protocol.models.JobGetTaskCountsHeaders;
import com.microsoft.azure.batch.protocol.models.JobGetTaskCountsOptions;
import com.microsoft.azure.batch.protocol.models.JobListFromJobScheduleHeaders;
import com.microsoft.azure.batch.protocol.models.JobListFromJobScheduleNextOptions;
import com.microsoft.azure.batch.protocol.models.JobListFromJobScheduleOptions;
import com.microsoft.azure.batch.protocol.models.JobListHeaders;
import com.microsoft.azure.batch.protocol.models.JobListNextOptions;
import com.microsoft.azure.batch.protocol.models.JobListOptions;
import com.microsoft.azure.batch.protocol.models.JobListPreparationAndReleaseTaskStatusHeaders;
import com.microsoft.azure.batch.protocol.models.JobListPreparationAndReleaseTaskStatusNextOptions;
import com.microsoft.azure.batch.protocol.models.JobListPreparationAndReleaseTaskStatusOptions;
import com.microsoft.azure.batch.protocol.models.JobPatchHeaders;
import com.microsoft.azure.batch.protocol.models.JobPatchOptions;
import com.microsoft.azure.batch.protocol.models.JobPatchParameter;
import com.microsoft.azure.batch.protocol.models.JobPreparationAndReleaseTaskExecutionInformation;
import com.microsoft.azure.batch.protocol.models.JobStatistics;
import com.microsoft.azure.batch.protocol.models.JobTerminateHeaders;
import com.microsoft.azure.batch.protocol.models.JobTerminateOptions;
import com.microsoft.azure.batch.protocol.models.JobTerminateParameter;
import com.microsoft.azure.batch.protocol.models.JobUpdateHeaders;
import com.microsoft.azure.batch.protocol.models.JobUpdateOptions;
import com.microsoft.azure.batch.protocol.models.JobUpdateParameter;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.azure.batch.protocol.models.TaskCountsResult;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobsImpl
implements Jobs {
    private JobsService service;
    private BatchServiceClientImpl client;

    public JobsImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (JobsService)retrofit.create(JobsService.class);
        this.client = client;
    }

    @Override
    public JobStatistics getAllLifetimeStatistics() {
        return (JobStatistics)((ServiceResponseWithHeaders)this.getAllLifetimeStatisticsWithServiceResponseAsync().toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobStatistics> getAllLifetimeStatisticsAsync(ServiceCallback<JobStatistics> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getAllLifetimeStatisticsWithServiceResponseAsync(), serviceCallback);
    }

    @Override
    public Observable<JobStatistics> getAllLifetimeStatisticsAsync() {
        return this.getAllLifetimeStatisticsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders>, JobStatistics>(){

            public JobStatistics call(ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders> response) {
                return (JobStatistics)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders>> getAllLifetimeStatisticsWithServiceResponseAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobGetAllLifetimeStatisticsOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.getAllLifetimeStatistics(this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.getAllLifetimeStatisticsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public JobStatistics getAllLifetimeStatistics(JobGetAllLifetimeStatisticsOptions jobGetAllLifetimeStatisticsOptions) {
        return (JobStatistics)((ServiceResponseWithHeaders)this.getAllLifetimeStatisticsWithServiceResponseAsync(jobGetAllLifetimeStatisticsOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<JobStatistics> getAllLifetimeStatisticsAsync(JobGetAllLifetimeStatisticsOptions jobGetAllLifetimeStatisticsOptions, ServiceCallback<JobStatistics> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getAllLifetimeStatisticsWithServiceResponseAsync(jobGetAllLifetimeStatisticsOptions), serviceCallback);
    }

    @Override
    public Observable<JobStatistics> getAllLifetimeStatisticsAsync(JobGetAllLifetimeStatisticsOptions jobGetAllLifetimeStatisticsOptions) {
        return this.getAllLifetimeStatisticsWithServiceResponseAsync(jobGetAllLifetimeStatisticsOptions).map((Func1)new Func1<ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders>, JobStatistics>(){

            public JobStatistics call(ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders> response) {
                return (JobStatistics)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders>> getAllLifetimeStatisticsWithServiceResponseAsync(JobGetAllLifetimeStatisticsOptions jobGetAllLifetimeStatisticsOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobGetAllLifetimeStatisticsOptions);
        Integer timeout = null;
        if (jobGetAllLifetimeStatisticsOptions != null) {
            timeout = jobGetAllLifetimeStatisticsOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobGetAllLifetimeStatisticsOptions != null) {
            clientRequestId = jobGetAllLifetimeStatisticsOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobGetAllLifetimeStatisticsOptions != null) {
            returnClientRequestId = jobGetAllLifetimeStatisticsOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobGetAllLifetimeStatisticsOptions != null) {
            ocpDate = jobGetAllLifetimeStatisticsOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.getAllLifetimeStatistics(this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.getAllLifetimeStatisticsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<JobStatistics, JobGetAllLifetimeStatisticsHeaders> getAllLifetimeStatisticsDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobStatistics>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobGetAllLifetimeStatisticsHeaders.class);
    }

    @Override
    public void delete(String jobId) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(jobId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String jobId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(jobId), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String jobId) {
        return this.deleteWithServiceResponseAsync(jobId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobDeleteHeaders>> deleteWithServiceResponseAsync(String jobId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobDeleteOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void delete(String jobId, JobDeleteOptions jobDeleteOptions) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(jobId, jobDeleteOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String jobId, JobDeleteOptions jobDeleteOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(jobId, jobDeleteOptions), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String jobId, JobDeleteOptions jobDeleteOptions) {
        return this.deleteWithServiceResponseAsync(jobId, jobDeleteOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobDeleteHeaders>> deleteWithServiceResponseAsync(String jobId, JobDeleteOptions jobDeleteOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobDeleteOptions);
        Integer timeout = null;
        if (jobDeleteOptions != null) {
            timeout = jobDeleteOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobDeleteOptions != null) {
            clientRequestId = jobDeleteOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobDeleteOptions != null) {
            returnClientRequestId = jobDeleteOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobDeleteOptions != null) {
            ocpDate = jobDeleteOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobDeleteOptions != null) {
            ifMatch = jobDeleteOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobDeleteOptions != null) {
            ifNoneMatch = jobDeleteOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobDeleteOptions != null) {
            ifModifiedSince = jobDeleteOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobDeleteOptions != null) {
            ifUnmodifiedSince = jobDeleteOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobDeleteHeaders> deleteDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobDeleteHeaders.class);
    }

    @Override
    public CloudJob get(String jobId) {
        return (CloudJob)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(jobId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudJob> getAsync(String jobId, ServiceCallback<CloudJob> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(jobId), serviceCallback);
    }

    @Override
    public Observable<CloudJob> getAsync(String jobId) {
        return this.getWithServiceResponseAsync(jobId).map((Func1)new Func1<ServiceResponseWithHeaders<CloudJob, JobGetHeaders>, CloudJob>(){

            public CloudJob call(ServiceResponseWithHeaders<CloudJob, JobGetHeaders> response) {
                return (CloudJob)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudJob, JobGetHeaders>> getWithServiceResponseAsync(String jobId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobGetOptions = null;
        String select = null;
        String expand = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.get(jobId, this.client.apiVersion(), this.client.acceptLanguage(), select, expand, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudJob, JobGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudJob, JobGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CloudJob get(String jobId, JobGetOptions jobGetOptions) {
        return (CloudJob)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(jobId, jobGetOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudJob> getAsync(String jobId, JobGetOptions jobGetOptions, ServiceCallback<CloudJob> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(jobId, jobGetOptions), serviceCallback);
    }

    @Override
    public Observable<CloudJob> getAsync(String jobId, JobGetOptions jobGetOptions) {
        return this.getWithServiceResponseAsync(jobId, jobGetOptions).map((Func1)new Func1<ServiceResponseWithHeaders<CloudJob, JobGetHeaders>, CloudJob>(){

            public CloudJob call(ServiceResponseWithHeaders<CloudJob, JobGetHeaders> response) {
                return (CloudJob)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudJob, JobGetHeaders>> getWithServiceResponseAsync(String jobId, JobGetOptions jobGetOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobGetOptions);
        String select = null;
        if (jobGetOptions != null) {
            select = jobGetOptions.select();
        }
        String expand = null;
        if (jobGetOptions != null) {
            expand = jobGetOptions.expand();
        }
        Integer timeout = null;
        if (jobGetOptions != null) {
            timeout = jobGetOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobGetOptions != null) {
            clientRequestId = jobGetOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobGetOptions != null) {
            returnClientRequestId = jobGetOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobGetOptions != null) {
            ocpDate = jobGetOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobGetOptions != null) {
            ifMatch = jobGetOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobGetOptions != null) {
            ifNoneMatch = jobGetOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobGetOptions != null) {
            ifModifiedSince = jobGetOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobGetOptions != null) {
            ifUnmodifiedSince = jobGetOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.get(jobId, this.client.apiVersion(), this.client.acceptLanguage(), select, expand, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudJob, JobGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudJob, JobGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CloudJob, JobGetHeaders> getDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CloudJob>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobGetHeaders.class);
    }

    @Override
    public void patch(String jobId, JobPatchParameter jobPatchParameter) {
        ((ServiceResponseWithHeaders)this.patchWithServiceResponseAsync(jobId, jobPatchParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> patchAsync(String jobId, JobPatchParameter jobPatchParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.patchWithServiceResponseAsync(jobId, jobPatchParameter), serviceCallback);
    }

    @Override
    public Observable<Void> patchAsync(String jobId, JobPatchParameter jobPatchParameter) {
        return this.patchWithServiceResponseAsync(jobId, jobPatchParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobPatchHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobPatchHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobPatchHeaders>> patchWithServiceResponseAsync(String jobId, JobPatchParameter jobPatchParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (jobPatchParameter == null) {
            throw new IllegalArgumentException("Parameter jobPatchParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobPatchParameter);
        Object jobPatchOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.patch(jobId, jobPatchParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobPatchHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobPatchHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void patch(String jobId, JobPatchParameter jobPatchParameter, JobPatchOptions jobPatchOptions) {
        ((ServiceResponseWithHeaders)this.patchWithServiceResponseAsync(jobId, jobPatchParameter, jobPatchOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> patchAsync(String jobId, JobPatchParameter jobPatchParameter, JobPatchOptions jobPatchOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.patchWithServiceResponseAsync(jobId, jobPatchParameter, jobPatchOptions), serviceCallback);
    }

    @Override
    public Observable<Void> patchAsync(String jobId, JobPatchParameter jobPatchParameter, JobPatchOptions jobPatchOptions) {
        return this.patchWithServiceResponseAsync(jobId, jobPatchParameter, jobPatchOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobPatchHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobPatchHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobPatchHeaders>> patchWithServiceResponseAsync(String jobId, JobPatchParameter jobPatchParameter, JobPatchOptions jobPatchOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (jobPatchParameter == null) {
            throw new IllegalArgumentException("Parameter jobPatchParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobPatchParameter);
        Validator.validate((Object)jobPatchOptions);
        Integer timeout = null;
        if (jobPatchOptions != null) {
            timeout = jobPatchOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobPatchOptions != null) {
            clientRequestId = jobPatchOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobPatchOptions != null) {
            returnClientRequestId = jobPatchOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobPatchOptions != null) {
            ocpDate = jobPatchOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobPatchOptions != null) {
            ifMatch = jobPatchOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobPatchOptions != null) {
            ifNoneMatch = jobPatchOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobPatchOptions != null) {
            ifModifiedSince = jobPatchOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobPatchOptions != null) {
            ifUnmodifiedSince = jobPatchOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.patch(jobId, jobPatchParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobPatchHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobPatchHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobPatchHeaders> patchDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobPatchHeaders.class);
    }

    @Override
    public void update(String jobId, JobUpdateParameter jobUpdateParameter) {
        ((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(jobId, jobUpdateParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateAsync(String jobId, JobUpdateParameter jobUpdateParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(jobId, jobUpdateParameter), serviceCallback);
    }

    @Override
    public Observable<Void> updateAsync(String jobId, JobUpdateParameter jobUpdateParameter) {
        return this.updateWithServiceResponseAsync(jobId, jobUpdateParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobUpdateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobUpdateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobUpdateHeaders>> updateWithServiceResponseAsync(String jobId, JobUpdateParameter jobUpdateParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (jobUpdateParameter == null) {
            throw new IllegalArgumentException("Parameter jobUpdateParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobUpdateParameter);
        Object jobUpdateOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.update(jobId, jobUpdateParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void update(String jobId, JobUpdateParameter jobUpdateParameter, JobUpdateOptions jobUpdateOptions) {
        ((ServiceResponseWithHeaders)this.updateWithServiceResponseAsync(jobId, jobUpdateParameter, jobUpdateOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updateAsync(String jobId, JobUpdateParameter jobUpdateParameter, JobUpdateOptions jobUpdateOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updateWithServiceResponseAsync(jobId, jobUpdateParameter, jobUpdateOptions), serviceCallback);
    }

    @Override
    public Observable<Void> updateAsync(String jobId, JobUpdateParameter jobUpdateParameter, JobUpdateOptions jobUpdateOptions) {
        return this.updateWithServiceResponseAsync(jobId, jobUpdateParameter, jobUpdateOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobUpdateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobUpdateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobUpdateHeaders>> updateWithServiceResponseAsync(String jobId, JobUpdateParameter jobUpdateParameter, JobUpdateOptions jobUpdateOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (jobUpdateParameter == null) {
            throw new IllegalArgumentException("Parameter jobUpdateParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobUpdateParameter);
        Validator.validate((Object)jobUpdateOptions);
        Integer timeout = null;
        if (jobUpdateOptions != null) {
            timeout = jobUpdateOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobUpdateOptions != null) {
            clientRequestId = jobUpdateOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobUpdateOptions != null) {
            returnClientRequestId = jobUpdateOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobUpdateOptions != null) {
            ocpDate = jobUpdateOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobUpdateOptions != null) {
            ifMatch = jobUpdateOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobUpdateOptions != null) {
            ifNoneMatch = jobUpdateOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobUpdateOptions != null) {
            ifModifiedSince = jobUpdateOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobUpdateOptions != null) {
            ifUnmodifiedSince = jobUpdateOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.update(jobId, jobUpdateParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobUpdateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobUpdateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobUpdateHeaders> updateDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobUpdateHeaders.class);
    }

    @Override
    public void disable(String jobId, DisableJobOption disableTasks) {
        ((ServiceResponseWithHeaders)this.disableWithServiceResponseAsync(jobId, disableTasks).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> disableAsync(String jobId, DisableJobOption disableTasks, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableWithServiceResponseAsync(jobId, disableTasks), serviceCallback);
    }

    @Override
    public Observable<Void> disableAsync(String jobId, DisableJobOption disableTasks) {
        return this.disableWithServiceResponseAsync(jobId, disableTasks).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobDisableHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobDisableHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobDisableHeaders>> disableWithServiceResponseAsync(String jobId, DisableJobOption disableTasks) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (disableTasks == null) {
            throw new IllegalArgumentException("Parameter disableTasks is required and cannot be null.");
        }
        Object jobDisableOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        JobDisableParameter jobDisableParameter = new JobDisableParameter();
        jobDisableParameter.withDisableTasks(disableTasks);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.disable(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, jobDisableParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobDisableHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobDisableHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.disableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void disable(String jobId, DisableJobOption disableTasks, JobDisableOptions jobDisableOptions) {
        ((ServiceResponseWithHeaders)this.disableWithServiceResponseAsync(jobId, disableTasks, jobDisableOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> disableAsync(String jobId, DisableJobOption disableTasks, JobDisableOptions jobDisableOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableWithServiceResponseAsync(jobId, disableTasks, jobDisableOptions), serviceCallback);
    }

    @Override
    public Observable<Void> disableAsync(String jobId, DisableJobOption disableTasks, JobDisableOptions jobDisableOptions) {
        return this.disableWithServiceResponseAsync(jobId, disableTasks, jobDisableOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobDisableHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobDisableHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobDisableHeaders>> disableWithServiceResponseAsync(String jobId, DisableJobOption disableTasks, JobDisableOptions jobDisableOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (disableTasks == null) {
            throw new IllegalArgumentException("Parameter disableTasks is required and cannot be null.");
        }
        Validator.validate((Object)jobDisableOptions);
        Integer timeout = null;
        if (jobDisableOptions != null) {
            timeout = jobDisableOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobDisableOptions != null) {
            clientRequestId = jobDisableOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobDisableOptions != null) {
            returnClientRequestId = jobDisableOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobDisableOptions != null) {
            ocpDate = jobDisableOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobDisableOptions != null) {
            ifMatch = jobDisableOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobDisableOptions != null) {
            ifNoneMatch = jobDisableOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobDisableOptions != null) {
            ifModifiedSince = jobDisableOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobDisableOptions != null) {
            ifUnmodifiedSince = jobDisableOptions.ifUnmodifiedSince();
        }
        JobDisableParameter jobDisableParameter = new JobDisableParameter();
        jobDisableParameter.withDisableTasks(disableTasks);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.disable(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, jobDisableParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobDisableHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobDisableHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.disableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobDisableHeaders> disableDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobDisableHeaders.class);
    }

    @Override
    public void enable(String jobId) {
        ((ServiceResponseWithHeaders)this.enableWithServiceResponseAsync(jobId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> enableAsync(String jobId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.enableWithServiceResponseAsync(jobId), serviceCallback);
    }

    @Override
    public Observable<Void> enableAsync(String jobId) {
        return this.enableWithServiceResponseAsync(jobId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobEnableHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobEnableHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobEnableHeaders>> enableWithServiceResponseAsync(String jobId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobEnableOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.enable(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobEnableHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobEnableHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.enableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void enable(String jobId, JobEnableOptions jobEnableOptions) {
        ((ServiceResponseWithHeaders)this.enableWithServiceResponseAsync(jobId, jobEnableOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> enableAsync(String jobId, JobEnableOptions jobEnableOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.enableWithServiceResponseAsync(jobId, jobEnableOptions), serviceCallback);
    }

    @Override
    public Observable<Void> enableAsync(String jobId, JobEnableOptions jobEnableOptions) {
        return this.enableWithServiceResponseAsync(jobId, jobEnableOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobEnableHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobEnableHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobEnableHeaders>> enableWithServiceResponseAsync(String jobId, JobEnableOptions jobEnableOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobEnableOptions);
        Integer timeout = null;
        if (jobEnableOptions != null) {
            timeout = jobEnableOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobEnableOptions != null) {
            clientRequestId = jobEnableOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobEnableOptions != null) {
            returnClientRequestId = jobEnableOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobEnableOptions != null) {
            ocpDate = jobEnableOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobEnableOptions != null) {
            ifMatch = jobEnableOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobEnableOptions != null) {
            ifNoneMatch = jobEnableOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobEnableOptions != null) {
            ifModifiedSince = jobEnableOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobEnableOptions != null) {
            ifUnmodifiedSince = jobEnableOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.enable(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobEnableHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobEnableHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.enableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobEnableHeaders> enableDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobEnableHeaders.class);
    }

    @Override
    public void terminate(String jobId) {
        ((ServiceResponseWithHeaders)this.terminateWithServiceResponseAsync(jobId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> terminateAsync(String jobId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.terminateWithServiceResponseAsync(jobId), serviceCallback);
    }

    @Override
    public Observable<Void> terminateAsync(String jobId) {
        return this.terminateWithServiceResponseAsync(jobId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobTerminateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobTerminateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobTerminateHeaders>> terminateWithServiceResponseAsync(String jobId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object terminateReason = null;
        Object jobTerminateOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        JobTerminateParameter jobTerminateParameter = new JobTerminateParameter();
        jobTerminateParameter.withTerminateReason(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.terminate(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, jobTerminateParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobTerminateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobTerminateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.terminateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void terminate(String jobId, String terminateReason, JobTerminateOptions jobTerminateOptions) {
        ((ServiceResponseWithHeaders)this.terminateWithServiceResponseAsync(jobId, terminateReason, jobTerminateOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> terminateAsync(String jobId, String terminateReason, JobTerminateOptions jobTerminateOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.terminateWithServiceResponseAsync(jobId, terminateReason, jobTerminateOptions), serviceCallback);
    }

    @Override
    public Observable<Void> terminateAsync(String jobId, String terminateReason, JobTerminateOptions jobTerminateOptions) {
        return this.terminateWithServiceResponseAsync(jobId, terminateReason, jobTerminateOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobTerminateHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobTerminateHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobTerminateHeaders>> terminateWithServiceResponseAsync(String jobId, String terminateReason, JobTerminateOptions jobTerminateOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobTerminateOptions);
        Integer timeout = null;
        if (jobTerminateOptions != null) {
            timeout = jobTerminateOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobTerminateOptions != null) {
            clientRequestId = jobTerminateOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobTerminateOptions != null) {
            returnClientRequestId = jobTerminateOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobTerminateOptions != null) {
            ocpDate = jobTerminateOptions.ocpDate();
        }
        String ifMatch = null;
        if (jobTerminateOptions != null) {
            ifMatch = jobTerminateOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (jobTerminateOptions != null) {
            ifNoneMatch = jobTerminateOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (jobTerminateOptions != null) {
            ifModifiedSince = jobTerminateOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (jobTerminateOptions != null) {
            ifUnmodifiedSince = jobTerminateOptions.ifUnmodifiedSince();
        }
        JobTerminateParameter jobTerminateParameter = null;
        if (terminateReason != null) {
            jobTerminateParameter = new JobTerminateParameter();
            jobTerminateParameter.withTerminateReason(terminateReason);
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.terminate(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, jobTerminateParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobTerminateHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobTerminateHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.terminateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobTerminateHeaders> terminateDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobTerminateHeaders.class);
    }

    @Override
    public void add(JobAddParameter job) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(job).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(JobAddParameter job, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(job), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(JobAddParameter job) {
        return this.addWithServiceResponseAsync(job).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobAddHeaders>> addWithServiceResponseAsync(JobAddParameter job) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (job == null) {
            throw new IllegalArgumentException("Parameter job is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)job);
        Object jobAddOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(job, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void add(JobAddParameter job, JobAddOptions jobAddOptions) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(job, jobAddOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(JobAddParameter job, JobAddOptions jobAddOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(job, jobAddOptions), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(JobAddParameter job, JobAddOptions jobAddOptions) {
        return this.addWithServiceResponseAsync(job, jobAddOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, JobAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, JobAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, JobAddHeaders>> addWithServiceResponseAsync(JobAddParameter job, JobAddOptions jobAddOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (job == null) {
            throw new IllegalArgumentException("Parameter job is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)job);
        Validator.validate((Object)jobAddOptions);
        Integer timeout = null;
        if (jobAddOptions != null) {
            timeout = jobAddOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobAddOptions != null) {
            clientRequestId = jobAddOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobAddOptions != null) {
            returnClientRequestId = jobAddOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobAddOptions != null) {
            ocpDate = jobAddOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(job, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, JobAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, JobAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, JobAddHeaders> addDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobAddHeaders.class);
    }

    @Override
    public PagedList<CloudJob> list() {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<CloudJob>((Page)response.body()){

            public Page<CloudJob> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJob>> listAsync(ListOperationCallback<CloudJob> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJob>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>, Page<CloudJob>>(){

            public Page<CloudJob> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> listSinglePageAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobListOptions = null;
        String filter = null;
        String select = null;
        String expand = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudJob> list(final JobListOptions jobListOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(jobListOptions).toBlocking().single();
        return new PagedList<CloudJob>((Page)response.body()){

            public Page<CloudJob> nextPage(String nextPageLink) {
                JobListNextOptions jobListNextOptions = null;
                if (jobListOptions != null) {
                    jobListNextOptions = new JobListNextOptions();
                    jobListNextOptions.withClientRequestId(jobListOptions.clientRequestId());
                    jobListNextOptions.withReturnClientRequestId(jobListOptions.returnClientRequestId());
                    jobListNextOptions.withOcpDate(jobListOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listNextSinglePageAsync(nextPageLink, jobListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJob>> listAsync(final JobListOptions jobListOptions, ListOperationCallback<CloudJob> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(jobListOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(String nextPageLink) {
                JobListNextOptions jobListNextOptions = null;
                if (jobListOptions != null) {
                    jobListNextOptions = new JobListNextOptions();
                    jobListNextOptions.withClientRequestId(jobListOptions.clientRequestId());
                    jobListNextOptions.withReturnClientRequestId(jobListOptions.returnClientRequestId());
                    jobListNextOptions.withOcpDate(jobListOptions.ocpDate());
                }
                return JobsImpl.this.listNextSinglePageAsync(nextPageLink, jobListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJob>> listAsync(JobListOptions jobListOptions) {
        return this.listWithServiceResponseAsync(jobListOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>, Page<CloudJob>>(){

            public Page<CloudJob> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> listWithServiceResponseAsync(final JobListOptions jobListOptions) {
        return this.listSinglePageAsync(jobListOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                JobListNextOptions jobListNextOptions = null;
                if (jobListOptions != null) {
                    jobListNextOptions = new JobListNextOptions();
                    jobListNextOptions.withClientRequestId(jobListOptions.clientRequestId());
                    jobListNextOptions.withReturnClientRequestId(jobListOptions.returnClientRequestId());
                    jobListNextOptions.withOcpDate(jobListOptions.ocpDate());
                }
                return Observable.just(page).concatWith(JobsImpl.this.listNextWithServiceResponseAsync(nextPageLink, jobListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> listSinglePageAsync(JobListOptions jobListOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobListOptions);
        String filter = null;
        if (jobListOptions != null) {
            filter = jobListOptions.filter();
        }
        String select = null;
        if (jobListOptions != null) {
            select = jobListOptions.select();
        }
        String expand = null;
        if (jobListOptions != null) {
            expand = jobListOptions.expand();
        }
        Integer maxResults = null;
        if (jobListOptions != null) {
            maxResults = jobListOptions.maxResults();
        }
        Integer timeout = null;
        if (jobListOptions != null) {
            timeout = jobListOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobListOptions != null) {
            clientRequestId = jobListOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobListOptions != null) {
            returnClientRequestId = jobListOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobListOptions != null) {
            ocpDate = jobListOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudJob>, JobListHeaders> listDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudJob>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobListHeaders.class);
    }

    @Override
    public PagedList<CloudJob> listFromJobSchedule(String jobScheduleId) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromJobScheduleSinglePageAsync(jobScheduleId).toBlocking().single();
        return new PagedList<CloudJob>((Page)response.body()){

            public Page<CloudJob> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listFromJobScheduleNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJob>> listFromJobScheduleAsync(String jobScheduleId, ListOperationCallback<CloudJob> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromJobScheduleSinglePageAsync(jobScheduleId), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listFromJobScheduleNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJob>> listFromJobScheduleAsync(String jobScheduleId) {
        return this.listFromJobScheduleWithServiceResponseAsync(jobScheduleId).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>, Page<CloudJob>>(){

            public Page<CloudJob> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> listFromJobScheduleWithServiceResponseAsync(String jobScheduleId) {
        return this.listFromJobScheduleSinglePageAsync(jobScheduleId).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listFromJobScheduleNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> listFromJobScheduleSinglePageAsync(String jobScheduleId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobListFromJobScheduleOptions = null;
        String filter = null;
        String select = null;
        String expand = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listFromJobSchedule(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listFromJobScheduleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudJob> listFromJobSchedule(String jobScheduleId, final JobListFromJobScheduleOptions jobListFromJobScheduleOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromJobScheduleSinglePageAsync(jobScheduleId, jobListFromJobScheduleOptions).toBlocking().single();
        return new PagedList<CloudJob>((Page)response.body()){

            public Page<CloudJob> nextPage(String nextPageLink) {
                JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions = null;
                if (jobListFromJobScheduleOptions != null) {
                    jobListFromJobScheduleNextOptions = new JobListFromJobScheduleNextOptions();
                    jobListFromJobScheduleNextOptions.withClientRequestId(jobListFromJobScheduleOptions.clientRequestId());
                    jobListFromJobScheduleNextOptions.withReturnClientRequestId(jobListFromJobScheduleOptions.returnClientRequestId());
                    jobListFromJobScheduleNextOptions.withOcpDate(jobListFromJobScheduleOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listFromJobScheduleNextSinglePageAsync(nextPageLink, jobListFromJobScheduleNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJob>> listFromJobScheduleAsync(String jobScheduleId, final JobListFromJobScheduleOptions jobListFromJobScheduleOptions, ListOperationCallback<CloudJob> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromJobScheduleSinglePageAsync(jobScheduleId, jobListFromJobScheduleOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(String nextPageLink) {
                JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions = null;
                if (jobListFromJobScheduleOptions != null) {
                    jobListFromJobScheduleNextOptions = new JobListFromJobScheduleNextOptions();
                    jobListFromJobScheduleNextOptions.withClientRequestId(jobListFromJobScheduleOptions.clientRequestId());
                    jobListFromJobScheduleNextOptions.withReturnClientRequestId(jobListFromJobScheduleOptions.returnClientRequestId());
                    jobListFromJobScheduleNextOptions.withOcpDate(jobListFromJobScheduleOptions.ocpDate());
                }
                return JobsImpl.this.listFromJobScheduleNextSinglePageAsync(nextPageLink, jobListFromJobScheduleNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJob>> listFromJobScheduleAsync(String jobScheduleId, JobListFromJobScheduleOptions jobListFromJobScheduleOptions) {
        return this.listFromJobScheduleWithServiceResponseAsync(jobScheduleId, jobListFromJobScheduleOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>, Page<CloudJob>>(){

            public Page<CloudJob> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> listFromJobScheduleWithServiceResponseAsync(String jobScheduleId, final JobListFromJobScheduleOptions jobListFromJobScheduleOptions) {
        return this.listFromJobScheduleSinglePageAsync(jobScheduleId, jobListFromJobScheduleOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions = null;
                if (jobListFromJobScheduleOptions != null) {
                    jobListFromJobScheduleNextOptions = new JobListFromJobScheduleNextOptions();
                    jobListFromJobScheduleNextOptions.withClientRequestId(jobListFromJobScheduleOptions.clientRequestId());
                    jobListFromJobScheduleNextOptions.withReturnClientRequestId(jobListFromJobScheduleOptions.returnClientRequestId());
                    jobListFromJobScheduleNextOptions.withOcpDate(jobListFromJobScheduleOptions.ocpDate());
                }
                return Observable.just(page).concatWith(JobsImpl.this.listFromJobScheduleNextWithServiceResponseAsync(nextPageLink, jobListFromJobScheduleNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> listFromJobScheduleSinglePageAsync(String jobScheduleId, JobListFromJobScheduleOptions jobListFromJobScheduleOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobScheduleId == null) {
            throw new IllegalArgumentException("Parameter jobScheduleId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobListFromJobScheduleOptions);
        String filter = null;
        if (jobListFromJobScheduleOptions != null) {
            filter = jobListFromJobScheduleOptions.filter();
        }
        String select = null;
        if (jobListFromJobScheduleOptions != null) {
            select = jobListFromJobScheduleOptions.select();
        }
        String expand = null;
        if (jobListFromJobScheduleOptions != null) {
            expand = jobListFromJobScheduleOptions.expand();
        }
        Integer maxResults = null;
        if (jobListFromJobScheduleOptions != null) {
            maxResults = jobListFromJobScheduleOptions.maxResults();
        }
        Integer timeout = null;
        if (jobListFromJobScheduleOptions != null) {
            timeout = jobListFromJobScheduleOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobListFromJobScheduleOptions != null) {
            clientRequestId = jobListFromJobScheduleOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobListFromJobScheduleOptions != null) {
            returnClientRequestId = jobListFromJobScheduleOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobListFromJobScheduleOptions != null) {
            ocpDate = jobListFromJobScheduleOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listFromJobSchedule(jobScheduleId, this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listFromJobScheduleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudJob>, JobListFromJobScheduleHeaders> listFromJobScheduleDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudJob>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobListFromJobScheduleHeaders.class);
    }

    @Override
    public PagedList<JobPreparationAndReleaseTaskExecutionInformation> listPreparationAndReleaseTaskStatus(String jobId) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listPreparationAndReleaseTaskStatusSinglePageAsync(jobId).toBlocking().single();
        return new PagedList<JobPreparationAndReleaseTaskExecutionInformation>((Page)response.body()){

            public Page<JobPreparationAndReleaseTaskExecutionInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobPreparationAndReleaseTaskExecutionInformation>> listPreparationAndReleaseTaskStatusAsync(String jobId, ListOperationCallback<JobPreparationAndReleaseTaskExecutionInformation> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listPreparationAndReleaseTaskStatusSinglePageAsync(jobId), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobPreparationAndReleaseTaskExecutionInformation>> listPreparationAndReleaseTaskStatusAsync(String jobId) {
        return this.listPreparationAndReleaseTaskStatusWithServiceResponseAsync(jobId).map((Func1)new Func1<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>, Page<JobPreparationAndReleaseTaskExecutionInformation>>(){

            public Page<JobPreparationAndReleaseTaskExecutionInformation> call(ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> listPreparationAndReleaseTaskStatusWithServiceResponseAsync(String jobId) {
        return this.listPreparationAndReleaseTaskStatusSinglePageAsync(jobId).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listPreparationAndReleaseTaskStatusNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> listPreparationAndReleaseTaskStatusSinglePageAsync(String jobId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobListPreparationAndReleaseTaskStatusOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listPreparationAndReleaseTaskStatus(jobId, this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listPreparationAndReleaseTaskStatusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<JobPreparationAndReleaseTaskExecutionInformation> listPreparationAndReleaseTaskStatus(String jobId, final JobListPreparationAndReleaseTaskStatusOptions jobListPreparationAndReleaseTaskStatusOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listPreparationAndReleaseTaskStatusSinglePageAsync(jobId, jobListPreparationAndReleaseTaskStatusOptions).toBlocking().single();
        return new PagedList<JobPreparationAndReleaseTaskExecutionInformation>((Page)response.body()){

            public Page<JobPreparationAndReleaseTaskExecutionInformation> nextPage(String nextPageLink) {
                JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions = null;
                if (jobListPreparationAndReleaseTaskStatusOptions != null) {
                    jobListPreparationAndReleaseTaskStatusNextOptions = new JobListPreparationAndReleaseTaskStatusNextOptions();
                    jobListPreparationAndReleaseTaskStatusNextOptions.withClientRequestId(jobListPreparationAndReleaseTaskStatusOptions.clientRequestId());
                    jobListPreparationAndReleaseTaskStatusNextOptions.withReturnClientRequestId(jobListPreparationAndReleaseTaskStatusOptions.returnClientRequestId());
                    jobListPreparationAndReleaseTaskStatusNextOptions.withOcpDate(jobListPreparationAndReleaseTaskStatusOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobPreparationAndReleaseTaskExecutionInformation>> listPreparationAndReleaseTaskStatusAsync(String jobId, final JobListPreparationAndReleaseTaskStatusOptions jobListPreparationAndReleaseTaskStatusOptions, ListOperationCallback<JobPreparationAndReleaseTaskExecutionInformation> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listPreparationAndReleaseTaskStatusSinglePageAsync(jobId, jobListPreparationAndReleaseTaskStatusOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(String nextPageLink) {
                JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions = null;
                if (jobListPreparationAndReleaseTaskStatusOptions != null) {
                    jobListPreparationAndReleaseTaskStatusNextOptions = new JobListPreparationAndReleaseTaskStatusNextOptions();
                    jobListPreparationAndReleaseTaskStatusNextOptions.withClientRequestId(jobListPreparationAndReleaseTaskStatusOptions.clientRequestId());
                    jobListPreparationAndReleaseTaskStatusNextOptions.withReturnClientRequestId(jobListPreparationAndReleaseTaskStatusOptions.returnClientRequestId());
                    jobListPreparationAndReleaseTaskStatusNextOptions.withOcpDate(jobListPreparationAndReleaseTaskStatusOptions.ocpDate());
                }
                return JobsImpl.this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobPreparationAndReleaseTaskExecutionInformation>> listPreparationAndReleaseTaskStatusAsync(String jobId, JobListPreparationAndReleaseTaskStatusOptions jobListPreparationAndReleaseTaskStatusOptions) {
        return this.listPreparationAndReleaseTaskStatusWithServiceResponseAsync(jobId, jobListPreparationAndReleaseTaskStatusOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>, Page<JobPreparationAndReleaseTaskExecutionInformation>>(){

            public Page<JobPreparationAndReleaseTaskExecutionInformation> call(ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> listPreparationAndReleaseTaskStatusWithServiceResponseAsync(String jobId, final JobListPreparationAndReleaseTaskStatusOptions jobListPreparationAndReleaseTaskStatusOptions) {
        return this.listPreparationAndReleaseTaskStatusSinglePageAsync(jobId, jobListPreparationAndReleaseTaskStatusOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions = null;
                if (jobListPreparationAndReleaseTaskStatusOptions != null) {
                    jobListPreparationAndReleaseTaskStatusNextOptions = new JobListPreparationAndReleaseTaskStatusNextOptions();
                    jobListPreparationAndReleaseTaskStatusNextOptions.withClientRequestId(jobListPreparationAndReleaseTaskStatusOptions.clientRequestId());
                    jobListPreparationAndReleaseTaskStatusNextOptions.withReturnClientRequestId(jobListPreparationAndReleaseTaskStatusOptions.returnClientRequestId());
                    jobListPreparationAndReleaseTaskStatusNextOptions.withOcpDate(jobListPreparationAndReleaseTaskStatusOptions.ocpDate());
                }
                return Observable.just(page).concatWith(JobsImpl.this.listPreparationAndReleaseTaskStatusNextWithServiceResponseAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> listPreparationAndReleaseTaskStatusSinglePageAsync(String jobId, JobListPreparationAndReleaseTaskStatusOptions jobListPreparationAndReleaseTaskStatusOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobListPreparationAndReleaseTaskStatusOptions);
        String filter = null;
        if (jobListPreparationAndReleaseTaskStatusOptions != null) {
            filter = jobListPreparationAndReleaseTaskStatusOptions.filter();
        }
        String select = null;
        if (jobListPreparationAndReleaseTaskStatusOptions != null) {
            select = jobListPreparationAndReleaseTaskStatusOptions.select();
        }
        Integer maxResults = null;
        if (jobListPreparationAndReleaseTaskStatusOptions != null) {
            maxResults = jobListPreparationAndReleaseTaskStatusOptions.maxResults();
        }
        Integer timeout = null;
        if (jobListPreparationAndReleaseTaskStatusOptions != null) {
            timeout = jobListPreparationAndReleaseTaskStatusOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobListPreparationAndReleaseTaskStatusOptions != null) {
            clientRequestId = jobListPreparationAndReleaseTaskStatusOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobListPreparationAndReleaseTaskStatusOptions != null) {
            returnClientRequestId = jobListPreparationAndReleaseTaskStatusOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobListPreparationAndReleaseTaskStatusOptions != null) {
            ocpDate = jobListPreparationAndReleaseTaskStatusOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listPreparationAndReleaseTaskStatus(jobId, this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listPreparationAndReleaseTaskStatusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> listPreparationAndReleaseTaskStatusDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobPreparationAndReleaseTaskExecutionInformation>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobListPreparationAndReleaseTaskStatusHeaders.class);
    }

    @Override
    public TaskCountsResult getTaskCounts(String jobId) {
        return (TaskCountsResult)((ServiceResponseWithHeaders)this.getTaskCountsWithServiceResponseAsync(jobId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<TaskCountsResult> getTaskCountsAsync(String jobId, ServiceCallback<TaskCountsResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getTaskCountsWithServiceResponseAsync(jobId), serviceCallback);
    }

    @Override
    public Observable<TaskCountsResult> getTaskCountsAsync(String jobId) {
        return this.getTaskCountsWithServiceResponseAsync(jobId).map((Func1)new Func1<ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders>, TaskCountsResult>(){

            public TaskCountsResult call(ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders> response) {
                return (TaskCountsResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders>> getTaskCountsWithServiceResponseAsync(String jobId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobGetTaskCountsOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.getTaskCounts(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.getTaskCountsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public TaskCountsResult getTaskCounts(String jobId, JobGetTaskCountsOptions jobGetTaskCountsOptions) {
        return (TaskCountsResult)((ServiceResponseWithHeaders)this.getTaskCountsWithServiceResponseAsync(jobId, jobGetTaskCountsOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<TaskCountsResult> getTaskCountsAsync(String jobId, JobGetTaskCountsOptions jobGetTaskCountsOptions, ServiceCallback<TaskCountsResult> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getTaskCountsWithServiceResponseAsync(jobId, jobGetTaskCountsOptions), serviceCallback);
    }

    @Override
    public Observable<TaskCountsResult> getTaskCountsAsync(String jobId, JobGetTaskCountsOptions jobGetTaskCountsOptions) {
        return this.getTaskCountsWithServiceResponseAsync(jobId, jobGetTaskCountsOptions).map((Func1)new Func1<ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders>, TaskCountsResult>(){

            public TaskCountsResult call(ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders> response) {
                return (TaskCountsResult)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders>> getTaskCountsWithServiceResponseAsync(String jobId, JobGetTaskCountsOptions jobGetTaskCountsOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobGetTaskCountsOptions);
        Integer timeout = null;
        if (jobGetTaskCountsOptions != null) {
            timeout = jobGetTaskCountsOptions.timeout();
        }
        UUID clientRequestId = null;
        if (jobGetTaskCountsOptions != null) {
            clientRequestId = jobGetTaskCountsOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobGetTaskCountsOptions != null) {
            returnClientRequestId = jobGetTaskCountsOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobGetTaskCountsOptions != null) {
            ocpDate = jobGetTaskCountsOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.getTaskCounts(jobId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = JobsImpl.this.getTaskCountsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<TaskCountsResult, JobGetTaskCountsHeaders> getTaskCountsDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TaskCountsResult>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobGetTaskCountsHeaders.class);
    }

    @Override
    public PagedList<CloudJob> listNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CloudJob>((Page)response.body()){

            public Page<CloudJob> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJob>> listNextAsync(String nextPageLink, ServiceFuture<List<CloudJob>> serviceFuture, ListOperationCallback<CloudJob> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJob>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>, Page<CloudJob>>(){

            public Page<CloudJob> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object jobListNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudJob> listNext(String nextPageLink, final JobListNextOptions jobListNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink, jobListNextOptions).toBlocking().single();
        return new PagedList<CloudJob>((Page)response.body()){

            public Page<CloudJob> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listNextSinglePageAsync(nextPageLink, jobListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJob>> listNextAsync(String nextPageLink, final JobListNextOptions jobListNextOptions, ServiceFuture<List<CloudJob>> serviceFuture, ListOperationCallback<CloudJob> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink, jobListNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listNextSinglePageAsync(nextPageLink, jobListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJob>> listNextAsync(String nextPageLink, JobListNextOptions jobListNextOptions) {
        return this.listNextWithServiceResponseAsync(nextPageLink, jobListNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>, Page<CloudJob>>(){

            public Page<CloudJob> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> listNextWithServiceResponseAsync(String nextPageLink, final JobListNextOptions jobListNextOptions) {
        return this.listNextSinglePageAsync(nextPageLink, jobListNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listNextWithServiceResponseAsync(nextPageLink, jobListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> listNextSinglePageAsync(String nextPageLink, JobListNextOptions jobListNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)jobListNextOptions);
        UUID clientRequestId = null;
        if (jobListNextOptions != null) {
            clientRequestId = jobListNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobListNextOptions != null) {
            returnClientRequestId = jobListNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobListNextOptions != null) {
            ocpDate = jobListNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudJob>, JobListHeaders> listNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudJob>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobListHeaders.class);
    }

    @Override
    public PagedList<CloudJob> listFromJobScheduleNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromJobScheduleNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CloudJob>((Page)response.body()){

            public Page<CloudJob> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listFromJobScheduleNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJob>> listFromJobScheduleNextAsync(String nextPageLink, ServiceFuture<List<CloudJob>> serviceFuture, ListOperationCallback<CloudJob> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromJobScheduleNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listFromJobScheduleNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJob>> listFromJobScheduleNextAsync(String nextPageLink) {
        return this.listFromJobScheduleNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>, Page<CloudJob>>(){

            public Page<CloudJob> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> listFromJobScheduleNextWithServiceResponseAsync(String nextPageLink) {
        return this.listFromJobScheduleNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listFromJobScheduleNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> listFromJobScheduleNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object jobListFromJobScheduleNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listFromJobScheduleNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listFromJobScheduleNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudJob> listFromJobScheduleNext(String nextPageLink, final JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromJobScheduleNextSinglePageAsync(nextPageLink, jobListFromJobScheduleNextOptions).toBlocking().single();
        return new PagedList<CloudJob>((Page)response.body()){

            public Page<CloudJob> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listFromJobScheduleNextSinglePageAsync(nextPageLink, jobListFromJobScheduleNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudJob>> listFromJobScheduleNextAsync(String nextPageLink, final JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions, ServiceFuture<List<CloudJob>> serviceFuture, ListOperationCallback<CloudJob> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromJobScheduleNextSinglePageAsync(nextPageLink, jobListFromJobScheduleNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listFromJobScheduleNextSinglePageAsync(nextPageLink, jobListFromJobScheduleNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudJob>> listFromJobScheduleNextAsync(String nextPageLink, JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions) {
        return this.listFromJobScheduleNextWithServiceResponseAsync(nextPageLink, jobListFromJobScheduleNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>, Page<CloudJob>>(){

            public Page<CloudJob> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> listFromJobScheduleNextWithServiceResponseAsync(String nextPageLink, final JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions) {
        return this.listFromJobScheduleNextSinglePageAsync(nextPageLink, jobListFromJobScheduleNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listFromJobScheduleNextWithServiceResponseAsync(nextPageLink, jobListFromJobScheduleNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> listFromJobScheduleNextSinglePageAsync(String nextPageLink, JobListFromJobScheduleNextOptions jobListFromJobScheduleNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)jobListFromJobScheduleNextOptions);
        UUID clientRequestId = null;
        if (jobListFromJobScheduleNextOptions != null) {
            clientRequestId = jobListFromJobScheduleNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobListFromJobScheduleNextOptions != null) {
            returnClientRequestId = jobListFromJobScheduleNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobListFromJobScheduleNextOptions != null) {
            ocpDate = jobListFromJobScheduleNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listFromJobScheduleNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudJob>, JobListFromJobScheduleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listFromJobScheduleNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudJob>, JobListFromJobScheduleHeaders> listFromJobScheduleNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudJob>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobListFromJobScheduleHeaders.class);
    }

    @Override
    public PagedList<JobPreparationAndReleaseTaskExecutionInformation> listPreparationAndReleaseTaskStatusNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobPreparationAndReleaseTaskExecutionInformation>((Page)response.body()){

            public Page<JobPreparationAndReleaseTaskExecutionInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobPreparationAndReleaseTaskExecutionInformation>> listPreparationAndReleaseTaskStatusNextAsync(String nextPageLink, ServiceFuture<List<JobPreparationAndReleaseTaskExecutionInformation>> serviceFuture, ListOperationCallback<JobPreparationAndReleaseTaskExecutionInformation> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobPreparationAndReleaseTaskExecutionInformation>> listPreparationAndReleaseTaskStatusNextAsync(String nextPageLink) {
        return this.listPreparationAndReleaseTaskStatusNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>, Page<JobPreparationAndReleaseTaskExecutionInformation>>(){

            public Page<JobPreparationAndReleaseTaskExecutionInformation> call(ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> listPreparationAndReleaseTaskStatusNextWithServiceResponseAsync(String nextPageLink) {
        return this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listPreparationAndReleaseTaskStatusNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> listPreparationAndReleaseTaskStatusNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object jobListPreparationAndReleaseTaskStatusNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listPreparationAndReleaseTaskStatusNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listPreparationAndReleaseTaskStatusNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<JobPreparationAndReleaseTaskExecutionInformation> listPreparationAndReleaseTaskStatusNext(String nextPageLink, final JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions).toBlocking().single();
        return new PagedList<JobPreparationAndReleaseTaskExecutionInformation>((Page)response.body()){

            public Page<JobPreparationAndReleaseTaskExecutionInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)JobsImpl.this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<JobPreparationAndReleaseTaskExecutionInformation>> listPreparationAndReleaseTaskStatusNextAsync(String nextPageLink, final JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions, ServiceFuture<List<JobPreparationAndReleaseTaskExecutionInformation>> serviceFuture, ListOperationCallback<JobPreparationAndReleaseTaskExecutionInformation> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(String nextPageLink) {
                return JobsImpl.this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<JobPreparationAndReleaseTaskExecutionInformation>> listPreparationAndReleaseTaskStatusNextAsync(String nextPageLink, JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions) {
        return this.listPreparationAndReleaseTaskStatusNextWithServiceResponseAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>, Page<JobPreparationAndReleaseTaskExecutionInformation>>(){

            public Page<JobPreparationAndReleaseTaskExecutionInformation> call(ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> listPreparationAndReleaseTaskStatusNextWithServiceResponseAsync(String nextPageLink, final JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions) {
        return this.listPreparationAndReleaseTaskStatusNextSinglePageAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsImpl.this.listPreparationAndReleaseTaskStatusNextWithServiceResponseAsync(nextPageLink, jobListPreparationAndReleaseTaskStatusNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> listPreparationAndReleaseTaskStatusNextSinglePageAsync(String nextPageLink, JobListPreparationAndReleaseTaskStatusNextOptions jobListPreparationAndReleaseTaskStatusNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)jobListPreparationAndReleaseTaskStatusNextOptions);
        UUID clientRequestId = null;
        if (jobListPreparationAndReleaseTaskStatusNextOptions != null) {
            clientRequestId = jobListPreparationAndReleaseTaskStatusNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (jobListPreparationAndReleaseTaskStatusNextOptions != null) {
            returnClientRequestId = jobListPreparationAndReleaseTaskStatusNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (jobListPreparationAndReleaseTaskStatusNextOptions != null) {
            ocpDate = jobListPreparationAndReleaseTaskStatusNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listPreparationAndReleaseTaskStatusNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = JobsImpl.this.listPreparationAndReleaseTaskStatusNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<JobPreparationAndReleaseTaskExecutionInformation>, JobListPreparationAndReleaseTaskStatusHeaders> listPreparationAndReleaseTaskStatusNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobPreparationAndReleaseTaskExecutionInformation>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, JobListPreparationAndReleaseTaskStatusHeaders.class);
    }

    static interface JobsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs getAllLifetimeStatistics"})
        @GET(value="lifetimejobstats")
        public Observable<Response<ResponseBody>> getAllLifetimeStatistics(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="timeout") Integer var3, @Header(value="client-request-id") UUID var4, @Header(value="return-client-request-id") Boolean var5, @Header(value="ocp-date") DateTimeRfc1123 var6, @Header(value="x-ms-parameterized-host") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs delete"})
        @HTTP(path="jobs/{jobId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs get"})
        @GET(value="jobs/{jobId}")
        public Observable<Response<ResponseBody>> get(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$select") String var4, @Query(value="$expand") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="If-Match") String var10, @Header(value="If-None-Match") String var11, @Header(value="If-Modified-Since") DateTimeRfc1123 var12, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var13, @Header(value="x-ms-parameterized-host") String var14, @Header(value="User-Agent") String var15);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs patch"})
        @PATCH(value="jobs/{jobId}")
        public Observable<Response<ResponseBody>> patch(@Path(value="jobId") String var1, @Body JobPatchParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs update"})
        @PUT(value="jobs/{jobId}")
        public Observable<Response<ResponseBody>> update(@Path(value="jobId") String var1, @Body JobUpdateParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs disable"})
        @POST(value="jobs/{jobId}/disable")
        public Observable<Response<ResponseBody>> disable(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Body JobDisableParameter var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs enable"})
        @POST(value="jobs/{jobId}/enable")
        public Observable<Response<ResponseBody>> enable(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs terminate"})
        @POST(value="jobs/{jobId}/terminate")
        public Observable<Response<ResponseBody>> terminate(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Body JobTerminateParameter var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs add"})
        @POST(value="jobs")
        public Observable<Response<ResponseBody>> add(@Body JobAddParameter var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs list"})
        @GET(value="jobs")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="$filter") String var3, @Query(value="$select") String var4, @Query(value="$expand") String var5, @Query(value="maxresults") Integer var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs listFromJobSchedule"})
        @GET(value="jobschedules/{jobScheduleId}/jobs")
        public Observable<Response<ResponseBody>> listFromJobSchedule(@Path(value="jobScheduleId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$filter") String var4, @Query(value="$select") String var5, @Query(value="$expand") String var6, @Query(value="maxresults") Integer var7, @Query(value="timeout") Integer var8, @Header(value="client-request-id") UUID var9, @Header(value="return-client-request-id") Boolean var10, @Header(value="ocp-date") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs listPreparationAndReleaseTaskStatus"})
        @GET(value="jobs/{jobId}/jobpreparationandreleasetaskstatus")
        public Observable<Response<ResponseBody>> listPreparationAndReleaseTaskStatus(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$filter") String var4, @Query(value="$select") String var5, @Query(value="maxresults") Integer var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs getTaskCounts"})
        @GET(value="jobs/{jobId}/taskcounts")
        public Observable<Response<ResponseBody>> getTaskCounts(@Path(value="jobId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs listFromJobScheduleNext"})
        @GET
        public Observable<Response<ResponseBody>> listFromJobScheduleNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Jobs listPreparationAndReleaseTaskStatusNext"})
        @GET
        public Observable<Response<ResponseBody>> listPreparationAndReleaseTaskStatusNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

