/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.batch.AccountOperations;
import com.microsoft.azure.batch.ApplicationOperations;
import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.CertificateOperations;
import com.microsoft.azure.batch.ComputeNodeOperations;
import com.microsoft.azure.batch.FileOperations;
import com.microsoft.azure.batch.JobOperations;
import com.microsoft.azure.batch.JobScheduleOperations;
import com.microsoft.azure.batch.PoolOperations;
import com.microsoft.azure.batch.TaskOperations;
import com.microsoft.azure.batch.auth.BatchCredentials;
import com.microsoft.azure.batch.interceptor.ClientRequestIdInterceptor;
import com.microsoft.azure.batch.protocol.BatchServiceClient;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.RestException;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.util.Collection;
import java.util.LinkedList;

public class BatchClient {
    private final BatchServiceClient protocolLayer;
    private final CertificateOperations certificateOperations;
    private final JobOperations jobOperations;
    private final TaskOperations taskOperations;
    private final JobScheduleOperations jobScheduleOperations;
    private final PoolOperations poolOperations;
    private final FileOperations fileOperations;
    private final ComputeNodeOperations computeNodeOperations;
    private final ApplicationOperations applicationOperations;
    private final AccountOperations accountOperations;
    private Collection<BatchClientBehavior> customBehaviors;

    public BatchServiceClient protocolLayer() {
        return this.protocolLayer;
    }

    private BatchClient(BatchCredentials credentials) {
        RestClient restClient = new RestClient.Builder().withBaseUrl(credentials.baseUrl()).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new ResponseBuilderFactory()).build();
        this.protocolLayer = new BatchServiceClientImpl(restClient).withBatchUrl(credentials.baseUrl());
        this.customBehaviors = new LinkedList<BatchClientBehavior>();
        this.customBehaviors.add(new ClientRequestIdInterceptor());
        this.certificateOperations = new CertificateOperations(this, this.customBehaviors());
        this.jobOperations = new JobOperations(this, this.customBehaviors());
        this.taskOperations = new TaskOperations(this, this.customBehaviors());
        this.jobScheduleOperations = new JobScheduleOperations(this, this.customBehaviors());
        this.poolOperations = new PoolOperations(this, this.customBehaviors());
        this.fileOperations = new FileOperations(this, this.customBehaviors());
        this.applicationOperations = new ApplicationOperations(this, this.customBehaviors());
        this.accountOperations = new AccountOperations(this, this.customBehaviors());
        this.computeNodeOperations = new ComputeNodeOperations(this, this.customBehaviors());
    }

    private BatchClient(RestClient restClient, String baseUrl) {
        this.protocolLayer = new BatchServiceClientImpl(restClient).withBatchUrl(baseUrl);
        this.customBehaviors = new LinkedList<BatchClientBehavior>();
        this.customBehaviors.add(new ClientRequestIdInterceptor());
        this.certificateOperations = new CertificateOperations(this, this.customBehaviors());
        this.jobOperations = new JobOperations(this, this.customBehaviors());
        this.taskOperations = new TaskOperations(this, this.customBehaviors());
        this.jobScheduleOperations = new JobScheduleOperations(this, this.customBehaviors());
        this.poolOperations = new PoolOperations(this, this.customBehaviors());
        this.fileOperations = new FileOperations(this, this.customBehaviors());
        this.applicationOperations = new ApplicationOperations(this, this.customBehaviors());
        this.accountOperations = new AccountOperations(this, this.customBehaviors());
        this.computeNodeOperations = new ComputeNodeOperations(this, this.customBehaviors());
    }

    public static BatchClient open(BatchCredentials credentials) {
        return new BatchClient(credentials);
    }

    public static BatchClient open(RestClient restClient, String baseUrl) {
        return new BatchClient(restClient, baseUrl);
    }

    @Deprecated
    public CertificateOperations certificateOperations() {
        return this.certificateOperations;
    }

    public JobOperations jobOperations() {
        return this.jobOperations;
    }

    public TaskOperations taskOperations() {
        return this.taskOperations;
    }

    public JobScheduleOperations jobScheduleOperations() {
        return this.jobScheduleOperations;
    }

    public FileOperations fileOperations() {
        return this.fileOperations;
    }

    public PoolOperations poolOperations() {
        return this.poolOperations;
    }

    public ComputeNodeOperations computeNodeOperations() {
        return this.computeNodeOperations;
    }

    public ApplicationOperations applicationOperations() {
        return this.applicationOperations;
    }

    public AccountOperations accountOperations() {
        return this.accountOperations;
    }

    public Collection<BatchClientBehavior> customBehaviors() {
        return this.customBehaviors;
    }

    public BatchClient withCustomBehaviors(Collection<BatchClientBehavior> customBehaviors) {
        this.customBehaviors = customBehaviors;
        return this;
    }

    private static class ResponseBuilderFactory
    implements ResponseBuilder.Factory {
        private final AzureResponseBuilder.Factory baseFactory = new AzureResponseBuilder.Factory();

        private ResponseBuilderFactory() {
        }

        public <T, E extends RestException> ResponseBuilder<T, E> newInstance(SerializerAdapter<?> serializerAdapter) {
            return this.baseFactory.newInstance(serializerAdapter).withThrowOnGet404(true);
        }
    }
}

