/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.interceptor.DetailLevelInterceptor;
import com.microsoft.azure.batch.interceptor.RequestInterceptor;
import java.util.Collection;
import java.util.LinkedList;

class BehaviorManager {
    private Collection<BatchClientBehavior> perCallBehaviors;
    private Collection<BatchClientBehavior> baseBehaviors = new LinkedList<BatchClientBehavior>();

    BehaviorManager(Collection<BatchClientBehavior> baseBehaviors, Iterable<BatchClientBehavior> perCallBehaviors) {
        if (null != baseBehaviors) {
            this.baseBehaviors().addAll(baseBehaviors);
        }
        this.perCallBehaviors = new LinkedList<BatchClientBehavior>();
        if (null != perCallBehaviors) {
            for (BatchClientBehavior bh : perCallBehaviors) {
                this.perCallBehaviors().add(bh);
            }
        }
    }

    Collection<BatchClientBehavior> getMasterListOfBehaviors() {
        LinkedList<BatchClientBehavior> ml = new LinkedList<BatchClientBehavior>(this.baseBehaviors());
        ml.addAll(this.perCallBehaviors());
        return ml;
    }

    void applyRequestBehaviors(Object request) {
        for (BatchClientBehavior bh : this.getMasterListOfBehaviors()) {
            if (!(bh instanceof RequestInterceptor)) continue;
            ((RequestInterceptor)bh).handler().modify(request);
        }
    }

    void appendDetailLevelToPerCallBehaviors(DetailLevel dl) {
        if (dl != null) {
            this.perCallBehaviors().add(new DetailLevelInterceptor(dl));
        }
    }

    private Collection<BatchClientBehavior> baseBehaviors() {
        return this.baseBehaviors;
    }

    public BehaviorManager withBaseBehaviors(Collection<BatchClientBehavior> baseBehaviors) {
        this.baseBehaviors = baseBehaviors;
        return this;
    }

    private Collection<BatchClientBehavior> perCallBehaviors() {
        return this.perCallBehaviors;
    }

    public BehaviorManager withPerCallBehaviors(Collection<BatchClientBehavior> perCallBehaviors) {
        this.perCallBehaviors = perCallBehaviors;
        return this;
    }
}

