/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.BatchClient;
import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.BehaviorManager;
import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.IInheritedBehaviors;
import com.microsoft.azure.batch.InternalHelper;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.FileDeleteFromComputeNodeOptions;
import com.microsoft.azure.batch.protocol.models.FileDeleteFromTaskOptions;
import com.microsoft.azure.batch.protocol.models.FileGetFromComputeNodeOptions;
import com.microsoft.azure.batch.protocol.models.FileGetFromTaskOptions;
import com.microsoft.azure.batch.protocol.models.FileGetPropertiesFromComputeNodeHeaders;
import com.microsoft.azure.batch.protocol.models.FileGetPropertiesFromComputeNodeOptions;
import com.microsoft.azure.batch.protocol.models.FileGetPropertiesFromTaskHeaders;
import com.microsoft.azure.batch.protocol.models.FileGetPropertiesFromTaskOptions;
import com.microsoft.azure.batch.protocol.models.FileListFromComputeNodeOptions;
import com.microsoft.azure.batch.protocol.models.FileListFromTaskOptions;
import com.microsoft.azure.batch.protocol.models.FileProperties;
import com.microsoft.azure.batch.protocol.models.NodeFile;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

public class FileOperations
implements IInheritedBehaviors {
    private Collection<BatchClientBehavior> customBehaviors;
    private final BatchClient parentBatchClient;

    FileOperations(BatchClient batchClient, Iterable<BatchClientBehavior> inheritedBehaviors) {
        this.parentBatchClient = batchClient;
        InternalHelper.inheritClientBehaviorsAndSetPublicProperty(this, inheritedBehaviors);
    }

    @Override
    public Collection<BatchClientBehavior> customBehaviors() {
        return this.customBehaviors;
    }

    @Override
    public IInheritedBehaviors withCustomBehaviors(Collection<BatchClientBehavior> behaviors) {
        this.customBehaviors = behaviors;
        return this;
    }

    public PagedList<NodeFile> listFilesFromTask(String jobId, String taskId) throws BatchErrorException, IOException {
        return this.listFilesFromTask(jobId, taskId, null, null, null);
    }

    public PagedList<NodeFile> listFilesFromTask(String jobId, String taskId, Boolean recursive, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listFilesFromTask(jobId, taskId, recursive, detailLevel, null);
    }

    public PagedList<NodeFile> listFilesFromTask(String jobId, String taskId, Boolean recursive, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        FileListFromTaskOptions options = new FileListFromTaskOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().files().listFromTask(jobId, taskId, recursive, options);
    }

    public PagedList<NodeFile> listFilesFromComputeNode(String poolId, String nodeId) throws BatchErrorException, IOException {
        return this.listFilesFromComputeNode(poolId, nodeId, null, null, null);
    }

    public PagedList<NodeFile> listFilesFromComputeNode(String poolId, String nodeId, Boolean recursive, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listFilesFromComputeNode(poolId, nodeId, recursive, detailLevel, null);
    }

    public PagedList<NodeFile> listFilesFromComputeNode(String poolId, String nodeId, Boolean recursive, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        FileListFromComputeNodeOptions options = new FileListFromComputeNodeOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().files().listFromComputeNode(poolId, nodeId, recursive, options);
    }

    public void deleteFileFromTask(String jobId, String taskId, String fileName) throws BatchErrorException, IOException {
        this.deleteFileFromTask(jobId, taskId, fileName, null, null);
    }

    public void deleteFileFromTask(String jobId, String taskId, String fileName, Boolean recursive) throws BatchErrorException, IOException {
        this.deleteFileFromTask(jobId, taskId, fileName, recursive, null);
    }

    public void deleteFileFromTask(String jobId, String taskId, String fileName, Boolean recursive, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        FileDeleteFromTaskOptions options = new FileDeleteFromTaskOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().files().deleteFromTask(jobId, taskId, fileName, recursive, options);
    }

    public void deleteFileFromComputeNode(String poolId, String nodeId, String fileName) throws BatchErrorException, IOException {
        this.deleteFileFromComputeNode(poolId, nodeId, fileName, null, null);
    }

    public void deleteFileFromComputeNode(String poolId, String nodeId, String fileName, Boolean recursive) throws BatchErrorException, IOException {
        this.deleteFileFromComputeNode(poolId, nodeId, fileName, recursive, null);
    }

    public void deleteFileFromComputeNode(String poolId, String nodeId, String fileName, Boolean recursive, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        FileDeleteFromComputeNodeOptions options = new FileDeleteFromComputeNodeOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().files().deleteFromComputeNode(poolId, nodeId, fileName, recursive, options);
    }

    public void getFileFromTask(String jobId, String taskId, String fileName, OutputStream outputStream) throws BatchErrorException, IOException {
        this.getFileFromTask(jobId, taskId, fileName, null, outputStream);
    }

    public void getFileFromTask(String jobId, String taskId, String fileName, Iterable<BatchClientBehavior> additionalBehaviors, OutputStream outputStream) throws BatchErrorException, IOException {
        FileGetFromTaskOptions options = new FileGetFromTaskOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().files().getFromTask(jobId, taskId, fileName, options, outputStream);
    }

    public void getFileFromComputeNode(String poolId, String nodeId, String fileName, OutputStream outputStream) throws BatchErrorException, IOException {
        this.getFileFromComputeNode(poolId, nodeId, fileName, null, outputStream);
    }

    public void getFileFromComputeNode(String poolId, String nodeId, String fileName, Iterable<BatchClientBehavior> additionalBehaviors, OutputStream outputStream) throws BatchErrorException, IOException {
        FileGetFromComputeNodeOptions options = new FileGetFromComputeNodeOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().files().getFromComputeNode(poolId, nodeId, fileName, options, outputStream);
    }

    public FileProperties getFilePropertiesFromTask(String jobId, String taskId, String fileName) throws BatchErrorException, IOException {
        return this.getFilePropertiesFromTask(jobId, taskId, fileName, null);
    }

    public FileProperties getFilePropertiesFromTask(String jobId, String taskId, String fileName, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        FileGetPropertiesFromTaskOptions options = new FileGetPropertiesFromTaskOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.parentBatchClient.protocolLayer().files().getPropertiesFromTaskWithServiceResponseAsync(jobId, taskId, fileName, options).toBlocking().single();
        return new FileProperties().withContentLength(((FileGetPropertiesFromTaskHeaders)response.headers()).contentLength()).withContentType(((FileGetPropertiesFromTaskHeaders)response.headers()).contentType()).withCreationTime(((FileGetPropertiesFromTaskHeaders)response.headers()).ocpCreationTime()).withLastModified(((FileGetPropertiesFromTaskHeaders)response.headers()).lastModified()).withFileMode(((FileGetPropertiesFromTaskHeaders)response.headers()).ocpBatchFileMode());
    }

    public FileProperties getFilePropertiesFromComputeNode(String poolId, String nodeId, String fileName) throws BatchErrorException, IOException {
        return this.getFilePropertiesFromComputeNode(poolId, nodeId, fileName, null);
    }

    public FileProperties getFilePropertiesFromComputeNode(String poolId, String nodeId, String fileName, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        FileGetPropertiesFromComputeNodeOptions options = new FileGetPropertiesFromComputeNodeOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.parentBatchClient.protocolLayer().files().getPropertiesFromComputeNodeWithServiceResponseAsync(poolId, nodeId, fileName, options).toBlocking().single();
        return new FileProperties().withContentLength(((FileGetPropertiesFromComputeNodeHeaders)response.headers()).contentLength()).withContentType(((FileGetPropertiesFromComputeNodeHeaders)response.headers()).contentType()).withCreationTime(((FileGetPropertiesFromComputeNodeHeaders)response.headers()).ocpCreationTime()).withLastModified(((FileGetPropertiesFromComputeNodeHeaders)response.headers()).lastModified()).withFileMode(((FileGetPropertiesFromComputeNodeHeaders)response.headers()).ocpBatchFileMode());
    }
}

