/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.BatchClient;
import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.BehaviorManager;
import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.IInheritedBehaviors;
import com.microsoft.azure.batch.InternalHelper;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.CloudJob;
import com.microsoft.azure.batch.protocol.models.DisableJobOption;
import com.microsoft.azure.batch.protocol.models.JobAddOptions;
import com.microsoft.azure.batch.protocol.models.JobAddParameter;
import com.microsoft.azure.batch.protocol.models.JobConstraints;
import com.microsoft.azure.batch.protocol.models.JobDeleteOptions;
import com.microsoft.azure.batch.protocol.models.JobDisableOptions;
import com.microsoft.azure.batch.protocol.models.JobEnableOptions;
import com.microsoft.azure.batch.protocol.models.JobGetOptions;
import com.microsoft.azure.batch.protocol.models.JobGetTaskCountsOptions;
import com.microsoft.azure.batch.protocol.models.JobListFromJobScheduleOptions;
import com.microsoft.azure.batch.protocol.models.JobListOptions;
import com.microsoft.azure.batch.protocol.models.JobListPreparationAndReleaseTaskStatusOptions;
import com.microsoft.azure.batch.protocol.models.JobPatchOptions;
import com.microsoft.azure.batch.protocol.models.JobPatchParameter;
import com.microsoft.azure.batch.protocol.models.JobPreparationAndReleaseTaskExecutionInformation;
import com.microsoft.azure.batch.protocol.models.JobTerminateOptions;
import com.microsoft.azure.batch.protocol.models.JobUpdateOptions;
import com.microsoft.azure.batch.protocol.models.JobUpdateParameter;
import com.microsoft.azure.batch.protocol.models.MetadataItem;
import com.microsoft.azure.batch.protocol.models.OnAllTasksComplete;
import com.microsoft.azure.batch.protocol.models.PoolInformation;
import com.microsoft.azure.batch.protocol.models.TaskCounts;
import com.microsoft.azure.batch.protocol.models.TaskCountsResult;
import com.microsoft.azure.batch.protocol.models.TaskSlotCounts;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class JobOperations
implements IInheritedBehaviors {
    private Collection<BatchClientBehavior> customBehaviors;
    private final BatchClient parentBatchClient;

    JobOperations(BatchClient batchClient, Collection<BatchClientBehavior> inheritedBehaviors) {
        this.parentBatchClient = batchClient;
        InternalHelper.inheritClientBehaviorsAndSetPublicProperty(this, inheritedBehaviors);
    }

    @Override
    public Collection<BatchClientBehavior> customBehaviors() {
        return this.customBehaviors;
    }

    @Override
    public IInheritedBehaviors withCustomBehaviors(Collection<BatchClientBehavior> behaviors) {
        this.customBehaviors = behaviors;
        return this;
    }

    public CloudJob getJob(String jobId) throws BatchErrorException, IOException {
        return this.getJob(jobId, null, null);
    }

    public CloudJob getJob(String jobId, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.getJob(jobId, detailLevel, null);
    }

    public CloudJob getJob(String jobId, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobGetOptions getJobOptions = new JobGetOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(getJobOptions);
        return this.parentBatchClient.protocolLayer().jobs().get(jobId, getJobOptions);
    }

    public PagedList<CloudJob> listJobs() throws BatchErrorException, IOException {
        return this.listJobs(null, (Iterable<BatchClientBehavior>)null);
    }

    public PagedList<CloudJob> listJobs(DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listJobs(detailLevel, null);
    }

    public PagedList<CloudJob> listJobs(DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobListOptions jobListOptions = new JobListOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(jobListOptions);
        return this.parentBatchClient.protocolLayer().jobs().list(jobListOptions);
    }

    public PagedList<CloudJob> listJobs(String jobScheduleId) throws BatchErrorException, IOException {
        return this.listJobs(jobScheduleId, null, null);
    }

    public PagedList<CloudJob> listJobs(String jobScheduleId, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listJobs(jobScheduleId, detailLevel, null);
    }

    public PagedList<CloudJob> listJobs(String jobScheduleId, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobListFromJobScheduleOptions jobListOptions = new JobListFromJobScheduleOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(jobListOptions);
        return this.parentBatchClient.protocolLayer().jobs().listFromJobSchedule(jobScheduleId, jobListOptions);
    }

    public PagedList<JobPreparationAndReleaseTaskExecutionInformation> listPreparationAndReleaseTaskStatus(String jobId) throws BatchErrorException, IOException {
        return this.listPreparationAndReleaseTaskStatus(jobId, null);
    }

    public PagedList<JobPreparationAndReleaseTaskExecutionInformation> listPreparationAndReleaseTaskStatus(String jobId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobListPreparationAndReleaseTaskStatusOptions jobListOptions = new JobListPreparationAndReleaseTaskStatusOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(jobListOptions);
        return this.parentBatchClient.protocolLayer().jobs().listPreparationAndReleaseTaskStatus(jobId, jobListOptions);
    }

    public void createJob(String jobId, PoolInformation poolInfo) throws BatchErrorException, IOException {
        this.createJob(jobId, poolInfo, null);
    }

    public void createJob(String jobId, PoolInformation poolInfo, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobAddParameter param = new JobAddParameter().withId(jobId).withPoolInfo(poolInfo);
        this.createJob(param, additionalBehaviors);
    }

    public void createJob(JobAddParameter job) throws BatchErrorException, IOException {
        this.createJob(job, null);
    }

    public void createJob(JobAddParameter job, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobAddOptions options = new JobAddOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobs().add(job, options);
    }

    public void deleteJob(String jobId) throws BatchErrorException, IOException {
        this.deleteJob(jobId, null);
    }

    public void deleteJob(String jobId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobDeleteOptions options = new JobDeleteOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobs().delete(jobId, options);
    }

    public void terminateJob(String jobId) throws BatchErrorException, IOException {
        this.terminateJob(jobId, null, null);
    }

    public void terminateJob(String jobId, String terminateReason) throws BatchErrorException, IOException {
        this.terminateJob(jobId, terminateReason, null);
    }

    public void terminateJob(String jobId, String terminateReason, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobTerminateOptions options = new JobTerminateOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobs().terminate(jobId, terminateReason, options);
    }

    public void enableJob(String jobId) throws BatchErrorException, IOException {
        this.enableJob(jobId, null);
    }

    public void enableJob(String jobId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobEnableOptions options = new JobEnableOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobs().enable(jobId, options);
    }

    public void disableJob(String jobId, DisableJobOption disableJobOption) throws BatchErrorException, IOException {
        this.disableJob(jobId, disableJobOption, null);
    }

    public void disableJob(String jobId, DisableJobOption disableJobOption, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobDisableOptions options = new JobDisableOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobs().disable(jobId, disableJobOption, options);
    }

    public void updateJob(String jobId, PoolInformation poolInfo, Integer priority, JobConstraints constraints, OnAllTasksComplete onAllTasksComplete, List<MetadataItem> metadata) throws BatchErrorException, IOException {
        this.updateJob(jobId, poolInfo, priority, constraints, onAllTasksComplete, metadata, null);
    }

    public void updateJob(String jobId, PoolInformation poolInfo, Integer priority, JobConstraints constraints, OnAllTasksComplete onAllTasksComplete, List<MetadataItem> metadata, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobUpdateParameter param = new JobUpdateParameter().withPriority(priority).withPoolInfo(poolInfo).withConstraints(constraints).withOnAllTasksComplete(onAllTasksComplete).withMetadata(metadata);
        this.updateJob(jobId, param, additionalBehaviors);
    }

    public void updateJob(String jobId, JobUpdateParameter param) throws BatchErrorException, IOException {
        this.updateJob(jobId, param, null);
    }

    public void updateJob(String jobId, JobUpdateParameter param, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobUpdateOptions options = new JobUpdateOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobs().update(jobId, param, options);
    }

    public void patchJob(String jobId, PoolInformation poolInfo) throws BatchErrorException, IOException {
        this.patchJob(jobId, poolInfo, null, null, null, null, null);
    }

    public void patchJob(String jobId, OnAllTasksComplete onAllTasksComplete) throws BatchErrorException, IOException {
        this.patchJob(jobId, null, null, null, onAllTasksComplete, null, null);
    }

    public void patchJob(String jobId, PoolInformation poolInfo, Integer priority, JobConstraints constraints, OnAllTasksComplete onAllTasksComplete, List<MetadataItem> metadata) throws BatchErrorException, IOException {
        this.patchJob(jobId, poolInfo, priority, constraints, onAllTasksComplete, metadata, null);
    }

    public void patchJob(String jobId, PoolInformation poolInfo, Integer priority, JobConstraints constraints, OnAllTasksComplete onAllTasksComplete, List<MetadataItem> metadata, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobPatchParameter param = new JobPatchParameter().withPriority(priority).withPoolInfo(poolInfo).withConstraints(constraints).withOnAllTasksComplete(onAllTasksComplete).withMetadata(metadata);
        this.patchJob(jobId, param, additionalBehaviors);
    }

    public void patchJob(String jobId, JobPatchParameter jobPatchParameter) throws BatchErrorException, IOException {
        this.patchJob(jobId, jobPatchParameter, null);
    }

    public void patchJob(String jobId, JobPatchParameter jobPatchParameter, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobPatchOptions options = new JobPatchOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobs().patch(jobId, jobPatchParameter, options);
    }

    public TaskCounts getTaskCounts(String jobId) throws BatchErrorException, IOException {
        return this.getTaskCounts(jobId, null);
    }

    public TaskCounts getTaskCounts(String jobId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        return this.getTaskCountsResult(jobId, additionalBehaviors).taskCounts();
    }

    public TaskSlotCounts getTaskSlotCounts(String jobId) throws BatchErrorException, IOException {
        return this.getTaskSlotCounts(jobId, null);
    }

    public TaskSlotCounts getTaskSlotCounts(String jobId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        return this.getTaskCountsResult(jobId, additionalBehaviors).taskSlotCounts();
    }

    public TaskCountsResult getTaskCountsResult(String jobId) throws BatchErrorException, IOException {
        return this.getTaskCountsResult(jobId, null);
    }

    public TaskCountsResult getTaskCountsResult(String jobId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobGetTaskCountsOptions options = new JobGetTaskCountsOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().jobs().getTaskCounts(jobId, options);
    }
}

