/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.auth;

import com.microsoft.azure.batch.auth.BatchCredentials;
import com.microsoft.azure.batch.auth.BatchSharedKeyCredentialsInterceptor;
import okhttp3.OkHttpClient;

public class BatchSharedKeyCredentials
implements BatchCredentials {
    private String accountName;
    private String keyValue;
    private String baseUrl;

    public String accountName() {
        return this.accountName;
    }

    public String keyValue() {
        return this.keyValue;
    }

    public BatchSharedKeyCredentials(String baseUrl, String accountName, String keyValue) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Parameter baseUrl is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyValue == null) {
            throw new IllegalArgumentException("Parameter keyValue is required and cannot be null.");
        }
        this.baseUrl = baseUrl;
        this.accountName = accountName;
        this.keyValue = keyValue;
    }

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.interceptors().add(new BatchSharedKeyCredentialsInterceptor(this));
    }

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }
}

