/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.interceptor;

import com.microsoft.azure.batch.interceptor.BatchRequestInterceptHandler;
import com.microsoft.azure.batch.interceptor.RequestInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PageSizeInterceptor
extends RequestInterceptor {
    private final int maxResults;

    public PageSizeInterceptor(int pageSize) {
        this.maxResults = pageSize;
        this.withHandler(new BatchRequestInterceptHandler(){

            @Override
            public void modify(Object request) {
                Class<?> c = request.getClass();
                try {
                    Method maxResultsMethod = c.getMethod("withMaxResults", Integer.class);
                    maxResultsMethod.invoke(request, PageSizeInterceptor.this.maxResults);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
    }

    public int maxResults() {
        return this.maxResults;
    }
}

