/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.Accounts;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.AccountListPoolNodeCountsHeaders;
import com.microsoft.azure.batch.protocol.models.AccountListPoolNodeCountsNextOptions;
import com.microsoft.azure.batch.protocol.models.AccountListPoolNodeCountsOptions;
import com.microsoft.azure.batch.protocol.models.AccountListSupportedImagesHeaders;
import com.microsoft.azure.batch.protocol.models.AccountListSupportedImagesNextOptions;
import com.microsoft.azure.batch.protocol.models.AccountListSupportedImagesOptions;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.ImageInformation;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.azure.batch.protocol.models.PoolNodeCounts;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AccountsImpl
implements Accounts {
    private AccountsService service;
    private BatchServiceClientImpl client;

    public AccountsImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (AccountsService)retrofit.create(AccountsService.class);
        this.client = client;
    }

    @Override
    public PagedList<ImageInformation> listSupportedImages() {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSupportedImagesSinglePageAsync().toBlocking().single();
        return new PagedList<ImageInformation>((Page)response.body()){

            public Page<ImageInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)AccountsImpl.this.listSupportedImagesNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ImageInformation>> listSupportedImagesAsync(ListOperationCallback<ImageInformation> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSupportedImagesSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(String nextPageLink) {
                return AccountsImpl.this.listSupportedImagesNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ImageInformation>> listSupportedImagesAsync() {
        return this.listSupportedImagesWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>, Page<ImageInformation>>(){

            public Page<ImageInformation> call(ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> listSupportedImagesWithServiceResponseAsync() {
        return this.listSupportedImagesSinglePageAsync().concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listSupportedImagesNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> listSupportedImagesSinglePageAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object accountListSupportedImagesOptions = null;
        String filter = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listSupportedImages(this.client.apiVersion(), this.client.acceptLanguage(), filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = AccountsImpl.this.listSupportedImagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<ImageInformation> listSupportedImages(final AccountListSupportedImagesOptions accountListSupportedImagesOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSupportedImagesSinglePageAsync(accountListSupportedImagesOptions).toBlocking().single();
        return new PagedList<ImageInformation>((Page)response.body()){

            public Page<ImageInformation> nextPage(String nextPageLink) {
                AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions = null;
                if (accountListSupportedImagesOptions != null) {
                    accountListSupportedImagesNextOptions = new AccountListSupportedImagesNextOptions();
                    accountListSupportedImagesNextOptions.withClientRequestId(accountListSupportedImagesOptions.clientRequestId());
                    accountListSupportedImagesNextOptions.withReturnClientRequestId(accountListSupportedImagesOptions.returnClientRequestId());
                    accountListSupportedImagesNextOptions.withOcpDate(accountListSupportedImagesOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)AccountsImpl.this.listSupportedImagesNextSinglePageAsync(nextPageLink, accountListSupportedImagesNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ImageInformation>> listSupportedImagesAsync(final AccountListSupportedImagesOptions accountListSupportedImagesOptions, ListOperationCallback<ImageInformation> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSupportedImagesSinglePageAsync(accountListSupportedImagesOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(String nextPageLink) {
                AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions = null;
                if (accountListSupportedImagesOptions != null) {
                    accountListSupportedImagesNextOptions = new AccountListSupportedImagesNextOptions();
                    accountListSupportedImagesNextOptions.withClientRequestId(accountListSupportedImagesOptions.clientRequestId());
                    accountListSupportedImagesNextOptions.withReturnClientRequestId(accountListSupportedImagesOptions.returnClientRequestId());
                    accountListSupportedImagesNextOptions.withOcpDate(accountListSupportedImagesOptions.ocpDate());
                }
                return AccountsImpl.this.listSupportedImagesNextSinglePageAsync(nextPageLink, accountListSupportedImagesNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ImageInformation>> listSupportedImagesAsync(AccountListSupportedImagesOptions accountListSupportedImagesOptions) {
        return this.listSupportedImagesWithServiceResponseAsync(accountListSupportedImagesOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>, Page<ImageInformation>>(){

            public Page<ImageInformation> call(ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> listSupportedImagesWithServiceResponseAsync(final AccountListSupportedImagesOptions accountListSupportedImagesOptions) {
        return this.listSupportedImagesSinglePageAsync(accountListSupportedImagesOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions = null;
                if (accountListSupportedImagesOptions != null) {
                    accountListSupportedImagesNextOptions = new AccountListSupportedImagesNextOptions();
                    accountListSupportedImagesNextOptions.withClientRequestId(accountListSupportedImagesOptions.clientRequestId());
                    accountListSupportedImagesNextOptions.withReturnClientRequestId(accountListSupportedImagesOptions.returnClientRequestId());
                    accountListSupportedImagesNextOptions.withOcpDate(accountListSupportedImagesOptions.ocpDate());
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listSupportedImagesNextWithServiceResponseAsync(nextPageLink, accountListSupportedImagesNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> listSupportedImagesSinglePageAsync(AccountListSupportedImagesOptions accountListSupportedImagesOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)accountListSupportedImagesOptions);
        String filter = null;
        if (accountListSupportedImagesOptions != null) {
            filter = accountListSupportedImagesOptions.filter();
        }
        Integer maxResults = null;
        if (accountListSupportedImagesOptions != null) {
            maxResults = accountListSupportedImagesOptions.maxResults();
        }
        Integer timeout = null;
        if (accountListSupportedImagesOptions != null) {
            timeout = accountListSupportedImagesOptions.timeout();
        }
        UUID clientRequestId = null;
        if (accountListSupportedImagesOptions != null) {
            clientRequestId = accountListSupportedImagesOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (accountListSupportedImagesOptions != null) {
            returnClientRequestId = accountListSupportedImagesOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (accountListSupportedImagesOptions != null) {
            ocpDate = accountListSupportedImagesOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listSupportedImages(this.client.apiVersion(), this.client.acceptLanguage(), filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = AccountsImpl.this.listSupportedImagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<ImageInformation>, AccountListSupportedImagesHeaders> listSupportedImagesDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ImageInformation>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, AccountListSupportedImagesHeaders.class);
    }

    @Override
    public PagedList<PoolNodeCounts> listPoolNodeCounts() {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listPoolNodeCountsSinglePageAsync().toBlocking().single();
        return new PagedList<PoolNodeCounts>((Page)response.body()){

            public Page<PoolNodeCounts> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)AccountsImpl.this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<PoolNodeCounts>> listPoolNodeCountsAsync(ListOperationCallback<PoolNodeCounts> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listPoolNodeCountsSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(String nextPageLink) {
                return AccountsImpl.this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PoolNodeCounts>> listPoolNodeCountsAsync() {
        return this.listPoolNodeCountsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>, Page<PoolNodeCounts>>(){

            public Page<PoolNodeCounts> call(ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> listPoolNodeCountsWithServiceResponseAsync() {
        return this.listPoolNodeCountsSinglePageAsync().concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listPoolNodeCountsNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> listPoolNodeCountsSinglePageAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object accountListPoolNodeCountsOptions = null;
        String filter = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listPoolNodeCounts(this.client.apiVersion(), this.client.acceptLanguage(), filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = AccountsImpl.this.listPoolNodeCountsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<PoolNodeCounts> listPoolNodeCounts(final AccountListPoolNodeCountsOptions accountListPoolNodeCountsOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listPoolNodeCountsSinglePageAsync(accountListPoolNodeCountsOptions).toBlocking().single();
        return new PagedList<PoolNodeCounts>((Page)response.body()){

            public Page<PoolNodeCounts> nextPage(String nextPageLink) {
                AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions = null;
                if (accountListPoolNodeCountsOptions != null) {
                    accountListPoolNodeCountsNextOptions = new AccountListPoolNodeCountsNextOptions();
                    accountListPoolNodeCountsNextOptions.withClientRequestId(accountListPoolNodeCountsOptions.clientRequestId());
                    accountListPoolNodeCountsNextOptions.withReturnClientRequestId(accountListPoolNodeCountsOptions.returnClientRequestId());
                    accountListPoolNodeCountsNextOptions.withOcpDate(accountListPoolNodeCountsOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)AccountsImpl.this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, accountListPoolNodeCountsNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<PoolNodeCounts>> listPoolNodeCountsAsync(final AccountListPoolNodeCountsOptions accountListPoolNodeCountsOptions, ListOperationCallback<PoolNodeCounts> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listPoolNodeCountsSinglePageAsync(accountListPoolNodeCountsOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(String nextPageLink) {
                AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions = null;
                if (accountListPoolNodeCountsOptions != null) {
                    accountListPoolNodeCountsNextOptions = new AccountListPoolNodeCountsNextOptions();
                    accountListPoolNodeCountsNextOptions.withClientRequestId(accountListPoolNodeCountsOptions.clientRequestId());
                    accountListPoolNodeCountsNextOptions.withReturnClientRequestId(accountListPoolNodeCountsOptions.returnClientRequestId());
                    accountListPoolNodeCountsNextOptions.withOcpDate(accountListPoolNodeCountsOptions.ocpDate());
                }
                return AccountsImpl.this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, accountListPoolNodeCountsNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PoolNodeCounts>> listPoolNodeCountsAsync(AccountListPoolNodeCountsOptions accountListPoolNodeCountsOptions) {
        return this.listPoolNodeCountsWithServiceResponseAsync(accountListPoolNodeCountsOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>, Page<PoolNodeCounts>>(){

            public Page<PoolNodeCounts> call(ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> listPoolNodeCountsWithServiceResponseAsync(final AccountListPoolNodeCountsOptions accountListPoolNodeCountsOptions) {
        return this.listPoolNodeCountsSinglePageAsync(accountListPoolNodeCountsOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions = null;
                if (accountListPoolNodeCountsOptions != null) {
                    accountListPoolNodeCountsNextOptions = new AccountListPoolNodeCountsNextOptions();
                    accountListPoolNodeCountsNextOptions.withClientRequestId(accountListPoolNodeCountsOptions.clientRequestId());
                    accountListPoolNodeCountsNextOptions.withReturnClientRequestId(accountListPoolNodeCountsOptions.returnClientRequestId());
                    accountListPoolNodeCountsNextOptions.withOcpDate(accountListPoolNodeCountsOptions.ocpDate());
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listPoolNodeCountsNextWithServiceResponseAsync(nextPageLink, accountListPoolNodeCountsNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> listPoolNodeCountsSinglePageAsync(AccountListPoolNodeCountsOptions accountListPoolNodeCountsOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)accountListPoolNodeCountsOptions);
        String filter = null;
        if (accountListPoolNodeCountsOptions != null) {
            filter = accountListPoolNodeCountsOptions.filter();
        }
        Integer maxResults = null;
        if (accountListPoolNodeCountsOptions != null) {
            maxResults = accountListPoolNodeCountsOptions.maxResults();
        }
        Integer timeout = null;
        if (accountListPoolNodeCountsOptions != null) {
            timeout = accountListPoolNodeCountsOptions.timeout();
        }
        UUID clientRequestId = null;
        if (accountListPoolNodeCountsOptions != null) {
            clientRequestId = accountListPoolNodeCountsOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (accountListPoolNodeCountsOptions != null) {
            returnClientRequestId = accountListPoolNodeCountsOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (accountListPoolNodeCountsOptions != null) {
            ocpDate = accountListPoolNodeCountsOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listPoolNodeCounts(this.client.apiVersion(), this.client.acceptLanguage(), filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = AccountsImpl.this.listPoolNodeCountsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> listPoolNodeCountsDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PoolNodeCounts>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, AccountListPoolNodeCountsHeaders.class);
    }

    @Override
    public PagedList<ImageInformation> listSupportedImagesNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSupportedImagesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ImageInformation>((Page)response.body()){

            public Page<ImageInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)AccountsImpl.this.listSupportedImagesNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ImageInformation>> listSupportedImagesNextAsync(String nextPageLink, ServiceFuture<List<ImageInformation>> serviceFuture, ListOperationCallback<ImageInformation> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSupportedImagesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(String nextPageLink) {
                return AccountsImpl.this.listSupportedImagesNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ImageInformation>> listSupportedImagesNextAsync(String nextPageLink) {
        return this.listSupportedImagesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>, Page<ImageInformation>>(){

            public Page<ImageInformation> call(ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> listSupportedImagesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSupportedImagesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listSupportedImagesNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> listSupportedImagesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object accountListSupportedImagesNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSupportedImagesNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = AccountsImpl.this.listSupportedImagesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<ImageInformation> listSupportedImagesNext(String nextPageLink, final AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSupportedImagesNextSinglePageAsync(nextPageLink, accountListSupportedImagesNextOptions).toBlocking().single();
        return new PagedList<ImageInformation>((Page)response.body()){

            public Page<ImageInformation> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)AccountsImpl.this.listSupportedImagesNextSinglePageAsync(nextPageLink, accountListSupportedImagesNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ImageInformation>> listSupportedImagesNextAsync(String nextPageLink, final AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions, ServiceFuture<List<ImageInformation>> serviceFuture, ListOperationCallback<ImageInformation> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSupportedImagesNextSinglePageAsync(nextPageLink, accountListSupportedImagesNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(String nextPageLink) {
                return AccountsImpl.this.listSupportedImagesNextSinglePageAsync(nextPageLink, accountListSupportedImagesNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ImageInformation>> listSupportedImagesNextAsync(String nextPageLink, AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions) {
        return this.listSupportedImagesNextWithServiceResponseAsync(nextPageLink, accountListSupportedImagesNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>, Page<ImageInformation>>(){

            public Page<ImageInformation> call(ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> listSupportedImagesNextWithServiceResponseAsync(String nextPageLink, final AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions) {
        return this.listSupportedImagesNextSinglePageAsync(nextPageLink, accountListSupportedImagesNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listSupportedImagesNextWithServiceResponseAsync(nextPageLink, accountListSupportedImagesNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> listSupportedImagesNextSinglePageAsync(String nextPageLink, AccountListSupportedImagesNextOptions accountListSupportedImagesNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)accountListSupportedImagesNextOptions);
        UUID clientRequestId = null;
        if (accountListSupportedImagesNextOptions != null) {
            clientRequestId = accountListSupportedImagesNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (accountListSupportedImagesNextOptions != null) {
            returnClientRequestId = accountListSupportedImagesNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (accountListSupportedImagesNextOptions != null) {
            ocpDate = accountListSupportedImagesNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSupportedImagesNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ImageInformation>, AccountListSupportedImagesHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = AccountsImpl.this.listSupportedImagesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<ImageInformation>, AccountListSupportedImagesHeaders> listSupportedImagesNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ImageInformation>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, AccountListSupportedImagesHeaders.class);
    }

    @Override
    public PagedList<PoolNodeCounts> listPoolNodeCountsNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listPoolNodeCountsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PoolNodeCounts>((Page)response.body()){

            public Page<PoolNodeCounts> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)AccountsImpl.this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<PoolNodeCounts>> listPoolNodeCountsNextAsync(String nextPageLink, ServiceFuture<List<PoolNodeCounts>> serviceFuture, ListOperationCallback<PoolNodeCounts> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listPoolNodeCountsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(String nextPageLink) {
                return AccountsImpl.this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PoolNodeCounts>> listPoolNodeCountsNextAsync(String nextPageLink) {
        return this.listPoolNodeCountsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>, Page<PoolNodeCounts>>(){

            public Page<PoolNodeCounts> call(ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> listPoolNodeCountsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listPoolNodeCountsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listPoolNodeCountsNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> listPoolNodeCountsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object accountListPoolNodeCountsNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listPoolNodeCountsNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = AccountsImpl.this.listPoolNodeCountsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<PoolNodeCounts> listPoolNodeCountsNext(String nextPageLink, final AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, accountListPoolNodeCountsNextOptions).toBlocking().single();
        return new PagedList<PoolNodeCounts>((Page)response.body()){

            public Page<PoolNodeCounts> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)AccountsImpl.this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, accountListPoolNodeCountsNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<PoolNodeCounts>> listPoolNodeCountsNextAsync(String nextPageLink, final AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions, ServiceFuture<List<PoolNodeCounts>> serviceFuture, ListOperationCallback<PoolNodeCounts> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, accountListPoolNodeCountsNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(String nextPageLink) {
                return AccountsImpl.this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, accountListPoolNodeCountsNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PoolNodeCounts>> listPoolNodeCountsNextAsync(String nextPageLink, AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions) {
        return this.listPoolNodeCountsNextWithServiceResponseAsync(nextPageLink, accountListPoolNodeCountsNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>, Page<PoolNodeCounts>>(){

            public Page<PoolNodeCounts> call(ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> listPoolNodeCountsNextWithServiceResponseAsync(String nextPageLink, final AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions) {
        return this.listPoolNodeCountsNextSinglePageAsync(nextPageLink, accountListPoolNodeCountsNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AccountsImpl.this.listPoolNodeCountsNextWithServiceResponseAsync(nextPageLink, accountListPoolNodeCountsNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> listPoolNodeCountsNextSinglePageAsync(String nextPageLink, AccountListPoolNodeCountsNextOptions accountListPoolNodeCountsNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)accountListPoolNodeCountsNextOptions);
        UUID clientRequestId = null;
        if (accountListPoolNodeCountsNextOptions != null) {
            clientRequestId = accountListPoolNodeCountsNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (accountListPoolNodeCountsNextOptions != null) {
            returnClientRequestId = accountListPoolNodeCountsNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (accountListPoolNodeCountsNextOptions != null) {
            ocpDate = accountListPoolNodeCountsNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listPoolNodeCountsNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolNodeCounts>, AccountListPoolNodeCountsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = AccountsImpl.this.listPoolNodeCountsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<PoolNodeCounts>, AccountListPoolNodeCountsHeaders> listPoolNodeCountsNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PoolNodeCounts>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, AccountListPoolNodeCountsHeaders.class);
    }

    static interface AccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Accounts listSupportedImages"})
        @GET(value="supportedimages")
        public Observable<Response<ResponseBody>> listSupportedImages(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="$filter") String var3, @Query(value="maxresults") Integer var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Accounts listPoolNodeCounts"})
        @GET(value="nodecounts")
        public Observable<Response<ResponseBody>> listPoolNodeCounts(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="$filter") String var3, @Query(value="maxresults") Integer var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Accounts listSupportedImagesNext"})
        @GET
        public Observable<Response<ResponseBody>> listSupportedImagesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Accounts listPoolNodeCountsNext"})
        @GET
        public Observable<Response<ResponseBody>> listPoolNodeCountsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

