/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.Certificates;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.Certificate;
import com.microsoft.azure.batch.protocol.models.CertificateAddHeaders;
import com.microsoft.azure.batch.protocol.models.CertificateAddOptions;
import com.microsoft.azure.batch.protocol.models.CertificateAddParameter;
import com.microsoft.azure.batch.protocol.models.CertificateCancelDeletionHeaders;
import com.microsoft.azure.batch.protocol.models.CertificateCancelDeletionOptions;
import com.microsoft.azure.batch.protocol.models.CertificateDeleteHeaders;
import com.microsoft.azure.batch.protocol.models.CertificateDeleteOptions;
import com.microsoft.azure.batch.protocol.models.CertificateGetHeaders;
import com.microsoft.azure.batch.protocol.models.CertificateGetOptions;
import com.microsoft.azure.batch.protocol.models.CertificateListHeaders;
import com.microsoft.azure.batch.protocol.models.CertificateListNextOptions;
import com.microsoft.azure.batch.protocol.models.CertificateListOptions;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class CertificatesImpl
implements Certificates {
    private CertificatesService service;
    private BatchServiceClientImpl client;

    public CertificatesImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (CertificatesService)retrofit.create(CertificatesService.class);
        this.client = client;
    }

    @Override
    public void add(CertificateAddParameter certificate) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(certificate).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(CertificateAddParameter certificate, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(certificate), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(CertificateAddParameter certificate) {
        return this.addWithServiceResponseAsync(certificate).map((Func1)new Func1<ServiceResponseWithHeaders<Void, CertificateAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, CertificateAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, CertificateAddHeaders>> addWithServiceResponseAsync(CertificateAddParameter certificate) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Parameter certificate is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificate);
        Object certificateAddOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(certificate, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, CertificateAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, CertificateAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void add(CertificateAddParameter certificate, CertificateAddOptions certificateAddOptions) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(certificate, certificateAddOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(CertificateAddParameter certificate, CertificateAddOptions certificateAddOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(certificate, certificateAddOptions), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(CertificateAddParameter certificate, CertificateAddOptions certificateAddOptions) {
        return this.addWithServiceResponseAsync(certificate, certificateAddOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, CertificateAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, CertificateAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, CertificateAddHeaders>> addWithServiceResponseAsync(CertificateAddParameter certificate, CertificateAddOptions certificateAddOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Parameter certificate is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificate);
        Validator.validate((Object)certificateAddOptions);
        Integer timeout = null;
        if (certificateAddOptions != null) {
            timeout = certificateAddOptions.timeout();
        }
        UUID clientRequestId = null;
        if (certificateAddOptions != null) {
            clientRequestId = certificateAddOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (certificateAddOptions != null) {
            returnClientRequestId = certificateAddOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (certificateAddOptions != null) {
            ocpDate = certificateAddOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(certificate, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, CertificateAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, CertificateAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, CertificateAddHeaders> addDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, CertificateAddHeaders.class);
    }

    @Override
    public PagedList<Certificate> list() {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<Certificate>((Page)response.body()){

            public Page<Certificate> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)CertificatesImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Certificate>> listAsync(ListOperationCallback<Certificate> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(String nextPageLink) {
                return CertificatesImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Certificate>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>, Page<Certificate>>(){

            public Page<Certificate> call(ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CertificatesImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> listSinglePageAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object certificateListOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = CertificatesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<Certificate> list(final CertificateListOptions certificateListOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(certificateListOptions).toBlocking().single();
        return new PagedList<Certificate>((Page)response.body()){

            public Page<Certificate> nextPage(String nextPageLink) {
                CertificateListNextOptions certificateListNextOptions = null;
                if (certificateListOptions != null) {
                    certificateListNextOptions = new CertificateListNextOptions();
                    certificateListNextOptions.withClientRequestId(certificateListOptions.clientRequestId());
                    certificateListNextOptions.withReturnClientRequestId(certificateListOptions.returnClientRequestId());
                    certificateListNextOptions.withOcpDate(certificateListOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)CertificatesImpl.this.listNextSinglePageAsync(nextPageLink, certificateListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Certificate>> listAsync(final CertificateListOptions certificateListOptions, ListOperationCallback<Certificate> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(certificateListOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(String nextPageLink) {
                CertificateListNextOptions certificateListNextOptions = null;
                if (certificateListOptions != null) {
                    certificateListNextOptions = new CertificateListNextOptions();
                    certificateListNextOptions.withClientRequestId(certificateListOptions.clientRequestId());
                    certificateListNextOptions.withReturnClientRequestId(certificateListOptions.returnClientRequestId());
                    certificateListNextOptions.withOcpDate(certificateListOptions.ocpDate());
                }
                return CertificatesImpl.this.listNextSinglePageAsync(nextPageLink, certificateListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Certificate>> listAsync(CertificateListOptions certificateListOptions) {
        return this.listWithServiceResponseAsync(certificateListOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>, Page<Certificate>>(){

            public Page<Certificate> call(ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> listWithServiceResponseAsync(final CertificateListOptions certificateListOptions) {
        return this.listSinglePageAsync(certificateListOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                CertificateListNextOptions certificateListNextOptions = null;
                if (certificateListOptions != null) {
                    certificateListNextOptions = new CertificateListNextOptions();
                    certificateListNextOptions.withClientRequestId(certificateListOptions.clientRequestId());
                    certificateListNextOptions.withReturnClientRequestId(certificateListOptions.returnClientRequestId());
                    certificateListNextOptions.withOcpDate(certificateListOptions.ocpDate());
                }
                return Observable.just(page).concatWith(CertificatesImpl.this.listNextWithServiceResponseAsync(nextPageLink, certificateListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> listSinglePageAsync(CertificateListOptions certificateListOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificateListOptions);
        String filter = null;
        if (certificateListOptions != null) {
            filter = certificateListOptions.filter();
        }
        String select = null;
        if (certificateListOptions != null) {
            select = certificateListOptions.select();
        }
        Integer maxResults = null;
        if (certificateListOptions != null) {
            maxResults = certificateListOptions.maxResults();
        }
        Integer timeout = null;
        if (certificateListOptions != null) {
            timeout = certificateListOptions.timeout();
        }
        UUID clientRequestId = null;
        if (certificateListOptions != null) {
            clientRequestId = certificateListOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (certificateListOptions != null) {
            returnClientRequestId = certificateListOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (certificateListOptions != null) {
            ocpDate = certificateListOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = CertificatesImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<Certificate>, CertificateListHeaders> listDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Certificate>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, CertificateListHeaders.class);
    }

    @Override
    public void cancelDeletion(String thumbprintAlgorithm, String thumbprint) {
        ((ServiceResponseWithHeaders)this.cancelDeletionWithServiceResponseAsync(thumbprintAlgorithm, thumbprint).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> cancelDeletionAsync(String thumbprintAlgorithm, String thumbprint, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.cancelDeletionWithServiceResponseAsync(thumbprintAlgorithm, thumbprint), serviceCallback);
    }

    @Override
    public Observable<Void> cancelDeletionAsync(String thumbprintAlgorithm, String thumbprint) {
        return this.cancelDeletionWithServiceResponseAsync(thumbprintAlgorithm, thumbprint).map((Func1)new Func1<ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders>> cancelDeletionWithServiceResponseAsync(String thumbprintAlgorithm, String thumbprint) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (thumbprintAlgorithm == null) {
            throw new IllegalArgumentException("Parameter thumbprintAlgorithm is required and cannot be null.");
        }
        if (thumbprint == null) {
            throw new IllegalArgumentException("Parameter thumbprint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object certificateCancelDeletionOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.cancelDeletion(thumbprintAlgorithm, thumbprint, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesImpl.this.cancelDeletionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void cancelDeletion(String thumbprintAlgorithm, String thumbprint, CertificateCancelDeletionOptions certificateCancelDeletionOptions) {
        ((ServiceResponseWithHeaders)this.cancelDeletionWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateCancelDeletionOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> cancelDeletionAsync(String thumbprintAlgorithm, String thumbprint, CertificateCancelDeletionOptions certificateCancelDeletionOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.cancelDeletionWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateCancelDeletionOptions), serviceCallback);
    }

    @Override
    public Observable<Void> cancelDeletionAsync(String thumbprintAlgorithm, String thumbprint, CertificateCancelDeletionOptions certificateCancelDeletionOptions) {
        return this.cancelDeletionWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateCancelDeletionOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders>> cancelDeletionWithServiceResponseAsync(String thumbprintAlgorithm, String thumbprint, CertificateCancelDeletionOptions certificateCancelDeletionOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (thumbprintAlgorithm == null) {
            throw new IllegalArgumentException("Parameter thumbprintAlgorithm is required and cannot be null.");
        }
        if (thumbprint == null) {
            throw new IllegalArgumentException("Parameter thumbprint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificateCancelDeletionOptions);
        Integer timeout = null;
        if (certificateCancelDeletionOptions != null) {
            timeout = certificateCancelDeletionOptions.timeout();
        }
        UUID clientRequestId = null;
        if (certificateCancelDeletionOptions != null) {
            clientRequestId = certificateCancelDeletionOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (certificateCancelDeletionOptions != null) {
            returnClientRequestId = certificateCancelDeletionOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (certificateCancelDeletionOptions != null) {
            ocpDate = certificateCancelDeletionOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.cancelDeletion(thumbprintAlgorithm, thumbprint, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesImpl.this.cancelDeletionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, CertificateCancelDeletionHeaders> cancelDeletionDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, CertificateCancelDeletionHeaders.class);
    }

    @Override
    public void delete(String thumbprintAlgorithm, String thumbprint) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(thumbprintAlgorithm, thumbprint).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String thumbprintAlgorithm, String thumbprint, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(thumbprintAlgorithm, thumbprint), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String thumbprintAlgorithm, String thumbprint) {
        return this.deleteWithServiceResponseAsync(thumbprintAlgorithm, thumbprint).map((Func1)new Func1<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> deleteWithServiceResponseAsync(String thumbprintAlgorithm, String thumbprint) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (thumbprintAlgorithm == null) {
            throw new IllegalArgumentException("Parameter thumbprintAlgorithm is required and cannot be null.");
        }
        if (thumbprint == null) {
            throw new IllegalArgumentException("Parameter thumbprint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object certificateDeleteOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.delete(thumbprintAlgorithm, thumbprint, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void delete(String thumbprintAlgorithm, String thumbprint, CertificateDeleteOptions certificateDeleteOptions) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateDeleteOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String thumbprintAlgorithm, String thumbprint, CertificateDeleteOptions certificateDeleteOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateDeleteOptions), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String thumbprintAlgorithm, String thumbprint, CertificateDeleteOptions certificateDeleteOptions) {
        return this.deleteWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateDeleteOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> deleteWithServiceResponseAsync(String thumbprintAlgorithm, String thumbprint, CertificateDeleteOptions certificateDeleteOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (thumbprintAlgorithm == null) {
            throw new IllegalArgumentException("Parameter thumbprintAlgorithm is required and cannot be null.");
        }
        if (thumbprint == null) {
            throw new IllegalArgumentException("Parameter thumbprint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificateDeleteOptions);
        Integer timeout = null;
        if (certificateDeleteOptions != null) {
            timeout = certificateDeleteOptions.timeout();
        }
        UUID clientRequestId = null;
        if (certificateDeleteOptions != null) {
            clientRequestId = certificateDeleteOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (certificateDeleteOptions != null) {
            returnClientRequestId = certificateDeleteOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (certificateDeleteOptions != null) {
            ocpDate = certificateDeleteOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.delete(thumbprintAlgorithm, thumbprint, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> deleteDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, CertificateDeleteHeaders.class);
    }

    @Override
    public Certificate get(String thumbprintAlgorithm, String thumbprint) {
        return (Certificate)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(thumbprintAlgorithm, thumbprint).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Certificate> getAsync(String thumbprintAlgorithm, String thumbprint, ServiceCallback<Certificate> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(thumbprintAlgorithm, thumbprint), serviceCallback);
    }

    @Override
    public Observable<Certificate> getAsync(String thumbprintAlgorithm, String thumbprint) {
        return this.getWithServiceResponseAsync(thumbprintAlgorithm, thumbprint).map((Func1)new Func1<ServiceResponseWithHeaders<Certificate, CertificateGetHeaders>, Certificate>(){

            public Certificate call(ServiceResponseWithHeaders<Certificate, CertificateGetHeaders> response) {
                return (Certificate)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Certificate, CertificateGetHeaders>> getWithServiceResponseAsync(String thumbprintAlgorithm, String thumbprint) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (thumbprintAlgorithm == null) {
            throw new IllegalArgumentException("Parameter thumbprintAlgorithm is required and cannot be null.");
        }
        if (thumbprint == null) {
            throw new IllegalArgumentException("Parameter thumbprint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object certificateGetOptions = null;
        String select = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.get(thumbprintAlgorithm, thumbprint, this.client.apiVersion(), this.client.acceptLanguage(), select, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Certificate, CertificateGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Certificate, CertificateGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Certificate get(String thumbprintAlgorithm, String thumbprint, CertificateGetOptions certificateGetOptions) {
        return (Certificate)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateGetOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Certificate> getAsync(String thumbprintAlgorithm, String thumbprint, CertificateGetOptions certificateGetOptions, ServiceCallback<Certificate> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateGetOptions), serviceCallback);
    }

    @Override
    public Observable<Certificate> getAsync(String thumbprintAlgorithm, String thumbprint, CertificateGetOptions certificateGetOptions) {
        return this.getWithServiceResponseAsync(thumbprintAlgorithm, thumbprint, certificateGetOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Certificate, CertificateGetHeaders>, Certificate>(){

            public Certificate call(ServiceResponseWithHeaders<Certificate, CertificateGetHeaders> response) {
                return (Certificate)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Certificate, CertificateGetHeaders>> getWithServiceResponseAsync(String thumbprintAlgorithm, String thumbprint, CertificateGetOptions certificateGetOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (thumbprintAlgorithm == null) {
            throw new IllegalArgumentException("Parameter thumbprintAlgorithm is required and cannot be null.");
        }
        if (thumbprint == null) {
            throw new IllegalArgumentException("Parameter thumbprint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificateGetOptions);
        String select = null;
        if (certificateGetOptions != null) {
            select = certificateGetOptions.select();
        }
        Integer timeout = null;
        if (certificateGetOptions != null) {
            timeout = certificateGetOptions.timeout();
        }
        UUID clientRequestId = null;
        if (certificateGetOptions != null) {
            clientRequestId = certificateGetOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (certificateGetOptions != null) {
            returnClientRequestId = certificateGetOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (certificateGetOptions != null) {
            ocpDate = certificateGetOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.get(thumbprintAlgorithm, thumbprint, this.client.apiVersion(), this.client.acceptLanguage(), select, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Certificate, CertificateGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Certificate, CertificateGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = CertificatesImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Certificate, CertificateGetHeaders> getDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Certificate>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, CertificateGetHeaders.class);
    }

    @Override
    public PagedList<Certificate> listNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<Certificate>((Page)response.body()){

            public Page<Certificate> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)CertificatesImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Certificate>> listNextAsync(String nextPageLink, ServiceFuture<List<Certificate>> serviceFuture, ListOperationCallback<Certificate> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(String nextPageLink) {
                return CertificatesImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Certificate>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>, Page<Certificate>>(){

            public Page<Certificate> call(ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CertificatesImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object certificateListNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = CertificatesImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<Certificate> listNext(String nextPageLink, final CertificateListNextOptions certificateListNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink, certificateListNextOptions).toBlocking().single();
        return new PagedList<Certificate>((Page)response.body()){

            public Page<Certificate> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)CertificatesImpl.this.listNextSinglePageAsync(nextPageLink, certificateListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<Certificate>> listNextAsync(String nextPageLink, final CertificateListNextOptions certificateListNextOptions, ServiceFuture<List<Certificate>> serviceFuture, ListOperationCallback<Certificate> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink, certificateListNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(String nextPageLink) {
                return CertificatesImpl.this.listNextSinglePageAsync(nextPageLink, certificateListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<Certificate>> listNextAsync(String nextPageLink, CertificateListNextOptions certificateListNextOptions) {
        return this.listNextWithServiceResponseAsync(nextPageLink, certificateListNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>, Page<Certificate>>(){

            public Page<Certificate> call(ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> listNextWithServiceResponseAsync(String nextPageLink, final CertificateListNextOptions certificateListNextOptions) {
        return this.listNextSinglePageAsync(nextPageLink, certificateListNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CertificatesImpl.this.listNextWithServiceResponseAsync(nextPageLink, certificateListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> listNextSinglePageAsync(String nextPageLink, CertificateListNextOptions certificateListNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)certificateListNextOptions);
        UUID clientRequestId = null;
        if (certificateListNextOptions != null) {
            clientRequestId = certificateListNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (certificateListNextOptions != null) {
            returnClientRequestId = certificateListNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (certificateListNextOptions != null) {
            ocpDate = certificateListNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<Certificate>, CertificateListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = CertificatesImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<Certificate>, CertificateListHeaders> listNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<Certificate>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, CertificateListHeaders.class);
    }

    static interface CertificatesService {
        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Certificates add"})
        @POST(value="certificates")
        public Observable<Response<ResponseBody>> add(@Body CertificateAddParameter var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Certificates list"})
        @GET(value="certificates")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="$filter") String var3, @Query(value="$select") String var4, @Query(value="maxresults") Integer var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Certificates cancelDeletion"})
        @POST(value="certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})/canceldelete")
        public Observable<Response<ResponseBody>> cancelDeletion(@Path(value="thumbprintAlgorithm") String var1, @Path(value="thumbprint") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Certificates delete"})
        @HTTP(path="certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="thumbprintAlgorithm") String var1, @Path(value="thumbprint") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Certificates get"})
        @GET(value="certificates(thumbprintAlgorithm={thumbprintAlgorithm},thumbprint={thumbprint})")
        public Observable<Response<ResponseBody>> get(@Path(value="thumbprintAlgorithm") String var1, @Path(value="thumbprint") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="$select") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="x-ms-parameterized-host") String var10, @Header(value="User-Agent") String var11);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Certificates listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

