/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.ComputeNodeExtensions;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.ComputeNodeExtensionGetHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeExtensionGetOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeExtensionListHeaders;
import com.microsoft.azure.batch.protocol.models.ComputeNodeExtensionListNextOptions;
import com.microsoft.azure.batch.protocol.models.ComputeNodeExtensionListOptions;
import com.microsoft.azure.batch.protocol.models.NodeVMExtension;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ComputeNodeExtensionsImpl
implements ComputeNodeExtensions {
    private ComputeNodeExtensionsService service;
    private BatchServiceClientImpl client;

    public ComputeNodeExtensionsImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (ComputeNodeExtensionsService)retrofit.create(ComputeNodeExtensionsService.class);
        this.client = client;
    }

    @Override
    public NodeVMExtension get(String poolId, String nodeId, String extensionName) {
        return (NodeVMExtension)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(poolId, nodeId, extensionName).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<NodeVMExtension> getAsync(String poolId, String nodeId, String extensionName, ServiceCallback<NodeVMExtension> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(poolId, nodeId, extensionName), serviceCallback);
    }

    @Override
    public Observable<NodeVMExtension> getAsync(String poolId, String nodeId, String extensionName) {
        return this.getWithServiceResponseAsync(poolId, nodeId, extensionName).map((Func1)new Func1<ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders>, NodeVMExtension>(){

            public NodeVMExtension call(ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders> response) {
                return (NodeVMExtension)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders>> getWithServiceResponseAsync(String poolId, String nodeId, String extensionName) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (extensionName == null) {
            throw new IllegalArgumentException("Parameter extensionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object computeNodeExtensionGetOptions = null;
        String select = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.get(poolId, nodeId, extensionName, this.client.apiVersion(), this.client.acceptLanguage(), select, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodeExtensionsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public NodeVMExtension get(String poolId, String nodeId, String extensionName, ComputeNodeExtensionGetOptions computeNodeExtensionGetOptions) {
        return (NodeVMExtension)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(poolId, nodeId, extensionName, computeNodeExtensionGetOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<NodeVMExtension> getAsync(String poolId, String nodeId, String extensionName, ComputeNodeExtensionGetOptions computeNodeExtensionGetOptions, ServiceCallback<NodeVMExtension> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(poolId, nodeId, extensionName, computeNodeExtensionGetOptions), serviceCallback);
    }

    @Override
    public Observable<NodeVMExtension> getAsync(String poolId, String nodeId, String extensionName, ComputeNodeExtensionGetOptions computeNodeExtensionGetOptions) {
        return this.getWithServiceResponseAsync(poolId, nodeId, extensionName, computeNodeExtensionGetOptions).map((Func1)new Func1<ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders>, NodeVMExtension>(){

            public NodeVMExtension call(ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders> response) {
                return (NodeVMExtension)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders>> getWithServiceResponseAsync(String poolId, String nodeId, String extensionName, ComputeNodeExtensionGetOptions computeNodeExtensionGetOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (extensionName == null) {
            throw new IllegalArgumentException("Parameter extensionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeExtensionGetOptions);
        String select = null;
        if (computeNodeExtensionGetOptions != null) {
            select = computeNodeExtensionGetOptions.select();
        }
        Integer timeout = null;
        if (computeNodeExtensionGetOptions != null) {
            timeout = computeNodeExtensionGetOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeExtensionGetOptions != null) {
            clientRequestId = computeNodeExtensionGetOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeExtensionGetOptions != null) {
            returnClientRequestId = computeNodeExtensionGetOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeExtensionGetOptions != null) {
            ocpDate = computeNodeExtensionGetOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.get(poolId, nodeId, extensionName, this.client.apiVersion(), this.client.acceptLanguage(), select, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ComputeNodeExtensionsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<NodeVMExtension, ComputeNodeExtensionGetHeaders> getDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NodeVMExtension>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeExtensionGetHeaders.class);
    }

    @Override
    public PagedList<NodeVMExtension> list(String poolId, String nodeId) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(poolId, nodeId).toBlocking().single();
        return new PagedList<NodeVMExtension>((Page)response.body()){

            public Page<NodeVMExtension> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ComputeNodeExtensionsImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeVMExtension>> listAsync(String poolId, String nodeId, ListOperationCallback<NodeVMExtension> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(poolId, nodeId), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(String nextPageLink) {
                return ComputeNodeExtensionsImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeVMExtension>> listAsync(String poolId, String nodeId) {
        return this.listWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>, Page<NodeVMExtension>>(){

            public Page<NodeVMExtension> call(ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> listWithServiceResponseAsync(String poolId, String nodeId) {
        return this.listSinglePageAsync(poolId, nodeId).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComputeNodeExtensionsImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> listSinglePageAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object computeNodeExtensionListOptions = null;
        String select = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), select, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ComputeNodeExtensionsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<NodeVMExtension> list(String poolId, String nodeId, final ComputeNodeExtensionListOptions computeNodeExtensionListOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(poolId, nodeId, computeNodeExtensionListOptions).toBlocking().single();
        return new PagedList<NodeVMExtension>((Page)response.body()){

            public Page<NodeVMExtension> nextPage(String nextPageLink) {
                ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions = null;
                if (computeNodeExtensionListOptions != null) {
                    computeNodeExtensionListNextOptions = new ComputeNodeExtensionListNextOptions();
                    computeNodeExtensionListNextOptions.withClientRequestId(computeNodeExtensionListOptions.clientRequestId());
                    computeNodeExtensionListNextOptions.withReturnClientRequestId(computeNodeExtensionListOptions.returnClientRequestId());
                    computeNodeExtensionListNextOptions.withOcpDate(computeNodeExtensionListOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)ComputeNodeExtensionsImpl.this.listNextSinglePageAsync(nextPageLink, computeNodeExtensionListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeVMExtension>> listAsync(String poolId, String nodeId, final ComputeNodeExtensionListOptions computeNodeExtensionListOptions, ListOperationCallback<NodeVMExtension> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(poolId, nodeId, computeNodeExtensionListOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(String nextPageLink) {
                ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions = null;
                if (computeNodeExtensionListOptions != null) {
                    computeNodeExtensionListNextOptions = new ComputeNodeExtensionListNextOptions();
                    computeNodeExtensionListNextOptions.withClientRequestId(computeNodeExtensionListOptions.clientRequestId());
                    computeNodeExtensionListNextOptions.withReturnClientRequestId(computeNodeExtensionListOptions.returnClientRequestId());
                    computeNodeExtensionListNextOptions.withOcpDate(computeNodeExtensionListOptions.ocpDate());
                }
                return ComputeNodeExtensionsImpl.this.listNextSinglePageAsync(nextPageLink, computeNodeExtensionListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeVMExtension>> listAsync(String poolId, String nodeId, ComputeNodeExtensionListOptions computeNodeExtensionListOptions) {
        return this.listWithServiceResponseAsync(poolId, nodeId, computeNodeExtensionListOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>, Page<NodeVMExtension>>(){

            public Page<NodeVMExtension> call(ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> listWithServiceResponseAsync(String poolId, String nodeId, final ComputeNodeExtensionListOptions computeNodeExtensionListOptions) {
        return this.listSinglePageAsync(poolId, nodeId, computeNodeExtensionListOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions = null;
                if (computeNodeExtensionListOptions != null) {
                    computeNodeExtensionListNextOptions = new ComputeNodeExtensionListNextOptions();
                    computeNodeExtensionListNextOptions.withClientRequestId(computeNodeExtensionListOptions.clientRequestId());
                    computeNodeExtensionListNextOptions.withReturnClientRequestId(computeNodeExtensionListOptions.returnClientRequestId());
                    computeNodeExtensionListNextOptions.withOcpDate(computeNodeExtensionListOptions.ocpDate());
                }
                return Observable.just(page).concatWith(ComputeNodeExtensionsImpl.this.listNextWithServiceResponseAsync(nextPageLink, computeNodeExtensionListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> listSinglePageAsync(String poolId, String nodeId, ComputeNodeExtensionListOptions computeNodeExtensionListOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeExtensionListOptions);
        String select = null;
        if (computeNodeExtensionListOptions != null) {
            select = computeNodeExtensionListOptions.select();
        }
        Integer maxResults = null;
        if (computeNodeExtensionListOptions != null) {
            maxResults = computeNodeExtensionListOptions.maxResults();
        }
        Integer timeout = null;
        if (computeNodeExtensionListOptions != null) {
            timeout = computeNodeExtensionListOptions.timeout();
        }
        UUID clientRequestId = null;
        if (computeNodeExtensionListOptions != null) {
            clientRequestId = computeNodeExtensionListOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeExtensionListOptions != null) {
            returnClientRequestId = computeNodeExtensionListOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeExtensionListOptions != null) {
            ocpDate = computeNodeExtensionListOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(poolId, nodeId, this.client.apiVersion(), this.client.acceptLanguage(), select, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ComputeNodeExtensionsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<NodeVMExtension>, ComputeNodeExtensionListHeaders> listDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NodeVMExtension>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeExtensionListHeaders.class);
    }

    @Override
    public PagedList<NodeVMExtension> listNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NodeVMExtension>((Page)response.body()){

            public Page<NodeVMExtension> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ComputeNodeExtensionsImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeVMExtension>> listNextAsync(String nextPageLink, ServiceFuture<List<NodeVMExtension>> serviceFuture, ListOperationCallback<NodeVMExtension> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(String nextPageLink) {
                return ComputeNodeExtensionsImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeVMExtension>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>, Page<NodeVMExtension>>(){

            public Page<NodeVMExtension> call(ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComputeNodeExtensionsImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object computeNodeExtensionListNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ComputeNodeExtensionsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<NodeVMExtension> listNext(String nextPageLink, final ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink, computeNodeExtensionListNextOptions).toBlocking().single();
        return new PagedList<NodeVMExtension>((Page)response.body()){

            public Page<NodeVMExtension> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ComputeNodeExtensionsImpl.this.listNextSinglePageAsync(nextPageLink, computeNodeExtensionListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeVMExtension>> listNextAsync(String nextPageLink, final ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions, ServiceFuture<List<NodeVMExtension>> serviceFuture, ListOperationCallback<NodeVMExtension> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink, computeNodeExtensionListNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(String nextPageLink) {
                return ComputeNodeExtensionsImpl.this.listNextSinglePageAsync(nextPageLink, computeNodeExtensionListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeVMExtension>> listNextAsync(String nextPageLink, ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions) {
        return this.listNextWithServiceResponseAsync(nextPageLink, computeNodeExtensionListNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>, Page<NodeVMExtension>>(){

            public Page<NodeVMExtension> call(ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> listNextWithServiceResponseAsync(String nextPageLink, final ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions) {
        return this.listNextSinglePageAsync(nextPageLink, computeNodeExtensionListNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComputeNodeExtensionsImpl.this.listNextWithServiceResponseAsync(nextPageLink, computeNodeExtensionListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> listNextSinglePageAsync(String nextPageLink, ComputeNodeExtensionListNextOptions computeNodeExtensionListNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)computeNodeExtensionListNextOptions);
        UUID clientRequestId = null;
        if (computeNodeExtensionListNextOptions != null) {
            clientRequestId = computeNodeExtensionListNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (computeNodeExtensionListNextOptions != null) {
            returnClientRequestId = computeNodeExtensionListNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (computeNodeExtensionListNextOptions != null) {
            ocpDate = computeNodeExtensionListNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeVMExtension>, ComputeNodeExtensionListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ComputeNodeExtensionsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<NodeVMExtension>, ComputeNodeExtensionListHeaders> listNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NodeVMExtension>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ComputeNodeExtensionListHeaders.class);
    }

    static interface ComputeNodeExtensionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodeExtensions get"})
        @GET(value="pools/{poolId}/nodes/{nodeId}/extensions/{extensionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Path(value="extensionName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="$select") String var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodeExtensions list"})
        @GET(value="pools/{poolId}/nodes/{nodeId}/extensions")
        public Observable<Response<ResponseBody>> list(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="$select") String var5, @Query(value="maxresults") Integer var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.ComputeNodeExtensions listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

