/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.Pools;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.AutoScaleRun;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.CloudPool;
import com.microsoft.azure.batch.protocol.models.NodeRemoveParameter;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.azure.batch.protocol.models.PoolAddHeaders;
import com.microsoft.azure.batch.protocol.models.PoolAddOptions;
import com.microsoft.azure.batch.protocol.models.PoolAddParameter;
import com.microsoft.azure.batch.protocol.models.PoolDeleteHeaders;
import com.microsoft.azure.batch.protocol.models.PoolDeleteOptions;
import com.microsoft.azure.batch.protocol.models.PoolDisableAutoScaleHeaders;
import com.microsoft.azure.batch.protocol.models.PoolDisableAutoScaleOptions;
import com.microsoft.azure.batch.protocol.models.PoolEnableAutoScaleHeaders;
import com.microsoft.azure.batch.protocol.models.PoolEnableAutoScaleOptions;
import com.microsoft.azure.batch.protocol.models.PoolEnableAutoScaleParameter;
import com.microsoft.azure.batch.protocol.models.PoolEvaluateAutoScaleHeaders;
import com.microsoft.azure.batch.protocol.models.PoolEvaluateAutoScaleOptions;
import com.microsoft.azure.batch.protocol.models.PoolEvaluateAutoScaleParameter;
import com.microsoft.azure.batch.protocol.models.PoolExistsHeaders;
import com.microsoft.azure.batch.protocol.models.PoolExistsOptions;
import com.microsoft.azure.batch.protocol.models.PoolGetHeaders;
import com.microsoft.azure.batch.protocol.models.PoolGetOptions;
import com.microsoft.azure.batch.protocol.models.PoolListHeaders;
import com.microsoft.azure.batch.protocol.models.PoolListNextOptions;
import com.microsoft.azure.batch.protocol.models.PoolListOptions;
import com.microsoft.azure.batch.protocol.models.PoolListUsageMetricsHeaders;
import com.microsoft.azure.batch.protocol.models.PoolListUsageMetricsNextOptions;
import com.microsoft.azure.batch.protocol.models.PoolListUsageMetricsOptions;
import com.microsoft.azure.batch.protocol.models.PoolPatchHeaders;
import com.microsoft.azure.batch.protocol.models.PoolPatchOptions;
import com.microsoft.azure.batch.protocol.models.PoolPatchParameter;
import com.microsoft.azure.batch.protocol.models.PoolRemoveNodesHeaders;
import com.microsoft.azure.batch.protocol.models.PoolRemoveNodesOptions;
import com.microsoft.azure.batch.protocol.models.PoolResizeHeaders;
import com.microsoft.azure.batch.protocol.models.PoolResizeOptions;
import com.microsoft.azure.batch.protocol.models.PoolResizeParameter;
import com.microsoft.azure.batch.protocol.models.PoolStopResizeHeaders;
import com.microsoft.azure.batch.protocol.models.PoolStopResizeOptions;
import com.microsoft.azure.batch.protocol.models.PoolUpdatePropertiesHeaders;
import com.microsoft.azure.batch.protocol.models.PoolUpdatePropertiesOptions;
import com.microsoft.azure.batch.protocol.models.PoolUpdatePropertiesParameter;
import com.microsoft.azure.batch.protocol.models.PoolUsageMetrics;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PoolsImpl
implements Pools {
    private PoolsService service;
    private BatchServiceClientImpl client;

    public PoolsImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (PoolsService)retrofit.create(PoolsService.class);
        this.client = client;
    }

    @Override
    public PagedList<PoolUsageMetrics> listUsageMetrics() {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listUsageMetricsSinglePageAsync().toBlocking().single();
        return new PagedList<PoolUsageMetrics>((Page)response.body()){

            public Page<PoolUsageMetrics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)PoolsImpl.this.listUsageMetricsNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<PoolUsageMetrics>> listUsageMetricsAsync(ListOperationCallback<PoolUsageMetrics> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listUsageMetricsSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(String nextPageLink) {
                return PoolsImpl.this.listUsageMetricsNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PoolUsageMetrics>> listUsageMetricsAsync() {
        return this.listUsageMetricsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>, Page<PoolUsageMetrics>>(){

            public Page<PoolUsageMetrics> call(ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> listUsageMetricsWithServiceResponseAsync() {
        return this.listUsageMetricsSinglePageAsync().concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsImpl.this.listUsageMetricsNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> listUsageMetricsSinglePageAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object poolListUsageMetricsOptions = null;
        DateTime startTime = null;
        DateTime endTime = null;
        String filter = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listUsageMetrics(this.client.apiVersion(), this.client.acceptLanguage(), startTime, endTime, filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = PoolsImpl.this.listUsageMetricsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<PoolUsageMetrics> listUsageMetrics(final PoolListUsageMetricsOptions poolListUsageMetricsOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listUsageMetricsSinglePageAsync(poolListUsageMetricsOptions).toBlocking().single();
        return new PagedList<PoolUsageMetrics>((Page)response.body()){

            public Page<PoolUsageMetrics> nextPage(String nextPageLink) {
                PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions = null;
                if (poolListUsageMetricsOptions != null) {
                    poolListUsageMetricsNextOptions = new PoolListUsageMetricsNextOptions();
                    poolListUsageMetricsNextOptions.withClientRequestId(poolListUsageMetricsOptions.clientRequestId());
                    poolListUsageMetricsNextOptions.withReturnClientRequestId(poolListUsageMetricsOptions.returnClientRequestId());
                    poolListUsageMetricsNextOptions.withOcpDate(poolListUsageMetricsOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)PoolsImpl.this.listUsageMetricsNextSinglePageAsync(nextPageLink, poolListUsageMetricsNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<PoolUsageMetrics>> listUsageMetricsAsync(final PoolListUsageMetricsOptions poolListUsageMetricsOptions, ListOperationCallback<PoolUsageMetrics> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listUsageMetricsSinglePageAsync(poolListUsageMetricsOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(String nextPageLink) {
                PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions = null;
                if (poolListUsageMetricsOptions != null) {
                    poolListUsageMetricsNextOptions = new PoolListUsageMetricsNextOptions();
                    poolListUsageMetricsNextOptions.withClientRequestId(poolListUsageMetricsOptions.clientRequestId());
                    poolListUsageMetricsNextOptions.withReturnClientRequestId(poolListUsageMetricsOptions.returnClientRequestId());
                    poolListUsageMetricsNextOptions.withOcpDate(poolListUsageMetricsOptions.ocpDate());
                }
                return PoolsImpl.this.listUsageMetricsNextSinglePageAsync(nextPageLink, poolListUsageMetricsNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PoolUsageMetrics>> listUsageMetricsAsync(PoolListUsageMetricsOptions poolListUsageMetricsOptions) {
        return this.listUsageMetricsWithServiceResponseAsync(poolListUsageMetricsOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>, Page<PoolUsageMetrics>>(){

            public Page<PoolUsageMetrics> call(ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> listUsageMetricsWithServiceResponseAsync(final PoolListUsageMetricsOptions poolListUsageMetricsOptions) {
        return this.listUsageMetricsSinglePageAsync(poolListUsageMetricsOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions = null;
                if (poolListUsageMetricsOptions != null) {
                    poolListUsageMetricsNextOptions = new PoolListUsageMetricsNextOptions();
                    poolListUsageMetricsNextOptions.withClientRequestId(poolListUsageMetricsOptions.clientRequestId());
                    poolListUsageMetricsNextOptions.withReturnClientRequestId(poolListUsageMetricsOptions.returnClientRequestId());
                    poolListUsageMetricsNextOptions.withOcpDate(poolListUsageMetricsOptions.ocpDate());
                }
                return Observable.just(page).concatWith(PoolsImpl.this.listUsageMetricsNextWithServiceResponseAsync(nextPageLink, poolListUsageMetricsNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> listUsageMetricsSinglePageAsync(PoolListUsageMetricsOptions poolListUsageMetricsOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolListUsageMetricsOptions);
        DateTime startTime = null;
        if (poolListUsageMetricsOptions != null) {
            startTime = poolListUsageMetricsOptions.startTime();
        }
        DateTime endTime = null;
        if (poolListUsageMetricsOptions != null) {
            endTime = poolListUsageMetricsOptions.endTime();
        }
        String filter = null;
        if (poolListUsageMetricsOptions != null) {
            filter = poolListUsageMetricsOptions.filter();
        }
        Integer maxResults = null;
        if (poolListUsageMetricsOptions != null) {
            maxResults = poolListUsageMetricsOptions.maxResults();
        }
        Integer timeout = null;
        if (poolListUsageMetricsOptions != null) {
            timeout = poolListUsageMetricsOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolListUsageMetricsOptions != null) {
            clientRequestId = poolListUsageMetricsOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolListUsageMetricsOptions != null) {
            returnClientRequestId = poolListUsageMetricsOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolListUsageMetricsOptions != null) {
            ocpDate = poolListUsageMetricsOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listUsageMetrics(this.client.apiVersion(), this.client.acceptLanguage(), startTime, endTime, filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = PoolsImpl.this.listUsageMetricsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<PoolUsageMetrics>, PoolListUsageMetricsHeaders> listUsageMetricsDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PoolUsageMetrics>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolListUsageMetricsHeaders.class);
    }

    @Override
    public void add(PoolAddParameter pool) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(pool).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(PoolAddParameter pool, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(pool), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(PoolAddParameter pool) {
        return this.addWithServiceResponseAsync(pool).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolAddHeaders>> addWithServiceResponseAsync(PoolAddParameter pool) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Parameter pool is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)pool);
        Object poolAddOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(pool, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void add(PoolAddParameter pool, PoolAddOptions poolAddOptions) {
        ((ServiceResponseWithHeaders)this.addWithServiceResponseAsync(pool, poolAddOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> addAsync(PoolAddParameter pool, PoolAddOptions poolAddOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.addWithServiceResponseAsync(pool, poolAddOptions), serviceCallback);
    }

    @Override
    public Observable<Void> addAsync(PoolAddParameter pool, PoolAddOptions poolAddOptions) {
        return this.addWithServiceResponseAsync(pool, poolAddOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolAddHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolAddHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolAddHeaders>> addWithServiceResponseAsync(PoolAddParameter pool, PoolAddOptions poolAddOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (pool == null) {
            throw new IllegalArgumentException("Parameter pool is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)pool);
        Validator.validate((Object)poolAddOptions);
        Integer timeout = null;
        if (poolAddOptions != null) {
            timeout = poolAddOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolAddOptions != null) {
            clientRequestId = poolAddOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolAddOptions != null) {
            returnClientRequestId = poolAddOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolAddOptions != null) {
            ocpDate = poolAddOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.add(pool, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolAddHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolAddHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolAddHeaders> addDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolAddHeaders.class);
    }

    @Override
    public PagedList<CloudPool> list() {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<CloudPool>((Page)response.body()){

            public Page<CloudPool> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)PoolsImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudPool>> listAsync(ListOperationCallback<CloudPool> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(String nextPageLink) {
                return PoolsImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudPool>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>, Page<CloudPool>>(){

            public Page<CloudPool> call(ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> listSinglePageAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object poolListOptions = null;
        String filter = null;
        String select = null;
        String expand = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = PoolsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudPool> list(final PoolListOptions poolListOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(poolListOptions).toBlocking().single();
        return new PagedList<CloudPool>((Page)response.body()){

            public Page<CloudPool> nextPage(String nextPageLink) {
                PoolListNextOptions poolListNextOptions = null;
                if (poolListOptions != null) {
                    poolListNextOptions = new PoolListNextOptions();
                    poolListNextOptions.withClientRequestId(poolListOptions.clientRequestId());
                    poolListNextOptions.withReturnClientRequestId(poolListOptions.returnClientRequestId());
                    poolListNextOptions.withOcpDate(poolListOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)PoolsImpl.this.listNextSinglePageAsync(nextPageLink, poolListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudPool>> listAsync(final PoolListOptions poolListOptions, ListOperationCallback<CloudPool> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(poolListOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(String nextPageLink) {
                PoolListNextOptions poolListNextOptions = null;
                if (poolListOptions != null) {
                    poolListNextOptions = new PoolListNextOptions();
                    poolListNextOptions.withClientRequestId(poolListOptions.clientRequestId());
                    poolListNextOptions.withReturnClientRequestId(poolListOptions.returnClientRequestId());
                    poolListNextOptions.withOcpDate(poolListOptions.ocpDate());
                }
                return PoolsImpl.this.listNextSinglePageAsync(nextPageLink, poolListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudPool>> listAsync(PoolListOptions poolListOptions) {
        return this.listWithServiceResponseAsync(poolListOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>, Page<CloudPool>>(){

            public Page<CloudPool> call(ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> listWithServiceResponseAsync(final PoolListOptions poolListOptions) {
        return this.listSinglePageAsync(poolListOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                PoolListNextOptions poolListNextOptions = null;
                if (poolListOptions != null) {
                    poolListNextOptions = new PoolListNextOptions();
                    poolListNextOptions.withClientRequestId(poolListOptions.clientRequestId());
                    poolListNextOptions.withReturnClientRequestId(poolListOptions.returnClientRequestId());
                    poolListNextOptions.withOcpDate(poolListOptions.ocpDate());
                }
                return Observable.just(page).concatWith(PoolsImpl.this.listNextWithServiceResponseAsync(nextPageLink, poolListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> listSinglePageAsync(PoolListOptions poolListOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolListOptions);
        String filter = null;
        if (poolListOptions != null) {
            filter = poolListOptions.filter();
        }
        String select = null;
        if (poolListOptions != null) {
            select = poolListOptions.select();
        }
        String expand = null;
        if (poolListOptions != null) {
            expand = poolListOptions.expand();
        }
        Integer maxResults = null;
        if (poolListOptions != null) {
            maxResults = poolListOptions.maxResults();
        }
        Integer timeout = null;
        if (poolListOptions != null) {
            timeout = poolListOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolListOptions != null) {
            clientRequestId = poolListOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolListOptions != null) {
            returnClientRequestId = poolListOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolListOptions != null) {
            ocpDate = poolListOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), filter, select, expand, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = PoolsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudPool>, PoolListHeaders> listDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudPool>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolListHeaders.class);
    }

    @Override
    public void delete(String poolId) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(poolId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String poolId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(poolId), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String poolId) {
        return this.deleteWithServiceResponseAsync(poolId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> deleteWithServiceResponseAsync(String poolId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object poolDeleteOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void delete(String poolId, PoolDeleteOptions poolDeleteOptions) {
        ((ServiceResponseWithHeaders)this.deleteWithServiceResponseAsync(poolId, poolDeleteOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteAsync(String poolId, PoolDeleteOptions poolDeleteOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteWithServiceResponseAsync(poolId, poolDeleteOptions), serviceCallback);
    }

    @Override
    public Observable<Void> deleteAsync(String poolId, PoolDeleteOptions poolDeleteOptions) {
        return this.deleteWithServiceResponseAsync(poolId, poolDeleteOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolDeleteHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> deleteWithServiceResponseAsync(String poolId, PoolDeleteOptions poolDeleteOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolDeleteOptions);
        Integer timeout = null;
        if (poolDeleteOptions != null) {
            timeout = poolDeleteOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolDeleteOptions != null) {
            clientRequestId = poolDeleteOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolDeleteOptions != null) {
            returnClientRequestId = poolDeleteOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolDeleteOptions != null) {
            ocpDate = poolDeleteOptions.ocpDate();
        }
        String ifMatch = null;
        if (poolDeleteOptions != null) {
            ifMatch = poolDeleteOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (poolDeleteOptions != null) {
            ifNoneMatch = poolDeleteOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (poolDeleteOptions != null) {
            ifModifiedSince = poolDeleteOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (poolDeleteOptions != null) {
            ifUnmodifiedSince = poolDeleteOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolDeleteHeaders> deleteDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolDeleteHeaders.class);
    }

    @Override
    public boolean exists(String poolId) {
        return (Boolean)((ServiceResponseWithHeaders)this.existsWithServiceResponseAsync(poolId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Boolean> existsAsync(String poolId, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.existsWithServiceResponseAsync(poolId), serviceCallback);
    }

    @Override
    public Observable<Boolean> existsAsync(String poolId) {
        return this.existsWithServiceResponseAsync(poolId).map((Func1)new Func1<ServiceResponseWithHeaders<Boolean, PoolExistsHeaders>, Boolean>(){

            public Boolean call(ServiceResponseWithHeaders<Boolean, PoolExistsHeaders> response) {
                return (Boolean)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Boolean, PoolExistsHeaders>> existsWithServiceResponseAsync(String poolId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object poolExistsOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.exists(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponseWithHeaders<Boolean, PoolExistsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Boolean, PoolExistsHeaders>> call(Response<Void> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.existsDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public boolean exists(String poolId, PoolExistsOptions poolExistsOptions) {
        return (Boolean)((ServiceResponseWithHeaders)this.existsWithServiceResponseAsync(poolId, poolExistsOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Boolean> existsAsync(String poolId, PoolExistsOptions poolExistsOptions, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.existsWithServiceResponseAsync(poolId, poolExistsOptions), serviceCallback);
    }

    @Override
    public Observable<Boolean> existsAsync(String poolId, PoolExistsOptions poolExistsOptions) {
        return this.existsWithServiceResponseAsync(poolId, poolExistsOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Boolean, PoolExistsHeaders>, Boolean>(){

            public Boolean call(ServiceResponseWithHeaders<Boolean, PoolExistsHeaders> response) {
                return (Boolean)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Boolean, PoolExistsHeaders>> existsWithServiceResponseAsync(String poolId, PoolExistsOptions poolExistsOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolExistsOptions);
        Integer timeout = null;
        if (poolExistsOptions != null) {
            timeout = poolExistsOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolExistsOptions != null) {
            clientRequestId = poolExistsOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolExistsOptions != null) {
            returnClientRequestId = poolExistsOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolExistsOptions != null) {
            ocpDate = poolExistsOptions.ocpDate();
        }
        String ifMatch = null;
        if (poolExistsOptions != null) {
            ifMatch = poolExistsOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (poolExistsOptions != null) {
            ifNoneMatch = poolExistsOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (poolExistsOptions != null) {
            ifModifiedSince = poolExistsOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (poolExistsOptions != null) {
            ifUnmodifiedSince = poolExistsOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.exists(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponseWithHeaders<Boolean, PoolExistsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Boolean, PoolExistsHeaders>> call(Response<Void> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.existsDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Boolean, PoolExistsHeaders> existsDelegate(Response<Void> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildEmptyWithHeaders(response, PoolExistsHeaders.class);
    }

    @Override
    public CloudPool get(String poolId) {
        return (CloudPool)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(poolId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudPool> getAsync(String poolId, ServiceCallback<CloudPool> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(poolId), serviceCallback);
    }

    @Override
    public Observable<CloudPool> getAsync(String poolId) {
        return this.getWithServiceResponseAsync(poolId).map((Func1)new Func1<ServiceResponseWithHeaders<CloudPool, PoolGetHeaders>, CloudPool>(){

            public CloudPool call(ServiceResponseWithHeaders<CloudPool, PoolGetHeaders> response) {
                return (CloudPool)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudPool, PoolGetHeaders>> getWithServiceResponseAsync(String poolId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object poolGetOptions = null;
        String select = null;
        String expand = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.get(poolId, this.client.apiVersion(), this.client.acceptLanguage(), select, expand, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudPool, PoolGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudPool, PoolGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public CloudPool get(String poolId, PoolGetOptions poolGetOptions) {
        return (CloudPool)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(poolId, poolGetOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<CloudPool> getAsync(String poolId, PoolGetOptions poolGetOptions, ServiceCallback<CloudPool> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(poolId, poolGetOptions), serviceCallback);
    }

    @Override
    public Observable<CloudPool> getAsync(String poolId, PoolGetOptions poolGetOptions) {
        return this.getWithServiceResponseAsync(poolId, poolGetOptions).map((Func1)new Func1<ServiceResponseWithHeaders<CloudPool, PoolGetHeaders>, CloudPool>(){

            public CloudPool call(ServiceResponseWithHeaders<CloudPool, PoolGetHeaders> response) {
                return (CloudPool)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<CloudPool, PoolGetHeaders>> getWithServiceResponseAsync(String poolId, PoolGetOptions poolGetOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolGetOptions);
        String select = null;
        if (poolGetOptions != null) {
            select = poolGetOptions.select();
        }
        String expand = null;
        if (poolGetOptions != null) {
            expand = poolGetOptions.expand();
        }
        Integer timeout = null;
        if (poolGetOptions != null) {
            timeout = poolGetOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolGetOptions != null) {
            clientRequestId = poolGetOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolGetOptions != null) {
            returnClientRequestId = poolGetOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolGetOptions != null) {
            ocpDate = poolGetOptions.ocpDate();
        }
        String ifMatch = null;
        if (poolGetOptions != null) {
            ifMatch = poolGetOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (poolGetOptions != null) {
            ifNoneMatch = poolGetOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (poolGetOptions != null) {
            ifModifiedSince = poolGetOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (poolGetOptions != null) {
            ifUnmodifiedSince = poolGetOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.get(poolId, this.client.apiVersion(), this.client.acceptLanguage(), select, expand, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CloudPool, PoolGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<CloudPool, PoolGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<CloudPool, PoolGetHeaders> getDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CloudPool>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolGetHeaders.class);
    }

    @Override
    public void patch(String poolId, PoolPatchParameter poolPatchParameter) {
        ((ServiceResponseWithHeaders)this.patchWithServiceResponseAsync(poolId, poolPatchParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> patchAsync(String poolId, PoolPatchParameter poolPatchParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.patchWithServiceResponseAsync(poolId, poolPatchParameter), serviceCallback);
    }

    @Override
    public Observable<Void> patchAsync(String poolId, PoolPatchParameter poolPatchParameter) {
        return this.patchWithServiceResponseAsync(poolId, poolPatchParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolPatchHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolPatchHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolPatchHeaders>> patchWithServiceResponseAsync(String poolId, PoolPatchParameter poolPatchParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (poolPatchParameter == null) {
            throw new IllegalArgumentException("Parameter poolPatchParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolPatchParameter);
        Object poolPatchOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.patch(poolId, poolPatchParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolPatchHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolPatchHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void patch(String poolId, PoolPatchParameter poolPatchParameter, PoolPatchOptions poolPatchOptions) {
        ((ServiceResponseWithHeaders)this.patchWithServiceResponseAsync(poolId, poolPatchParameter, poolPatchOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> patchAsync(String poolId, PoolPatchParameter poolPatchParameter, PoolPatchOptions poolPatchOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.patchWithServiceResponseAsync(poolId, poolPatchParameter, poolPatchOptions), serviceCallback);
    }

    @Override
    public Observable<Void> patchAsync(String poolId, PoolPatchParameter poolPatchParameter, PoolPatchOptions poolPatchOptions) {
        return this.patchWithServiceResponseAsync(poolId, poolPatchParameter, poolPatchOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolPatchHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolPatchHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolPatchHeaders>> patchWithServiceResponseAsync(String poolId, PoolPatchParameter poolPatchParameter, PoolPatchOptions poolPatchOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (poolPatchParameter == null) {
            throw new IllegalArgumentException("Parameter poolPatchParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolPatchParameter);
        Validator.validate((Object)poolPatchOptions);
        Integer timeout = null;
        if (poolPatchOptions != null) {
            timeout = poolPatchOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolPatchOptions != null) {
            clientRequestId = poolPatchOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolPatchOptions != null) {
            returnClientRequestId = poolPatchOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolPatchOptions != null) {
            ocpDate = poolPatchOptions.ocpDate();
        }
        String ifMatch = null;
        if (poolPatchOptions != null) {
            ifMatch = poolPatchOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (poolPatchOptions != null) {
            ifNoneMatch = poolPatchOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (poolPatchOptions != null) {
            ifModifiedSince = poolPatchOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (poolPatchOptions != null) {
            ifUnmodifiedSince = poolPatchOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.patch(poolId, poolPatchParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolPatchHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolPatchHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.patchDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolPatchHeaders> patchDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolPatchHeaders.class);
    }

    @Override
    public void disableAutoScale(String poolId) {
        ((ServiceResponseWithHeaders)this.disableAutoScaleWithServiceResponseAsync(poolId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> disableAutoScaleAsync(String poolId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableAutoScaleWithServiceResponseAsync(poolId), serviceCallback);
    }

    @Override
    public Observable<Void> disableAutoScaleAsync(String poolId) {
        return this.disableAutoScaleWithServiceResponseAsync(poolId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders>> disableAutoScaleWithServiceResponseAsync(String poolId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object poolDisableAutoScaleOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.disableAutoScale(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.disableAutoScaleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void disableAutoScale(String poolId, PoolDisableAutoScaleOptions poolDisableAutoScaleOptions) {
        ((ServiceResponseWithHeaders)this.disableAutoScaleWithServiceResponseAsync(poolId, poolDisableAutoScaleOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> disableAutoScaleAsync(String poolId, PoolDisableAutoScaleOptions poolDisableAutoScaleOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.disableAutoScaleWithServiceResponseAsync(poolId, poolDisableAutoScaleOptions), serviceCallback);
    }

    @Override
    public Observable<Void> disableAutoScaleAsync(String poolId, PoolDisableAutoScaleOptions poolDisableAutoScaleOptions) {
        return this.disableAutoScaleWithServiceResponseAsync(poolId, poolDisableAutoScaleOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders>> disableAutoScaleWithServiceResponseAsync(String poolId, PoolDisableAutoScaleOptions poolDisableAutoScaleOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolDisableAutoScaleOptions);
        Integer timeout = null;
        if (poolDisableAutoScaleOptions != null) {
            timeout = poolDisableAutoScaleOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolDisableAutoScaleOptions != null) {
            clientRequestId = poolDisableAutoScaleOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolDisableAutoScaleOptions != null) {
            returnClientRequestId = poolDisableAutoScaleOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolDisableAutoScaleOptions != null) {
            ocpDate = poolDisableAutoScaleOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.disableAutoScale(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.disableAutoScaleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolDisableAutoScaleHeaders> disableAutoScaleDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolDisableAutoScaleHeaders.class);
    }

    @Override
    public void enableAutoScale(String poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter) {
        ((ServiceResponseWithHeaders)this.enableAutoScaleWithServiceResponseAsync(poolId, poolEnableAutoScaleParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> enableAutoScaleAsync(String poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.enableAutoScaleWithServiceResponseAsync(poolId, poolEnableAutoScaleParameter), serviceCallback);
    }

    @Override
    public Observable<Void> enableAutoScaleAsync(String poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter) {
        return this.enableAutoScaleWithServiceResponseAsync(poolId, poolEnableAutoScaleParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders>> enableAutoScaleWithServiceResponseAsync(String poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (poolEnableAutoScaleParameter == null) {
            throw new IllegalArgumentException("Parameter poolEnableAutoScaleParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolEnableAutoScaleParameter);
        Object poolEnableAutoScaleOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.enableAutoScale(poolId, poolEnableAutoScaleParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.enableAutoScaleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void enableAutoScale(String poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter, PoolEnableAutoScaleOptions poolEnableAutoScaleOptions) {
        ((ServiceResponseWithHeaders)this.enableAutoScaleWithServiceResponseAsync(poolId, poolEnableAutoScaleParameter, poolEnableAutoScaleOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> enableAutoScaleAsync(String poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter, PoolEnableAutoScaleOptions poolEnableAutoScaleOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.enableAutoScaleWithServiceResponseAsync(poolId, poolEnableAutoScaleParameter, poolEnableAutoScaleOptions), serviceCallback);
    }

    @Override
    public Observable<Void> enableAutoScaleAsync(String poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter, PoolEnableAutoScaleOptions poolEnableAutoScaleOptions) {
        return this.enableAutoScaleWithServiceResponseAsync(poolId, poolEnableAutoScaleParameter, poolEnableAutoScaleOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders>> enableAutoScaleWithServiceResponseAsync(String poolId, PoolEnableAutoScaleParameter poolEnableAutoScaleParameter, PoolEnableAutoScaleOptions poolEnableAutoScaleOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (poolEnableAutoScaleParameter == null) {
            throw new IllegalArgumentException("Parameter poolEnableAutoScaleParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolEnableAutoScaleParameter);
        Validator.validate((Object)poolEnableAutoScaleOptions);
        Integer timeout = null;
        if (poolEnableAutoScaleOptions != null) {
            timeout = poolEnableAutoScaleOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolEnableAutoScaleOptions != null) {
            clientRequestId = poolEnableAutoScaleOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolEnableAutoScaleOptions != null) {
            returnClientRequestId = poolEnableAutoScaleOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolEnableAutoScaleOptions != null) {
            ocpDate = poolEnableAutoScaleOptions.ocpDate();
        }
        String ifMatch = null;
        if (poolEnableAutoScaleOptions != null) {
            ifMatch = poolEnableAutoScaleOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (poolEnableAutoScaleOptions != null) {
            ifNoneMatch = poolEnableAutoScaleOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (poolEnableAutoScaleOptions != null) {
            ifModifiedSince = poolEnableAutoScaleOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (poolEnableAutoScaleOptions != null) {
            ifUnmodifiedSince = poolEnableAutoScaleOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.enableAutoScale(poolId, poolEnableAutoScaleParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.enableAutoScaleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolEnableAutoScaleHeaders> enableAutoScaleDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolEnableAutoScaleHeaders.class);
    }

    @Override
    public AutoScaleRun evaluateAutoScale(String poolId, String autoScaleFormula) {
        return (AutoScaleRun)((ServiceResponseWithHeaders)this.evaluateAutoScaleWithServiceResponseAsync(poolId, autoScaleFormula).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<AutoScaleRun> evaluateAutoScaleAsync(String poolId, String autoScaleFormula, ServiceCallback<AutoScaleRun> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.evaluateAutoScaleWithServiceResponseAsync(poolId, autoScaleFormula), serviceCallback);
    }

    @Override
    public Observable<AutoScaleRun> evaluateAutoScaleAsync(String poolId, String autoScaleFormula) {
        return this.evaluateAutoScaleWithServiceResponseAsync(poolId, autoScaleFormula).map((Func1)new Func1<ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders>, AutoScaleRun>(){

            public AutoScaleRun call(ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders> response) {
                return (AutoScaleRun)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders>> evaluateAutoScaleWithServiceResponseAsync(String poolId, String autoScaleFormula) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (autoScaleFormula == null) {
            throw new IllegalArgumentException("Parameter autoScaleFormula is required and cannot be null.");
        }
        Object poolEvaluateAutoScaleOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        PoolEvaluateAutoScaleParameter poolEvaluateAutoScaleParameter = new PoolEvaluateAutoScaleParameter();
        poolEvaluateAutoScaleParameter.withAutoScaleFormula(autoScaleFormula);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.evaluateAutoScale(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, poolEvaluateAutoScaleParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.evaluateAutoScaleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public AutoScaleRun evaluateAutoScale(String poolId, String autoScaleFormula, PoolEvaluateAutoScaleOptions poolEvaluateAutoScaleOptions) {
        return (AutoScaleRun)((ServiceResponseWithHeaders)this.evaluateAutoScaleWithServiceResponseAsync(poolId, autoScaleFormula, poolEvaluateAutoScaleOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<AutoScaleRun> evaluateAutoScaleAsync(String poolId, String autoScaleFormula, PoolEvaluateAutoScaleOptions poolEvaluateAutoScaleOptions, ServiceCallback<AutoScaleRun> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.evaluateAutoScaleWithServiceResponseAsync(poolId, autoScaleFormula, poolEvaluateAutoScaleOptions), serviceCallback);
    }

    @Override
    public Observable<AutoScaleRun> evaluateAutoScaleAsync(String poolId, String autoScaleFormula, PoolEvaluateAutoScaleOptions poolEvaluateAutoScaleOptions) {
        return this.evaluateAutoScaleWithServiceResponseAsync(poolId, autoScaleFormula, poolEvaluateAutoScaleOptions).map((Func1)new Func1<ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders>, AutoScaleRun>(){

            public AutoScaleRun call(ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders> response) {
                return (AutoScaleRun)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders>> evaluateAutoScaleWithServiceResponseAsync(String poolId, String autoScaleFormula, PoolEvaluateAutoScaleOptions poolEvaluateAutoScaleOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (autoScaleFormula == null) {
            throw new IllegalArgumentException("Parameter autoScaleFormula is required and cannot be null.");
        }
        Validator.validate((Object)poolEvaluateAutoScaleOptions);
        Integer timeout = null;
        if (poolEvaluateAutoScaleOptions != null) {
            timeout = poolEvaluateAutoScaleOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolEvaluateAutoScaleOptions != null) {
            clientRequestId = poolEvaluateAutoScaleOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolEvaluateAutoScaleOptions != null) {
            returnClientRequestId = poolEvaluateAutoScaleOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolEvaluateAutoScaleOptions != null) {
            ocpDate = poolEvaluateAutoScaleOptions.ocpDate();
        }
        PoolEvaluateAutoScaleParameter poolEvaluateAutoScaleParameter = new PoolEvaluateAutoScaleParameter();
        poolEvaluateAutoScaleParameter.withAutoScaleFormula(autoScaleFormula);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.evaluateAutoScale(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, poolEvaluateAutoScaleParameter, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.evaluateAutoScaleDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<AutoScaleRun, PoolEvaluateAutoScaleHeaders> evaluateAutoScaleDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AutoScaleRun>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolEvaluateAutoScaleHeaders.class);
    }

    @Override
    public void resize(String poolId, PoolResizeParameter poolResizeParameter) {
        ((ServiceResponseWithHeaders)this.resizeWithServiceResponseAsync(poolId, poolResizeParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> resizeAsync(String poolId, PoolResizeParameter poolResizeParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.resizeWithServiceResponseAsync(poolId, poolResizeParameter), serviceCallback);
    }

    @Override
    public Observable<Void> resizeAsync(String poolId, PoolResizeParameter poolResizeParameter) {
        return this.resizeWithServiceResponseAsync(poolId, poolResizeParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolResizeHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolResizeHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolResizeHeaders>> resizeWithServiceResponseAsync(String poolId, PoolResizeParameter poolResizeParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (poolResizeParameter == null) {
            throw new IllegalArgumentException("Parameter poolResizeParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolResizeParameter);
        Object poolResizeOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.resize(poolId, poolResizeParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolResizeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolResizeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.resizeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void resize(String poolId, PoolResizeParameter poolResizeParameter, PoolResizeOptions poolResizeOptions) {
        ((ServiceResponseWithHeaders)this.resizeWithServiceResponseAsync(poolId, poolResizeParameter, poolResizeOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> resizeAsync(String poolId, PoolResizeParameter poolResizeParameter, PoolResizeOptions poolResizeOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.resizeWithServiceResponseAsync(poolId, poolResizeParameter, poolResizeOptions), serviceCallback);
    }

    @Override
    public Observable<Void> resizeAsync(String poolId, PoolResizeParameter poolResizeParameter, PoolResizeOptions poolResizeOptions) {
        return this.resizeWithServiceResponseAsync(poolId, poolResizeParameter, poolResizeOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolResizeHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolResizeHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolResizeHeaders>> resizeWithServiceResponseAsync(String poolId, PoolResizeParameter poolResizeParameter, PoolResizeOptions poolResizeOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (poolResizeParameter == null) {
            throw new IllegalArgumentException("Parameter poolResizeParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolResizeParameter);
        Validator.validate((Object)poolResizeOptions);
        Integer timeout = null;
        if (poolResizeOptions != null) {
            timeout = poolResizeOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolResizeOptions != null) {
            clientRequestId = poolResizeOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolResizeOptions != null) {
            returnClientRequestId = poolResizeOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolResizeOptions != null) {
            ocpDate = poolResizeOptions.ocpDate();
        }
        String ifMatch = null;
        if (poolResizeOptions != null) {
            ifMatch = poolResizeOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (poolResizeOptions != null) {
            ifNoneMatch = poolResizeOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (poolResizeOptions != null) {
            ifModifiedSince = poolResizeOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (poolResizeOptions != null) {
            ifUnmodifiedSince = poolResizeOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.resize(poolId, poolResizeParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolResizeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolResizeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.resizeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolResizeHeaders> resizeDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolResizeHeaders.class);
    }

    @Override
    public void stopResize(String poolId) {
        ((ServiceResponseWithHeaders)this.stopResizeWithServiceResponseAsync(poolId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> stopResizeAsync(String poolId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.stopResizeWithServiceResponseAsync(poolId), serviceCallback);
    }

    @Override
    public Observable<Void> stopResizeAsync(String poolId) {
        return this.stopResizeWithServiceResponseAsync(poolId).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolStopResizeHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolStopResizeHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolStopResizeHeaders>> stopResizeWithServiceResponseAsync(String poolId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object poolStopResizeOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.stopResize(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolStopResizeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolStopResizeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.stopResizeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void stopResize(String poolId, PoolStopResizeOptions poolStopResizeOptions) {
        ((ServiceResponseWithHeaders)this.stopResizeWithServiceResponseAsync(poolId, poolStopResizeOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> stopResizeAsync(String poolId, PoolStopResizeOptions poolStopResizeOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.stopResizeWithServiceResponseAsync(poolId, poolStopResizeOptions), serviceCallback);
    }

    @Override
    public Observable<Void> stopResizeAsync(String poolId, PoolStopResizeOptions poolStopResizeOptions) {
        return this.stopResizeWithServiceResponseAsync(poolId, poolStopResizeOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolStopResizeHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolStopResizeHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolStopResizeHeaders>> stopResizeWithServiceResponseAsync(String poolId, PoolStopResizeOptions poolStopResizeOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolStopResizeOptions);
        Integer timeout = null;
        if (poolStopResizeOptions != null) {
            timeout = poolStopResizeOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolStopResizeOptions != null) {
            clientRequestId = poolStopResizeOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolStopResizeOptions != null) {
            returnClientRequestId = poolStopResizeOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolStopResizeOptions != null) {
            ocpDate = poolStopResizeOptions.ocpDate();
        }
        String ifMatch = null;
        if (poolStopResizeOptions != null) {
            ifMatch = poolStopResizeOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (poolStopResizeOptions != null) {
            ifNoneMatch = poolStopResizeOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (poolStopResizeOptions != null) {
            ifModifiedSince = poolStopResizeOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (poolStopResizeOptions != null) {
            ifUnmodifiedSince = poolStopResizeOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.stopResize(poolId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolStopResizeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolStopResizeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.stopResizeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolStopResizeHeaders> stopResizeDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolStopResizeHeaders.class);
    }

    @Override
    public void updateProperties(String poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter) {
        ((ServiceResponseWithHeaders)this.updatePropertiesWithServiceResponseAsync(poolId, poolUpdatePropertiesParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updatePropertiesAsync(String poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updatePropertiesWithServiceResponseAsync(poolId, poolUpdatePropertiesParameter), serviceCallback);
    }

    @Override
    public Observable<Void> updatePropertiesAsync(String poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter) {
        return this.updatePropertiesWithServiceResponseAsync(poolId, poolUpdatePropertiesParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders>> updatePropertiesWithServiceResponseAsync(String poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (poolUpdatePropertiesParameter == null) {
            throw new IllegalArgumentException("Parameter poolUpdatePropertiesParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolUpdatePropertiesParameter);
        Object poolUpdatePropertiesOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.updateProperties(poolId, poolUpdatePropertiesParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.updatePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void updateProperties(String poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter, PoolUpdatePropertiesOptions poolUpdatePropertiesOptions) {
        ((ServiceResponseWithHeaders)this.updatePropertiesWithServiceResponseAsync(poolId, poolUpdatePropertiesParameter, poolUpdatePropertiesOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> updatePropertiesAsync(String poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter, PoolUpdatePropertiesOptions poolUpdatePropertiesOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.updatePropertiesWithServiceResponseAsync(poolId, poolUpdatePropertiesParameter, poolUpdatePropertiesOptions), serviceCallback);
    }

    @Override
    public Observable<Void> updatePropertiesAsync(String poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter, PoolUpdatePropertiesOptions poolUpdatePropertiesOptions) {
        return this.updatePropertiesWithServiceResponseAsync(poolId, poolUpdatePropertiesParameter, poolUpdatePropertiesOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders>> updatePropertiesWithServiceResponseAsync(String poolId, PoolUpdatePropertiesParameter poolUpdatePropertiesParameter, PoolUpdatePropertiesOptions poolUpdatePropertiesOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (poolUpdatePropertiesParameter == null) {
            throw new IllegalArgumentException("Parameter poolUpdatePropertiesParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)poolUpdatePropertiesParameter);
        Validator.validate((Object)poolUpdatePropertiesOptions);
        Integer timeout = null;
        if (poolUpdatePropertiesOptions != null) {
            timeout = poolUpdatePropertiesOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolUpdatePropertiesOptions != null) {
            clientRequestId = poolUpdatePropertiesOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolUpdatePropertiesOptions != null) {
            returnClientRequestId = poolUpdatePropertiesOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolUpdatePropertiesOptions != null) {
            ocpDate = poolUpdatePropertiesOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.updateProperties(poolId, poolUpdatePropertiesParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.updatePropertiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolUpdatePropertiesHeaders> updatePropertiesDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolUpdatePropertiesHeaders.class);
    }

    @Override
    public void removeNodes(String poolId, NodeRemoveParameter nodeRemoveParameter) {
        ((ServiceResponseWithHeaders)this.removeNodesWithServiceResponseAsync(poolId, nodeRemoveParameter).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> removeNodesAsync(String poolId, NodeRemoveParameter nodeRemoveParameter, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.removeNodesWithServiceResponseAsync(poolId, nodeRemoveParameter), serviceCallback);
    }

    @Override
    public Observable<Void> removeNodesAsync(String poolId, NodeRemoveParameter nodeRemoveParameter) {
        return this.removeNodesWithServiceResponseAsync(poolId, nodeRemoveParameter).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders>> removeNodesWithServiceResponseAsync(String poolId, NodeRemoveParameter nodeRemoveParameter) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeRemoveParameter == null) {
            throw new IllegalArgumentException("Parameter nodeRemoveParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)nodeRemoveParameter);
        Object poolRemoveNodesOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.removeNodes(poolId, nodeRemoveParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.removeNodesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void removeNodes(String poolId, NodeRemoveParameter nodeRemoveParameter, PoolRemoveNodesOptions poolRemoveNodesOptions) {
        ((ServiceResponseWithHeaders)this.removeNodesWithServiceResponseAsync(poolId, nodeRemoveParameter, poolRemoveNodesOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> removeNodesAsync(String poolId, NodeRemoveParameter nodeRemoveParameter, PoolRemoveNodesOptions poolRemoveNodesOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.removeNodesWithServiceResponseAsync(poolId, nodeRemoveParameter, poolRemoveNodesOptions), serviceCallback);
    }

    @Override
    public Observable<Void> removeNodesAsync(String poolId, NodeRemoveParameter nodeRemoveParameter, PoolRemoveNodesOptions poolRemoveNodesOptions) {
        return this.removeNodesWithServiceResponseAsync(poolId, nodeRemoveParameter, poolRemoveNodesOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders>> removeNodesWithServiceResponseAsync(String poolId, NodeRemoveParameter nodeRemoveParameter, PoolRemoveNodesOptions poolRemoveNodesOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeRemoveParameter == null) {
            throw new IllegalArgumentException("Parameter nodeRemoveParameter is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)nodeRemoveParameter);
        Validator.validate((Object)poolRemoveNodesOptions);
        Integer timeout = null;
        if (poolRemoveNodesOptions != null) {
            timeout = poolRemoveNodesOptions.timeout();
        }
        UUID clientRequestId = null;
        if (poolRemoveNodesOptions != null) {
            clientRequestId = poolRemoveNodesOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolRemoveNodesOptions != null) {
            returnClientRequestId = poolRemoveNodesOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolRemoveNodesOptions != null) {
            ocpDate = poolRemoveNodesOptions.ocpDate();
        }
        String ifMatch = null;
        if (poolRemoveNodesOptions != null) {
            ifMatch = poolRemoveNodesOptions.ifMatch();
        }
        String ifNoneMatch = null;
        if (poolRemoveNodesOptions != null) {
            ifNoneMatch = poolRemoveNodesOptions.ifNoneMatch();
        }
        DateTime ifModifiedSince = null;
        if (poolRemoveNodesOptions != null) {
            ifModifiedSince = poolRemoveNodesOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (poolRemoveNodesOptions != null) {
            ifUnmodifiedSince = poolRemoveNodesOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.removeNodes(poolId, nodeRemoveParameter, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = PoolsImpl.this.removeNodesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, PoolRemoveNodesHeaders> removeNodesDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolRemoveNodesHeaders.class);
    }

    @Override
    public PagedList<PoolUsageMetrics> listUsageMetricsNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listUsageMetricsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PoolUsageMetrics>((Page)response.body()){

            public Page<PoolUsageMetrics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)PoolsImpl.this.listUsageMetricsNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<PoolUsageMetrics>> listUsageMetricsNextAsync(String nextPageLink, ServiceFuture<List<PoolUsageMetrics>> serviceFuture, ListOperationCallback<PoolUsageMetrics> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listUsageMetricsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(String nextPageLink) {
                return PoolsImpl.this.listUsageMetricsNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PoolUsageMetrics>> listUsageMetricsNextAsync(String nextPageLink) {
        return this.listUsageMetricsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>, Page<PoolUsageMetrics>>(){

            public Page<PoolUsageMetrics> call(ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> listUsageMetricsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listUsageMetricsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsImpl.this.listUsageMetricsNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> listUsageMetricsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object poolListUsageMetricsNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listUsageMetricsNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = PoolsImpl.this.listUsageMetricsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<PoolUsageMetrics> listUsageMetricsNext(String nextPageLink, final PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listUsageMetricsNextSinglePageAsync(nextPageLink, poolListUsageMetricsNextOptions).toBlocking().single();
        return new PagedList<PoolUsageMetrics>((Page)response.body()){

            public Page<PoolUsageMetrics> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)PoolsImpl.this.listUsageMetricsNextSinglePageAsync(nextPageLink, poolListUsageMetricsNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<PoolUsageMetrics>> listUsageMetricsNextAsync(String nextPageLink, final PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions, ServiceFuture<List<PoolUsageMetrics>> serviceFuture, ListOperationCallback<PoolUsageMetrics> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listUsageMetricsNextSinglePageAsync(nextPageLink, poolListUsageMetricsNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(String nextPageLink) {
                return PoolsImpl.this.listUsageMetricsNextSinglePageAsync(nextPageLink, poolListUsageMetricsNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<PoolUsageMetrics>> listUsageMetricsNextAsync(String nextPageLink, PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions) {
        return this.listUsageMetricsNextWithServiceResponseAsync(nextPageLink, poolListUsageMetricsNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>, Page<PoolUsageMetrics>>(){

            public Page<PoolUsageMetrics> call(ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> listUsageMetricsNextWithServiceResponseAsync(String nextPageLink, final PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions) {
        return this.listUsageMetricsNextSinglePageAsync(nextPageLink, poolListUsageMetricsNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsImpl.this.listUsageMetricsNextWithServiceResponseAsync(nextPageLink, poolListUsageMetricsNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> listUsageMetricsNextSinglePageAsync(String nextPageLink, PoolListUsageMetricsNextOptions poolListUsageMetricsNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)poolListUsageMetricsNextOptions);
        UUID clientRequestId = null;
        if (poolListUsageMetricsNextOptions != null) {
            clientRequestId = poolListUsageMetricsNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolListUsageMetricsNextOptions != null) {
            returnClientRequestId = poolListUsageMetricsNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolListUsageMetricsNextOptions != null) {
            ocpDate = poolListUsageMetricsNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listUsageMetricsNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<PoolUsageMetrics>, PoolListUsageMetricsHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = PoolsImpl.this.listUsageMetricsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<PoolUsageMetrics>, PoolListUsageMetricsHeaders> listUsageMetricsNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PoolUsageMetrics>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolListUsageMetricsHeaders.class);
    }

    @Override
    public PagedList<CloudPool> listNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CloudPool>((Page)response.body()){

            public Page<CloudPool> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)PoolsImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudPool>> listNextAsync(String nextPageLink, ServiceFuture<List<CloudPool>> serviceFuture, ListOperationCallback<CloudPool> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(String nextPageLink) {
                return PoolsImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudPool>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>, Page<CloudPool>>(){

            public Page<CloudPool> call(ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object poolListNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = PoolsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<CloudPool> listNext(String nextPageLink, final PoolListNextOptions poolListNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink, poolListNextOptions).toBlocking().single();
        return new PagedList<CloudPool>((Page)response.body()){

            public Page<CloudPool> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)PoolsImpl.this.listNextSinglePageAsync(nextPageLink, poolListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<CloudPool>> listNextAsync(String nextPageLink, final PoolListNextOptions poolListNextOptions, ServiceFuture<List<CloudPool>> serviceFuture, ListOperationCallback<CloudPool> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink, poolListNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(String nextPageLink) {
                return PoolsImpl.this.listNextSinglePageAsync(nextPageLink, poolListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<CloudPool>> listNextAsync(String nextPageLink, PoolListNextOptions poolListNextOptions) {
        return this.listNextWithServiceResponseAsync(nextPageLink, poolListNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>, Page<CloudPool>>(){

            public Page<CloudPool> call(ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> listNextWithServiceResponseAsync(String nextPageLink, final PoolListNextOptions poolListNextOptions) {
        return this.listNextSinglePageAsync(nextPageLink, poolListNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PoolsImpl.this.listNextWithServiceResponseAsync(nextPageLink, poolListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> listNextSinglePageAsync(String nextPageLink, PoolListNextOptions poolListNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)poolListNextOptions);
        UUID clientRequestId = null;
        if (poolListNextOptions != null) {
            clientRequestId = poolListNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (poolListNextOptions != null) {
            returnClientRequestId = poolListNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (poolListNextOptions != null) {
            ocpDate = poolListNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<CloudPool>, PoolListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = PoolsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<CloudPool>, PoolListHeaders> listNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CloudPool>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, PoolListHeaders.class);
    }

    static interface PoolsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools listUsageMetrics"})
        @GET(value="poolusagemetrics")
        public Observable<Response<ResponseBody>> listUsageMetrics(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="starttime") DateTime var3, @Query(value="endtime") DateTime var4, @Query(value="$filter") String var5, @Query(value="maxresults") Integer var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools add"})
        @POST(value="pools")
        public Observable<Response<ResponseBody>> add(@Body PoolAddParameter var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools list"})
        @GET(value="pools")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="$filter") String var3, @Query(value="$select") String var4, @Query(value="$expand") String var5, @Query(value="maxresults") Integer var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools delete"})
        @HTTP(path="pools/{poolId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="poolId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools exists"})
        @HEAD(value="pools/{poolId}")
        public Observable<Response<Void>> exists(@Path(value="poolId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools get"})
        @GET(value="pools/{poolId}")
        public Observable<Response<ResponseBody>> get(@Path(value="poolId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$select") String var4, @Query(value="$expand") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="If-Match") String var10, @Header(value="If-None-Match") String var11, @Header(value="If-Modified-Since") DateTimeRfc1123 var12, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var13, @Header(value="x-ms-parameterized-host") String var14, @Header(value="User-Agent") String var15);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools patch"})
        @PATCH(value="pools/{poolId}")
        public Observable<Response<ResponseBody>> patch(@Path(value="poolId") String var1, @Body PoolPatchParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools disableAutoScale"})
        @POST(value="pools/{poolId}/disableautoscale")
        public Observable<Response<ResponseBody>> disableAutoScale(@Path(value="poolId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools enableAutoScale"})
        @POST(value="pools/{poolId}/enableautoscale")
        public Observable<Response<ResponseBody>> enableAutoScale(@Path(value="poolId") String var1, @Body PoolEnableAutoScaleParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools evaluateAutoScale"})
        @POST(value="pools/{poolId}/evaluateautoscale")
        public Observable<Response<ResponseBody>> evaluateAutoScale(@Path(value="poolId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Body PoolEvaluateAutoScaleParameter var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools resize"})
        @POST(value="pools/{poolId}/resize")
        public Observable<Response<ResponseBody>> resize(@Path(value="poolId") String var1, @Body PoolResizeParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools stopResize"})
        @POST(value="pools/{poolId}/stopresize")
        public Observable<Response<ResponseBody>> stopResize(@Path(value="poolId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="If-Match") String var8, @Header(value="If-None-Match") String var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools updateProperties"})
        @POST(value="pools/{poolId}/updateproperties")
        public Observable<Response<ResponseBody>> updateProperties(@Path(value="poolId") String var1, @Body PoolUpdatePropertiesParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; odata=minimalmetadata; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools removeNodes"})
        @POST(value="pools/{poolId}/removenodes")
        public Observable<Response<ResponseBody>> removeNodes(@Path(value="poolId") String var1, @Body NodeRemoveParameter var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="timeout") Integer var5, @Header(value="client-request-id") UUID var6, @Header(value="return-client-request-id") Boolean var7, @Header(value="ocp-date") DateTimeRfc1123 var8, @Header(value="If-Match") String var9, @Header(value="If-None-Match") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools listUsageMetricsNext"})
        @GET
        public Observable<Response<ResponseBody>> listUsageMetricsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Pools listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

