/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.BatchClient;
import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.BehaviorManager;
import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.IInheritedBehaviors;
import com.microsoft.azure.batch.InternalHelper;
import com.microsoft.azure.batch.protocol.models.AccountListPoolNodeCountsOptions;
import com.microsoft.azure.batch.protocol.models.AccountListSupportedImagesOptions;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.ImageInformation;
import com.microsoft.azure.batch.protocol.models.PoolNodeCounts;
import java.io.IOException;
import java.util.Collection;

public class AccountOperations
implements IInheritedBehaviors {
    private Collection<BatchClientBehavior> customBehaviors;
    private final BatchClient parentBatchClient;

    AccountOperations(BatchClient batchClient, Collection<BatchClientBehavior> customBehaviors) {
        this.parentBatchClient = batchClient;
        InternalHelper.inheritClientBehaviorsAndSetPublicProperty(this, customBehaviors);
    }

    @Override
    public Collection<BatchClientBehavior> customBehaviors() {
        return this.customBehaviors;
    }

    @Override
    public IInheritedBehaviors withCustomBehaviors(Collection<BatchClientBehavior> behaviors) {
        this.customBehaviors = behaviors;
        return this;
    }

    public PagedList<ImageInformation> listSupportedImages() throws BatchErrorException, IOException {
        return this.listSupportedImages(null, null);
    }

    public PagedList<ImageInformation> listSupportedImages(DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listSupportedImages(detailLevel, null);
    }

    public PagedList<ImageInformation> listSupportedImages(DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        AccountListSupportedImagesOptions options = new AccountListSupportedImagesOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().accounts().listSupportedImages(options);
    }

    public PagedList<PoolNodeCounts> listPoolNodeCounts() throws BatchErrorException, IOException {
        return this.listPoolNodeCounts(null, null);
    }

    public PagedList<PoolNodeCounts> listPoolNodeCounts(DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        AccountListPoolNodeCountsOptions options = new AccountListPoolNodeCountsOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().accounts().listPoolNodeCounts(options);
    }
}

