/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.BatchClient;
import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.BehaviorManager;
import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.IInheritedBehaviors;
import com.microsoft.azure.batch.InternalHelper;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.Certificate;
import com.microsoft.azure.batch.protocol.models.CertificateAddOptions;
import com.microsoft.azure.batch.protocol.models.CertificateAddParameter;
import com.microsoft.azure.batch.protocol.models.CertificateCancelDeletionOptions;
import com.microsoft.azure.batch.protocol.models.CertificateDeleteOptions;
import com.microsoft.azure.batch.protocol.models.CertificateFormat;
import com.microsoft.azure.batch.protocol.models.CertificateGetOptions;
import com.microsoft.azure.batch.protocol.models.CertificateListOptions;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.commons.codec.binary.Base64;

public class CertificateOperations
implements IInheritedBehaviors {
    private Collection<BatchClientBehavior> customBehaviors;
    private final BatchClient parentBatchClient;
    public static final String SHA1_CERTIFICATE_ALGORITHM = "sha1";

    CertificateOperations(BatchClient batchClient, Iterable<BatchClientBehavior> inheritedBehaviors) {
        this.parentBatchClient = batchClient;
        InternalHelper.inheritClientBehaviorsAndSetPublicProperty(this, inheritedBehaviors);
    }

    @Override
    public Collection<BatchClientBehavior> customBehaviors() {
        return this.customBehaviors;
    }

    @Override
    public IInheritedBehaviors withCustomBehaviors(Collection<BatchClientBehavior> behaviors) {
        this.customBehaviors = behaviors;
        return this;
    }

    private static String getThumbPrint(java.security.cert.Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return CertificateOperations.hexify(digest);
    }

    private static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            buf.append(hexDigits[(b & 0xF0) >> 4]);
            buf.append(hexDigits[b & 0xF]);
        }
        return buf.toString();
    }

    public void createCertificate(InputStream certStream) throws BatchErrorException, IOException, CertificateException, NoSuchAlgorithmException {
        this.createCertificate(certStream, null);
    }

    public void createCertificate(InputStream certStream, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException, CertificateException, NoSuchAlgorithmException {
        CertificateFactory x509CertFact = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)x509CertFact.generateCertificate(certStream);
        CertificateAddParameter addParam = new CertificateAddParameter().withCertificateFormat(CertificateFormat.CER).withThumbprintAlgorithm(SHA1_CERTIFICATE_ALGORITHM).withThumbprint(CertificateOperations.getThumbPrint(cert)).withData(Base64.encodeBase64String((byte[])cert.getEncoded()));
        this.createCertificate(addParam, additionalBehaviors);
    }

    public void createCertificate(CertificateAddParameter certificate) throws BatchErrorException, IOException {
        this.createCertificate(certificate, null);
    }

    public void createCertificate(CertificateAddParameter certificate, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        CertificateAddOptions options = new CertificateAddOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().certificates().add(certificate, options);
    }

    public void cancelDeleteCertificate(String thumbprintAlgorithm, String thumbprint) throws BatchErrorException, IOException {
        this.cancelDeleteCertificate(thumbprintAlgorithm, thumbprint, null);
    }

    public void cancelDeleteCertificate(String thumbprintAlgorithm, String thumbprint, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        CertificateCancelDeletionOptions options = new CertificateCancelDeletionOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().certificates().cancelDeletion(thumbprintAlgorithm, thumbprint, options);
    }

    public void deleteCertificate(String thumbprintAlgorithm, String thumbprint) throws BatchErrorException, IOException {
        this.deleteCertificate(thumbprintAlgorithm, thumbprint, null);
    }

    public void deleteCertificate(String thumbprintAlgorithm, String thumbprint, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        CertificateDeleteOptions options = new CertificateDeleteOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().certificates().delete(thumbprintAlgorithm, thumbprint, options);
    }

    public Certificate getCertificate(String thumbprintAlgorithm, String thumbprint) throws BatchErrorException, IOException {
        return this.getCertificate(thumbprintAlgorithm, thumbprint, null, null);
    }

    public Certificate getCertificate(String thumbprintAlgorithm, String thumbprint, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.getCertificate(thumbprintAlgorithm, thumbprint, detailLevel, null);
    }

    public Certificate getCertificate(String thumbprintAlgorithm, String thumbprint, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        CertificateGetOptions getCertificateOptions = new CertificateGetOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(getCertificateOptions);
        return this.parentBatchClient.protocolLayer().certificates().get(thumbprintAlgorithm, thumbprint, getCertificateOptions);
    }

    public PagedList<Certificate> listCertificates() throws BatchErrorException, IOException {
        return this.listCertificates(null, null);
    }

    public PagedList<Certificate> listCertificates(DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listCertificates(detailLevel, null);
    }

    public PagedList<Certificate> listCertificates(DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        CertificateListOptions certificateListOptions = new CertificateListOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(certificateListOptions);
        return this.parentBatchClient.protocolLayer().certificates().list(certificateListOptions);
    }
}

