/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.BatchClient;
import com.microsoft.azure.batch.BatchClientBehavior;
import com.microsoft.azure.batch.BehaviorManager;
import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.IInheritedBehaviors;
import com.microsoft.azure.batch.InternalHelper;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.CloudJobSchedule;
import com.microsoft.azure.batch.protocol.models.JobScheduleAddOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleAddParameter;
import com.microsoft.azure.batch.protocol.models.JobScheduleDeleteOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleDisableOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleEnableOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleExistsOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleGetOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleListOptions;
import com.microsoft.azure.batch.protocol.models.JobSchedulePatchOptions;
import com.microsoft.azure.batch.protocol.models.JobSchedulePatchParameter;
import com.microsoft.azure.batch.protocol.models.JobScheduleTerminateOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleUpdateOptions;
import com.microsoft.azure.batch.protocol.models.JobScheduleUpdateParameter;
import com.microsoft.azure.batch.protocol.models.JobSpecification;
import com.microsoft.azure.batch.protocol.models.MetadataItem;
import com.microsoft.azure.batch.protocol.models.Schedule;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class JobScheduleOperations
implements IInheritedBehaviors {
    private Collection<BatchClientBehavior> customBehaviors;
    private final BatchClient parentBatchClient;

    JobScheduleOperations(BatchClient batchClient, Iterable<BatchClientBehavior> inheritedBehaviors) {
        this.parentBatchClient = batchClient;
        InternalHelper.inheritClientBehaviorsAndSetPublicProperty(this, inheritedBehaviors);
    }

    @Override
    public Collection<BatchClientBehavior> customBehaviors() {
        return this.customBehaviors;
    }

    @Override
    public IInheritedBehaviors withCustomBehaviors(Collection<BatchClientBehavior> behaviors) {
        this.customBehaviors = behaviors;
        return this;
    }

    public boolean existsJobSchedule(String jobScheduleId) throws BatchErrorException, IOException {
        return this.existsJobSchedule(jobScheduleId, null);
    }

    public boolean existsJobSchedule(String jobScheduleId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleExistsOptions options = new JobScheduleExistsOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().jobSchedules().exists(jobScheduleId, options);
    }

    public void deleteJobSchedule(String jobScheduleId) throws BatchErrorException, IOException {
        this.deleteJobSchedule(jobScheduleId, null);
    }

    public void deleteJobSchedule(String jobScheduleId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleDeleteOptions options = new JobScheduleDeleteOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobSchedules().delete(jobScheduleId, options);
    }

    public CloudJobSchedule getJobSchedule(String jobScheduleId) throws BatchErrorException, IOException {
        return this.getJobSchedule(jobScheduleId, null, null);
    }

    public CloudJobSchedule getJobSchedule(String jobScheduleId, DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.getJobSchedule(jobScheduleId, detailLevel, null);
    }

    public CloudJobSchedule getJobSchedule(String jobScheduleId, DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleGetOptions options = new JobScheduleGetOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().jobSchedules().get(jobScheduleId, options);
    }

    public void patchJobSchedule(String jobScheduleId, Schedule schedule, JobSpecification jobSpecification) throws BatchErrorException, IOException {
        this.patchJobSchedule(jobScheduleId, schedule, jobSpecification, null, null);
    }

    public void patchJobSchedule(String jobScheduleId, Schedule schedule, JobSpecification jobSpecification, List<MetadataItem> metadata) throws BatchErrorException, IOException {
        this.patchJobSchedule(jobScheduleId, schedule, jobSpecification, metadata, null);
    }

    public void patchJobSchedule(String jobScheduleId, Schedule schedule, JobSpecification jobSpecification, List<MetadataItem> metadata, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobSchedulePatchOptions options = new JobSchedulePatchOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        JobSchedulePatchParameter param = new JobSchedulePatchParameter().withJobSpecification(jobSpecification).withMetadata(metadata).withSchedule(schedule);
        this.parentBatchClient.protocolLayer().jobSchedules().patch(jobScheduleId, param, options);
    }

    public void updateJobSchedule(String jobScheduleId, Schedule schedule, JobSpecification jobSpecification) throws BatchErrorException, IOException {
        this.updateJobSchedule(jobScheduleId, schedule, jobSpecification, null, null);
    }

    public void updateJobSchedule(String jobScheduleId, Schedule schedule, JobSpecification jobSpecification, List<MetadataItem> metadata) throws BatchErrorException, IOException {
        this.updateJobSchedule(jobScheduleId, schedule, jobSpecification, metadata, null);
    }

    public void updateJobSchedule(String jobScheduleId, Schedule schedule, JobSpecification jobSpecification, List<MetadataItem> metadata, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleUpdateOptions options = new JobScheduleUpdateOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        JobScheduleUpdateParameter param = new JobScheduleUpdateParameter().withJobSpecification(jobSpecification).withMetadata(metadata).withSchedule(schedule);
        this.parentBatchClient.protocolLayer().jobSchedules().update(jobScheduleId, param, options);
    }

    public void disableJobSchedule(String jobScheduleId) throws BatchErrorException, IOException {
        this.disableJobSchedule(jobScheduleId, null);
    }

    public void disableJobSchedule(String jobScheduleId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleDisableOptions options = new JobScheduleDisableOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobSchedules().disable(jobScheduleId, options);
    }

    public void enableJobSchedule(String jobScheduleId) throws BatchErrorException, IOException {
        this.enableJobSchedule(jobScheduleId, null);
    }

    public void enableJobSchedule(String jobScheduleId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleEnableOptions options = new JobScheduleEnableOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobSchedules().enable(jobScheduleId, options);
    }

    public void terminateJobSchedule(String jobScheduleId) throws BatchErrorException, IOException {
        this.terminateJobSchedule(jobScheduleId, null);
    }

    public void terminateJobSchedule(String jobScheduleId, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleTerminateOptions options = new JobScheduleTerminateOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobSchedules().terminate(jobScheduleId, options);
    }

    public void createJobSchedule(String jobScheduleId, Schedule schedule, JobSpecification jobSpecification) throws BatchErrorException, IOException {
        this.createJobSchedule(jobScheduleId, schedule, jobSpecification, null);
    }

    public void createJobSchedule(String jobScheduleId, Schedule schedule, JobSpecification jobSpecification, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleAddParameter param = new JobScheduleAddParameter().withJobSpecification(jobSpecification).withSchedule(schedule).withId(jobScheduleId);
        this.createJobSchedule(param, additionalBehaviors);
    }

    public void createJobSchedule(JobScheduleAddParameter jobSchedule) throws BatchErrorException, IOException {
        this.createJobSchedule(jobSchedule, null);
    }

    public void createJobSchedule(JobScheduleAddParameter jobSchedule, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleAddOptions options = new JobScheduleAddOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.applyRequestBehaviors(options);
        this.parentBatchClient.protocolLayer().jobSchedules().add(jobSchedule, options);
    }

    public PagedList<CloudJobSchedule> listJobSchedules() throws BatchErrorException, IOException {
        return this.listJobSchedules(null, null);
    }

    public PagedList<CloudJobSchedule> listJobSchedules(DetailLevel detailLevel) throws BatchErrorException, IOException {
        return this.listJobSchedules(detailLevel, null);
    }

    public PagedList<CloudJobSchedule> listJobSchedules(DetailLevel detailLevel, Iterable<BatchClientBehavior> additionalBehaviors) throws BatchErrorException, IOException {
        JobScheduleListOptions options = new JobScheduleListOptions();
        BehaviorManager bhMgr = new BehaviorManager(this.customBehaviors(), additionalBehaviors);
        bhMgr.appendDetailLevelToPerCallBehaviors(detailLevel);
        bhMgr.applyRequestBehaviors(options);
        return this.parentBatchClient.protocolLayer().jobSchedules().list(options);
    }
}

