/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.interceptor;

import com.microsoft.azure.batch.DetailLevel;
import com.microsoft.azure.batch.interceptor.BatchRequestInterceptHandler;
import com.microsoft.azure.batch.interceptor.RequestInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DetailLevelInterceptor
extends RequestInterceptor {
    private final DetailLevel detailLevel;

    public DetailLevelInterceptor(DetailLevel detailLevel) {
        this.detailLevel = detailLevel;
        this.withHandler(new RequestHandler(detailLevel));
    }

    public DetailLevel detailLevel() {
        return this.detailLevel;
    }

    private static class RequestHandler
    implements BatchRequestInterceptHandler {
        private final DetailLevel detailLevel;

        RequestHandler(DetailLevel level) {
            this.detailLevel = level;
        }

        @Override
        public void modify(Object request) {
            if (this.detailLevel != null) {
                Class<?> c = request.getClass();
                try {
                    Method selectMethod = c.getMethod("withSelect", String.class);
                    selectMethod.invoke(request, this.detailLevel.selectClause());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException selectMethod) {
                    // empty catch block
                }
                try {
                    Method filterMethod = c.getMethod("withFilter", String.class);
                    filterMethod.invoke(request, this.detailLevel.filterClause());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException filterMethod) {
                    // empty catch block
                }
                try {
                    Method expandMethod = c.getMethod("withExpand", String.class);
                    expandMethod.invoke(request, this.detailLevel.expandClause());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
    }
}

