/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.Applications;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.ApplicationGetHeaders;
import com.microsoft.azure.batch.protocol.models.ApplicationGetOptions;
import com.microsoft.azure.batch.protocol.models.ApplicationListHeaders;
import com.microsoft.azure.batch.protocol.models.ApplicationListNextOptions;
import com.microsoft.azure.batch.protocol.models.ApplicationListOptions;
import com.microsoft.azure.batch.protocol.models.ApplicationSummary;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ApplicationsImpl
implements Applications {
    private ApplicationsService service;
    private BatchServiceClientImpl client;

    public ApplicationsImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (ApplicationsService)retrofit.create(ApplicationsService.class);
        this.client = client;
    }

    @Override
    public PagedList<ApplicationSummary> list() {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationSummary>((Page)response.body()){

            public Page<ApplicationSummary> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ApplicationsImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ApplicationSummary>> listAsync(ListOperationCallback<ApplicationSummary> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(String nextPageLink) {
                return ApplicationsImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ApplicationSummary>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>, Page<ApplicationSummary>>(){

            public Page<ApplicationSummary> call(ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> listSinglePageAsync() {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object applicationListOptions = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ApplicationsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<ApplicationSummary> list(final ApplicationListOptions applicationListOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listSinglePageAsync(applicationListOptions).toBlocking().single();
        return new PagedList<ApplicationSummary>((Page)response.body()){

            public Page<ApplicationSummary> nextPage(String nextPageLink) {
                ApplicationListNextOptions applicationListNextOptions = null;
                if (applicationListOptions != null) {
                    applicationListNextOptions = new ApplicationListNextOptions();
                    applicationListNextOptions.withClientRequestId(applicationListOptions.clientRequestId());
                    applicationListNextOptions.withReturnClientRequestId(applicationListOptions.returnClientRequestId());
                    applicationListNextOptions.withOcpDate(applicationListOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)ApplicationsImpl.this.listNextSinglePageAsync(nextPageLink, applicationListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ApplicationSummary>> listAsync(final ApplicationListOptions applicationListOptions, ListOperationCallback<ApplicationSummary> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listSinglePageAsync(applicationListOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(String nextPageLink) {
                ApplicationListNextOptions applicationListNextOptions = null;
                if (applicationListOptions != null) {
                    applicationListNextOptions = new ApplicationListNextOptions();
                    applicationListNextOptions.withClientRequestId(applicationListOptions.clientRequestId());
                    applicationListNextOptions.withReturnClientRequestId(applicationListOptions.returnClientRequestId());
                    applicationListNextOptions.withOcpDate(applicationListOptions.ocpDate());
                }
                return ApplicationsImpl.this.listNextSinglePageAsync(nextPageLink, applicationListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ApplicationSummary>> listAsync(ApplicationListOptions applicationListOptions) {
        return this.listWithServiceResponseAsync(applicationListOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>, Page<ApplicationSummary>>(){

            public Page<ApplicationSummary> call(ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> listWithServiceResponseAsync(final ApplicationListOptions applicationListOptions) {
        return this.listSinglePageAsync(applicationListOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                ApplicationListNextOptions applicationListNextOptions = null;
                if (applicationListOptions != null) {
                    applicationListNextOptions = new ApplicationListNextOptions();
                    applicationListNextOptions.withClientRequestId(applicationListOptions.clientRequestId());
                    applicationListNextOptions.withReturnClientRequestId(applicationListOptions.returnClientRequestId());
                    applicationListNextOptions.withOcpDate(applicationListOptions.ocpDate());
                }
                return Observable.just(page).concatWith(ApplicationsImpl.this.listNextWithServiceResponseAsync(nextPageLink, applicationListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> listSinglePageAsync(ApplicationListOptions applicationListOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)applicationListOptions);
        Integer maxResults = null;
        if (applicationListOptions != null) {
            maxResults = applicationListOptions.maxResults();
        }
        Integer timeout = null;
        if (applicationListOptions != null) {
            timeout = applicationListOptions.timeout();
        }
        UUID clientRequestId = null;
        if (applicationListOptions != null) {
            clientRequestId = applicationListOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (applicationListOptions != null) {
            returnClientRequestId = applicationListOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (applicationListOptions != null) {
            ocpDate = applicationListOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ApplicationsImpl.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<ApplicationSummary>, ApplicationListHeaders> listDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationSummary>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ApplicationListHeaders.class);
    }

    @Override
    public ApplicationSummary get(String applicationId) {
        return (ApplicationSummary)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(applicationId).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ApplicationSummary> getAsync(String applicationId, ServiceCallback<ApplicationSummary> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(applicationId), serviceCallback);
    }

    @Override
    public Observable<ApplicationSummary> getAsync(String applicationId) {
        return this.getWithServiceResponseAsync(applicationId).map((Func1)new Func1<ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders>, ApplicationSummary>(){

            public ApplicationSummary call(ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders> response) {
                return (ApplicationSummary)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders>> getWithServiceResponseAsync(String applicationId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Parameter applicationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object applicationGetOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.get(applicationId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ApplicationsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public ApplicationSummary get(String applicationId, ApplicationGetOptions applicationGetOptions) {
        return (ApplicationSummary)((ServiceResponseWithHeaders)this.getWithServiceResponseAsync(applicationId, applicationGetOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<ApplicationSummary> getAsync(String applicationId, ApplicationGetOptions applicationGetOptions, ServiceCallback<ApplicationSummary> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getWithServiceResponseAsync(applicationId, applicationGetOptions), serviceCallback);
    }

    @Override
    public Observable<ApplicationSummary> getAsync(String applicationId, ApplicationGetOptions applicationGetOptions) {
        return this.getWithServiceResponseAsync(applicationId, applicationGetOptions).map((Func1)new Func1<ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders>, ApplicationSummary>(){

            public ApplicationSummary call(ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders> response) {
                return (ApplicationSummary)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders>> getWithServiceResponseAsync(String applicationId, ApplicationGetOptions applicationGetOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Parameter applicationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)applicationGetOptions);
        Integer timeout = null;
        if (applicationGetOptions != null) {
            timeout = applicationGetOptions.timeout();
        }
        UUID clientRequestId = null;
        if (applicationGetOptions != null) {
            clientRequestId = applicationGetOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (applicationGetOptions != null) {
            returnClientRequestId = applicationGetOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (applicationGetOptions != null) {
            ocpDate = applicationGetOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.get(applicationId, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = ApplicationsImpl.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<ApplicationSummary, ApplicationGetHeaders> getDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationSummary>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ApplicationGetHeaders.class);
    }

    @Override
    public PagedList<ApplicationSummary> listNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationSummary>((Page)response.body()){

            public Page<ApplicationSummary> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ApplicationsImpl.this.listNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ApplicationSummary>> listNextAsync(String nextPageLink, ServiceFuture<List<ApplicationSummary>> serviceFuture, ListOperationCallback<ApplicationSummary> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(String nextPageLink) {
                return ApplicationsImpl.this.listNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ApplicationSummary>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>, Page<ApplicationSummary>>(){

            public Page<ApplicationSummary> call(ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsImpl.this.listNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object applicationListNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ApplicationsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<ApplicationSummary> listNext(String nextPageLink, final ApplicationListNextOptions applicationListNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listNextSinglePageAsync(nextPageLink, applicationListNextOptions).toBlocking().single();
        return new PagedList<ApplicationSummary>((Page)response.body()){

            public Page<ApplicationSummary> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)ApplicationsImpl.this.listNextSinglePageAsync(nextPageLink, applicationListNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<ApplicationSummary>> listNextAsync(String nextPageLink, final ApplicationListNextOptions applicationListNextOptions, ServiceFuture<List<ApplicationSummary>> serviceFuture, ListOperationCallback<ApplicationSummary> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listNextSinglePageAsync(nextPageLink, applicationListNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(String nextPageLink) {
                return ApplicationsImpl.this.listNextSinglePageAsync(nextPageLink, applicationListNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<ApplicationSummary>> listNextAsync(String nextPageLink, ApplicationListNextOptions applicationListNextOptions) {
        return this.listNextWithServiceResponseAsync(nextPageLink, applicationListNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>, Page<ApplicationSummary>>(){

            public Page<ApplicationSummary> call(ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> listNextWithServiceResponseAsync(String nextPageLink, final ApplicationListNextOptions applicationListNextOptions) {
        return this.listNextSinglePageAsync(nextPageLink, applicationListNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsImpl.this.listNextWithServiceResponseAsync(nextPageLink, applicationListNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> listNextSinglePageAsync(String nextPageLink, ApplicationListNextOptions applicationListNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)applicationListNextOptions);
        UUID clientRequestId = null;
        if (applicationListNextOptions != null) {
            clientRequestId = applicationListNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (applicationListNextOptions != null) {
            returnClientRequestId = applicationListNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (applicationListNextOptions != null) {
            ocpDate = applicationListNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<ApplicationSummary>, ApplicationListHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = ApplicationsImpl.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<ApplicationSummary>, ApplicationListHeaders> listNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationSummary>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, ApplicationListHeaders.class);
    }

    static interface ApplicationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Applications list"})
        @GET(value="applications")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Query(value="maxresults") Integer var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Applications get"})
        @GET(value="applications/{applicationId}")
        public Observable<Response<ResponseBody>> get(@Path(value="applicationId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="timeout") Integer var4, @Header(value="client-request-id") UUID var5, @Header(value="return-client-request-id") Boolean var6, @Header(value="ocp-date") DateTimeRfc1123 var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Applications listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

