/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.batch.protocol.Accounts;
import com.microsoft.azure.batch.protocol.Applications;
import com.microsoft.azure.batch.protocol.BatchServiceClient;
import com.microsoft.azure.batch.protocol.Certificates;
import com.microsoft.azure.batch.protocol.ComputeNodes;
import com.microsoft.azure.batch.protocol.Files;
import com.microsoft.azure.batch.protocol.JobSchedules;
import com.microsoft.azure.batch.protocol.Jobs;
import com.microsoft.azure.batch.protocol.Pools;
import com.microsoft.azure.batch.protocol.Tasks;
import com.microsoft.azure.batch.protocol.implementation.AccountsImpl;
import com.microsoft.azure.batch.protocol.implementation.ApplicationsImpl;
import com.microsoft.azure.batch.protocol.implementation.CertificatesImpl;
import com.microsoft.azure.batch.protocol.implementation.ComputeNodesImpl;
import com.microsoft.azure.batch.protocol.implementation.FilesImpl;
import com.microsoft.azure.batch.protocol.implementation.JobSchedulesImpl;
import com.microsoft.azure.batch.protocol.implementation.JobsImpl;
import com.microsoft.azure.batch.protocol.implementation.PoolsImpl;
import com.microsoft.azure.batch.protocol.implementation.TasksImpl;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class BatchServiceClientImpl
extends AzureServiceClient
implements BatchServiceClient {
    private AzureClient azureClient;
    private String apiVersion;
    private String batchUrl;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private Applications applications;
    private Pools pools;
    private Accounts accounts;
    private Jobs jobs;
    private Certificates certificates;
    private Files files;
    private JobSchedules jobSchedules;
    private Tasks tasks;
    private ComputeNodes computeNodes;

    @Override
    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    @Override
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String batchUrl() {
        return this.batchUrl;
    }

    @Override
    public BatchServiceClientImpl withBatchUrl(String batchUrl) {
        this.batchUrl = batchUrl;
        return this;
    }

    @Override
    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public BatchServiceClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    @Override
    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    @Override
    public BatchServiceClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    @Override
    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    @Override
    public BatchServiceClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    @Override
    public Applications applications() {
        return this.applications;
    }

    @Override
    public Pools pools() {
        return this.pools;
    }

    @Override
    public Accounts accounts() {
        return this.accounts;
    }

    @Override
    public Jobs jobs() {
        return this.jobs;
    }

    @Override
    public Certificates certificates() {
        return this.certificates;
    }

    @Override
    public Files files() {
        return this.files;
    }

    @Override
    public JobSchedules jobSchedules() {
        return this.jobSchedules;
    }

    @Override
    public Tasks tasks() {
        return this.tasks;
    }

    @Override
    public ComputeNodes computeNodes() {
        return this.computeNodes;
    }

    public BatchServiceClientImpl(ServiceClientCredentials credentials) {
        this("https://{batchUrl}", credentials);
    }

    private BatchServiceClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public BatchServiceClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2020-09-01.12.0";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.applications = new ApplicationsImpl(this.restClient().retrofit(), this);
        this.pools = new PoolsImpl(this.restClient().retrofit(), this);
        this.accounts = new AccountsImpl(this.restClient().retrofit(), this);
        this.jobs = new JobsImpl(this.restClient().retrofit(), this);
        this.certificates = new CertificatesImpl(this.restClient().retrofit(), this);
        this.files = new FilesImpl(this.restClient().retrofit(), this);
        this.jobSchedules = new JobSchedulesImpl(this.restClient().retrofit(), this);
        this.tasks = new TasksImpl(this.restClient().retrofit(), this);
        this.computeNodes = new ComputeNodesImpl(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    @Override
    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "BatchServiceClient", "2020-09-01.12.0");
    }
}

