/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.batch.protocol.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.batch.protocol.Files;
import com.microsoft.azure.batch.protocol.implementation.BatchServiceClientImpl;
import com.microsoft.azure.batch.protocol.models.BatchErrorException;
import com.microsoft.azure.batch.protocol.models.FileDeleteFromComputeNodeHeaders;
import com.microsoft.azure.batch.protocol.models.FileDeleteFromComputeNodeOptions;
import com.microsoft.azure.batch.protocol.models.FileDeleteFromTaskHeaders;
import com.microsoft.azure.batch.protocol.models.FileDeleteFromTaskOptions;
import com.microsoft.azure.batch.protocol.models.FileGetFromComputeNodeHeaders;
import com.microsoft.azure.batch.protocol.models.FileGetFromComputeNodeOptions;
import com.microsoft.azure.batch.protocol.models.FileGetFromTaskHeaders;
import com.microsoft.azure.batch.protocol.models.FileGetFromTaskOptions;
import com.microsoft.azure.batch.protocol.models.FileGetPropertiesFromComputeNodeHeaders;
import com.microsoft.azure.batch.protocol.models.FileGetPropertiesFromComputeNodeOptions;
import com.microsoft.azure.batch.protocol.models.FileGetPropertiesFromTaskHeaders;
import com.microsoft.azure.batch.protocol.models.FileGetPropertiesFromTaskOptions;
import com.microsoft.azure.batch.protocol.models.FileListFromComputeNodeHeaders;
import com.microsoft.azure.batch.protocol.models.FileListFromComputeNodeNextOptions;
import com.microsoft.azure.batch.protocol.models.FileListFromComputeNodeOptions;
import com.microsoft.azure.batch.protocol.models.FileListFromTaskHeaders;
import com.microsoft.azure.batch.protocol.models.FileListFromTaskNextOptions;
import com.microsoft.azure.batch.protocol.models.FileListFromTaskOptions;
import com.microsoft.azure.batch.protocol.models.NodeFile;
import com.microsoft.azure.batch.protocol.models.PageImpl;
import com.microsoft.rest.DateTimeRfc1123;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Streaming;
import retrofit2.http.Url;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;

public class FilesImpl
implements Files {
    private FilesService service;
    private BatchServiceClientImpl client;

    public FilesImpl(Retrofit retrofit, BatchServiceClientImpl client) {
        this.service = (FilesService)retrofit.create(FilesService.class);
        this.client = client;
    }

    @Override
    public void getFromTask(String jobId, String taskId, String filePath, final OutputStream outputStream) {
        this.getFromTaskAsync(jobId, taskId, filePath).doOnNext((Action1)new Action1<InputStream>(){

            public void call(InputStream input) {
                byte[] data = new byte[4096];
                try {
                    int nRead;
                    while ((nRead = input.read(data, 0, data.length)) != -1) {
                        outputStream.write(data, 0, nRead);
                    }
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }).toBlocking().single();
    }

    @Override
    public void getFromTask(String jobId, String taskId, String filePath, FileGetFromTaskOptions fileGetFromTaskOptions, final OutputStream outputStream) {
        this.getFromTaskAsync(jobId, taskId, filePath, fileGetFromTaskOptions).doOnNext((Action1)new Action1<InputStream>(){

            public void call(InputStream input) {
                byte[] data = new byte[4096];
                try {
                    int nRead;
                    while ((nRead = input.read(data, 0, data.length)) != -1) {
                        outputStream.write(data, 0, nRead);
                    }
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }).toBlocking().single();
    }

    @Override
    public void getFromComputeNode(String poolId, String nodeId, String filePath, final OutputStream outputStream) {
        this.getFromComputeNodeAsync(poolId, nodeId, filePath).doOnNext((Action1)new Action1<InputStream>(){

            public void call(InputStream input) {
                byte[] data = new byte[4096];
                try {
                    int nRead;
                    while ((nRead = input.read(data, 0, data.length)) != -1) {
                        outputStream.write(data, 0, nRead);
                    }
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }).toBlocking().single();
    }

    @Override
    public void getFromComputeNode(String poolId, String nodeId, String filePath, FileGetFromComputeNodeOptions fileGetFromComputeNodeOptions, final OutputStream outputStream) {
        this.getFromComputeNodeAsync(poolId, nodeId, filePath, fileGetFromComputeNodeOptions).doOnNext((Action1)new Action1<InputStream>(){

            public void call(InputStream input) {
                byte[] data = new byte[4096];
                try {
                    int nRead;
                    while ((nRead = input.read(data, 0, data.length)) != -1) {
                        outputStream.write(data, 0, nRead);
                    }
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }).toBlocking().single();
    }

    @Override
    public void deleteFromTask(String jobId, String taskId, String filePath) {
        ((ServiceResponseWithHeaders)this.deleteFromTaskWithServiceResponseAsync(jobId, taskId, filePath).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteFromTaskAsync(String jobId, String taskId, String filePath, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteFromTaskWithServiceResponseAsync(jobId, taskId, filePath), serviceCallback);
    }

    @Override
    public Observable<Void> deleteFromTaskAsync(String jobId, String taskId, String filePath) {
        return this.deleteFromTaskWithServiceResponseAsync(jobId, taskId, filePath).map((Func1)new Func1<ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders>> deleteFromTaskWithServiceResponseAsync(String jobId, String taskId, String filePath) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean recursive = null;
        Object fileDeleteFromTaskOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.deleteFromTask(jobId, taskId, filePath, recursive, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.deleteFromTaskDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void deleteFromTask(String jobId, String taskId, String filePath, Boolean recursive, FileDeleteFromTaskOptions fileDeleteFromTaskOptions) {
        ((ServiceResponseWithHeaders)this.deleteFromTaskWithServiceResponseAsync(jobId, taskId, filePath, recursive, fileDeleteFromTaskOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteFromTaskAsync(String jobId, String taskId, String filePath, Boolean recursive, FileDeleteFromTaskOptions fileDeleteFromTaskOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteFromTaskWithServiceResponseAsync(jobId, taskId, filePath, recursive, fileDeleteFromTaskOptions), serviceCallback);
    }

    @Override
    public Observable<Void> deleteFromTaskAsync(String jobId, String taskId, String filePath, Boolean recursive, FileDeleteFromTaskOptions fileDeleteFromTaskOptions) {
        return this.deleteFromTaskWithServiceResponseAsync(jobId, taskId, filePath, recursive, fileDeleteFromTaskOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders>> deleteFromTaskWithServiceResponseAsync(String jobId, String taskId, String filePath, Boolean recursive, FileDeleteFromTaskOptions fileDeleteFromTaskOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileDeleteFromTaskOptions);
        Integer timeout = null;
        if (fileDeleteFromTaskOptions != null) {
            timeout = fileDeleteFromTaskOptions.timeout();
        }
        UUID clientRequestId = null;
        if (fileDeleteFromTaskOptions != null) {
            clientRequestId = fileDeleteFromTaskOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileDeleteFromTaskOptions != null) {
            returnClientRequestId = fileDeleteFromTaskOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileDeleteFromTaskOptions != null) {
            ocpDate = fileDeleteFromTaskOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.deleteFromTask(jobId, taskId, filePath, recursive, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.deleteFromTaskDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, FileDeleteFromTaskHeaders> deleteFromTaskDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, FileDeleteFromTaskHeaders.class);
    }

    @Override
    public InputStream getFromTask(String jobId, String taskId, String filePath) {
        return (InputStream)((ServiceResponseWithHeaders)this.getFromTaskWithServiceResponseAsync(jobId, taskId, filePath).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<InputStream> getFromTaskAsync(String jobId, String taskId, String filePath, ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getFromTaskWithServiceResponseAsync(jobId, taskId, filePath), serviceCallback);
    }

    @Override
    public Observable<InputStream> getFromTaskAsync(String jobId, String taskId, String filePath) {
        return this.getFromTaskWithServiceResponseAsync(jobId, taskId, filePath).map((Func1)new Func1<ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders>, InputStream>(){

            public InputStream call(ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders> response) {
                return (InputStream)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders>> getFromTaskWithServiceResponseAsync(String jobId, String taskId, String filePath) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object fileGetFromTaskOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ocpRange = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getFromTask(jobId, taskId, filePath, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ocpRange, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.getFromTaskDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public InputStream getFromTask(String jobId, String taskId, String filePath, FileGetFromTaskOptions fileGetFromTaskOptions) {
        return (InputStream)((ServiceResponseWithHeaders)this.getFromTaskWithServiceResponseAsync(jobId, taskId, filePath, fileGetFromTaskOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<InputStream> getFromTaskAsync(String jobId, String taskId, String filePath, FileGetFromTaskOptions fileGetFromTaskOptions, ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getFromTaskWithServiceResponseAsync(jobId, taskId, filePath, fileGetFromTaskOptions), serviceCallback);
    }

    @Override
    public Observable<InputStream> getFromTaskAsync(String jobId, String taskId, String filePath, FileGetFromTaskOptions fileGetFromTaskOptions) {
        return this.getFromTaskWithServiceResponseAsync(jobId, taskId, filePath, fileGetFromTaskOptions).map((Func1)new Func1<ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders>, InputStream>(){

            public InputStream call(ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders> response) {
                return (InputStream)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders>> getFromTaskWithServiceResponseAsync(String jobId, String taskId, String filePath, FileGetFromTaskOptions fileGetFromTaskOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileGetFromTaskOptions);
        Integer timeout = null;
        if (fileGetFromTaskOptions != null) {
            timeout = fileGetFromTaskOptions.timeout();
        }
        UUID clientRequestId = null;
        if (fileGetFromTaskOptions != null) {
            clientRequestId = fileGetFromTaskOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileGetFromTaskOptions != null) {
            returnClientRequestId = fileGetFromTaskOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileGetFromTaskOptions != null) {
            ocpDate = fileGetFromTaskOptions.ocpDate();
        }
        String ocpRange = null;
        if (fileGetFromTaskOptions != null) {
            ocpRange = fileGetFromTaskOptions.ocpRange();
        }
        DateTime ifModifiedSince = null;
        if (fileGetFromTaskOptions != null) {
            ifModifiedSince = fileGetFromTaskOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (fileGetFromTaskOptions != null) {
            ifUnmodifiedSince = fileGetFromTaskOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getFromTask(jobId, taskId, filePath, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ocpRange, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.getFromTaskDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<InputStream, FileGetFromTaskHeaders> getFromTaskDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InputStream>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, FileGetFromTaskHeaders.class);
    }

    @Override
    public void getPropertiesFromTask(String jobId, String taskId, String filePath) {
        ((ServiceResponseWithHeaders)this.getPropertiesFromTaskWithServiceResponseAsync(jobId, taskId, filePath).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> getPropertiesFromTaskAsync(String jobId, String taskId, String filePath, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getPropertiesFromTaskWithServiceResponseAsync(jobId, taskId, filePath), serviceCallback);
    }

    @Override
    public Observable<Void> getPropertiesFromTaskAsync(String jobId, String taskId, String filePath) {
        return this.getPropertiesFromTaskWithServiceResponseAsync(jobId, taskId, filePath).map((Func1)new Func1<ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders>> getPropertiesFromTaskWithServiceResponseAsync(String jobId, String taskId, String filePath) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object fileGetPropertiesFromTaskOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getPropertiesFromTask(jobId, taskId, filePath, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders>> call(Response<Void> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.getPropertiesFromTaskDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void getPropertiesFromTask(String jobId, String taskId, String filePath, FileGetPropertiesFromTaskOptions fileGetPropertiesFromTaskOptions) {
        ((ServiceResponseWithHeaders)this.getPropertiesFromTaskWithServiceResponseAsync(jobId, taskId, filePath, fileGetPropertiesFromTaskOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> getPropertiesFromTaskAsync(String jobId, String taskId, String filePath, FileGetPropertiesFromTaskOptions fileGetPropertiesFromTaskOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getPropertiesFromTaskWithServiceResponseAsync(jobId, taskId, filePath, fileGetPropertiesFromTaskOptions), serviceCallback);
    }

    @Override
    public Observable<Void> getPropertiesFromTaskAsync(String jobId, String taskId, String filePath, FileGetPropertiesFromTaskOptions fileGetPropertiesFromTaskOptions) {
        return this.getPropertiesFromTaskWithServiceResponseAsync(jobId, taskId, filePath, fileGetPropertiesFromTaskOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders>> getPropertiesFromTaskWithServiceResponseAsync(String jobId, String taskId, String filePath, FileGetPropertiesFromTaskOptions fileGetPropertiesFromTaskOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileGetPropertiesFromTaskOptions);
        Integer timeout = null;
        if (fileGetPropertiesFromTaskOptions != null) {
            timeout = fileGetPropertiesFromTaskOptions.timeout();
        }
        UUID clientRequestId = null;
        if (fileGetPropertiesFromTaskOptions != null) {
            clientRequestId = fileGetPropertiesFromTaskOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileGetPropertiesFromTaskOptions != null) {
            returnClientRequestId = fileGetPropertiesFromTaskOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileGetPropertiesFromTaskOptions != null) {
            ocpDate = fileGetPropertiesFromTaskOptions.ocpDate();
        }
        DateTime ifModifiedSince = null;
        if (fileGetPropertiesFromTaskOptions != null) {
            ifModifiedSince = fileGetPropertiesFromTaskOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (fileGetPropertiesFromTaskOptions != null) {
            ifUnmodifiedSince = fileGetPropertiesFromTaskOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getPropertiesFromTask(jobId, taskId, filePath, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders>> call(Response<Void> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.getPropertiesFromTaskDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, FileGetPropertiesFromTaskHeaders> getPropertiesFromTaskDelegate(Response<Void> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildEmptyWithHeaders(response, FileGetPropertiesFromTaskHeaders.class);
    }

    @Override
    public void deleteFromComputeNode(String poolId, String nodeId, String filePath) {
        ((ServiceResponseWithHeaders)this.deleteFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteFromComputeNodeAsync(String poolId, String nodeId, String filePath, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath), serviceCallback);
    }

    @Override
    public Observable<Void> deleteFromComputeNodeAsync(String poolId, String nodeId, String filePath) {
        return this.deleteFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath).map((Func1)new Func1<ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders>> deleteFromComputeNodeWithServiceResponseAsync(String poolId, String nodeId, String filePath) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean recursive = null;
        Object fileDeleteFromComputeNodeOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.deleteFromComputeNode(poolId, nodeId, filePath, recursive, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.deleteFromComputeNodeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void deleteFromComputeNode(String poolId, String nodeId, String filePath, Boolean recursive, FileDeleteFromComputeNodeOptions fileDeleteFromComputeNodeOptions) {
        ((ServiceResponseWithHeaders)this.deleteFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, recursive, fileDeleteFromComputeNodeOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> deleteFromComputeNodeAsync(String poolId, String nodeId, String filePath, Boolean recursive, FileDeleteFromComputeNodeOptions fileDeleteFromComputeNodeOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.deleteFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, recursive, fileDeleteFromComputeNodeOptions), serviceCallback);
    }

    @Override
    public Observable<Void> deleteFromComputeNodeAsync(String poolId, String nodeId, String filePath, Boolean recursive, FileDeleteFromComputeNodeOptions fileDeleteFromComputeNodeOptions) {
        return this.deleteFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, recursive, fileDeleteFromComputeNodeOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders>> deleteFromComputeNodeWithServiceResponseAsync(String poolId, String nodeId, String filePath, Boolean recursive, FileDeleteFromComputeNodeOptions fileDeleteFromComputeNodeOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileDeleteFromComputeNodeOptions);
        Integer timeout = null;
        if (fileDeleteFromComputeNodeOptions != null) {
            timeout = fileDeleteFromComputeNodeOptions.timeout();
        }
        UUID clientRequestId = null;
        if (fileDeleteFromComputeNodeOptions != null) {
            clientRequestId = fileDeleteFromComputeNodeOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileDeleteFromComputeNodeOptions != null) {
            returnClientRequestId = fileDeleteFromComputeNodeOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileDeleteFromComputeNodeOptions != null) {
            ocpDate = fileDeleteFromComputeNodeOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.deleteFromComputeNode(poolId, nodeId, filePath, recursive, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.deleteFromComputeNodeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, FileDeleteFromComputeNodeHeaders> deleteFromComputeNodeDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, FileDeleteFromComputeNodeHeaders.class);
    }

    @Override
    public InputStream getFromComputeNode(String poolId, String nodeId, String filePath) {
        return (InputStream)((ServiceResponseWithHeaders)this.getFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<InputStream> getFromComputeNodeAsync(String poolId, String nodeId, String filePath, ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath), serviceCallback);
    }

    @Override
    public Observable<InputStream> getFromComputeNodeAsync(String poolId, String nodeId, String filePath) {
        return this.getFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath).map((Func1)new Func1<ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders>, InputStream>(){

            public InputStream call(ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders> response) {
                return (InputStream)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders>> getFromComputeNodeWithServiceResponseAsync(String poolId, String nodeId, String filePath) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object fileGetFromComputeNodeOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String ocpRange = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getFromComputeNode(poolId, nodeId, filePath, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ocpRange, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.getFromComputeNodeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public InputStream getFromComputeNode(String poolId, String nodeId, String filePath, FileGetFromComputeNodeOptions fileGetFromComputeNodeOptions) {
        return (InputStream)((ServiceResponseWithHeaders)this.getFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, fileGetFromComputeNodeOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<InputStream> getFromComputeNodeAsync(String poolId, String nodeId, String filePath, FileGetFromComputeNodeOptions fileGetFromComputeNodeOptions, ServiceCallback<InputStream> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, fileGetFromComputeNodeOptions), serviceCallback);
    }

    @Override
    public Observable<InputStream> getFromComputeNodeAsync(String poolId, String nodeId, String filePath, FileGetFromComputeNodeOptions fileGetFromComputeNodeOptions) {
        return this.getFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, fileGetFromComputeNodeOptions).map((Func1)new Func1<ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders>, InputStream>(){

            public InputStream call(ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders> response) {
                return (InputStream)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders>> getFromComputeNodeWithServiceResponseAsync(String poolId, String nodeId, String filePath, FileGetFromComputeNodeOptions fileGetFromComputeNodeOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileGetFromComputeNodeOptions);
        Integer timeout = null;
        if (fileGetFromComputeNodeOptions != null) {
            timeout = fileGetFromComputeNodeOptions.timeout();
        }
        UUID clientRequestId = null;
        if (fileGetFromComputeNodeOptions != null) {
            clientRequestId = fileGetFromComputeNodeOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileGetFromComputeNodeOptions != null) {
            returnClientRequestId = fileGetFromComputeNodeOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileGetFromComputeNodeOptions != null) {
            ocpDate = fileGetFromComputeNodeOptions.ocpDate();
        }
        String ocpRange = null;
        if (fileGetFromComputeNodeOptions != null) {
            ocpRange = fileGetFromComputeNodeOptions.ocpRange();
        }
        DateTime ifModifiedSince = null;
        if (fileGetFromComputeNodeOptions != null) {
            ifModifiedSince = fileGetFromComputeNodeOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (fileGetFromComputeNodeOptions != null) {
            ifUnmodifiedSince = fileGetFromComputeNodeOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getFromComputeNode(poolId, nodeId, filePath, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ocpRange, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.getFromComputeNodeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<InputStream, FileGetFromComputeNodeHeaders> getFromComputeNodeDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InputStream>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, FileGetFromComputeNodeHeaders.class);
    }

    @Override
    public void getPropertiesFromComputeNode(String poolId, String nodeId, String filePath) {
        ((ServiceResponseWithHeaders)this.getPropertiesFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> getPropertiesFromComputeNodeAsync(String poolId, String nodeId, String filePath, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getPropertiesFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath), serviceCallback);
    }

    @Override
    public Observable<Void> getPropertiesFromComputeNodeAsync(String poolId, String nodeId, String filePath) {
        return this.getPropertiesFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath).map((Func1)new Func1<ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders>> getPropertiesFromComputeNodeWithServiceResponseAsync(String poolId, String nodeId, String filePath) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object fileGetPropertiesFromComputeNodeOptions = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTime ifModifiedSince = null;
        DateTime ifUnmodifiedSince = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getPropertiesFromComputeNode(poolId, nodeId, filePath, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders>> call(Response<Void> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.getPropertiesFromComputeNodeDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public void getPropertiesFromComputeNode(String poolId, String nodeId, String filePath, FileGetPropertiesFromComputeNodeOptions fileGetPropertiesFromComputeNodeOptions) {
        ((ServiceResponseWithHeaders)this.getPropertiesFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, fileGetPropertiesFromComputeNodeOptions).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Void> getPropertiesFromComputeNodeAsync(String poolId, String nodeId, String filePath, FileGetPropertiesFromComputeNodeOptions fileGetPropertiesFromComputeNodeOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getPropertiesFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, fileGetPropertiesFromComputeNodeOptions), serviceCallback);
    }

    @Override
    public Observable<Void> getPropertiesFromComputeNodeAsync(String poolId, String nodeId, String filePath, FileGetPropertiesFromComputeNodeOptions fileGetPropertiesFromComputeNodeOptions) {
        return this.getPropertiesFromComputeNodeWithServiceResponseAsync(poolId, nodeId, filePath, fileGetPropertiesFromComputeNodeOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders>, Void>(){

            public Void call(ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders> response) {
                return (Void)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders>> getPropertiesFromComputeNodeWithServiceResponseAsync(String poolId, String nodeId, String filePath, FileGetPropertiesFromComputeNodeOptions fileGetPropertiesFromComputeNodeOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("Parameter filePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileGetPropertiesFromComputeNodeOptions);
        Integer timeout = null;
        if (fileGetPropertiesFromComputeNodeOptions != null) {
            timeout = fileGetPropertiesFromComputeNodeOptions.timeout();
        }
        UUID clientRequestId = null;
        if (fileGetPropertiesFromComputeNodeOptions != null) {
            clientRequestId = fileGetPropertiesFromComputeNodeOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileGetPropertiesFromComputeNodeOptions != null) {
            returnClientRequestId = fileGetPropertiesFromComputeNodeOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileGetPropertiesFromComputeNodeOptions != null) {
            ocpDate = fileGetPropertiesFromComputeNodeOptions.ocpDate();
        }
        DateTime ifModifiedSince = null;
        if (fileGetPropertiesFromComputeNodeOptions != null) {
            ifModifiedSince = fileGetPropertiesFromComputeNodeOptions.ifModifiedSince();
        }
        DateTime ifUnmodifiedSince = null;
        if (fileGetPropertiesFromComputeNodeOptions != null) {
            ifUnmodifiedSince = fileGetPropertiesFromComputeNodeOptions.ifUnmodifiedSince();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getPropertiesFromComputeNode(poolId, nodeId, filePath, this.client.apiVersion(), this.client.acceptLanguage(), timeout, clientRequestId, returnClientRequestId, ocpDateConverted, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders>> call(Response<Void> response) {
                try {
                    ServiceResponseWithHeaders clientResponse = FilesImpl.this.getPropertiesFromComputeNodeDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Void, FileGetPropertiesFromComputeNodeHeaders> getPropertiesFromComputeNodeDelegate(Response<Void> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(BatchErrorException.class).buildEmptyWithHeaders(response, FileGetPropertiesFromComputeNodeHeaders.class);
    }

    @Override
    public PagedList<NodeFile> listFromTask(String jobId, String taskId) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromTaskSinglePageAsync(jobId, taskId).toBlocking().single();
        return new PagedList<NodeFile>((Page)response.body()){

            public Page<NodeFile> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)FilesImpl.this.listFromTaskNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeFile>> listFromTaskAsync(String jobId, String taskId, ListOperationCallback<NodeFile> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromTaskSinglePageAsync(jobId, taskId), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(String nextPageLink) {
                return FilesImpl.this.listFromTaskNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeFile>> listFromTaskAsync(String jobId, String taskId) {
        return this.listFromTaskWithServiceResponseAsync(jobId, taskId).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>, Page<NodeFile>>(){

            public Page<NodeFile> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> listFromTaskWithServiceResponseAsync(String jobId, String taskId) {
        return this.listFromTaskSinglePageAsync(jobId, taskId).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FilesImpl.this.listFromTaskNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> listFromTaskSinglePageAsync(String jobId, String taskId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean recursive = null;
        Object fileListFromTaskOptions = null;
        String filter = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listFromTask(jobId, taskId, recursive, this.client.apiVersion(), this.client.acceptLanguage(), filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = FilesImpl.this.listFromTaskDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<NodeFile> listFromTask(String jobId, String taskId, Boolean recursive, final FileListFromTaskOptions fileListFromTaskOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromTaskSinglePageAsync(jobId, taskId, recursive, fileListFromTaskOptions).toBlocking().single();
        return new PagedList<NodeFile>((Page)response.body()){

            public Page<NodeFile> nextPage(String nextPageLink) {
                FileListFromTaskNextOptions fileListFromTaskNextOptions = null;
                if (fileListFromTaskOptions != null) {
                    fileListFromTaskNextOptions = new FileListFromTaskNextOptions();
                    fileListFromTaskNextOptions.withClientRequestId(fileListFromTaskOptions.clientRequestId());
                    fileListFromTaskNextOptions.withReturnClientRequestId(fileListFromTaskOptions.returnClientRequestId());
                    fileListFromTaskNextOptions.withOcpDate(fileListFromTaskOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)FilesImpl.this.listFromTaskNextSinglePageAsync(nextPageLink, fileListFromTaskNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeFile>> listFromTaskAsync(String jobId, String taskId, Boolean recursive, final FileListFromTaskOptions fileListFromTaskOptions, ListOperationCallback<NodeFile> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromTaskSinglePageAsync(jobId, taskId, recursive, fileListFromTaskOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(String nextPageLink) {
                FileListFromTaskNextOptions fileListFromTaskNextOptions = null;
                if (fileListFromTaskOptions != null) {
                    fileListFromTaskNextOptions = new FileListFromTaskNextOptions();
                    fileListFromTaskNextOptions.withClientRequestId(fileListFromTaskOptions.clientRequestId());
                    fileListFromTaskNextOptions.withReturnClientRequestId(fileListFromTaskOptions.returnClientRequestId());
                    fileListFromTaskNextOptions.withOcpDate(fileListFromTaskOptions.ocpDate());
                }
                return FilesImpl.this.listFromTaskNextSinglePageAsync(nextPageLink, fileListFromTaskNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeFile>> listFromTaskAsync(String jobId, String taskId, Boolean recursive, FileListFromTaskOptions fileListFromTaskOptions) {
        return this.listFromTaskWithServiceResponseAsync(jobId, taskId, recursive, fileListFromTaskOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>, Page<NodeFile>>(){

            public Page<NodeFile> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> listFromTaskWithServiceResponseAsync(String jobId, String taskId, Boolean recursive, final FileListFromTaskOptions fileListFromTaskOptions) {
        return this.listFromTaskSinglePageAsync(jobId, taskId, recursive, fileListFromTaskOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                FileListFromTaskNextOptions fileListFromTaskNextOptions = null;
                if (fileListFromTaskOptions != null) {
                    fileListFromTaskNextOptions = new FileListFromTaskNextOptions();
                    fileListFromTaskNextOptions.withClientRequestId(fileListFromTaskOptions.clientRequestId());
                    fileListFromTaskNextOptions.withReturnClientRequestId(fileListFromTaskOptions.returnClientRequestId());
                    fileListFromTaskNextOptions.withOcpDate(fileListFromTaskOptions.ocpDate());
                }
                return Observable.just(page).concatWith(FilesImpl.this.listFromTaskNextWithServiceResponseAsync(nextPageLink, fileListFromTaskNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> listFromTaskSinglePageAsync(String jobId, String taskId, Boolean recursive, FileListFromTaskOptions fileListFromTaskOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (jobId == null) {
            throw new IllegalArgumentException("Parameter jobId is required and cannot be null.");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Parameter taskId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileListFromTaskOptions);
        String filter = null;
        if (fileListFromTaskOptions != null) {
            filter = fileListFromTaskOptions.filter();
        }
        Integer maxResults = null;
        if (fileListFromTaskOptions != null) {
            maxResults = fileListFromTaskOptions.maxResults();
        }
        Integer timeout = null;
        if (fileListFromTaskOptions != null) {
            timeout = fileListFromTaskOptions.timeout();
        }
        UUID clientRequestId = null;
        if (fileListFromTaskOptions != null) {
            clientRequestId = fileListFromTaskOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileListFromTaskOptions != null) {
            returnClientRequestId = fileListFromTaskOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileListFromTaskOptions != null) {
            ocpDate = fileListFromTaskOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listFromTask(jobId, taskId, recursive, this.client.apiVersion(), this.client.acceptLanguage(), filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = FilesImpl.this.listFromTaskDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<NodeFile>, FileListFromTaskHeaders> listFromTaskDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NodeFile>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, FileListFromTaskHeaders.class);
    }

    @Override
    public PagedList<NodeFile> listFromComputeNode(String poolId, String nodeId) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromComputeNodeSinglePageAsync(poolId, nodeId).toBlocking().single();
        return new PagedList<NodeFile>((Page)response.body()){

            public Page<NodeFile> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)FilesImpl.this.listFromComputeNodeNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeFile>> listFromComputeNodeAsync(String poolId, String nodeId, ListOperationCallback<NodeFile> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromComputeNodeSinglePageAsync(poolId, nodeId), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(String nextPageLink) {
                return FilesImpl.this.listFromComputeNodeNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeFile>> listFromComputeNodeAsync(String poolId, String nodeId) {
        return this.listFromComputeNodeWithServiceResponseAsync(poolId, nodeId).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>, Page<NodeFile>>(){

            public Page<NodeFile> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> listFromComputeNodeWithServiceResponseAsync(String poolId, String nodeId) {
        return this.listFromComputeNodeSinglePageAsync(poolId, nodeId).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FilesImpl.this.listFromComputeNodeNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> listFromComputeNodeSinglePageAsync(String poolId, String nodeId) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Boolean recursive = null;
        Object fileListFromComputeNodeOptions = null;
        String filter = null;
        Integer maxResults = null;
        Integer timeout = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listFromComputeNode(poolId, nodeId, recursive, this.client.apiVersion(), this.client.acceptLanguage(), filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = FilesImpl.this.listFromComputeNodeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<NodeFile> listFromComputeNode(String poolId, String nodeId, Boolean recursive, final FileListFromComputeNodeOptions fileListFromComputeNodeOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromComputeNodeSinglePageAsync(poolId, nodeId, recursive, fileListFromComputeNodeOptions).toBlocking().single();
        return new PagedList<NodeFile>((Page)response.body()){

            public Page<NodeFile> nextPage(String nextPageLink) {
                FileListFromComputeNodeNextOptions fileListFromComputeNodeNextOptions = null;
                if (fileListFromComputeNodeOptions != null) {
                    fileListFromComputeNodeNextOptions = new FileListFromComputeNodeNextOptions();
                    fileListFromComputeNodeNextOptions.withClientRequestId(fileListFromComputeNodeOptions.clientRequestId());
                    fileListFromComputeNodeNextOptions.withReturnClientRequestId(fileListFromComputeNodeOptions.returnClientRequestId());
                    fileListFromComputeNodeNextOptions.withOcpDate(fileListFromComputeNodeOptions.ocpDate());
                }
                return (Page)((ServiceResponseWithHeaders)FilesImpl.this.listFromComputeNodeNextSinglePageAsync(nextPageLink, fileListFromComputeNodeNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeFile>> listFromComputeNodeAsync(String poolId, String nodeId, Boolean recursive, final FileListFromComputeNodeOptions fileListFromComputeNodeOptions, ListOperationCallback<NodeFile> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromComputeNodeSinglePageAsync(poolId, nodeId, recursive, fileListFromComputeNodeOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(String nextPageLink) {
                FileListFromComputeNodeNextOptions fileListFromComputeNodeNextOptions = null;
                if (fileListFromComputeNodeOptions != null) {
                    fileListFromComputeNodeNextOptions = new FileListFromComputeNodeNextOptions();
                    fileListFromComputeNodeNextOptions.withClientRequestId(fileListFromComputeNodeOptions.clientRequestId());
                    fileListFromComputeNodeNextOptions.withReturnClientRequestId(fileListFromComputeNodeOptions.returnClientRequestId());
                    fileListFromComputeNodeNextOptions.withOcpDate(fileListFromComputeNodeOptions.ocpDate());
                }
                return FilesImpl.this.listFromComputeNodeNextSinglePageAsync(nextPageLink, fileListFromComputeNodeNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeFile>> listFromComputeNodeAsync(String poolId, String nodeId, Boolean recursive, FileListFromComputeNodeOptions fileListFromComputeNodeOptions) {
        return this.listFromComputeNodeWithServiceResponseAsync(poolId, nodeId, recursive, fileListFromComputeNodeOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>, Page<NodeFile>>(){

            public Page<NodeFile> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> listFromComputeNodeWithServiceResponseAsync(String poolId, String nodeId, Boolean recursive, final FileListFromComputeNodeOptions fileListFromComputeNodeOptions) {
        return this.listFromComputeNodeSinglePageAsync(poolId, nodeId, recursive, fileListFromComputeNodeOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                FileListFromComputeNodeNextOptions fileListFromComputeNodeNextOptions = null;
                if (fileListFromComputeNodeOptions != null) {
                    fileListFromComputeNodeNextOptions = new FileListFromComputeNodeNextOptions();
                    fileListFromComputeNodeNextOptions.withClientRequestId(fileListFromComputeNodeOptions.clientRequestId());
                    fileListFromComputeNodeNextOptions.withReturnClientRequestId(fileListFromComputeNodeOptions.returnClientRequestId());
                    fileListFromComputeNodeNextOptions.withOcpDate(fileListFromComputeNodeOptions.ocpDate());
                }
                return Observable.just(page).concatWith(FilesImpl.this.listFromComputeNodeNextWithServiceResponseAsync(nextPageLink, fileListFromComputeNodeNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> listFromComputeNodeSinglePageAsync(String poolId, String nodeId, Boolean recursive, FileListFromComputeNodeOptions fileListFromComputeNodeOptions) {
        if (this.client.batchUrl() == null) {
            throw new IllegalArgumentException("Parameter this.client.batchUrl() is required and cannot be null.");
        }
        if (poolId == null) {
            throw new IllegalArgumentException("Parameter poolId is required and cannot be null.");
        }
        if (nodeId == null) {
            throw new IllegalArgumentException("Parameter nodeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileListFromComputeNodeOptions);
        String filter = null;
        if (fileListFromComputeNodeOptions != null) {
            filter = fileListFromComputeNodeOptions.filter();
        }
        Integer maxResults = null;
        if (fileListFromComputeNodeOptions != null) {
            maxResults = fileListFromComputeNodeOptions.maxResults();
        }
        Integer timeout = null;
        if (fileListFromComputeNodeOptions != null) {
            timeout = fileListFromComputeNodeOptions.timeout();
        }
        UUID clientRequestId = null;
        if (fileListFromComputeNodeOptions != null) {
            clientRequestId = fileListFromComputeNodeOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileListFromComputeNodeOptions != null) {
            returnClientRequestId = fileListFromComputeNodeOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileListFromComputeNodeOptions != null) {
            ocpDate = fileListFromComputeNodeOptions.ocpDate();
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{batchUrl}", (Object)this.client.batchUrl(), new Object[0]);
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        return this.service.listFromComputeNode(poolId, nodeId, recursive, this.client.apiVersion(), this.client.acceptLanguage(), filter, maxResults, timeout, clientRequestId, returnClientRequestId, ocpDateConverted, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = FilesImpl.this.listFromComputeNodeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<NodeFile>, FileListFromComputeNodeHeaders> listFromComputeNodeDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NodeFile>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, FileListFromComputeNodeHeaders.class);
    }

    @Override
    public PagedList<NodeFile> listFromTaskNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromTaskNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NodeFile>((Page)response.body()){

            public Page<NodeFile> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)FilesImpl.this.listFromTaskNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeFile>> listFromTaskNextAsync(String nextPageLink, ServiceFuture<List<NodeFile>> serviceFuture, ListOperationCallback<NodeFile> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromTaskNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(String nextPageLink) {
                return FilesImpl.this.listFromTaskNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeFile>> listFromTaskNextAsync(String nextPageLink) {
        return this.listFromTaskNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>, Page<NodeFile>>(){

            public Page<NodeFile> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> listFromTaskNextWithServiceResponseAsync(String nextPageLink) {
        return this.listFromTaskNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FilesImpl.this.listFromTaskNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> listFromTaskNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object fileListFromTaskNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listFromTaskNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = FilesImpl.this.listFromTaskNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<NodeFile> listFromTaskNext(String nextPageLink, final FileListFromTaskNextOptions fileListFromTaskNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromTaskNextSinglePageAsync(nextPageLink, fileListFromTaskNextOptions).toBlocking().single();
        return new PagedList<NodeFile>((Page)response.body()){

            public Page<NodeFile> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)FilesImpl.this.listFromTaskNextSinglePageAsync(nextPageLink, fileListFromTaskNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeFile>> listFromTaskNextAsync(String nextPageLink, final FileListFromTaskNextOptions fileListFromTaskNextOptions, ServiceFuture<List<NodeFile>> serviceFuture, ListOperationCallback<NodeFile> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromTaskNextSinglePageAsync(nextPageLink, fileListFromTaskNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(String nextPageLink) {
                return FilesImpl.this.listFromTaskNextSinglePageAsync(nextPageLink, fileListFromTaskNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeFile>> listFromTaskNextAsync(String nextPageLink, FileListFromTaskNextOptions fileListFromTaskNextOptions) {
        return this.listFromTaskNextWithServiceResponseAsync(nextPageLink, fileListFromTaskNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>, Page<NodeFile>>(){

            public Page<NodeFile> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> listFromTaskNextWithServiceResponseAsync(String nextPageLink, final FileListFromTaskNextOptions fileListFromTaskNextOptions) {
        return this.listFromTaskNextSinglePageAsync(nextPageLink, fileListFromTaskNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FilesImpl.this.listFromTaskNextWithServiceResponseAsync(nextPageLink, fileListFromTaskNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> listFromTaskNextSinglePageAsync(String nextPageLink, FileListFromTaskNextOptions fileListFromTaskNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)fileListFromTaskNextOptions);
        UUID clientRequestId = null;
        if (fileListFromTaskNextOptions != null) {
            clientRequestId = fileListFromTaskNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileListFromTaskNextOptions != null) {
            returnClientRequestId = fileListFromTaskNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileListFromTaskNextOptions != null) {
            ocpDate = fileListFromTaskNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listFromTaskNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromTaskHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = FilesImpl.this.listFromTaskNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<NodeFile>, FileListFromTaskHeaders> listFromTaskNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NodeFile>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, FileListFromTaskHeaders.class);
    }

    @Override
    public PagedList<NodeFile> listFromComputeNodeNext(String nextPageLink) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromComputeNodeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<NodeFile>((Page)response.body()){

            public Page<NodeFile> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)FilesImpl.this.listFromComputeNodeNextSinglePageAsync(nextPageLink, null).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeFile>> listFromComputeNodeNextAsync(String nextPageLink, ServiceFuture<List<NodeFile>> serviceFuture, ListOperationCallback<NodeFile> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromComputeNodeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(String nextPageLink) {
                return FilesImpl.this.listFromComputeNodeNextSinglePageAsync(nextPageLink, null);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeFile>> listFromComputeNodeNextAsync(String nextPageLink) {
        return this.listFromComputeNodeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>, Page<NodeFile>>(){

            public Page<NodeFile> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> listFromComputeNodeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listFromComputeNodeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FilesImpl.this.listFromComputeNodeNextWithServiceResponseAsync(nextPageLink, null));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> listFromComputeNodeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Object fileListFromComputeNodeNextOptions = null;
        UUID clientRequestId = null;
        Boolean returnClientRequestId = null;
        DateTime ocpDate = null;
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listFromComputeNodeNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = FilesImpl.this.listFromComputeNodeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public PagedList<NodeFile> listFromComputeNodeNext(String nextPageLink, final FileListFromComputeNodeNextOptions fileListFromComputeNodeNextOptions) {
        ServiceResponseWithHeaders response = (ServiceResponseWithHeaders)this.listFromComputeNodeNextSinglePageAsync(nextPageLink, fileListFromComputeNodeNextOptions).toBlocking().single();
        return new PagedList<NodeFile>((Page)response.body()){

            public Page<NodeFile> nextPage(String nextPageLink) {
                return (Page)((ServiceResponseWithHeaders)FilesImpl.this.listFromComputeNodeNextSinglePageAsync(nextPageLink, fileListFromComputeNodeNextOptions).toBlocking().single()).body();
            }
        };
    }

    @Override
    public ServiceFuture<List<NodeFile>> listFromComputeNodeNextAsync(String nextPageLink, final FileListFromComputeNodeNextOptions fileListFromComputeNodeNextOptions, ServiceFuture<List<NodeFile>> serviceFuture, ListOperationCallback<NodeFile> serviceCallback) {
        return AzureServiceFuture.fromHeaderPageResponse(this.listFromComputeNodeNextSinglePageAsync(nextPageLink, fileListFromComputeNodeNextOptions), (Func1)new Func1<String, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(String nextPageLink) {
                return FilesImpl.this.listFromComputeNodeNextSinglePageAsync(nextPageLink, fileListFromComputeNodeNextOptions);
            }
        }, serviceCallback);
    }

    @Override
    public Observable<Page<NodeFile>> listFromComputeNodeNextAsync(String nextPageLink, FileListFromComputeNodeNextOptions fileListFromComputeNodeNextOptions) {
        return this.listFromComputeNodeNextWithServiceResponseAsync(nextPageLink, fileListFromComputeNodeNextOptions).map((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>, Page<NodeFile>>(){

            public Page<NodeFile> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders> response) {
                return (Page)response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> listFromComputeNodeNextWithServiceResponseAsync(String nextPageLink, final FileListFromComputeNodeNextOptions fileListFromComputeNodeNextOptions) {
        return this.listFromComputeNodeNextSinglePageAsync(nextPageLink, fileListFromComputeNodeNextOptions).concatMap((Func1)new Func1<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FilesImpl.this.listFromComputeNodeNextWithServiceResponseAsync(nextPageLink, fileListFromComputeNodeNextOptions));
            }
        });
    }

    public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> listFromComputeNodeNextSinglePageAsync(String nextPageLink, FileListFromComputeNodeNextOptions fileListFromComputeNodeNextOptions) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        Validator.validate((Object)fileListFromComputeNodeNextOptions);
        UUID clientRequestId = null;
        if (fileListFromComputeNodeNextOptions != null) {
            clientRequestId = fileListFromComputeNodeNextOptions.clientRequestId();
        }
        Boolean returnClientRequestId = null;
        if (fileListFromComputeNodeNextOptions != null) {
            returnClientRequestId = fileListFromComputeNodeNextOptions.returnClientRequestId();
        }
        DateTime ocpDate = null;
        if (fileListFromComputeNodeNextOptions != null) {
            ocpDate = fileListFromComputeNodeNextOptions.ocpDate();
        }
        DateTimeRfc1123 ocpDateConverted = null;
        if (ocpDate != null) {
            ocpDateConverted = new DateTimeRfc1123(ocpDate);
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listFromComputeNodeNext(nextUrl, this.client.acceptLanguage(), clientRequestId, returnClientRequestId, ocpDateConverted, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Page<NodeFile>, FileListFromComputeNodeHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders result = FilesImpl.this.listFromComputeNodeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponseWithHeaders(result.body(), result.headers(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<PageImpl<NodeFile>, FileListFromComputeNodeHeaders> listFromComputeNodeNextDelegate(Response<ResponseBody> response) throws BatchErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<NodeFile>>(){}.getType()).registerError(BatchErrorException.class).buildWithHeaders(response, FileListFromComputeNodeHeaders.class);
    }

    static interface FilesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files deleteFromTask"})
        @HTTP(path="jobs/{jobId}/tasks/{taskId}/files/{filePath}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteFromTask(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Path(value="filePath") String var3, @Query(value="recursive") Boolean var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files getFromTask"})
        @GET(value="jobs/{jobId}/tasks/{taskId}/files/{filePath}")
        @Streaming
        public Observable<Response<ResponseBody>> getFromTask(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Path(value="filePath") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="ocp-range") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files getPropertiesFromTask"})
        @HEAD(value="jobs/{jobId}/tasks/{taskId}/files/{filePath}")
        public Observable<Response<Void>> getPropertiesFromTask(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Path(value="filePath") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files deleteFromComputeNode"})
        @HTTP(path="pools/{poolId}/nodes/{nodeId}/files/{filePath}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteFromComputeNode(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Path(value="filePath") String var3, @Query(value="recursive") Boolean var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Query(value="timeout") Integer var7, @Header(value="client-request-id") UUID var8, @Header(value="return-client-request-id") Boolean var9, @Header(value="ocp-date") DateTimeRfc1123 var10, @Header(value="x-ms-parameterized-host") String var11, @Header(value="User-Agent") String var12);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files getFromComputeNode"})
        @GET(value="pools/{poolId}/nodes/{nodeId}/files/{filePath}")
        @Streaming
        public Observable<Response<ResponseBody>> getFromComputeNode(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Path(value="filePath") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="ocp-range") String var10, @Header(value="If-Modified-Since") DateTimeRfc1123 var11, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var12, @Header(value="x-ms-parameterized-host") String var13, @Header(value="User-Agent") String var14);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files getPropertiesFromComputeNode"})
        @HEAD(value="pools/{poolId}/nodes/{nodeId}/files/{filePath}")
        public Observable<Response<Void>> getPropertiesFromComputeNode(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Path(value="filePath") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="timeout") Integer var6, @Header(value="client-request-id") UUID var7, @Header(value="return-client-request-id") Boolean var8, @Header(value="ocp-date") DateTimeRfc1123 var9, @Header(value="If-Modified-Since") DateTimeRfc1123 var10, @Header(value="If-Unmodified-Since") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files listFromTask"})
        @GET(value="jobs/{jobId}/tasks/{taskId}/files")
        public Observable<Response<ResponseBody>> listFromTask(@Path(value="jobId") String var1, @Path(value="taskId") String var2, @Query(value="recursive") Boolean var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="$filter") String var6, @Query(value="maxresults") Integer var7, @Query(value="timeout") Integer var8, @Header(value="client-request-id") UUID var9, @Header(value="return-client-request-id") Boolean var10, @Header(value="ocp-date") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files listFromComputeNode"})
        @GET(value="pools/{poolId}/nodes/{nodeId}/files")
        public Observable<Response<ResponseBody>> listFromComputeNode(@Path(value="poolId") String var1, @Path(value="nodeId") String var2, @Query(value="recursive") Boolean var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="$filter") String var6, @Query(value="maxresults") Integer var7, @Query(value="timeout") Integer var8, @Header(value="client-request-id") UUID var9, @Header(value="return-client-request-id") Boolean var10, @Header(value="ocp-date") DateTimeRfc1123 var11, @Header(value="x-ms-parameterized-host") String var12, @Header(value="User-Agent") String var13);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files listFromTaskNext"})
        @GET
        public Observable<Response<ResponseBody>> listFromTaskNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.batch.protocol.Files listFromComputeNodeNext"})
        @GET
        public Observable<Response<ResponseBody>> listFromComputeNodeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="client-request-id") UUID var3, @Header(value="return-client-request-id") Boolean var4, @Header(value="ocp-date") DateTimeRfc1123 var5, @Header(value="User-Agent") String var6);
    }
}

