/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentialsInterceptor;
import com.microsoft.rest.credentials.TokenCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.OkHttpClient;

public class ApplicationTokenCredentials
extends TokenCredentials
implements AzureTokenCredentials {
    private Map<String, AuthenticationResult> tokens;
    private AzureEnvironment environment;
    private String clientId;
    private String domain;
    private String secret;
    private String defaultSubscription;

    public ApplicationTokenCredentials(String clientId, String domain, String secret, AzureEnvironment environment) {
        super(null, null);
        this.environment = environment;
        this.clientId = clientId;
        this.domain = domain;
        this.secret = secret;
        this.tokens = new HashMap<String, AuthenticationResult>();
    }

    public String defaultSubscriptionId() {
        return this.defaultSubscription;
    }

    public ApplicationTokenCredentials withDefaultSubscriptionId(String subscriptionId) {
        this.defaultSubscription = subscriptionId;
        return this;
    }

    public static ApplicationTokenCredentials fromFile(File credentialsFile) throws IOException {
        Properties authSettings = new Properties();
        authSettings.put(CredentialSettings.AUTH_URL.toString(), AzureEnvironment.AZURE.getAuthenticationEndpoint());
        authSettings.put(CredentialSettings.BASE_URL.toString(), AzureEnvironment.AZURE.getBaseUrl());
        authSettings.put(CredentialSettings.MANAGEMENT_URI.toString(), AzureEnvironment.AZURE.getManagementEndpoint());
        FileInputStream credentialsFileStream = new FileInputStream(credentialsFile);
        authSettings.load(credentialsFileStream);
        credentialsFileStream.close();
        String clientId = authSettings.getProperty(CredentialSettings.CLIENT_ID.toString());
        String tenantId = authSettings.getProperty(CredentialSettings.TENANT_ID.toString());
        String clientKey = authSettings.getProperty(CredentialSettings.CLIENT_KEY.toString());
        String mgmtUri = authSettings.getProperty(CredentialSettings.MANAGEMENT_URI.toString());
        String authUrl = authSettings.getProperty(CredentialSettings.AUTH_URL.toString());
        String baseUrl = authSettings.getProperty(CredentialSettings.BASE_URL.toString());
        String graphUrl = authSettings.getProperty(CredentialSettings.GRAPH_URL.toString());
        String defaultSubscriptionId = authSettings.getProperty(CredentialSettings.SUBSCRIPTION_ID.toString());
        return new ApplicationTokenCredentials(clientId, tenantId, clientKey, new AzureEnvironment(authUrl, mgmtUri, baseUrl, graphUrl)).withDefaultSubscriptionId(defaultSubscriptionId);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getToken(String resource) throws IOException {
        AuthenticationResult authenticationResult = this.tokens.get(resource);
        if (authenticationResult == null || authenticationResult.getExpiresOnDate().before(new Date())) {
            authenticationResult = this.acquireAccessToken(resource);
        }
        return authenticationResult.getAccessToken();
    }

    public AzureEnvironment getEnvironment() {
        return this.environment;
    }

    private AuthenticationResult acquireAccessToken(String resource) throws IOException {
        String authorityUrl = this.getEnvironment().getAuthenticationEndpoint() + this.getDomain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, this.getEnvironment().isValidateAuthority(), executor);
        try {
            AuthenticationResult result = (AuthenticationResult)context.acquireToken(resource, new ClientCredential(this.getClientId(), this.getSecret()), null).get();
            this.tokens.put(resource, result);
            AuthenticationResult authenticationResult = result;
            return authenticationResult;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            executor.shutdown();
        }
    }

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.interceptors().add(new AzureTokenCredentialsInterceptor((AzureTokenCredentials)this));
    }

    private static enum CredentialSettings {
        SUBSCRIPTION_ID("subscription"),
        TENANT_ID("tenant"),
        CLIENT_ID("client"),
        CLIENT_KEY("key"),
        MANAGEMENT_URI("managementURI"),
        BASE_URL("baseURL"),
        AUTH_URL("authURL"),
        GRAPH_URL("graphURL");

        private final String name;

        private CredentialSettings(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

