/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentialsInterceptor;
import com.microsoft.rest.credentials.TokenCredentials;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.OkHttpClient;

public class UserTokenCredentials
extends TokenCredentials
implements AzureTokenCredentials {
    private Map<String, AuthenticationResult> tokens;
    private String clientId;
    private String domain;
    private String username;
    private String password;
    private AzureEnvironment environment;

    public UserTokenCredentials(String clientId, String domain, String username, String password, AzureEnvironment environment) {
        super(null, null);
        this.clientId = clientId;
        this.domain = domain;
        this.username = username;
        this.password = password;
        this.environment = environment;
        this.tokens = new HashMap<String, AuthenticationResult>();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken(String resource) throws IOException {
        AuthenticationResult authenticationResult = this.tokens.get(resource);
        if (authenticationResult == null || authenticationResult.getExpiresOnDate().before(new Date())) {
            authenticationResult = this.acquireAccessToken(resource);
        }
        return authenticationResult.getAccessToken();
    }

    public AzureEnvironment getEnvironment() {
        return this.environment;
    }

    private AuthenticationResult acquireAccessToken(String resource) throws IOException {
        String authorityUrl = this.getEnvironment().getAuthenticationEndpoint() + this.getDomain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, this.getEnvironment().isValidateAuthority(), executor);
        try {
            AuthenticationResult result = (AuthenticationResult)context.acquireToken(resource, this.getClientId(), this.getUsername(), this.getPassword(), null).get();
            this.tokens.put(resource, result);
            AuthenticationResult authenticationResult = result;
            return authenticationResult;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            executor.shutdown();
        }
    }

    private AuthenticationResult acquireAccessTokenFromRefreshToken(String resource) throws IOException {
        String authorityUrl = this.getEnvironment().getAuthenticationEndpoint() + this.getDomain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, this.getEnvironment().isValidateAuthority(), executor);
        try {
            AuthenticationResult result = (AuthenticationResult)context.acquireTokenByRefreshToken(this.tokens.get(resource).getRefreshToken(), this.getClientId(), null, null).get();
            this.tokens.put(resource, result);
            AuthenticationResult authenticationResult = result;
            return authenticationResult;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            executor.shutdown();
        }
    }

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.interceptors().add(new AzureTokenCredentialsInterceptor((AzureTokenCredentials)this));
    }
}

