/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ApplicationTokenCredentials
extends AzureTokenCredentials {
    private Map<String, AuthenticationResult> tokens;
    private String clientId;
    private String secret;
    private byte[] certificate;
    private String certPassword;

    public ApplicationTokenCredentials(String clientId, String domain, String secret, AzureEnvironment environment) {
        super(environment, domain);
        this.clientId = clientId;
        this.secret = secret;
        this.tokens = new HashMap<String, AuthenticationResult>();
    }

    public ApplicationTokenCredentials(String clientId, String domain, byte[] certificate, String password, AzureEnvironment environment) {
        super(environment, domain);
        this.clientId = clientId;
        this.certificate = certificate;
        this.certPassword = password;
        this.tokens = new HashMap<String, AuthenticationResult>();
    }

    public static ApplicationTokenCredentials fromFile(File credentialsFile) throws IOException {
        Properties authSettings = new Properties();
        authSettings.put(CredentialSettings.AUTH_URL.toString(), AzureEnvironment.AZURE.activeDirectoryEndpoint());
        authSettings.put(CredentialSettings.BASE_URL.toString(), AzureEnvironment.AZURE.resourceManagerEndpoint());
        authSettings.put(CredentialSettings.MANAGEMENT_URI.toString(), AzureEnvironment.AZURE.managementEndpoint());
        authSettings.put(CredentialSettings.GRAPH_URL.toString(), AzureEnvironment.AZURE.graphEndpoint());
        authSettings.put(CredentialSettings.VAULT_SUFFIX.toString(), AzureEnvironment.AZURE.keyVaultDnsSuffix());
        FileInputStream credentialsFileStream = new FileInputStream(credentialsFile);
        authSettings.load(credentialsFileStream);
        credentialsFileStream.close();
        String clientId = authSettings.getProperty(CredentialSettings.CLIENT_ID.toString());
        String tenantId = authSettings.getProperty(CredentialSettings.TENANT_ID.toString());
        String clientKey = authSettings.getProperty(CredentialSettings.CLIENT_KEY.toString());
        String certificate = authSettings.getProperty(CredentialSettings.CLIENT_CERT.toString());
        String certPasswrod = authSettings.getProperty(CredentialSettings.CLIENT_CERT_PASS.toString());
        final String mgmtUri = authSettings.getProperty(CredentialSettings.MANAGEMENT_URI.toString());
        final String authUrl = authSettings.getProperty(CredentialSettings.AUTH_URL.toString());
        final String baseUrl = authSettings.getProperty(CredentialSettings.BASE_URL.toString());
        final String graphUrl = authSettings.getProperty(CredentialSettings.GRAPH_URL.toString());
        final String vaultSuffix = authSettings.getProperty(CredentialSettings.VAULT_SUFFIX.toString());
        String defaultSubscriptionId = authSettings.getProperty(CredentialSettings.SUBSCRIPTION_ID.toString());
        if (clientKey != null) {
            return (ApplicationTokenCredentials)new ApplicationTokenCredentials(clientId, tenantId, clientKey, new AzureEnvironment((Map)new HashMap<String, String>(){
                {
                    this.put(AzureEnvironment.Endpoint.ACTIVE_DIRECTORY.toString(), authUrl.endsWith("/") ? authUrl : authUrl + "/");
                    this.put(AzureEnvironment.Endpoint.MANAGEMENT.toString(), mgmtUri);
                    this.put(AzureEnvironment.Endpoint.RESOURCE_MANAGER.toString(), baseUrl);
                    this.put(AzureEnvironment.Endpoint.GRAPH.toString(), graphUrl);
                    this.put(AzureEnvironment.Endpoint.KEYVAULT.toString(), vaultSuffix);
                }
            })).withDefaultSubscriptionId(defaultSubscriptionId);
        }
        if (certificate != null) {
            byte[] certs = new File(certificate).exists() ? Files.readAllBytes(Paths.get(certificate, new String[0])) : Files.readAllBytes(Paths.get(credentialsFile.getParent(), certificate));
            return (ApplicationTokenCredentials)new ApplicationTokenCredentials(clientId, tenantId, certs, certPasswrod, new AzureEnvironment((Map)new HashMap<String, String>(){
                {
                    this.put(AzureEnvironment.Endpoint.ACTIVE_DIRECTORY.toString(), authUrl);
                    this.put(AzureEnvironment.Endpoint.MANAGEMENT.toString(), mgmtUri);
                    this.put(AzureEnvironment.Endpoint.RESOURCE_MANAGER.toString(), baseUrl);
                    this.put(AzureEnvironment.Endpoint.GRAPH.toString(), graphUrl);
                    this.put(AzureEnvironment.Endpoint.KEYVAULT.toString(), vaultSuffix);
                }
            })).withDefaultSubscriptionId(defaultSubscriptionId);
        }
        throw new IllegalArgumentException("Please specify either a client key or a client certificate.");
    }

    public String clientId() {
        return this.clientId;
    }

    public synchronized String getToken(String resource) throws IOException {
        AuthenticationResult authenticationResult = this.tokens.get(resource);
        if (authenticationResult == null || authenticationResult.getExpiresOnDate().before(new Date())) {
            authenticationResult = this.acquireAccessToken(resource);
        }
        this.tokens.put(resource, authenticationResult);
        return authenticationResult.getAccessToken();
    }

    private AuthenticationResult acquireAccessToken(String resource) throws IOException {
        String authorityUrl = this.environment().activeDirectoryEndpoint() + this.domain();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AuthenticationContext context = new AuthenticationContext(authorityUrl, false, executor);
        if (this.proxy() != null) {
            context.setProxy(this.proxy());
        }
        try {
            if (this.secret != null) {
                AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireToken(resource, new ClientCredential(this.clientId(), this.secret), null).get();
                return authenticationResult;
            }
            if (this.certificate != null) {
                AuthenticationResult authenticationResult = (AuthenticationResult)context.acquireToken(resource, AsymmetricKeyCredential.create((String)this.clientId, (InputStream)new ByteArrayInputStream(this.certificate), (String)this.certPassword), null).get();
                return authenticationResult;
            }
            try {
                throw new AuthenticationException("Please provide either a non-null secret or a non-null certificate.");
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private static enum CredentialSettings {
        SUBSCRIPTION_ID("subscription"),
        TENANT_ID("tenant"),
        CLIENT_ID("client"),
        CLIENT_KEY("key"),
        CLIENT_CERT("certificate"),
        CLIENT_CERT_PASS("certificatePassword"),
        MANAGEMENT_URI("managementURI"),
        BASE_URL("baseURL"),
        AUTH_URL("authURL"),
        GRAPH_URL("graphURL"),
        VAULT_SUFFIX("vaultSuffix");

        private final String name;

        private CredentialSettings(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

