/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.AzureAsyncOperation;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.CloudError;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.PollingState;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AzureClient
extends AzureServiceClient {
    private Integer longRunningOperationRetryTimeout;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final String serviceClientUserAgent;

    public AzureClient(AzureServiceClient serviceClient) {
        super(serviceClient.restClient());
        this.serviceClientUserAgent = serviceClient.userAgent();
    }

    public Integer getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public void withLongRunningOperationRetryTimeout(Integer longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }

    public <T> ServiceResponse<T> getPutOrPatchResult(Observable<Response<ResponseBody>> observable, Type resourceType) throws CloudException, InterruptedException, IOException {
        Observable<ServiceResponse<T>> asyncObservable = this.getPutOrPatchResultAsync(observable, resourceType);
        return (ServiceResponse)asyncObservable.toBlocking().last();
    }

    public <T, THeader> ServiceResponseWithHeaders<T, THeader> getPutOrPatchResultWithHeaders(Observable<Response<ResponseBody>> observable, Type resourceType, Class<THeader> headerType) throws CloudException, InterruptedException, IOException {
        ServiceResponse<T> bodyResponse = this.getPutOrPatchResult(observable, resourceType);
        return new ServiceResponseWithHeaders(bodyResponse.getBody(), this.restClient().mapperAdapter().deserialize(this.restClient().mapperAdapter().serialize((Object)bodyResponse.getResponse().headers()), headerType), bodyResponse.getResponse());
    }

    public <T> Observable<ServiceResponse<T>> getPutOrPatchResultAsync(Observable<Response<ResponseBody>> observable, final Type resourceType) {
        return observable.flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<T>>>(){

            public Observable<ServiceResponse<T>> call(Response<ResponseBody> response) {
                CloudException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 201, 202});
                if (exception != null) {
                    return Observable.error((Throwable)((Object)exception));
                }
                try {
                    final PollingState pollingState = new PollingState(response, AzureClient.this.getLongRunningOperationRetryTimeout(), resourceType, AzureClient.this.restClient().mapperAdapter());
                    final String url = response.raw().request().url().toString();
                    return Observable.just(pollingState).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

                        public Observable<?> call(Observable<? extends Void> observable) {
                            return observable.delay((long)pollingState.getDelayInMilliseconds(), TimeUnit.MILLISECONDS);
                        }
                    }).flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

                        public Observable<PollingState<T>> call(PollingState<T> pollingState) {
                            if (!AzureAsyncOperation.getTerminalStatuses().contains(pollingState.getStatus())) {
                                return AzureClient.this.putOrPatchPollingDispatcher(pollingState, url);
                            }
                            return Observable.just(pollingState);
                        }
                    }).filter(new Func1<PollingState<T>, Boolean>(){

                        public Boolean call(PollingState<T> pollingState) {
                            return AzureAsyncOperation.getTerminalStatuses().contains(pollingState.getStatus());
                        }
                    }).first().flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

                        public Observable<PollingState<T>> call(PollingState<T> pollingState) {
                            if ("Succeeded".equals(pollingState.getStatus()) && pollingState.getResource() == null) {
                                return AzureClient.this.updateStateFromGetResourceOperationAsync(pollingState, url);
                            }
                            if (AzureAsyncOperation.getFailedStatuses().contains(pollingState.getStatus())) {
                                return Observable.error((Throwable)((Object)new CloudException("Async operation failed with provisioning state: " + pollingState.getStatus())));
                            }
                            return Observable.just(pollingState);
                        }
                    }).map(new Func1<PollingState<T>, ServiceResponse<T>>(){

                        public ServiceResponse<T> call(PollingState<T> pollingState) {
                            return new ServiceResponse(pollingState.getResource(), pollingState.getResponse());
                        }
                    });
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    public <T, THeader> Observable<ServiceResponseWithHeaders<T, THeader>> getPutOrPatchResultWithHeadersAsync(Observable<Response<ResponseBody>> observable, Type resourceType, final Class<THeader> headerType) {
        Observable<ServiceResponse<T>> bodyResponse = this.getPutOrPatchResultAsync(observable, resourceType);
        return bodyResponse.flatMap(new Func1<ServiceResponse<T>, Observable<ServiceResponseWithHeaders<T, THeader>>>(){

            public Observable<ServiceResponseWithHeaders<T, THeader>> call(ServiceResponse<T> serviceResponse) {
                try {
                    return Observable.just((Object)new ServiceResponseWithHeaders(serviceResponse.getBody(), AzureClient.this.restClient().mapperAdapter().deserialize(AzureClient.this.restClient().mapperAdapter().serialize((Object)serviceResponse.getResponse().headers()), (Type)headerType), serviceResponse.getResponse()));
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    public <T> ServiceResponse<T> getPostOrDeleteResult(Observable<Response<ResponseBody>> observable, Type resourceType) throws CloudException, InterruptedException, IOException {
        Observable<ServiceResponse<T>> asyncObservable = this.getPutOrPatchResultAsync(observable, resourceType);
        return (ServiceResponse)asyncObservable.toBlocking().last();
    }

    public <T, THeader> ServiceResponseWithHeaders<T, THeader> getPostOrDeleteResultWithHeaders(Observable<Response<ResponseBody>> observable, Type resourceType, Class<THeader> headerType) throws CloudException, InterruptedException, IOException {
        ServiceResponse<T> bodyResponse = this.getPostOrDeleteResult(observable, resourceType);
        return new ServiceResponseWithHeaders(bodyResponse.getBody(), this.restClient().mapperAdapter().deserialize(this.restClient().mapperAdapter().serialize((Object)bodyResponse.getResponse().headers()), headerType), bodyResponse.getResponse());
    }

    public <T> Observable<ServiceResponse<T>> getPostOrDeleteResultAsync(Observable<Response<ResponseBody>> observable, final Type resourceType) {
        return observable.flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<T>>>(){

            public Observable<ServiceResponse<T>> call(Response<ResponseBody> response) {
                CloudException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 202, 204});
                if (exception != null) {
                    return Observable.error((Throwable)((Object)exception));
                }
                try {
                    final PollingState pollingState = new PollingState(response, AzureClient.this.getLongRunningOperationRetryTimeout(), resourceType, AzureClient.this.restClient().mapperAdapter());
                    return Observable.just(pollingState).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

                        public Observable<?> call(Observable<? extends Void> observable) {
                            return observable.delay((long)pollingState.getDelayInMilliseconds(), TimeUnit.MILLISECONDS);
                        }
                    }).flatMap(new Func1<PollingState<T>, Observable<PollingState<T>>>(){

                        public Observable<PollingState<T>> call(PollingState<T> pollingState) {
                            if (!AzureAsyncOperation.getTerminalStatuses().contains(pollingState.getStatus())) {
                                return AzureClient.this.postOrDeletePollingDispatcher(pollingState);
                            }
                            return Observable.just(pollingState);
                        }
                    }).filter(new Func1<PollingState<T>, Boolean>(){

                        public Boolean call(PollingState<T> pollingState) {
                            return AzureAsyncOperation.getTerminalStatuses().contains(pollingState.getStatus());
                        }
                    }).first().flatMap(new Func1<PollingState<T>, Observable<ServiceResponse<T>>>(){

                        public Observable<ServiceResponse<T>> call(PollingState<T> pollingState) {
                            if (AzureAsyncOperation.getFailedStatuses().contains(pollingState.getStatus())) {
                                return Observable.error((Throwable)((Object)new CloudException("Async operation failed with provisioning state: " + pollingState.getStatus())));
                            }
                            return Observable.just((Object)new ServiceResponse(pollingState.getResource(), pollingState.getResponse()));
                        }
                    });
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    public <T, THeader> Observable<ServiceResponseWithHeaders<T, THeader>> getPostOrDeleteResultWithHeadersAsync(Observable<Response<ResponseBody>> observable, Type resourceType, final Class<THeader> headerType) {
        Observable<ServiceResponse<T>> bodyResponse = this.getPostOrDeleteResultAsync(observable, resourceType);
        return bodyResponse.flatMap(new Func1<ServiceResponse<T>, Observable<ServiceResponseWithHeaders<T, THeader>>>(){

            public Observable<ServiceResponseWithHeaders<T, THeader>> call(ServiceResponse<T> serviceResponse) {
                try {
                    return Observable.just((Object)new ServiceResponseWithHeaders(serviceResponse.getBody(), AzureClient.this.restClient().mapperAdapter().deserialize(AzureClient.this.restClient().mapperAdapter().serialize((Object)serviceResponse.getResponse().headers()), (Type)headerType), serviceResponse.getResponse()));
                }
                catch (IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromLocationHeaderOnPutAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.getLocationHeaderLink()).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                int statusCode = response.code();
                if (statusCode == 202) {
                    pollingState.setResponse(response);
                    pollingState.setStatus("InProgress");
                } else if (statusCode == 200 || statusCode == 201) {
                    try {
                        pollingState.updateFromResponseOnPutPatch(response);
                    }
                    catch (CloudException | IOException e) {
                        return Observable.error((Throwable)e);
                    }
                }
                return Observable.just((Object)pollingState);
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromLocationHeaderOnPostOrDeleteAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.getLocationHeaderLink()).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                int statusCode = response.code();
                if (statusCode == 202) {
                    pollingState.setResponse(response);
                    pollingState.setStatus("InProgress");
                } else if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                    try {
                        pollingState.updateFromResponseOnDeletePost(response);
                    }
                    catch (IOException e) {
                        return Observable.error((Throwable)e);
                    }
                }
                return Observable.just((Object)pollingState);
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromGetResourceOperationAsync(final PollingState<T> pollingState, String url) {
        return this.pollAsync(url).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                try {
                    pollingState.updateFromResponseOnPutPatch(response);
                    return Observable.just((Object)pollingState);
                }
                catch (CloudException | IOException e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    private <T> Observable<PollingState<T>> updateStateFromAzureAsyncOperationHeaderAsync(final PollingState<T> pollingState) {
        return this.pollAsync(pollingState.getAzureAsyncOperationHeaderLink()).flatMap(new Func1<Response<ResponseBody>, Observable<PollingState<T>>>(){

            public Observable<PollingState<T>> call(Response<ResponseBody> response) {
                AzureAsyncOperation body = null;
                if (response.body() != null) {
                    try {
                        body = (AzureAsyncOperation)AzureClient.this.restClient().mapperAdapter().deserialize(((ResponseBody)response.body()).string(), AzureAsyncOperation.class);
                        ((ResponseBody)response.body()).close();
                    }
                    catch (IOException e) {
                        body = null;
                    }
                }
                if (body == null || body.getStatus() == null) {
                    CloudException exception = new CloudException("polling response does not contain a valid body: " + body);
                    exception.setResponse(response);
                    return Observable.error((Throwable)((Object)exception));
                }
                pollingState.setStatus(body.getStatus());
                pollingState.setResponse(response);
                pollingState.setResource(null);
                return Observable.just((Object)pollingState);
            }
        });
    }

    private Observable<Response<ResponseBody>> pollAsync(String url) {
        URL endpoint;
        try {
            endpoint = new URL(url);
        }
        catch (MalformedURLException e) {
            return Observable.error((Throwable)e);
        }
        int port = endpoint.getPort();
        if (port == -1) {
            port = endpoint.getDefaultPort();
        }
        AsyncService service = (AsyncService)this.restClient().retrofit().create(AsyncService.class);
        return service.get(endpoint.getFile(), this.serviceClientUserAgent).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<Response<ResponseBody>>>(){

            public Observable<Response<ResponseBody>> call(Response<ResponseBody> response) {
                CloudException exception = AzureClient.this.createExceptionFromResponse((Response<ResponseBody>)response, new Integer[]{200, 201, 202, 204});
                if (exception != null) {
                    return Observable.error((Throwable)((Object)exception));
                }
                return Observable.just(response);
            }
        });
    }

    private CloudException createExceptionFromResponse(Response<ResponseBody> response, Integer ... allowedStatusCodes) {
        int statusCode = response.code();
        ResponseBody responseBody = response.isSuccessful() ? (ResponseBody)response.body() : response.errorBody();
        if (!Arrays.asList(allowedStatusCodes).contains(statusCode)) {
            try {
                CloudError errorBody = (CloudError)this.restClient().mapperAdapter().deserialize(responseBody.string(), CloudError.class);
                CloudException exception = errorBody != null ? new CloudException(errorBody.getMessage()) : new CloudException("Unknown error with status code " + statusCode);
                exception.setBody(errorBody);
                exception.setResponse(response);
                return exception;
            }
            catch (Exception e) {
                return new CloudException("Unknown error with status code " + statusCode, e);
            }
        }
        return null;
    }

    private <T> Observable<PollingState<T>> putOrPatchPollingDispatcher(PollingState<T> pollingState, String url) {
        if (pollingState.getAzureAsyncOperationHeaderLink() != null && !pollingState.getAzureAsyncOperationHeaderLink().isEmpty()) {
            return this.updateStateFromAzureAsyncOperationHeaderAsync(pollingState);
        }
        if (pollingState.getLocationHeaderLink() != null && !pollingState.getLocationHeaderLink().isEmpty()) {
            return this.updateStateFromLocationHeaderOnPutAsync(pollingState);
        }
        return this.updateStateFromGetResourceOperationAsync(pollingState, url);
    }

    private <T> Observable<PollingState<T>> postOrDeletePollingDispatcher(PollingState<T> pollingState) {
        if (pollingState.getAzureAsyncOperationHeaderLink() != null && !pollingState.getAzureAsyncOperationHeaderLink().isEmpty()) {
            return this.updateStateFromAzureAsyncOperationHeaderAsync(pollingState);
        }
        if (pollingState.getLocationHeaderLink() != null && !pollingState.getLocationHeaderLink().isEmpty()) {
            return this.updateStateFromLocationHeaderOnPostOrDeleteAsync(pollingState);
        }
        CloudException exception = new CloudException("Response does not contain an Azure-AsyncOperation or Location header.");
        exception.setBody(pollingState.getError());
        exception.setResponse(pollingState.getResponse());
        return Observable.error((Throwable)((Object)exception));
    }

    private static interface AsyncService {
        @GET
        public Observable<Response<ResponseBody>> get(@Url String var1, @Header(value="User-Agent") String var2);
    }
}

