/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.RequestIdHeaderInterceptor;
import com.microsoft.azure.RestClient;

public final class AzureEnvironment {
    private final String resourceManagerEndpoint;
    private String authenticationEndpoint;
    private String managementEndpoint;
    private String graphEndpoint;
    private boolean validateAuthority;
    public static final AzureEnvironment AZURE = new AzureEnvironment("https://login.microsoftonline.com/", "https://management.core.windows.net/", "https://management.azure.com/", "https://graph.windows.net/");
    public static final AzureEnvironment AZURE_CHINA = new AzureEnvironment("https://login.chinacloudapi.cn/", "https://management.core.chinacloudapi.cn/", "https://management.chinacloudapi.cn/", "https://graph.chinacloudapi.cn/");
    public static final AzureEnvironment AZURE_US_GOVERNMENT = new AzureEnvironment("https://login.microsoftonline.com/", "https://management.core.usgovcloudapi.net/", "https://management.usgovcloudapi.net/", "https://graph.windows.net/");
    public static final AzureEnvironment AZURE_GERMANY = new AzureEnvironment("https://login.microsoftonline.de/", "https://management.core.cloudapi.de/", "https://management.microsoftazure.de/", "https://graph.cloudapi.de/");

    public AzureEnvironment(String authenticationEndpoint, String managementEndpoint, String resourceManagerEndpoint, String graphEndpoint) {
        this.authenticationEndpoint = authenticationEndpoint;
        this.managementEndpoint = managementEndpoint;
        this.resourceManagerEndpoint = resourceManagerEndpoint;
        this.graphEndpoint = graphEndpoint;
        this.validateAuthority = false;
    }

    public String getBaseUrl() {
        return this.resourceManagerEndpoint;
    }

    public RestClient.Builder.Buildable newRestClientBuilder() {
        return new RestClient.Builder().withDefaultBaseUrl(this).withInterceptor(new RequestIdHeaderInterceptor());
    }

    public String getAuthenticationEndpoint() {
        return this.authenticationEndpoint;
    }

    public String getManagementEndpoint() {
        return this.managementEndpoint;
    }

    public String getGraphEndpoint() {
        return this.graphEndpoint;
    }

    public boolean isValidateAuthority() {
        return this.validateAuthority;
    }

    public void setValidateAuthority(boolean validateAuthority) {
        this.validateAuthority = validateAuthority;
    }
}

