/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class AzureServiceCall<T>
extends ServiceCall<T> {
    private AzureServiceCall() {
    }

    public static <E> ServiceCall<List<E>> create(Observable<ServiceResponse<Page<E>>> first, Func1<String, Observable<ServiceResponse<Page<E>>>> next, ListOperationCallback<E> callback) {
        AzureServiceCall serviceCall = new AzureServiceCall();
        PagingSubscriber subscriber = new PagingSubscriber(serviceCall, next, callback);
        serviceCall.setSubscription(first.single().subscribe(subscriber));
        return serviceCall;
    }

    public static <E, V> ServiceCall<List<E>> createWithHeaders(Observable<ServiceResponseWithHeaders<Page<E>, V>> first, final Func1<String, Observable<ServiceResponseWithHeaders<Page<E>, V>>> next, ListOperationCallback<E> callback) {
        AzureServiceCall serviceCall = new AzureServiceCall();
        PagingSubscriber subscriber = new PagingSubscriber(serviceCall, new Func1<String, Observable<ServiceResponse<Page<E>>>>(){

            public Observable<ServiceResponse<Page<E>>> call(String s) {
                return ((Observable)next.call((Object)s)).map(new Func1<ServiceResponseWithHeaders<Page<E>, V>, ServiceResponse<Page<E>>>(){

                    public ServiceResponse<Page<E>> call(ServiceResponseWithHeaders<Page<E>, V> pageVServiceResponseWithHeaders) {
                        return pageVServiceResponseWithHeaders;
                    }
                });
            }
        }, callback);
        serviceCall.setSubscription(first.single().subscribe(subscriber));
        return serviceCall;
    }

    private static class PagingSubscriber<E>
    extends Subscriber<ServiceResponse<Page<E>>> {
        private AzureServiceCall<List<E>> serviceCall;
        private Func1<String, Observable<ServiceResponse<Page<E>>>> next;
        private ListOperationCallback<E> callback;
        private ServiceResponse<Page<E>> lastResponse;

        PagingSubscriber(AzureServiceCall<List<E>> serviceCall, Func1<String, Observable<ServiceResponse<Page<E>>>> next, ListOperationCallback<E> callback) {
            this.serviceCall = serviceCall;
            this.next = next;
            this.callback = callback;
        }

        public void onCompleted() {
        }

        public void onError(Throwable e) {
            ((AzureServiceCall)this.serviceCall).setException(e);
            if (this.callback != null) {
                this.callback.failure(e);
            }
        }

        public void onNext(ServiceResponse<Page<E>> serviceResponse) {
            this.lastResponse = serviceResponse;
            ListOperationCallback.PagingBehavior behavior = ListOperationCallback.PagingBehavior.CONTINUE;
            if (this.callback != null && ((behavior = this.callback.progress(((Page)serviceResponse.getBody()).getItems())) == ListOperationCallback.PagingBehavior.STOP || ((Page)serviceResponse.getBody()).getNextPageLink() == null)) {
                this.callback.success();
            }
            if (behavior == ListOperationCallback.PagingBehavior.STOP || ((Page)serviceResponse.getBody()).getNextPageLink() == null) {
                ((AzureServiceCall)this.serviceCall).set(((Page)this.lastResponse.getBody()).getItems());
            } else {
                ((AzureServiceCall)this.serviceCall).setSubscription(((Observable)this.next.call((Object)((Page)serviceResponse.getBody()).getNextPageLink())).single().subscribe((Subscriber)this));
            }
        }
    }
}

