/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.RequestIdHeaderInterceptor;
import com.microsoft.azure.RestClient;
import com.microsoft.rest.serializer.JacksonMapperAdapter;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public abstract class AzureServiceClient {
    private RestClient restClient;

    protected AzureServiceClient(String baseUrl) {
        this(new RestClient.Builder().withBaseUrl(baseUrl).withInterceptor(new RequestIdHeaderInterceptor()).build());
    }

    protected AzureServiceClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public String userAgent() {
        return "Azure-SDK-For-Java/" + this.getClass().getPackage().getImplementationVersion();
    }

    public RestClient restClient() {
        return this.restClient;
    }

    public Retrofit retrofit() {
        return this.restClient().retrofit();
    }

    public OkHttpClient httpClient() {
        return this.restClient().httpClient();
    }

    public JacksonMapperAdapter mapperAdapter() {
        return this.restClient().mapperAdapter();
    }
}

