/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseBuilder;
import com.microsoft.rest.serializer.JacksonMapperAdapter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Response;

public class AzureServiceResponseBuilder<T, E extends RestException>
extends ServiceResponseBuilder<T, E> {
    public AzureServiceResponseBuilder(JacksonMapperAdapter deserializer) {
        this(deserializer, new HashMap<Integer, Type>());
    }

    public AzureServiceResponseBuilder(JacksonMapperAdapter deserializer, Map<Integer, Type> responseTypes) {
        super(deserializer, responseTypes);
    }

    public ServiceResponse<T> buildEmpty(Response<Void> response) throws E, IOException {
        int statusCode = response.code();
        if (this.responseTypes.containsKey(statusCode)) {
            if (new TypeToken<T>(((Object)((Object)this)).getClass()){}.getRawType().isAssignableFrom(Boolean.class)) {
                ServiceResponse serviceResponse = new ServiceResponse(response);
                serviceResponse.setBody((Object)(statusCode / 100 == 2 ? 1 : 0));
                return serviceResponse;
            }
            return new ServiceResponse(response);
        }
        try {
            RestException exception = (RestException)this.exceptionType.getConstructor(String.class).newInstance("Invalid status code " + statusCode);
            this.exceptionType.getMethod("setResponse", response.getClass()).invoke((Object)exception, response);
            throw exception;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Invalid status code " + statusCode + ", but an instance of " + this.exceptionType.getCanonicalName() + " cannot be created.", e);
        }
    }
}

