/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.DAGNode;
import com.microsoft.azure.Graph;
import com.microsoft.azure.Node;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DAGraph<T, U extends DAGNode<T>>
extends Graph<T, U> {
    private ConcurrentLinkedQueue<String> queue;
    private boolean hasParent;
    private U rootNode;

    public DAGraph(U rootNode) {
        this.rootNode = rootNode;
        this.queue = new ConcurrentLinkedQueue();
        ((DAGNode)this.rootNode).setPreparer(true);
        this.addNode(rootNode);
    }

    public boolean hasParent() {
        return this.hasParent;
    }

    public boolean isRootNode(U node) {
        return this.rootNode == node;
    }

    public boolean isPreparer() {
        return ((DAGNode)this.rootNode).isPreparer();
    }

    public void merge(DAGraph<T, U> parent) {
        this.hasParent = true;
        ((DAGNode)parent.rootNode).addDependency(((Node)this.rootNode).key());
        for (Map.Entry entry : this.graph.entrySet()) {
            String key = (String)entry.getKey();
            if (parent.graph.containsKey(key)) continue;
            parent.graph.put(key, entry.getValue());
        }
    }

    public void prepare() {
        if (this.isPreparer()) {
            for (DAGNode node : this.graph.values()) {
                node.initialize();
                if (this.isRootNode(node)) continue;
                node.setPreparer(false);
            }
            this.initializeDependentKeys();
            this.initializeQueue();
        }
    }

    public U getNext() {
        String nextItemKey = this.queue.poll();
        if (nextItemKey == null) {
            return null;
        }
        return (U)((DAGNode)this.graph.get(nextItemKey));
    }

    public T getNodeData(String key) {
        return ((DAGNode)this.graph.get(key)).data();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportedCompleted(U completed) {
        ((DAGNode)completed).setPreparer(true);
        String dependency = ((Node)completed).key();
        for (String dependentKey : ((DAGNode)this.graph.get(dependency)).dependentKeys()) {
            DAGNode dependent = (DAGNode)this.graph.get(dependentKey);
            dependent.lock().lock();
            try {
                dependent.reportResolved(dependency);
                if (!dependent.hasAllResolved()) continue;
                this.queue.add(dependent.key());
            }
            finally {
                dependent.lock().unlock();
            }
        }
    }

    private void initializeDependentKeys() {
        this.visit(new Graph.Visitor<U>(){

            @Override
            public void visitNode(U node) {
                if (((DAGNode)node).dependencyKeys().isEmpty()) {
                    return;
                }
                String dependentKey = ((Node)node).key();
                for (String dependencyKey : ((DAGNode)node).dependencyKeys()) {
                    ((DAGNode)DAGraph.this.graph.get(dependencyKey)).addDependent(dependentKey);
                }
            }

            @Override
            public void visitEdge(String fromKey, String toKey, Graph.EdgeType edgeType) {
                if (edgeType == Graph.EdgeType.BACK) {
                    throw new IllegalStateException("Detected circular dependency: " + DAGraph.this.findPath(fromKey, toKey));
                }
            }
        });
    }

    private void initializeQueue() {
        this.queue.clear();
        for (Map.Entry entry : this.graph.entrySet()) {
            if (((DAGNode)entry.getValue()).hasDependencies()) continue;
            this.queue.add((String)entry.getKey());
        }
        if (this.queue.isEmpty()) {
            throw new RuntimeException("Found circular dependency");
        }
    }
}

