/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Graph<T, U extends Node<T>> {
    protected Map<String, U> graph = new HashMap<String, U>();
    private Set<String> visited = new HashSet<String>();
    private Integer time = 0;
    private Map<String, Integer> entryTime = new HashMap<String, Integer>();
    private Map<String, Integer> exitTime = new HashMap<String, Integer>();
    private Map<String, String> parent = new HashMap<String, String>();
    private Set<String> processed = new HashSet<String>();

    public void addNode(U node) {
        this.graph.put(((Node)node).key(), node);
    }

    public Collection<U> getNodes() {
        return this.graph.values();
    }

    public void visit(Visitor visitor) {
        for (Map.Entry<String, U> item : this.graph.entrySet()) {
            if (this.visited.contains(item.getKey())) continue;
            this.dfs(visitor, (Node)item.getValue());
        }
        this.visited.clear();
        this.time = 0;
        this.entryTime.clear();
        this.exitTime.clear();
        this.parent.clear();
        this.processed.clear();
    }

    private void dfs(Visitor visitor, Node<T> node) {
        visitor.visitNode(node);
        String fromKey = node.key();
        this.visited.add(fromKey);
        Object object = this.time;
        Integer n = this.time = Integer.valueOf(this.time + 1);
        this.entryTime.put(fromKey, this.time);
        for (String toKey : node.children()) {
            if (!this.visited.contains(toKey)) {
                this.parent.put(toKey, fromKey);
                visitor.visitEdge(fromKey, toKey, this.edgeType(fromKey, toKey));
                this.dfs(visitor, (Node)this.graph.get(toKey));
                continue;
            }
            visitor.visitEdge(fromKey, toKey, this.edgeType(fromKey, toKey));
        }
        object = this.time;
        n = this.time = Integer.valueOf(this.time + 1);
        this.exitTime.put(fromKey, this.time);
        this.processed.add(fromKey);
    }

    private EdgeType edgeType(String fromKey, String toKey) {
        if (this.parent.containsKey(toKey) && this.parent.get(toKey).equals(fromKey)) {
            return EdgeType.TREE;
        }
        if (this.visited.contains(toKey) && !this.processed.contains(toKey)) {
            return EdgeType.BACK;
        }
        if (this.processed.contains(toKey) && this.entryTime.containsKey(toKey) && this.entryTime.containsKey(fromKey)) {
            if (this.entryTime.get(toKey) > this.entryTime.get(fromKey)) {
                return EdgeType.FORWARD;
            }
            if (this.entryTime.get(toKey) < this.entryTime.get(fromKey)) {
                return EdgeType.CROSS;
            }
        }
        throw new IllegalStateException("Internal Error: Unable to locate the edge type {" + fromKey + ", " + toKey + "}");
    }

    protected String findPath(String start, String end) {
        if (start.equals(end)) {
            return start;
        }
        return this.findPath(start, this.parent.get(end)) + " -> " + end;
    }

    static interface Visitor<U> {
        public void visitNode(U var1);

        public void visitEdge(String var1, String var2, EdgeType var3);
    }

    static enum EdgeType {
        TREE,
        FORWARD,
        BACK,
        CROSS;

    }
}

