/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.Page;
import com.microsoft.rest.RestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class PagedList<E>
implements List<E> {
    private List<E> items = new ArrayList();
    private Page<E> currentPage;
    private Page<E> cachedPage;

    public PagedList() {
    }

    public PagedList(Page<E> page) {
        this();
        List<E> retrievedItems = page.getItems();
        if (retrievedItems != null) {
            this.items.addAll(retrievedItems);
        }
        this.currentPage = page;
        super.cachePage(page.getNextPageLink());
    }

    private void cachePage(String nextPageLink) {
        try {
            while (nextPageLink != null) {
                this.cachedPage = this.nextPage(nextPageLink);
                nextPageLink = this.cachedPage.getNextPageLink();
                if (!this.hasNextPage()) continue;
                break;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public abstract Page<E> nextPage(String var1) throws RestException, IOException;

    public boolean hasNextPage() {
        return this.cachedPage != null && this.cachedPage.getItems() != null && !this.cachedPage.getItems().isEmpty();
    }

    public void loadNextPage() {
        this.currentPage = this.cachedPage;
        this.cachedPage = null;
        this.items.addAll(this.currentPage.getItems());
        this.cachePage(this.currentPage.getNextPageLink());
    }

    public void loadAll() {
        while (this.hasNextPage()) {
            this.loadNextPage();
        }
    }

    public Page<E> currentPage() {
        return this.currentPage;
    }

    protected void setCurrentPage(Page<E> currentPage) {
        this.currentPage = currentPage;
        List<E> retrievedItems = currentPage.getItems();
        if (retrievedItems != null) {
            this.items.addAll(retrievedItems);
        }
        this.cachePage(currentPage.getNextPageLink());
    }

    @Override
    public int size() {
        this.loadAll();
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty() && !this.hasNextPage();
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ListItr(0);
    }

    @Override
    public Object[] toArray() {
        this.loadAll();
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.loadAll();
        return this.items.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.items.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.items.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.items.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.items.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.items.retainAll(c);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public E get(int index) {
        while (index >= this.items.size() && this.hasNextPage()) {
            this.loadNextPage();
        }
        return this.items.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.items.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.items.add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.items.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            for (E item : this) {
                if (item == null) {
                    return index;
                }
                ++index;
            }
        } else {
            for (E item : this) {
                if (item == o) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        this.loadAll();
        return this.items.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        while (index >= this.items.size() && this.hasNextPage()) {
            this.loadNextPage();
        }
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        while ((fromIndex >= this.items.size() || toIndex >= this.items.size()) && this.hasNextPage()) {
            this.loadNextPage();
        }
        return this.items.subList(fromIndex, toIndex);
    }

    private class ListItr
    implements ListIterator<E> {
        private ListIterator<E> itemsListItr;

        ListItr(int index) {
            this.itemsListItr = PagedList.this.items.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.itemsListItr.hasNext() || PagedList.this.hasNextPage();
        }

        @Override
        public E next() {
            if (!this.itemsListItr.hasNext()) {
                if (!PagedList.this.hasNextPage()) {
                    throw new NoSuchElementException();
                }
                int size = PagedList.this.items.size();
                PagedList.this.loadNextPage();
                this.itemsListItr = PagedList.this.items.listIterator(size);
            }
            return this.itemsListItr.next();
        }

        @Override
        public void remove() {
            this.itemsListItr.remove();
        }

        @Override
        public boolean hasPrevious() {
            return this.itemsListItr.hasPrevious();
        }

        @Override
        public E previous() {
            return this.itemsListItr.previous();
        }

        @Override
        public int nextIndex() {
            return this.itemsListItr.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.itemsListItr.previousIndex();
        }

        @Override
        public void set(E e) {
            this.itemsListItr.set(e);
        }

        @Override
        public void add(E e) {
            this.itemsListItr.add(e);
        }
    }
}

